import QtQuick 2.14

import org.mauikit.controls 1.2 as Maui

/**
 * NewDialog
 * A global sidebar for the application window that can be collapsed.
 *
 *
 *
 *
 *
 *
 */
Maui.Dialog
{
    id: control
    entryField: true

    /**
      * finished :
      */
    signal finished(string text)

    acceptButton.text: i18n("Accept")
    rejectButton.text: i18n("Cancel")
    closeButtonVisible: false
    
    onAccepted: done()
    onRejected:
    {
        textEntry.clear()
        control.close()
    }

    page.margins: Maui.Style.space.big
    spacing: Maui.Style.space.medium
    
    onOpened: textEntry.selectAll()
    
    function done()
    {
        finished(textEntry.text)
        textEntry.clear()
        close()
    }
}
