/*
 *   Copyright (C) 2012, 2013, 2014 Ivan Cukic <ivan.cukic(at)kde.org>
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of
 *   the License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef PLUGINS_GLOBAL_TEMPLATES_H
#define PLUGINS_GLOBAL_TEMPLATES_H

#include <Plugin.h>

class QSignalMapper;
class KActionCollection;

class TemplatesPlugin : public Plugin {
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.kde.ActivityManager.Templates")

public:
    explicit TemplatesPlugin(QObject *parent = nullptr,
                             const QVariantList &args = QVariantList());
    ~TemplatesPlugin() override;

    bool init(QHash<QString, QObject *> &modules) override;

    QDBusVariant featureValue(const QStringList &property) const override;

    void setFeatureValue(const QStringList &property,
                         const QDBusVariant &value) override;

public Q_SLOTS:
    void createActivity(const QDBusVariant &values);

private:
    QObject *m_activities;

};

#endif // PLUGINS_GLOBAL_TEMPLATES_
