/*
   SPDX-FileCopyrightText: 2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#ifndef IMPORTADDRESSBOOKJOBINTERFACETESTIMPL_H
#define IMPORTADDRESSBOOKJOBINTERFACETESTIMPL_H

#include "exportimportutil.h"
#include "core/utils.h"

#include "addressbook/importaddressbookjobinterface.h"

class ImportAddressbookJobInterfaceTestImpl : public ImportAddressbookJobInterface, public ExportImportUtil
{
    Q_OBJECT
public:
    explicit ImportAddressbookJobInterfaceTestImpl(QObject *parent, Utils::StoredTypes typeSelected, ArchiveStorage *archiveStorage, int numberOfStep);
    ~ImportAddressbookJobInterfaceTestImpl();

protected:
    Q_REQUIRED_RESULT Akonadi::Collection::Id convertFolderPathToCollectionId(const QString &path) override;
    Q_REQUIRED_RESULT QString createResource(const QString &resources, const QString &name, const QMap<QString, QVariant> &settings, bool synchronizeTree = false) override;
    void synchronizeResource(const QStringList &lst) override;
    Q_REQUIRED_RESULT QString adaptResourcePath(const KSharedConfigPtr &resourceConfig, const QString &storedData) override;
    Q_REQUIRED_RESULT QString adaptNewResourceUrl(bool overwriteResources, const KSharedConfig::Ptr &resourceConfig, const QString &storePath) override;
    Q_REQUIRED_RESULT QString configLocation() const override;
};

#endif // IMPORTADDRESSBOOKJOBINTERFACETESTIMPL_H
