/*
   SPDX-FileCopyrightText: 2016-2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#ifndef AKREGATORCENTRALWIDGET_H
#define AKREGATORCENTRALWIDGET_H

#include <QStackedWidget>
#include "crashwidget/crashwidget.h"
namespace Akregator {
class MainWidget;
class AkregatorCentralWidget : public QStackedWidget
{
    Q_OBJECT
public:
    explicit AkregatorCentralWidget(QWidget *parent = nullptr);
    ~AkregatorCentralWidget();

    void needToRestoreCrashedSession();

    void setMainWidget(Akregator::MainWidget *mainWidget);
    Q_REQUIRED_RESULT bool previousSessionCrashed() const;

Q_SIGNALS:
    void restoreSession(Akregator::CrashWidget::CrashAction type);

private:
    void slotRestoreSession(Akregator::CrashWidget::CrashAction type);

    Akregator::CrashWidget *mCrashWidget = nullptr;
    Akregator::MainWidget *mMainWidget = nullptr;
};
}
#endif // AKREGATORCENTRALWIDGET_H
