/****************************************************************************
 *   Copyright (C)  2012-2015 by Savoir-Faire Linux                         *
 *   Author : Emmanuel Lepage Vallee <elv1313@gmail.com>                    *
 *                                                                          *
 *   This library is free software; you can redistribute it and/or          *
 *   modify it under the terms of the GNU Lesser General Public             *
 *   License as published by the Free Software Foundation; either           *
 *   version 2.1 of the License, or (at your option) any later version.     *
 *                                                                          *
 *   This library is distributed in the hope that it will be useful,        *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU      *
 *   Lesser General Public License for more details.                        *
 *                                                                          *
 *   You should have received a copy of the GNU General Public License      *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/
#ifndef DLGACCESSIBILITY_H
#define DLGACCESSIBILITY_H

#include <QtWidgets/QWidget>

#include "ui_dlgaccessibility.h"

class KConfigDialog;

///DlgAccessibility: Display option for the visually impaired
class DlgAccessibility final : public QWidget, public Ui_DlgAccessibility
{
Q_OBJECT
public:
   //Constructor
   explicit DlgAccessibility(KConfigDialog *parent = nullptr);

   //Destructor
   virtual ~DlgAccessibility();

   //Getters
   bool hasChanged();

private:
   //Attributes
   bool m_Changed;

public Q_SLOTS:
   void updateSettings();
   void updateWidgets();

private Q_SLOTS:
   void changed();

Q_SIGNALS:
   void updateButtons();
};

#endif

// kate: space-indent on; indent-width 3; replace-tabs on;
