/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* vad_root.sql */

static const char *proc0 = 
"#line 23 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_VERSION\" () returns varchar\n"
"{\n"
"return \'1.0.010601A\';\n"
"}\n"
"--src vad_root.sql:21\n"
;

static const char *other0 = 
"registry_set (\'VAD_atomic\', \'0\')\n";
static const char *tbl0 = 
"create table  \"VAD\".\"DBA\".\"VAD_REGISTRY\" (\n"
"\"R_ID\"  integer not null,\n"
"\"R_PRNT\"  integer not null,\n"
"\"R_KEY\" varchar not null,\n"
"\"R_SHKEY\" varchar not null,\n"
"\"R_TYPE\"  varchar not null,\n"
"\"R_VALUE\" long varchar,\n"
"primary key (\"R_ID\") )\n"
"create index VAD_REGISTRY_CHDIR on \"VAD\".\"DBA\".\"VAD_REGISTRY\" (R_PRNT,R_SHKEY,R_TYPE) partition cluster replicated\n"
"create index VAD_REGISTRY_KEY on \"VAD\".\"DBA\".\"VAD_REGISTRY\" (R_KEY) partition cluster replicated\n"
"alter index VAD_REGISTRY on \"VAD\".\"DBA\".\"VAD_REGISTRY\" partition cluster replicated\n";

static const char *proc1 = 
"#line 58 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_READ_INI\" (inout parr any) returns any\n"
"{\n"
"declare name, type, val varchar;\n"
"declare ini, ret integer;\n"
"declare aout any;\n"
"aout := vector();\n"
"ini := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, 1, \'/INI\');\n"
"ret := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (ini, \'DOCS_ROOT\', name, type, val);\n"
"aout := vector_concat (aout, vector(\'doc\', val));\n"
"if (parr is not null)\n"
"\"PUMP\".\"DBA\".\"CHANGE_VAL\" (parr, \'docs_root\', val);\n"
"ret := ret + \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (ini, \'HTTP_ROOT\', name, type, val);\n"
"aout := vector_concat (aout, vector(\'http\', val));\n"
"if (parr is not null)\n"
"\"PUMP\".\"DBA\".\"CHANGE_VAL\" (parr, \'http_root\', val);\n"
"ret := ret + \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (ini, \'CODE_ROOT\', name, type, val);\n"
"aout := vector_concat (aout, vector(\'code\', val));\n"
"if (parr is not null)\n"
"\"PUMP\".\"DBA\".\"CHANGE_VAL\" (parr, \'code_root\', val);\n"
"ret := ret + \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (ini, \'DATA_ROOT\', name, type, val);\n"
"aout := vector_concat (aout, vector(\'data\', val));\n"
"if (parr is not null)\n"
"\"PUMP\".\"DBA\".\"CHANGE_VAL\" (parr, \'data_root\', val);\n"
"ret := ret + \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (ini, \'DAV_ROOT\', name, type, val);\n"
"aout := vector_concat (aout, vector(\'dav\', val));\n"
"if (parr is not null)\n"
"\"PUMP\".\"DBA\".\"CHANGE_VAL\" (parr, \'dav_root\', val);\n"
"return aout;\n"
"}\n"
"--src vad_root.sql:56\n"
;

static const char *proc2 = 
"#line 90 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GET_ROOT\" ( in name varchar ) returns varchar\n"
"{\n"
"declare arr, arr2 any;\n"
"arr := null;\n"
"arr2 := \"VAD\".\"DBA\".\"VAD_READ_INI\" (arr);\n"
"declare s varchar;\n"
"s := get_keyword (name, arr2);\n"
"if (s is null or length(s) = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Attempt to get unknown root path:%s\', name));\n"
"return s;\n"
"}\n"
"--src vad_root.sql:88\n"
;

static const char *proc3 = 
"#line 104 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_SET_ROOT\" ( in name varchar, in val varchar) returns integer\n"
"{\n"
"declare arr any;\n"
"arr := null;\n"
"\n"
"name := upper (name);\n"
"if (  name is null or\n"
"(neq (name, \'DOCS_ROOT\')\n"
"and neq (name, \'HTTP_ROOT\')\n"
"and neq (name, \'CODE_ROOT\')\n"
"and neq (name, \'DAV_ROOT\')\n"
"and neq (name, \'DATA_ROOT\')))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'illegal root type:%s\',cast (name as varchar)));\n"
"\n"
"declare ini, ret integer;\n"
"declare lname, ltype, lval varchar;\n"
"ini := \"VAD\".\"DBA\".\"VAD_CHDIR\" (arr, 1, \'/INI\');\n"
"ret := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (ini, name, lname, ltype, lval, 0);\n"
"\n"
"if (not ret)\n"
"return \"VAD\".\"DBA\".\"VAD_MKNODE\" (arr, ini, name, \'STRING\', val);\n"
"return \"VAD\".\"DBA\".\"VAD_UPDATE_NODE\" (ret, val, lval);\n"
"}\n"
"--src vad_root.sql:102\n"
;

static const char *proc4 = 
"#line 129 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_MKDAV\" (inout id integer, inout gd integer, in path varchar, inout ini any, in istest integer := 0, in _usr varchar := NULL, in _pwd varchar := NULL) returns integer\n"
"{\n"
"declare parr any;\n"
"parr := NULL;\n"
"if (ini is null or length (ini) = 0)\n"
"ini := \"VAD\".\"DBA\".\"VAD_READ_INI\"(parr);\n"
"declare usr, pwd, p varchar;\n"
"if (_usr is not null)\n"
"usr := _usr;\n"
"declare curid, i, n integer;\n"
"declare lname varchar;\n"
"declare par any;\n"
"par := split_and_decode(path, 0, \'\\0\\0/\');\n"
"i := 0;\n"
"n := length(par);\n"
"curid := 0;\n"
"p := \'/\';\n"
"while (i < n)\n"
"{\n"
"lname := aref(par, i);\n"
"if (lname is not null and length(lname))\n"
"{\n"
"p := concat (p, lname, \'/\');\n"
"curid := DB.DBA.DAV_SEARCH_ID(p, \'c\');\n"
"if (curid < 0)\n"
"goto do_smth;\n"
"goto cont;\n"
"do_smth:;\n"
"if (istest)\n"
"return -1;\n"
"usr := \'dav\';\n"
"pwd := pwd_magic_calc(\'dav\', (select U_PWD from WS.WS.SYS_DAV_USER where U_NAME=\'dav\'), 1);\n"
"curid := \"DB\".\"DBA\".\"DAV_COL_CREATE\" (p, \'111101101N\', usr, NULL, usr, pwd);\n"
"if (curid < 0)\n"
"return curid;\n"
"}\n"
"cont:\n"
"i := i + 1;\n"
"}\n"
"return 1;\n"
"}\n"
"--src vad_root.sql:127\n"
;

static const char *proc5 = 
"#line 172 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_ATOMIC\" ( in mode integer )\n"
"{\n"
"if (sys_stat (\'cl_run_local_only\') <> 1)\n"
"return;\n"
"if (mode)\n"
"{\n"
"if (registry_get (\'VAD_atomic\') = \'1\')\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'Redundant attempt to enter atomic mode\');\n"
"__atomic(1);\n"
"registry_set (\'VAD_atomic\', \'1\');\n"
"}\n"
"else\n"
"{\n"
"if (registry_get (\'VAD_atomic\') = \'1\')\n"
"{\n"
"registry_set (\'VAD_atomic\', \'0\');\n"
"__atomic(0);\n"
"}\n"
"}\n"
"}\n"
"--src vad_root.sql:170\n"
;

static const char *proc6 = 
"#line 196 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" ( in msg varchar ) returns integer\n"
"{\n"
"rollback work;\n"
"\n"
"\"VAD\".\"DBA\".\"VAD_ATOMIC\"(0);\n"
"\n"
"registry_set (\'VAD_msg\', msg);\n"
"registry_set (\'VAD_errcount\', cast (1 + cast (registry_get (\'VAD_errcount\') as integer) as varchar));\n"
"\n"
"signal (\'42VAD\', msg);\n"
"}\n"
"--src vad_root.sql:194\n"
;

static const char *proc7 = 
"#line 210 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_CHDIR\" (inout parr any, in curdir integer, in dirname varchar) returns integer\n"
"{\n"
"curdir := cast (curdir as integer);\n"
"dirname := cast (dirname as varchar);\n"
"if (dirname is not null and aref (dirname, 0) <> 47 and not exists ( select \"R_ID\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = curdir ))\n"
"{\n"
"if (parr is not null)\n"
"\"VAD\".\"DBA\".\"VAD_REGET_HANDLERS\" (parr);\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Illegal handler:%d\', curdir));\n"
"}\n"
"declare i, n integer;\n"
"declare arr any;\n"
"declare ltype, lkey, lval varchar;\n"
"arr := split_and_decode (dirname, 0, \'\\0\\0/\');\n"
"i := 0;\n"
"n := length (arr);\n"
"if (aref(dirname,0) = 47)\n"
"{\n"
"curdir := 1;\n"
"i:= 1;\n"
"}\n"
"whenever not found goto notfound;\n"
"while (i<n)\n"
"{\n"
"select \"R_ID\", \"R_TYPE\", \"R_KEY\", \"R_VALUE\" into curdir, ltype, lkey, lval from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\" = curdir and (R_TYPE = \'FOLDER\' or R_TYPE = \'KEY\') and \"R_SHKEY\" = aref (arr,i);\n"
"if (equ (ltype, \'KEY\'))\n"
"{\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, 1, lval);\n"
"}\n"
"else if (neq (ltype, \'FOLDER\'))\n"
"{\n"
"return 0;\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return curdir;\n"
"notfound:\n"
"return 0;\n"
"}\n"
"--src vad_root.sql:208\n"
;

static const char *proc8 = 
"#line 252 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_FIND_SMTH_BY_NAME\" (in curdir integer, in itemname varchar) returns integer\n"
"{\n"
"curdir := cast (curdir as integer);\n"
"declare i, n integer;\n"
"declare arr any;\n"
"arr := split_and_decode (itemname, 0, \'\\0\\0/\');\n"
"i := 0;\n"
"n := length (arr);\n"
"if (aref(itemname,0) = 47)\n"
"{\n"
"curdir := 1;\n"
"i:= 1;\n"
"}\n"
"whenever not found goto notfound;\n"
"while (i<n)\n"
"{\n"
"select \"R_ID\" into curdir from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\" = curdir and R_TYPE = \'FOLDER\' and \"R_SHKEY\" = aref (arr,i);\n"
"i := i + 1;\n"
"}\n"
"return curdir;\n"
"notfound:\n"
"return 0;\n"
"}\n"
"--src vad_root.sql:250\n"
;

static const char *proc9 = 
"#line 277 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_REGET_HANDLERS\" (inout arr any) returns integer\n"
"{\n"
"if (arr is null or length(arr) = 0)\n"
"return 0;\n"
"declare arr2 any;\n"
"arr2 := \"VAD\".\"DBA\".\"VAD_BUILD_TREE\" ();\n"
"declare s varchar;\n"
"s := \"VAD\".\"DBA\".\"VAD_STRIP_RN\" (encode_base64 (gz_compress (serialize (arr2))));\n"
"\"PUMP\".\"DBA\".\"CHANGE_VAL\" (arr, \'tree_ser\', s);\n"
"http (sprintf (\'\\n<script>document.forms[0].tree_ser.value=\"%s\";</script>\\n\',s));\n"
"return 1;\n"
"}\n"
"--src vad_root.sql:275\n"
;

static const char *proc10 = 
"#line 291 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_FULL_PATH\" (inout parr any, in curdir integer) returns varchar\n"
"{\n"
"curdir := cast (curdir as integer);\n"
"declare i integer;\n"
"declare arr any;\n"
"declare ret varchar;\n"
"arr := vector();\n"
"\n"
"declare parent integer;\n"
"declare shkey varchar;\n"
"parent := 0;\n"
"shkey := \'\';\n"
"\n"
"whenever not found goto fin2;\n"
"\n"
"while (1)\n"
"{\n"
"select \"R_PRNT\", \"R_SHKEY\"  into parent, shkey from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = curdir;\n"
"arr := vector_concat (arr, vector(shkey));\n"
"if (curdir = 1)\n"
"goto fin;\n"
"curdir := parent;\n"
"}\n"
"fin:\n"
"i := length (arr) - 1;\n"
"ret := \'\';\n"
"while (i>=0)\n"
"{\n"
"declare t varchar;\n"
"t := aref (arr, i);\n"
"if (t is not null and length(t))\n"
"ret := concat (ret, \'/\', t);\n"
"i := i - 1;\n"
"}\n"
"if (length(ret)=0)\n"
"ret := \'/\';\n"
"return ret;\n"
"fin2:\n"
"if (parr is not null)\n"
"\"VAD\".\"DBA\".\"VAD_REGET_HANDLERS\" (parr);\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Illegal handler:%d\', curdir));\n"
"}\n"
"--src vad_root.sql:289\n"
;

static const char *proc11 = 
"#line 336 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_TEST_PARENT\" (inout parr any, in curdir integer, in name varchar, inout rid int)\n"
"returns varchar\n"
"{\n"
"curdir := cast (curdir as integer);\n"
"rid := null;\n"
"if (not exists (select \"R_ID\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = curdir))\n"
"{\n"
"if (parr is not null)\n"
"\"VAD\".\"DBA\".\"VAD_REGET_HANDLERS\" (parr);\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Illegal current directory handler:%d\', curdir));\n"
"}\n"
"whenever not found goto nfrid;\n"
"select \"R_ID\" into rid from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\" = curdir and \"R_SHKEY\" = name;\n"
"nfrid:\n"
"\n"
"\n"
"declare nname varchar;\n"
"nname := \"VAD\".\"DBA\".\"VAD_FULL_PATH\" (parr, curdir);\n"
"if (not exists (select \"R_ID\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = curdir and \"R_KEY\" = nname))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'parent directory name mismatch:%s\', nname));\n"
"return nname;\n"
"}\n"
"--src vad_root.sql:334\n"
;

static const char *proc12 = 
"#line 361 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_TEST_NODE_TYPE\" (in type varchar) returns varchar\n"
"{\n"
"type := upper (type);\n"
"if (  type is null or\n"
"(neq (type, \'FOLDER\')\n"
"and neq (type, \'STRING\')\n"
"and neq (type, \'INTEGER\')\n"
"and neq (type, \'KEY\')\n"
"and neq (type, \'URL\')\n"
"and neq (type, \'XML\')))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'illegal node type:%s\',cast (type as varchar)));\n"
"return type;\n"
"}\n"
"--src vad_root.sql:359\n"
;

static const char *proc13 = 
"#line 376 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_MKDIR\" (inout parr any, in curdir integer, in name varchar ) returns integer\n"
"{\n"
"curdir := cast (curdir as integer);\n"
"declare nname varchar;\n"
"declare _id integer;\n"
"nname := \"VAD\".\"DBA\".\"VAD_TEST_PARENT\" (parr, curdir, name, _id);\n"
"if (aref(nname, length (nname) - 1 ) <> 47)\n"
"nname := concat (nname, \'/\');\n"
"nname := concat (nname,  name);\n"
"if (_id is null)\n"
"_id := sequence_next(\'vad_id\');\n"
"insert replacing \"VAD\".\"DBA\".\"VAD_REGISTRY\" (\"R_ID\", \"R_PRNT\", \"R_KEY\", \"R_SHKEY\", \"R_TYPE\") values (_id, curdir, nname, name, \'FOLDER\');\n"
"\n"
"\n"
"return _id;\n"
"}\n"
"--src vad_root.sql:374\n"
;

static const char *proc14 = 
"#line 395 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_MKCD\" (inout parr any, in curdir integer, in name varchar ) returns integer\n"
"{\n"
"curdir := cast (curdir as integer);\n"
"declare tid integer;\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, curdir, name);\n"
"if (tid)\n"
"return tid;\n"
"else\n"
"return \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, curdir, name);\n"
"}\n"
"--src vad_root.sql:393\n"
;

static const char *proc15 = 
"#line 408 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_RMDIR\" (inout parr any, in curdir integer) returns integer\n"
"{\n"
"curdir := cast (curdir as integer);\n"
"declare name varchar;\n"
"declare id integer;\n"
"if (not exists (select \"R_ID\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = curdir and \"R_TYPE\" = \'FOLDER\'))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Directory been removed does not exist:%d\', curdir));\n"
"if (1 = curdir)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'You can\\\'t remove root directory\'));\n"
"\n"
"select \"R_KEY\", \"R_PRNT\" into name, id from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = curdir;\n"
"\n"
"if (exists (select \"R_KEY\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\" = curdir))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Directory is not empty:%s\', name));\n"
"delete from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where blob_to_string (\"R_VALUE\") = name and \"R_TYPE\" = \'KEY\';\n"
"delete from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = curdir;\n"
"\n"
"if (parr is not null)\n"
"\"PUMP\".\"DBA\".\"CHANGE_VAL\" (parr, \'reg_curdir\', cast (id as varchar));\n"
"\n"
"\n"
"return 1;\n"
"}\n"
"--src vad_root.sql:406\n"
;

static const char *proc16 = 
"#line 434 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_RMNODE\" (in id integer) returns integer\n"
"{\n"
"id := cast (id as integer);\n"
"declare skey varchar;\n"
"whenever not found goto err;\n"
"select \"R_KEY\" into skey from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = id and \"R_TYPE\" <> \'FOLDER\';\n"
"\n"
"delete from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where blob_to_string (\"R_VALUE\") = skey and \"R_TYPE\" = \'KEY\';\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"delete from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = id;\n"
"\n"
"\n"
"\n"
"return 1;\n"
"err:\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Item been removed does not exist:%d\', id));\n"
"}\n"
"--src vad_root.sql:432\n"
;

static const char *proc17 = 
"#line 458 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_MKNODE\" (inout parr any, in curdir integer, in name varchar, in type varchar, in val varchar ) returns integer\n"
"{\n"
"declare _id integer;\n"
"curdir := cast (curdir as integer);\n"
"type := \"VAD\".\"DBA\".\"VAD_TEST_NODE_TYPE\" (type);\n"
"declare nname varchar;\n"
"nname := \"VAD\".\"DBA\".\"VAD_TEST_PARENT\" (parr, curdir, name, _id);\n"
"if (aref(nname, length (nname) - 1 ) <> 47)\n"
"nname := concat (nname, \'/\');\n"
"nname := concat (nname,  name);\n"
"\"VAD\".\"DBA\".\"VAD_TEST_VALUE\" (type, val);\n"
"if (_id is null)\n"
"_id := sequence_next(\'vad_id\');\n"
"delete from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = _id;\n"
"insert into \"VAD\".\"DBA\".\"VAD_REGISTRY\" (\"R_ID\", \"R_PRNT\", \"R_KEY\", \"R_SHKEY\", \"R_TYPE\", \"R_VALUE\") values (_id, curdir, nname, name, type, val);\n"
"\n"
"\n"
"return _id;\n"
"}\n"
"--src vad_root.sql:456\n"
;

static const char *proc18 = 
"#line 480 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_UPDATE_NODE\" (in curid integer, in val varchar, in oldval varchar ) returns integer\n"
"{\n"
"curid := cast (curid as integer);\n"
"declare name, oval, type, okey varchar;\n"
"declare prnt integer;\n"
"whenever not found goto err;\n"
"\n"
"select \"R_SHKEY\", \"R_TYPE\", \"R_VALUE\", \"R_PRNT\", \"R_KEY\" into name, type, oval, prnt, okey from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = curid and \"R_TYPE\" <> \'FOLDER\';\n"
"if (neq (oldval, oval))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Value of item \"%s\" was changed from outside\', name));\n"
"\n"
"\"VAD\".\"DBA\".\"VAD_TEST_VALUE\" (type, val);\n"
"\n"
"update \"VAD\".\"DBA\".\"VAD_REGISTRY\" set \"R_PRNT\"=prnt, \"R_KEY\"=okey, \"R_SHKEY\"=name, \"R_TYPE\"=type, \"R_VALUE\"=val where \"R_ID\"=curid;\n"
"\n"
"\n"
"\n"
"return 1;\n"
"\n"
"err:\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Attempt of getting info for non-existent node %d\', curid));\n"
"}\n"
"--src vad_root.sql:478\n"
;

static const char *proc19 = 
"#line 504 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_TEST_VALUE\" ( in type varchar, inout val varchar ) returns integer\n"
"{\n"
"if (equ (type, \'FOLDER\'))\n"
"return 1;\n"
"else if (equ (type, \'STRING\') or equ (type, \'URL\'))\n"
"{\n"
"val := cast (val as varchar);\n"
"return 1;\n"
"}\n"
"else if (equ (type, \'INTEGER\'))\n"
"{\n"
"val := trim (val);\n"
"if (val is null or 0=length(val))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'Empty  string used as integer value\');\n"
"declare c integer;\n"
"c := aref (val, 0);\n"
"if (c<48 or c>57)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'Non-numeric string used as integer value\');\n"
"val := cast (cast (val as integer) as varchar);\n"
"return 1;\n"
"}\n"
"else if (equ (type, \'KEY\'))\n"
"{\n"
"if (not exists (select \"R_ID\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_KEY\" = val))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Attempt to create key on non-existing item:%s\', cast (val as varchar)));\n"
"return 1;\n"
"}\n"
"else if (equ (type, \'XML\'))\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"declare tree any;\n"
"tree := xml_tree (val);\n"
"return 1;\n"
"}\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'illegal node type:%s\',cast (type as varchar)));\n"
"}\n"
"--src vad_root.sql:502\n"
;

static const char *proc20 = 
"#line 550 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_NODE_INFO\" (in nodeid integer, inout name varchar, inout type varchar, inout val varchar ) returns integer\n"
"{\n"
"nodeid := cast (nodeid as integer);\n"
"whenever not found goto err;\n"
"select \"R_SHKEY\", \"R_TYPE\", \"R_VALUE\" into name, type, val from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = nodeid and \"R_TYPE\" <> \'FOLDER\';\n"
"return 1;\n"
"\n"
"err:\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Attempt of getting info for inexistent node %d\', nodeid));\n"
"}\n"
"--src vad_root.sql:548\n"
;

static const char *proc21 = 
"#line 563 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (in curdir integer, in nodename varchar, inout name varchar, inout type varchar, inout val varchar, in ignite_error integer := 1 ) returns integer\n"
"{\n"
"declare iid integer;\n"
"curdir := cast (curdir as integer);\n"
"whenever not found goto err;\n"
"select \"R_ID\", \"R_SHKEY\", \"R_TYPE\", \"R_VALUE\" into iid, name, type, val from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\" = curdir and \"R_TYPE\" <> \'FOLDER\' and \"R_SHKEY\" = nodename;\n"
"return iid;\n"
"\n"
"err:\n"
"if (ignite_error)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Attempt of getting info for inexistent node %d/%s\', curdir, nodename));\n"
"return 0;\n"
"}\n"
"--src vad_root.sql:561\n"
;

static const char *proc22 = 
"#line 579 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_NEW_PACKAGE\" (inout parr any, in name varchar, in version varchar ) returns integer\n"
"{\n"
"declare curdir, tid, ret integer;\n"
"declare ini any;\n"
"declare s, lname, ltype, lval varchar;\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, name);\n"
"if (tid = 0)\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\"(parr, curdir, name);\n"
"ret := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(tid, \'CurrentVersion\', lname, ltype, lval, 0);\n"
"if (not ret)\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\"(parr, tid, \'CurrentVersion\', \'STRING\', version);\n"
"else\n"
"\"VAD\".\"DBA\".\"VAD_UPDATE_NODE\"(ret, version, lval);\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, tid, version);\n"
"if (curdir = 0)\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\"(parr, tid, version);\n"
"else\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf (\'There exists such package:%s\', name));\n"
"ini := null;\n"
"s := concat(\'/DAV/VAD/\', name, \'/\');\n"
"\"VAD\".\"DBA\".\"VAD_DAV_MKCOL\"(ini, s);\n"
"s := concat(s, version, \'/\');\n"
"\"VAD\".\"DBA\".\"VAD_DAV_MKCOL\"(ini, s);\n"
"return tid;\n"
"}\n"
"--src vad_root.sql:577\n"
;

static const char *proc23 = 
"#line 607 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"__VAD_BUILD_TREE\" ( in curdir integer, in name varchar, in ltype varchar, in lkey varchar ) returns any\n"
"{\n"
"declare tname, ttype, tkey varchar;\n"
"declare tid, fnd integer;\n"
"declare arr, arr2, tarr any;\n"
"declare lcurdir, sysf integer;\n"
"lcurdir := curdir;\n"
"sysf := 0;\n"
"tarr := null;\n"
"if (equ (ltype, \'KEY\'))\n"
"{\n"
"lcurdir := \"VAD\".\"DBA\".\"VAD_CHDIR\" (tarr, 1, lkey);\n"
"}\n"
"if (lcurdir < 1000)\n"
"sysf := 1;\n"
"arr := vector(lcurdir, name, sysf);\n"
"declare cr cursor for select  f1.\"R_ID\", f1.\"R_SHKEY\", f1.\"R_TYPE\", f1.\"R_VALUE\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" as f1 where \"R_PRNT\"=curdir and (\"R_TYPE\" = \'FOLDER\' or\n"
"(\"R_TYPE\" = \'KEY\' and exists (select  \"R_ID\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" as f2 where f2.\"R_TYPE\" = \'FOLDER\' and blob_to_string (f1.\"R_VALUE\") = f2.\"R_KEY\")));\n"
"open cr;\n"
"whenever not found goto fin;\n"
"fnd := 0;\n"
"while (1)\n"
"{\n"
"fetch cr into tid, tname, ttype, tkey;\n"
"if (tid <> curdir)\n"
"{\n"
"arr2 := \"VAD\".\"DBA\".\"__VAD_BUILD_TREE\" (tid, tname, ttype, tkey);\n"
"arr := vector_concat (arr, vector(arr2));\n"
"fnd := 1;\n"
"}\n"
"}\n"
"fin:\n"
"close cr;\n"
"if (fnd = 0)\n"
"arr := vector_concat (arr, vector(NULL));\n"
"return arr;\n"
"}\n"
"--src vad_root.sql:605\n"
;

static const char *proc24 = 
"#line 647 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_BUILD_TREE\" (  ) returns any\n"
"{\n"
"declare arr any;\n"
"arr := \"VAD\".\"DBA\".\"__VAD_BUILD_TREE\" (1, \'/\', \'FOLDER\', \'/\');\n"
"return arr;\n"
"}\n"
"--src vad_root.sql:645\n"
;

static const char *proc25 = 
"#line 656 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GET_PACKAGES\" ( ) returns any\n"
"{\n"
"declare retarr, tmparr any;\n"
"retarr := vector();\n"
"tmparr := null;\n"
"\n"
"declare curdir, tid, tid2 integer;\n"
"declare tname, tname2 varchar;\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(tmparr, 0, \'/VAD\');\n"
"declare cr cursor for select  \"R_ID\", \"R_SHKEY\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\"=curdir and \"R_TYPE\" = \'FOLDER\';\n"
"open cr;\n"
"while (1)\n"
"{\n"
"whenever not found goto fin;\n"
"fetch cr into tid, tname;\n"
"\n"
"declare cr2 cursor for select  \"R_VALUE\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\"=tid and \"R_TYPE\" = \'STRING\' and R_SHKEY=\'CurrentVersion\';\n"
"open cr2;\n"
"while (1)\n"
"{\n"
"declare build, inst, title, verid any;\n"
"whenever not found goto fin2;\n"
"fetch cr2 into tname2;\n"
"verid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(tmparr, tid, tname2);\n"
"build := (select  \"R_VALUE\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\"=verid and \"R_TYPE\" = \'STRING\' and R_SHKEY=\'Release Date\');\n"
"inst := (select  \"R_VALUE\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\"=verid and \"R_TYPE\" = \'STRING\' and R_SHKEY=\'Install Date\');\n"
"title := (select  \"R_VALUE\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\"=verid and \"R_TYPE\" = \'STRING\' and R_SHKEY=\'Title\');\n"
"retarr := vector_concat (retarr, vector (vector (tid2, tname, tname2, build, inst, title)));\n"
"}\n"
"fin2:;\n"
"}\n"
"fin:\n"
"close cr;\n"
"\n"
"return retarr;\n"
"}\n"
"--src vad_root.sql:654\n"
;

static const char *proc26 = 
"#line 694 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"__VAD_DEL_SUBTREE\"(in curdir integer) returns any\n"
"{\n"
"declare tname varchar;\n"
"declare tid, fnd integer;\n"
"declare cr cursor for select \"R_ID\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\"=curdir and \"R_TYPE\" = \'FOLDER\';\n"
"open cr;\n"
"whenever not found goto fin;\n"
"fnd := 0;\n"
"while (1)\n"
"{\n"
"fetch cr into tid;\n"
"if (tid <> curdir)\n"
"\"VAD\".\"DBA\".\"__VAD_DEL_SUBTREE\" (tid);\n"
"}\n"
"close cr;\n"
"fin:\n"
"for select \"R_ID\" as rid from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\" = curdir do\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_RMNODE\" (rid);\n"
"}\n"
"declare arr any;\n"
"arr := vector();\n"
"\"VAD\".\"DBA\".\"VAD_RMDIR\" (arr, curdir);\n"
"\n"
"\n"
"\n"
"return 1;\n"
"}\n"
"--src vad_root.sql:692\n"
;

static const char *proc27 = 
"#line 725 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_DEL_SUBTREE\" ( in curdir integer ) returns any\n"
"{\n"
"curdir := cast (curdir as integer);\n"
"declare name varchar;\n"
"declare id integer;\n"
"if (not exists (select \"R_ID\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = curdir and \"R_TYPE\" = \'FOLDER\'))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Subtree been removed does not exist:%d\', curdir));\n"
"if (exists (select top 1 1 from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = curdir and \"R_PRNT\" = 1))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'You can\\\'t remove system subtree\'));\n"
"return \"VAD\".\"DBA\".\"__VAD_DEL_SUBTREE\" (curdir);\n"
"}\n"
"--src vad_root.sql:723\n"
;

static const char *proc28 = 
"#line 739 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GET_PKG_ID\" (inout parr any, in name varchar, in version varchar ) returns integer\n"
"{\n"
"declare curdir, tid integer;\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, name);\n"
"if (tid = 0)\n"
"return 0;\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, tid, version);\n"
"if (curdir = 0)\n"
"return 0;\n"
"else\n"
"return curdir;\n"
"}\n"
"--src vad_root.sql:737\n"
;

static const char *proc29 = 
"#line 755 \"[executable]/vad_root.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"__vad_init\"()\n"
"{\n"
"declare parr, ini any;\n"
"parr := NULL;\n"
"ini := NULL;\n"
"if (not exists(select * from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_ID\" = \"R_PRNT\"))\n"
"{\n"
"declare _ini_id integer;\n"
"sequence_next(\'vad_id\');\n"
"sequence_next(\'vad_id\');\n"
"sequence_next(\'vad_id\');\n"
"insert replacing \"VAD\".\"DBA\".\"VAD_REGISTRY\" (\"R_ID\", \"R_PRNT\", \"R_KEY\", \"R_SHKEY\", \"R_TYPE\") values (1, 1, \'/\', \'\', \'FOLDER\');\n"
"_ini_id := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, 1, \'INI\');\n"
"\"VAD\".\"DBA\".\"VAD_SET_ROOT\" ( \'DOCS_ROOT\', \'./vad/doc\');\n"
"\"VAD\".\"DBA\".\"VAD_SET_ROOT\" ( \'HTTP_ROOT\', \'./vad/vsp\');\n"
"\"VAD\".\"DBA\".\"VAD_SET_ROOT\" ( \'CODE_ROOT\', \'./vad/code\');\n"
"\"VAD\".\"DBA\".\"VAD_SET_ROOT\" ( \'DATA_ROOT\', \'./vad/data\');\n"
"\"VAD\".\"DBA\".\"VAD_SET_ROOT\" ( \'DAV_ROOT\',  \'/DAV/VAD\');\n"
"\"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, 1, \'DOCS\');\n"
"\"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, 1, \'FILES\');\n"
"\"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, 1, \'SCHEMA\');\n"
"\"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, 1, \'VAD\');\n"
"_ini_id := sequence_set (\'vad_id\', 0, 2);\n"
"sequence_set (\'__NEXT__vad_id\', _ini_id + 1, 1);\n"
"\n"
"}\n"
"}\n"
"--src vad_root.sql:753\n"
;


static const char *other1 = 
" \"VAD\".\"DBA\".\"__vad_init\"()\n";
/* vad_misc.sql */

static const char *proc30 = 
"#line 28 \"[executable]/vad_misc.sql\"\n"
" create procedure\n"
"DB.DBA.DAV_RES_GET (in path varchar,\n"
"inout data any,\n"
"in auth_uid varchar,\n"
"in auth_pwd varchar\n"
")\n"
"{\n"
"declare id, ouid, ogid, rc integer;\n"
"declare st char;\n"
"declare tmp any;\n"
"\n"
"if (0 > (id := DB.DBA.DAV_SEARCH_ID (path, \'r\')))\n"
"return id;\n"
"st := \'r\';\n"
"\n"
"\n"
"if (0 > (rc := DB.DBA.DAV_AUTHENTICATE (id, st, \'1__\', auth_uid, auth_pwd)))\n"
"return rc;\n"
"if (0 <> (rc := DB.DBA.DAV_IS_LOCKED (id , st)))\n"
"return rc;\n"
"\n"
"select RES_CONTENT into tmp from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"if (length (tmp) > 10000000)\n"
"{\n"
"data := string_output ();\n"
"http (tmp, data);\n"
"}\n"
"else\n"
"data := blob_to_string (tmp);\n"
"\n"
"return 1;\n"
"}\n"
"--src vad_misc.sql:26\n"
;

static const char *tbl1 = 
"create table \"VAD\".\"DBA\".\"VAD_HELP\" (\n"
"\"name\" varchar,\n"
"\"dflt\" varchar,\n"
"\"short_help\" varchar,\n"
"\"full_help\" long varchar,\n"
"primary key(\"name\")\n"
")\n";

static const char *proc31 = 
"#line 74 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"HTML_FOOTER_OUT\" ( in arr any )\n"
"{\n"
"http(\'</form></td></tr>\');\n"
"declare s varchar;\n"
"s := \"PUMP\".\"DBA\".\"__GET_KEYWORD\" (\'debug_in_footer\',arr,\'\');\n"
"if (s is not null and equ(s,\'on\'))\n"
"{\n"
"http(\'<TR CLASS=\"AdmBorders\"><TD COLSPAN=\"2\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\\n\');\n"
"http(\'<TR CLASS=\"CtrlMain\"><TD COLSPAN=\"2\" ALIGN=\"middle\">\');\n"
"\"PUMP\".\"DBA\".\"DUMP_DEBUG_INFO\" (arr);\n"
"http(\'</TD></TR>\');\n"
"}\n"
"http (\'<TR CLASS=\"CopyrightBorder\"><TD COLSPAN=\"2\"><IMG SRC=\"/admin/images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\');\n"
"http (\'<TR><TD ALIGN=\"right\" COLSPAN=\"2\"><P CLASS=\"Copyright\">Virtuoso Server \');\n"
"http (sys_stat(\'st_dbms_ver\'));\n"
"http (sprintf (\' VAD Interface (%s) - Copyright&copy; 1998-2015 OpenLink Software.</P></TD></TR>\',\"VAD\".\"DBA\".\"VAD_VERSION\" ()));\n"
"http (\'</TABLE>\\n</BODY>\');\n"
"}\n"
"--src vad_misc.sql:72\n"
;

static const char *proc32 = 
"#line 94 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"OUT_CHK_DFLT_PARS\" ( in req varchar )\n"
"{\n"
"declare vreq, treq any;\n"
"vreq := split_and_decode (req,0,\'\\0\\0@\');\n"
"declare s, _name varchar;\n"
"declare i, n integer;\n"
"if (vreq is null)\n"
"return 0;\n"
"n := length(vreq);\n"
"i := 0;\n"
"treq := vector();\n"
"http (\'<script> function chk_dflt () {var s=\\\'\\\';\\n\');\n"
"while (i<n)\n"
"{\n"
"_name := aref(vreq,i);\n"
"\n"
"declare sh varchar;\n"
"whenever not found goto smth;\n"
"select \"dflt\" into sh from \"VAD\".\"DBA\".\"VAD_HELP\" where \"name\"=_name;\n"
"\n"
"\n"
"http (sprintf(\'if (document.forms[0].%s.value != \\\'%s\\\')\\n\', _name, sh));\n"
"http (\'{return 0;}\\n\');\n"
"smth:\n"
"i := i + 1;\n"
"}\n"
"http (\'return 1;\\n}</script>\\n\');\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:92\n"
;

static const char *proc33 = 
"#line 125 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_STRIP_RN\" ( in str varchar )\n"
"{\n"
"declare ret any;\n"
"declare s varchar;\n"
"s := \' \';\n"
"ret := string_output();\n"
"declare i, n, c integer;\n"
"i := 0;\n"
"n := length (str);\n"
"while (i<n)\n"
"{\n"
"c := aref (str, i);\n"
"if (c<>10 and c <> 13)\n"
"{\n"
"aset (s, 0, c);\n"
"http (s, ret);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return string_output_string(ret);\n"
"}\n"
"--src vad_misc.sql:123\n"
;

static const char *proc34 = 
"#line 149 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"__VAD_TREE_OUT\" ( inout arr any, inout ses any, in level integer, in mask varchar, in islast integer, inout sz integer, in cd integer) returns any\n"
"{\n"
"declare nmask varchar;\n"
"declare i, n, l, curid integer;\n"
"declare t any;\n"
"if (arr is null)\n"
"return arr;\n"
"n:= length (arr);\n"
"if (n = 0)\n"
"return arr;\n"
"if (n < 3)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'Corrupted tree structure\');\n"
"i := 3;\n"
"declare gif varchar;\n"
"declare color varchar;\n"
"declare anchor varchar;\n"
"gif := \'\';\n"
"anchor := \'\';\n"
"curid := aref (arr, 0);\n"
"color := \'blue\';\n"
"if (cd = curid)\n"
"color := \'green\';\n"
"\n"
"t := aref (arr, 3);\n"
"if (t is not null and length(t)>0)\n"
"{\n"
"if (aref (arr, 2))\n"
"gif := \'minus.gif\';\n"
"else\n"
"gif := \'plus.gif\';\n"
"gif := sprintf (\'<img src=\"%s\" onclick=\"document.forms[0].tree_node_clicked.value=\\\'%d\\\';document.forms[0].submit();\">\', gif, curid);\n"
"}\n"
"anchor := sprintf (\'<a href=\"id=%d\" onclick=\"document.forms[0].tree_node_clicked.value=0;document.forms[0].reg_curdir.value=%d;document.forms[0].submit();return false;\"><font color=\"%s\">%s</font></a>\', aref (arr,0), aref (arr,0), color, aref (arr,1));\n"
"http (sprintf (\'%s%s%s\\n\', mask, gif, anchor), ses);\n"
"sz := sz + 1;\n"
"if (aref (arr, 2))\n"
"{\n"
"if (level)\n"
"{\n"
"if (islast)\n"
"{\n"
"aset (mask, level*2-2, 32);\n"
"aset (mask, level*2-1, 32);\n"
"}\n"
"else\n"
"{\n"
"aset (mask, level*2-2, 58);\n"
"aset (mask, level*2-1, 32);\n"
"}\n"
"}\n"
"while (i<n)\n"
"{\n"
"nmask := concat (mask, \':.\');\n"
"if (i<n-1)\n"
"l := 0;\n"
"else\n"
"l := 1;\n"
"aset (arr, i, \"VAD\".\"DBA\".\"__VAD_TREE_OUT\" (aref (arr,i), ses, level + 1, nmask, l, sz, cd));\n"
"i := i + 1;\n"
"}\n"
"}\n"
"return arr;\n"
"}\n"
"--src vad_misc.sql:147\n"
;

static const char *proc35 = 
"#line 215 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"__EXPAND_PATH\" ( inout arr any, in curdir integer, in clicked integer) returns integer\n"
"{\n"
"declare i, n, t, tt, flag integer;\n"
"declare tarr any;\n"
"n:= length (arr);\n"
"t := 0;\n"
"if (n = 0)\n"
"return arr;\n"
"if (n < 3)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'Corrupted tree structure\');\n"
"i := 3;\n"
"declare curid integer;\n"
"flag := 0;\n"
"curid := aref (arr, 0);\n"
"if (curid = clicked and aref (arr, 2))\n"
"{\n"
"\n"
"aset (arr, 2, 0);\n"
"flag := 1;\n"
"}\n"
"curid := aref (arr, 0);\n"
"while (i<n)\n"
"{\n"
"tarr := aref (arr,i);\n"
"tt := \"VAD\".\"DBA\".\"__EXPAND_PATH\" (tarr, curdir, clicked);\n"
"aset (arr, i, tarr);\n"
"if (tt)\n"
"{\n"
"t := 1;\n"
"aset (arr, 2, 1);\n"
"}\n"
"i := i + 1;\n"
"}\n"
"if (not flag and curid = clicked and not aref (arr, 2))\n"
"{\n"
"\n"
"aset (arr, 2, 1);\n"
"}\n"
"\n"
"if (curid = curdir)\n"
"t := 1;\n"
"return t;\n"
"}\n"
"--src vad_misc.sql:213\n"
;

static const char *proc36 = 
"#line 261 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_TREE_OUT\" ( inout parr any, inout arr any, in clicked integer, inout sz integer ) returns varchar\n"
"{\n"
"declare ses any;\n"
"ses := string_output();\n"
"declare s any;\n"
"declare cd integer;\n"
"\n"
"s := \"PUMP\".\"DBA\".\"__GET_KEYWORD\"(\'reg_curdir\', parr, \'\');\n"
"if (s is null or 0 = length(s))\n"
"s := \'0\';\n"
"\n"
"cd := cast (s as integer);\n"
"\"VAD\".\"DBA\".\"__EXPAND_PATH\" (arr, cd, clicked);\n"
"\"VAD\".\"DBA\".\"__VAD_TREE_OUT\" (arr, ses, 0, \'\', 1, sz, cd);\n"
"return string_output_string(ses);\n"
"}\n"
"--src vad_misc.sql:259\n"
;

static const char *proc37 = 
"#line 280 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_LIST_FOLDER\" (inout parr any, in id integer, in type varchar := \'file\' )\n"
"{\n"
"declare arr, tid integer;\n"
"declare tname, tval varchar;\n"
"arr := vector();\n"
"\n"
"whenever not found goto fin;\n"
"declare cr cursor for select  \"R_ID\", \"R_SHKEY\", \"R_VALUE\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\"= id and \"R_TYPE\" <> \'FOLDER\';\n"
"open cr;\n"
"while (1)\n"
"{\n"
"fetch cr into tid, tname, tval;\n"
"\n"
"arr := vector_concat (arr, vector (vector (tid, tname, tval, type))) ;\n"
"}\n"
"fin:\n"
"close cr;\n"
"return arr;\n"
"}\n"
"--src vad_misc.sql:278\n"
;

static const char *proc38 = 
"#line 302 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_REG_DIR_OUT\" (  inout arr any,\n"
"in sz integer )\n"
"{\n"
"declare curdir, fnd, tid integer;\n"
"declare s, tname varchar;\n"
"declare ses, tval any;\n"
"ses := string_output();\n"
"curdir := 0;\n"
"s := \"PUMP\".\"DBA\".\"__GET_KEYWORD\"(\'reg_curdir\', arr, \'\');\n"
"if (s is not null and length (s) > 0)\n"
"curdir := cast (s as integer);\n"
"\n"
"whenever not found goto fin;\n"
"declare cr cursor for select  \"R_ID\", \"R_SHKEY\", \"R_VALUE\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\"=curdir and \"R_TYPE\" <> \'FOLDER\';\n"
"open cr;\n"
"fnd := 0;\n"
"while (1)\n"
"{\n"
"fetch cr into tid, tname, tval;\n"
"\n"
"if (fnd)\n"
"http (\'&\', ses);\n"
"s := sprintf (\'%d=%s\', tid, (sprintf (\'%-20.20s = \"%s\"\', tname, cast (tval as varchar))));\n"
"\n"
"http (s, ses);\n"
"fnd := 1;\n"
"}\n"
"fin:\n"
"close cr;\n"
"\n"
"if (sz < 5)\n"
"sz := 5;\n"
"whenever not found goto fin2;\n"
"s := \'\';\n"
"s := \"VAD\".\"DBA\".\"VAD_FULL_PATH\" (arr, curdir);\n"
"fin2:\n"
"\"PUMP\".\"DBA\".\"HTML_SELECT_OUT\" (arr, \'items_list\', sprintf (\'Current:%s\', s ), string_output_string (ses), NULL, sprintf(\' size=%d style=\\\'{width: 100%%}\\\'\', sz), NULL, 40);\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:300\n"
;

static const char *proc39 = 
"#line 344 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_REG_TREE_OUT\" ( inout arr any, in rebuild integer := 0 )\n"
"{\n"
"declare arr2, ses any;\n"
"declare sz integer;\n"
"\n"
"arr2 := \"PUMP\".\"DBA\".\"__GET_KEYWORD\"(\'tree_ser\', arr, \'\');\n"
"if (arr2 is not null and length (arr2) > 0 and not rebuild)\n"
"{\n"
"ses := string_output();\n"
"gz_uncompress (decode_base64(arr2), ses);\n"
"arr2 := deserialize (string_output_string(ses));\n"
"}\n"
"else\n"
"arr2 := \"VAD\".\"DBA\".\"VAD_BUILD_TREE\" ();\n"
"declare s varchar;\n"
"s := \"PUMP\".\"DBA\".\"__GET_KEYWORD\"(\'tree_node_clicked\', arr, \'0\');\n"
"\n"
"sz := 0;\n"
"s := \"VAD\".\"DBA\".\"VAD_TREE_OUT\" (arr, arr2, cast (s as integer), sz);\n"
"\n"
"http(\'<table width=\"100%\"><tr><td class=\"genhead\">Registry Tree</td></tr><tr><td class=\"statdata\"><pre>\');\n"
"http(s);\n"
"http(\'</pre></td></tr>\');\n"
"http(\'</table>\');\n"
"s := \"VAD\".\"DBA\".\"VAD_STRIP_RN\" (encode_base64 (gz_compress (serialize (arr2))));\n"
"http (sprintf (\'\\n<script>document.forms[0].tree_ser.value=\"%s\";</script>\\n\',s));\n"
"return sz;\n"
"}\n"
"--src vad_misc.sql:342\n"
;

static const char *proc40 = 
"#line 375 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_OUT_PACKAGES_LIST\" (inout arr any) returns integer\n"
"{\n"
"declare s varchar;\n"
"\n"
"declare parr, pitem, ses any;\n"
"ses := string_output();\n"
"parr := \"VAD\".\"DBA\".\"VAD_GET_PACKAGES\" ( );\n"
"\n"
"declare i, n integer;\n"
"s := \'\';\n"
"\n"
"n := length (parr);\n"
"i := 0;\n"
"while (i < n)\n"
"{\n"
"pitem := aref (parr, i);\n"
"if (i)\n"
"http (\'&\', ses);\n"
"http (sprintf (\'%d=%s: %s\', aref (pitem, 0), aref (pitem, 1), aref (pitem, 2)), ses);\n"
"i := i + 1;\n"
"}\n"
"\n"
"do_smth_in_any_way:\n"
"\"PUMP\".\"DBA\".\"HTML_SELECT_OUT\" (arr, \'packages_list\', \'Available packages\', string_output_string (ses), NULL, \' size=10 style=\\\'{width: 100%}\\\'\', NULL, 50);\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:373\n"
;

static const char *proc41 = 
"#line 404 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GEN_PACKAGES_LIST\" (inout arr any, in execstr varchar ) returns integer\n"
"{\n"
"declare s varchar;\n"
"\n"
"declare parr, pitem, ses any;\n"
"ses := string_output();\n"
"parr := \"VAD\".\"DBA\".\"VAD_GET_PACKAGES\" ( );\n"
"\n"
"declare i, n integer;\n"
"s := \'\';\n"
"\n"
"declare curp integer;\n"
"curp := cast (\"PUMP\".\"DBA\".\"__GET_KEYWORD\"(\'packages_list\', arr, \'\') as integer );\n"
"\n"
"http (\'<table class=\"statdata\" border=\"0\" cellpadding=\"0\">\');\n"
"http (\'<tr><th CLASS=\"genhead\" style=\"{width:2in}\">Package</th><th CLASS=\"genhead\" style=\"{width:2in}\">Version</th></tr>\');\n"
"n := length (parr);\n"
"i := 0;\n"
"while (i < n)\n"
"{\n"
"pitem := aref (parr, i);\n"
"declare onclick varchar;\n"
"onclick := \'<a href=\"\" onclick=\"document.forms[0].packages_list.value=%d;document.forms[0].submit();return false;\">%s</a>\';\n"
"http (\'<tr><td CLASS=\"statlisthead\">\');\n"
"http (sprintf (onclick, aref (pitem, 0), aref (pitem, 1)));\n"
"http (\'</td>\');\n"
"\n"
"http (\'<td CLASS=\"statlistdata\">\');\n"
"http (sprintf (onclick, aref (pitem, 0), aref (pitem, 2)));\n"
"http (\'</td></tr>\');\n"
"if (curp = aref (pitem, 0))\n"
"{\n"
"\n"
"http (\'<tr><td CLASS=\"statlistdata\" colspan=2>\');\n"
"exec (sprintf (\'%s (\\\'%s\\\',\\\'%s\\\')\',execstr,  aref (pitem, 1), aref (pitem, 2)));\n"
"http (\'</td></tr>\');\n"
"}\n"
"i := i + 1;\n"
"}\n"
"\n"
"do_smth_in_any_way:\n"
"http (\'</table>\');\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:402\n"
;

static const char *proc42 = 
"#line 450 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GEN_PACKAGE_DOCS\" (in pkgname varchar , in pkgver varchar) returns integer\n"
"{\n"
"declare tarr any;\n"
"tarr := null;\n"
"declare s varchar;\n"
"http(\'<hr>\');\n"
"s := sprintf (\'/DOCS/%s/%s\', pkgname, pkgver);\n"
"declare id integer;\n"
"id := \"VAD\".\"DBA\".\"VAD_CHDIR\" (tarr, 1, s);\n"
"if (not id)\n"
"return 0;\n"
"http (\'<table class=\"statdata\" border=\"0\" cellpadding=\"0\">\');\n"
"whenever not found goto fin;\n"
"declare cr cursor for select  \"R_VALUE\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\"=id and \"R_TYPE\" <> \'FOLDER\';\n"
"open cr;\n"
"while (1)\n"
"{\n"
"fetch cr into s;\n"
"http (\'<tr><td colspan=2>\');\n"
"http (s);\n"
"http (\'</td></tr>\');\n"
"}\n"
"fin:\n"
"close cr;\n"
"http (\'</table>\');\n"
"http(\'<hr>\');\n"
"}\n"
"--src vad_misc.sql:448\n"
;

static const char *proc43 = 
"#line 480 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GEN_PACKAGE_HTTP\" (in pkgname varchar , in pkgver varchar) returns integer\n"
"{\n"
"declare tarr any;\n"
"tarr := null;\n"
"declare s varchar;\n"
"http(\'<hr>\');\n"
"s := sprintf (\'/VAD/%s/%s/resources/http\', pkgname, pkgver);\n"
"declare id integer;\n"
"id := \"VAD\".\"DBA\".\"VAD_CHDIR\" (tarr, 1, s);\n"
"if (not id)\n"
"return 0;\n"
"http (\'<table class=\"statdata\" border=\"0\" cellpadding=\"0\">\');\n"
"whenever not found goto fin;\n"
"declare cr cursor for select  \"R_VALUE\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\"=id and \"R_TYPE\" <> \'FOLDER\';\n"
"open cr;\n"
"while (1)\n"
"{\n"
"fetch cr into s;\n"
"http (\'<tr><td colspan=2>\');\n"
"http (sprintf (\'<a href = \"/VAD/%s\">%s</a>\', s, s));\n"
"http (\'</td></tr>\');\n"
"}\n"
"fin:\n"
"close cr;\n"
"http (\'</table>\');\n"
"http(\'<hr>\');\n"
"}\n"
"--src vad_misc.sql:478\n"
;

static const char *proc44 = 
"#line 510 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_TEST_PACKAGE_EQ\" (inout parr any, in pkgname varchar , in pkgver varchar) returns integer\n"
"{\n"
"declare s varchar;\n"
"s := sprintf (\'/VAD/%s\', pkgname);\n"
"declare id integer;\n"
"id := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, 1, s);\n"
"if (not id)\n"
"return 0;\n"
"if (exists (\n"
"select \"R_ID\" from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where \"R_PRNT\" = id and \"R_TYPE\" = \'FOLDER\' and \"R_SHKEY\" = pkgver\n"
"))\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:508\n"
;

static const char *proc45 = 
"#line 527 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_TEST_PACKAGE_LT\" (inout parr any, in pkgname varchar , in pkgver varchar) returns integer\n"
"{\n"
"declare s varchar;\n"
"s := sprintf (\'/VAD/%s\', pkgname);\n"
"declare id integer;\n"
"id := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, 1, s);\n"
"if (not id)\n"
"return 0;\n"
"\n"
"if (exists (\n"
"select \"R_ID\" \n"
"from \"VAD\".\"DBA\".\"VAD_REGISTRY\" \n"
"where \"R_PRNT\" = id and \n"
"\"R_TYPE\" = \'FOLDER\' and \n"
"\"VAD\".\"DBA\".\"VERSION_COMPARE\" (\"R_SHKEY\", pkgver) = -1\n"
"))\n"
"return 1;\n"
"\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:525\n"
;

static const char *proc46 = 
"#line 549 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_TEST_PACKAGE_GT\" (inout parr any, in pkgname varchar , in pkgver varchar) returns integer\n"
"{\n"
"declare s varchar;\n"
"s := sprintf (\'/VAD/%s\', pkgname);\n"
"declare id integer;\n"
"id := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, 1, s);\n"
"if (not id)\n"
"return 0;\n"
"if (exists (\n"
"select \"R_ID\" \n"
"from \"VAD\".\"DBA\".\"VAD_REGISTRY\" \n"
"where \"R_PRNT\" = id and \n"
"\"R_TYPE\" = \'FOLDER\' and \n"
"\"VAD\".\"DBA\".\"VERSION_COMPARE\" (\"R_SHKEY\", pkgver) = 1\n"
"))\n"
"return 1;\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:547\n"
;

static const char *proc47 = 
"#line 569 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_TEST_PACKAGE_AND_REMOVE\" (inout parr any, in pkgname varchar , in pkgver varchar) returns integer\n"
"{\n"
"declare s varchar;\n"
"s := sprintf (\'/VAD/%s/%s\', pkgname, pkgver);\n"
"declare id integer;\n"
"id := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, 1, s);\n"
"if (not id)\n"
"return 0;\n"
"declare lname, ltype, lval varchar;\n"
"\"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (id, \'Status\', lname, ltype, lval);\n"
"if (lval <> \'Installed\')\n"
"\"VAD\".\"DBA\".\"VAD_DEL_SUBTREE\" (id);\n"
"\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:567\n"
;

static const char *proc48 = 
"#line 586 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_EXEC\" (in prog varchar) returns integer\n"
"{\n"
"if (prog is null or length (prog) = 0)\n"
"return 0;\n"
"declare pname varchar;\n"
"pname := sprintf (\'vad.dba.vad_%d_code\', sequence_next(\'vad_tmp\'));\n"
"\n"
"\n"
"exec (sprintf (\'create procedure %s () { declare exit handler for not found { signal (\\\'42000\\\', \\\'No WHENEVER statement provided for SQLCODE 100\\\'); }; set_qualifier (\\\'DB\\\'); %s }\',\n"
"pname, cast(blob_to_string(prog) as varchar)));\n"
"exec (sprintf (\'%s ()\', pname));\n"
"exec (sprintf (\'drop procedure %s\', pname));\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:584\n"
;

static const char *proc49 = 
"#line 602 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_LOAD_FILE\" (in fname varchar) returns integer\n"
"{\n"
"declare code varchar;\n"
"declare s varchar;\n"
"\n"
"declare continue handler for sqlstate \'39000\' { goto error_nofile; };\n"
"declare continue handler for sqlstate \'42000\' { goto error_nofile; };\n"
"\n"
"declare iniarr, tarr any;\n"
"tarr := vector ();\n"
"iniarr := \"VAD\".\"DBA\".\"VAD_READ_INI\" (tarr);\n"
"\n"
"s := sprintf (\'%s/%s\',get_keyword (\'code\', iniarr), fname);\n"
"\n"
"code := file_to_string (s);\n"
"if (code is null)\n"
"return 0;\n"
"\n"
"declare i, n integer;\n"
"\n"
"tarr := sql_split_text (code);\n"
"n := length (tarr);\n"
"i := 0;\n"
"while (i < n)\n"
"{\n"
"\n"
"s := aref (tarr, i);\n"
"\n"
"exec (s);\n"
"i := i + 1;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"return 1;\n"
"error_nofile:;\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Attempt to load inexistent file\\n%s\', __SQL_MESSAGE));\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:600\n"
;

static const char *proc50 = 
"#line 670 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_VHOST_DEFINE\" (in pkgname varchar, in pkgver varchar ) returns integer\n"
"{\n"
"DB.DBA.VHOST_DEFINE(lpath=>sprintf (\'/VAD/%s/%s/\', pkgname, pkgver),ppath=>sprintf (\'/%s/%s/%s/\',\"VAD\".\"DBA\".\"VAD_GET_ROOT\" (\'http\'), pkgname, pkgver),vsp_user=>\'DBA\');\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:668\n"
;

static const char *proc51 = 
"#line 677 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_VHOST_REMOVE\" (in pkgname varchar, in pkgver varchar ) returns integer\n"
"{\n"
"DB.DBA.VHOST_REMOVE(lpath=>sprintf (\'/VAD/%s/%s/\', pkgname, pkgver));\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:675\n"
;

static const char *proc52 = 
"#line 684 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_EXEC_RETRYING\" (in _expn varchar) returns varchar\n"
"{\n"
"declare _state, _message varchar;\n"
"declare _retries integer;\n"
"_state := \'\';\n"
"_retries := 0;\n"
"while(1)\n"
"{\n"
"exec (_expn, _state, _message);\n"
"if (_state <> \'41000\')\n"
"return _state;\n"
"if (_retries > 10)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"  (concat (\'Continuous deadlocks in\\n\', _expn, \'\\n\'));\n"
"_retries := _retries+1;\n"
"}\n"
"}\n"
"--src vad_misc.sql:682\n"
;

static const char *proc53 = 
"#line 702 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_ASSERT2\" (in _val integer, in _text varchar)\n"
"{\n"
"if (not _val)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (_text);\n"
"}\n"
"--src vad_misc.sql:700\n"
;

static const char *proc54 = 
"#line 709 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_ASSERT\" (in _expn varchar)\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_EXEC_RETRYING\" (\n"
"concat (\n"
"\'\"DB\".\"DBA\".\"VAD_ASSERT2\"((\', _expn, \'), concat (\'\'Assertion failed: \'\', \',\n"
"\"WS\".\"WS\".\"STR_SQL_APOS\"(_expn), \'))\' ) );\n"
"}\n"
"--src vad_misc.sql:707\n"
;

static const char *proc55 = 
"#line 718 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_SAFE_EXEC\" (in _expn varchar) returns integer\n"
"{\n"
"declare exit handler for sqlstate \'*\' { goto error_smth; };\n"
"if (not length (\"VAD\".\"DBA\".\"VAD_EXEC_RETRYING\" (_expn)))\n"
"{\n"
"return 1;\n"
"}\n"
"error_smth:;\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:716\n"
;

static const char *proc56 = 
"#line 730 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GET_NAME_AND_VERSION\"(\n"
"in name_and_version varchar,\n"
"inout name varchar,\n"
"inout version varchar) returns integer\n"
"{\n"
"declare dot_pos integer;\n"
"dot_pos := strchr(name_and_version, \'/\');\n"
"if (dot_pos)\n"
"{\n"
"name := subseq(name_and_version, 0, dot_pos);\n"
"if (name = \'\' or name is null)\n"
"return 0;\n"
"version := subseq(name_and_version, dot_pos + 1);\n"
"if (version = \'\' or version is null)\n"
"return 0;\n"
"return 1;\n"
"}\n"
"else\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:728\n"
;

static const char *proc57 = 
"#line 769 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VERSION_COMPARE\"(in x varchar, in y varchar)\n"
"{\n"
"declare xx, yy any;\n"
"declare xsuff, ysuff varchar;\n"
"declare xi, yi int;\n"
"\n"
"if (x is null)\n"
"return 0;\n"
"if (length (x) = 0 and length (y) > 0)\n"
"return 1;\n"
"\n"
"\n"
"xsuff := \'\';\n"
"xx := sprintf_inverse (x, \'%s_%s\', 0);\n"
"if (not xx is null)\n"
"{\n"
"xsuff := xx[1];\n"
"x := xx[0];\n"
"}\n"
"ysuff := \'\';\n"
"yy := sprintf_inverse (y, \'%s_%s\', 0);\n"
"if (not yy is null)\n"
"{\n"
"ysuff := yy[1];\n"
"y := yy[0];\n"
"}\n"
"\n"
"\n"
"xx := split_and_decode (x, 0, \'\\0\\0.\');\n"
"yy := split_and_decode (y, 0, \'\\0\\0.\');\n"
"\n"
"\n"
"while (length (xx) < length (yy))\n"
"xx := vector_concat (xx, vector (\'0\'));\n"
"while (length (yy) < length (xx))\n"
"yy := vector_concat (yy, vector (\'0\'));\n"
"\n"
"\n"
"for (declare i, l int, i := 0, l := length (xx); i < l; i := i + 1)\n"
"{\n"
"xi := atoi (xx[i]);\n"
"yi := atoi (yy[i]);\n"
"\n"
"if (xi < yi)\n"
"return -1;\n"
"if (xi > yi)\n"
"return 1;\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"xx := regexp_parse(\'([a-zA-Z]*)([0-9]*)\', xsuff, 0);\n"
"xi := atoi (substring (xsuff, xx[4]+1, xx[5]-xx[4]));\n"
"\n"
"yy := regexp_parse(\'([a-zA-Z]*)([0-9]*)\', ysuff, 0);\n"
"yi := atoi (substring (ysuff, yy[4]+1, yy[5]-yy[4]));\n"
"\n"
"if (xi < yi)\n"
"return -1;\n"
"else if (xi > yi)\n"
"return 1;\n"
"else\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:767\n"
;

static const char *proc58 = 
"#line 837 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_CHECK_FOR_HIGH_VERSION\" (in name varchar) returns varchar\n"
"{\n"
"declare version, prod varchar;\n"
"if (\"VAD\".\"DBA\".\"VAD_GET_NAME_AND_VERSION\"(name, prod, version) = 0)\n"
"return \'-1\';\n"
"declare parr, pitem any;\n"
"parr := \"VAD\".\"DBA\".\"VAD_GET_PACKAGES\"();\n"
"declare i, n integer;\n"
"n := length (parr);\n"
"i := 0;\n"
"declare cur_name, cur_version varchar;\n"
"while (i < n)\n"
"{\n"
"pitem := aref(parr, i);\n"
"cur_name := aref(pitem, 1);\n"
"if (prod = cur_name)\n"
"{\n"
"cur_version := aref(pitem, 2);\n"
"if (\"VAD\".\"DBA\".\"VERSION_COMPARE\"(cur_version, version) = 1)\n"
"return cur_version;\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return \'0\';\n"
"}\n"
"--src vad_misc.sql:835\n"
;

static const char *proc59 = 
"#line 864 \"[executable]/vad_misc.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_REMOVE_PREVIOUS_VERSION\" (in prod varchar, in version varchar) returns integer\n"
"{\n"
"declare dot_pos, ver1, ver2 integer;\n"
"declare ss varchar;\n"
"dot_pos := strchr(version, \'.\');\n"
"if (dot_pos)\n"
"{\n"
"ss := subseq(version, 0, dot_pos);\n"
"if (ss = \'\' or ss is null)\n"
"ver1 := 0;\n"
"else\n"
"ver1 := atoi(ss);\n"
"\n"
"ss := subseq(version, dot_pos + 1);\n"
"if (ss = \'\' or ss is null)\n"
"ver2 := 0;\n"
"else\n"
"ver2 := atoi(ss);\n"
"\n"
"}\n"
"else\n"
"{\n"
"ver1 := atoi(version);\n"
"ver2 := 0;\n"
"}\n"
"\n"
"\n"
"declare parr, pitem, verarr any;\n"
"parr := \"VAD\".\"DBA\".\"VAD_GET_PACKAGES\"();\n"
"declare i, n integer;\n"
"n := length (parr);\n"
"i := 0;\n"
"declare cur_name, cur_version varchar;\n"
"declare dot_pos1, v1, v2 integer;\n"
"declare curdir, tid integer;\n"
"declare parr1 any;\n"
"while (i < n)\n"
"{\n"
"pitem := aref(parr, i);\n"
"cur_name := aref(pitem, 1);\n"
"if (prod = cur_name)\n"
"{\n"
"cur_version := aref(pitem, 2);\n"
"dot_pos1 := strchr(cur_version, \'.\');\n"
"if (dot_pos)\n"
"{\n"
"ss := subseq(cur_version, 0, dot_pos1);\n"
"if (ss = \'\' or ss is null)\n"
"v1 := 0;\n"
"else\n"
"v1 := atoi(ss);\n"
"ss := subseq(cur_version, dot_pos1 + 1);\n"
"if (ss = \'\' or ss is null)\n"
"v2 := 0;\n"
"else\n"
"v2 := atoi(ss);\n"
"if ((v1 < ver1) or ((v1 = ver1) and (v2 < ver2)))\n"
"{\n"
"parr1 := null;\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr1, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr1, curdir, concat(prod, \'/\', cast(cur_version as varchar)));\n"
"if (tid)\n"
"\"VAD\".\"DBA\".\"VAD_DEL_SUBTREE\"(tid);\n"
"\n"
"}\n"
"if ((v1 > ver1) or ((v1 = ver1) and (v2 > ver2)))\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf (\'Package \"%s\" with higher version \"%s\" already exists\', prod, cur_version));\n"
"}\n"
"}\n"
"else\n"
"{\n"
"v1 := atoi(cur_version);\n"
"v2 := 0;\n"
"if ((v1 < ver1) or ((v1 = ver1) and (v2 < ver2)))\n"
"{\n"
"parr1 := null;\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr1, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr1, curdir, concat(prod, \'/\', cast(cur_version as varchar)));\n"
"if (tid)\n"
"\"VAD\".\"DBA\".\"VAD_DEL_SUBTREE\"(tid);\n"
"\n"
"}\n"
"if ((v1 > ver1) or ((v1 = ver1) and (v2 > ver2)))\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf (\'Package \"%s\" with higher version \"%s\" already exists\', prod, cur_version));\n"
"}\n"
"}\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src vad_misc.sql:862\n"
;

/* oper_pars.sql */

static const char *other2 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'reg_curdir\',\'1\',\'\',\'\')\n";
static const char *other3 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'tree_node_clicked\',\'0\',\'\',\'\')\n";
static const char *other4 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'tree_ser\',\'\',\'\',\'\')\n";
static const char *other5 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'reg_action\',\'\',\'\',\'\')\n";
static const char *other6 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'new_folder_name\',\'new_folder\',\'Name of new folder\',\'Name of new folder to be created at current path\')\n";
static const char *other7 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'new_item_name\',\'new_item\',\'Name of new Item\',\'Name of new item to be created at current path\')\n";
static const char *other8 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'new_item_value\',\'\',\'Value of new Item\',\'Value of new item to be created at current path\')\n";
static const char *other9 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'old_item_value\',\'\',\'Old value of new Item\',\'Old value of new item to be created at current path\')\n";
static const char *other10 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'new_item_type\',\'STRING\',\'Type of new Item\',\'Type of new item to be created at current path\')\n";
static const char *other11 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'del_item_id\',\'\',\'Handle of been deleting item\',\'Handle of been deleting item\')\n";
static const char *other12 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'items_list\',\'\',\'Content of current folder\',\'Content of current folder\')\n";
static const char *other13 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'result_txt\',\'\',\'\',\'\')\n";
static const char *other14 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'packages_list\',\'\',\'The list of existing packages\',\'The list of existing packages\')\n";
static const char *other15 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'new_pkg_name\',\'./tmp/new_package.vad\',\'Path of new Package\',\'Path of new item to be installed at current path\')\n";
static const char *other16 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'tmp\',\'\',\'\',\'\')\n";
static const char *other17 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'docs_root\',\'\',\'\',\'\')\n";
static const char *other18 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'http_root\',\'\',\'\',\'\')\n";
static const char *other19 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'code_root\',\'\',\'\',\'\')\n";
static const char *other20 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'data_root\',\'\',\'\',\'\')\n";
static const char *other21 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'last_error\',\'\',\'\',\'\')\n";
static const char *other22 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'password\',\'\',\'User Password\',\'This string authenticates the user in terms of Virtuoso DBMS core.<br>\')\n";
static const char *other23 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'user\',\'\',\'User Name\',\'This string identifies the user in terms of Virtuoso DBMS core.<br>\')\n";
static const char *other24 = 
"insert replacing \"VAD\".\"DBA\".\"VAD_HELP\" (\"name\",\"dflt\",\"short_help\",\"full_help\") values (\n"
"\'datasource\',\'\',\'Selected Datasource\',\'Selected Datasource\')\n";
/* pars_init.sql */

static const char *proc60 = 
"#line 24 \"[executable]/pars_init.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"RETRIEVE_HTTP_PARS\" ( in afrom any )\n"
"{\n"
"declare ato any;\n"
"ato := vector();\n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'reg_curdir\',\'1\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'tree_node_clicked\',\'0\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'tree_ser\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'reg_action\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'new_folder_name\',\'new_folder\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'new_item_name\',\'new_item\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'new_item_value\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'old_item_value\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'new_item_type\',\'STRING\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'del_item_id\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'items_list\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'result_txt\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'packages_list\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'new_pkg_name\',\'./tmp/new_package.vad\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'tmp\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'docs_root\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'http_root\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'code_root\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'data_root\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'last_error\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'password\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'user\',\'\'); \n"
"\"PUMP\".\"DBA\".\"__RETRIEVE_HTTP_PARS\" (afrom,ato,\'datasource\',\'\'); \n"
"return ato;\n"
"\n"
"}\n"
"--src pars_init.sql:22\n"
;

/* vad_make.sql */

static const char *proc61 = 
"#line 24 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"DAV_DELETE_VAD\" (\n"
"in path varchar,\n"
"in silent integer := 0,\n"
"in extern integer := 1)\n"
"{\n"
"declare id, rc integer;\n"
"declare ty char;\n"
"if (0 > (id := DB.DBA.DAV_SEARCH_ID (path, \'r\')))\n"
"{\n"
"if (0 > (id := DB.DBA.DAV_SEARCH_ID (path, \'c\')))\n"
"return (case when silent then 1 else id end);\n"
"else\n"
"ty := \'c\';\n"
"}\n"
"else\n"
"ty := \'r\';\n"
"if (0 <> (rc := DB.DBA.DAV_IS_LOCKED (id , ty)))\n"
"return rc;\n"
"if (ty = \'r\')\n"
"delete from WS.WS.SYS_DAV_RES where RES_ID = id;\n"
"else if (ty = \'c\')\n"
"{\n"
"declare rrc integer;\n"
"for select RES_FULL_PATH from WS.WS.SYS_DAV_RES where RES_COL = id do\n"
"{\n"
"rrc := \"VAD\".\"DBA\".\"DAV_DELETE_VAD\" (RES_FULL_PATH, silent, extern);\n"
"if (rrc <> 1)\n"
"{\n"
"rollback work;\n"
"return rrc;\n"
"}\n"
"}\n"
"for select COL_ID from WS.WS.SYS_DAV_COL where COL_PARENT = id do\n"
"{\n"
"rrc := \"VAD\".\"DBA\".\"DAV_DELETE_VAD\" (WS.WS.COL_PATH(COL_ID), silent, extern);\n"
"if (rrc <> 1)\n"
"{\n"
"rollback work;\n"
"return rrc;\n"
"}\n"
"}\n"
"delete from WS.WS.SYS_DAV_COL where COL_ID = id;\n"
"}\n"
"else if (not silent)\n"
"return -1;\n"
"return 1;\n"
"}\n"
"--src vad_make.sql:22\n"
;

static const char *proc62 = 
"#line 73 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"BLOB_2_STRING_OUTPUT\" (\n"
"in fname varchar,\n"
"in f1 integer,\n"
"in f2 integer,\n"
"inout ses any) returns integer\n"
"{\n"
"declare _blob, _part, _to_get any;\n"
"declare flen, offs, buf_sz integer;\n"
"\n"
"flen := f2 - f1;\n"
"select RES_CONTENT into _blob from ws.ws.sys_dav_res where RES_FULL_PATH=fname;\n"
"\n"
"if (f1 = 0 and length (_blob) = f2)\n"
"{\n"
"ses := string_output ();\n"
"http (_blob, ses);\n"
"}\n"
"else if (flen < 10000000)\n"
"{\n"
"ses := string_output ();\n"
"_part := subseq (_blob, f1, f2);\n"
"http (_part, ses);\n"
"}\n"
"else\n"
"{\n"
"ses := string_output (http_strses_memory_size ());\n"
"_to_get := flen;\n"
"offs := f1;\n"
"buf_sz := 5000000;\n"
"while (1)\n"
"{\n"
"\n"
"_part := subseq (_blob, offs, offs + buf_sz);\n"
"http (_part, ses);\n"
"offs := offs + buf_sz;\n"
"\n"
"if ((offs + buf_sz) > f2)\n"
"buf_sz := f2 - offs;\n"
"\n"
"if (buf_sz <= 0)\n"
"goto endloop;\n"
"}\n"
"endloop:;\n"
"}\n"
"\n"
"return 1;\n"
"}\n"
"--src vad_make.sql:71\n"
;

static const char *proc63 = 
"#line 122 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_DAV_MKCOL\" (\n"
"inout ini any,\n"
"in name varchar ) returns integer\n"
"{\n"
"declare parr any;\n"
"parr := null;\n"
"if (ini is null or length (ini) = 0)\n"
"ini := \"VAD\".\"DBA\".\"VAD_READ_INI\" (parr);\n"
"declare usr, pwd varchar;\n"
"declare ret integer;\n"
"usr := \'dav\';\n"
"pwd := pwd_magic_calc(\'dav\', (select U_PWD from WS.WS.SYS_DAV_USER where U_NAME=\'dav\'), 1);\n"
"ret := \"DB\".\"DBA\".\"DAV_COL_CREATE\" (name, \'110100100N\', usr, NULL, usr, pwd);\n"
"return ret;\n"
"}\n"
"--src vad_make.sql:120\n"
;

static const char *proc64 = 
"#line 139 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_DAV_MOVE\" (\n"
"in name varchar,\n"
"in destination varchar,\n"
"in overwrite int := 1) returns integer\n"
"{\n"
"declare usr, pwd varchar;\n"
"declare ret integer;\n"
"usr := \'dav\';\n"
"pwd := pwd_magic_calc(\'dav\', (select U_PWD from WS.WS.SYS_DAV_USER where U_NAME=\'dav\'), 1);\n"
"ret := \"DB\".\"DBA\".\"DAV_MOVE\" (name, destination, overwrite, usr, pwd);\n"
"return ret;\n"
"}\n"
"--src vad_make.sql:137\n"
;

static const char *proc65 = 
"#line 153 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_DAV_GET_RES\" (\n"
"inout ini any,\n"
"in name varchar,\n"
"inout data any ) returns integer\n"
"{\n"
"declare parr any;\n"
"parr := null;\n"
"if (ini is null or length (ini) = 0)\n"
"ini := \"VAD\".\"DBA\".\"VAD_READ_INI\" (parr);\n"
"declare usr, pwd varchar;\n"
"usr := \'dav\';\n"
"pwd := pwd_magic_calc(\'dav\', (select U_PWD from WS.WS.SYS_DAV_USER where U_NAME=\'dav\'), 1);\n"
"declare ret integer;\n"
"ret := \"DB\".\"DBA\".\"DAV_RES_GET\" (name, data, usr, pwd);\n"
"return ret;\n"
"}\n"
"--src vad_make.sql:151\n"
;

static const char *proc66 = 
"#line 171 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_DAV_UPLOAD_RES\" (\n"
"inout ini any,\n"
"in name varchar,\n"
"inout data any,\n"
"in dav_owner varchar,\n"
"in dav_grp varchar,\n"
"in dav_perm varchar) returns integer\n"
"{\n"
"declare parr any;\n"
"parr := null;\n"
"if (ini is null or length (ini) = 0)\n"
"ini := \"VAD\".\"DBA\".\"VAD_READ_INI\" (parr);\n"
"declare usr, pwd varchar;\n"
"declare ret integer;\n"
"usr := \'dav\';\n"
"pwd := pwd_magic_calc(\'dav\', (select U_PWD from WS.WS.SYS_DAV_USER where U_NAME=\'dav\'), 1);\n"
"ret := \"DB\".\"DBA\".\"DAV_RES_UPLOAD_STRSES\" (name, data, \'\', dav_perm, dav_owner, dav_grp, usr, pwd);\n"
"return ret;\n"
"}\n"
"--src vad_make.sql:169\n"
;

static const char *proc67 = 
"#line 192 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_DAV_DELETE\" (\n"
"inout ini any,\n"
"in name varchar ) returns integer\n"
"{\n"
"declare parr any;\n"
"parr := null;\n"
"if (ini is null or length (ini) = 0)\n"
"ini := \"VAD\".\"DBA\".\"VAD_READ_INI\" (parr);\n"
"declare ret integer;\n"
"ret := \"VAD\".\"DBA\".\"DAV_DELETE_VAD\" (name, 0);\n"
"return ret;\n"
"}\n"
"--src vad_make.sql:190\n"
;

static const char *proc68 = 
"#line 206 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_MD5_FILE\" (\n"
"in fname varchar,\n"
"in is_dav integer)\n"
"{\n"
"declare _len integer;\n"
"declare i, j integer;\n"
"declare ctx varchar;\n"
"ctx := md5_init();\n"
"if (is_dav = 0)\n"
"_len := cast (file_stat (fname, 1) as integer);\n"
"else\n"
"_len := (select length (RES_CONTENT) from ws.ws.sys_dav_res where RES_FULL_PATH=fname);\n"
"declare data varchar;\n"
"i := 0;\n"
"while (i < _len)\n"
"{\n"
"j := i + 4096;\n"
"if (j > _len)\n"
"j := _len;\n"
"if (is_dav = 0)\n"
"data := cast (file_to_string_output (fname, i, j) as varchar);\n"
"else\n"
"{\n"
"select subseq (RES_CONTENT, i, j) into data from WS.WS.SYS_DAV_RES where RES_FULL_PATH = fname;\n"
"}\n"
"ctx := md5_update (ctx, data);\n"
"i := i + 4096;\n"
"}\n"
"ctx := md5_final (ctx);\n"
"return ctx;\n"
"}\n"
"--src vad_make.sql:204\n"
;

static const char *proc69 = 
"#line 239 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_SPLIT_PATH\" (\n"
"in fpath varchar,\n"
"inout path varchar,\n"
"inout name varchar )\n"
"{\n"
"declare idx, idx2 integer;\n"
"idx := strrchr (fpath, \'/\');\n"
"idx2 := strrchr (fpath, \'\\\\\');\n"
"if (idx is not null or idx2 is not null)\n"
"{\n"
"if (idx is not null)\n"
"{\n"
"if (idx2 is not null)\n"
"{\n"
"if (idx < idx2)\n"
"idx := idx2;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (idx2 is not null)\n"
"idx := idx2;\n"
"}\n"
"path := subseq (fpath, 0, idx);\n"
"name := subseq (fpath, idx + 1, length (fpath));\n"
"}\n"
"}\n"
"--src vad_make.sql:237\n"
;

static const char *proc70 = 
"#line 268 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (\n"
"inout ses any,\n"
"inout pos integer,\n"
"in val integer,\n"
"inout ctx varchar )\n"
"{\n"
"declare s varchar;\n"
"s := \' \';\n"
"aset(s,0,val);\n"
"string_to_file (ses, s, -1);\n"
"ctx := md5_update (ctx, s);\n"
"pos := pos + 1;\n"
"}\n"
"--src vad_make.sql:266\n"
;

static const char *proc71 = 
"#line 283 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GET_CHAR\" (\n"
"inout ses any,\n"
"inout pos integer)\n"
"{\n"
"declare s varchar;\n"
"declare c integer;\n"
"\n"
"s := ses_read (ses, 1);\n"
"pos := pos + 1;\n"
"\n"
"c := aref (s, 0);\n"
"\n"
"return c;\n"
"}\n"
"--src vad_make.sql:281\n"
;

static const char *proc72 = 
"#line 299 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_OUT_LONG\" (\n"
"inout ses any,\n"
"inout pos integer,\n"
"in val integer,\n"
"inout ctx varchar  )\n"
"{\n"
"declare v1, v2, v3, v4 integer;\n"
"\n"
"v1 := mod (val, 256);\n"
"if (v1 < 0)\n"
"v1 := -v1;\n"
"v2 := mod (val, 256 * 256);\n"
"if (v2 < 0)\n"
"v2 := -v2;\n"
"v2 := v2 / 256;\n"
"\n"
"v3 := mod (val, 256 * 256 * 256);\n"
"if (v3 < 0)\n"
"v3 := -v3;\n"
"v3 := v3 / (256 * 256);\n"
"\n"
"v4 := (((val) / 256) / 256) / 256;\n"
"\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, v4, ctx);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, v3, ctx);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, v2, ctx);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, v1, ctx);\n"
"}\n"
"--src vad_make.sql:297\n"
;

static const char *proc73 = 
"#line 330 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GET_LONG\" (\n"
"inout ses any,\n"
"inout pos integer)\n"
"{\n"
"declare v1, v2, v3, v4 integer;\n"
"declare tmp, str varchar;\n"
"\n"
"str := cast (ses_read (ses, 4) as varchar);\n"
"pos := pos + 4;\n"
"\n"
"v4 := str[0];\n"
"v3 := str[1];\n"
"v2 := str[2];\n"
"v1 := str[3];\n"
"\n"
"return v1 + 256 * ( v2 + 256 * ( v3 + 256 * ( v4 )));\n"
"}\n"
"--src vad_make.sql:328\n"
;

static const char *proc74 = 
"#line 349 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_OUT_ROW\" (\n"
"inout ses any,\n"
"inout pos integer,\n"
"in name varchar,\n"
"inout data any,\n"
"inout ctx varchar )\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, 182, ctx);\n"
"declare _len integer;\n"
"_len := length (name);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_LONG\" (ses, pos, _len, ctx);\n"
"declare i integer;\n"
"i:=0;\n"
"while (i<_len)\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, aref (name, i), ctx);\n"
"i := i + 1;\n"
"}\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, 223, ctx);\n"
"_len := length (data);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_LONG\" (ses, pos, _len, ctx);\n"
"ctx := md5_update (ctx, data);\n"
"string_to_file (ses, data, -1);\n"
"}\n"
"--src vad_make.sql:347\n"
;

static const char *proc75 = 
"#line 375 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_OUT_ROW_FILE\" (\n"
"inout ses any,\n"
"inout pos integer,\n"
"in name varchar,\n"
"in fname varchar,\n"
"inout ctx varchar )\n"
"{\n"
"if (file_stat(fname, 3) = 0)\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf(\'Inexistent file resource (%s)\', fname));\n"
"}\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, 182, ctx);\n"
"declare _len integer;\n"
"_len := length (name);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_LONG\" (ses, pos, _len, ctx);\n"
"declare i, j integer;\n"
"i := 0;\n"
"while (i<_len)\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, aref (name, i), ctx);\n"
"i := i + 1;\n"
"}\n"
"_len := cast (file_stat (fname, 1) as integer);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, 223, ctx);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_LONG\" (ses, pos, _len, ctx);\n"
"declare data varchar;\n"
"i := 0;\n"
"while (i<_len)\n"
"{\n"
"j := i + 4096;\n"
"if (j > _len)\n"
"j := _len;\n"
"data := cast (file_to_string_output (fname, i, j) as varchar);\n"
"ctx := md5_update (ctx, data);\n"
"string_to_file (ses, data, -1);\n"
"i := i + 4096;\n"
"}\n"
"}\n"
"--src vad_make.sql:373\n"
;

static const char *proc76 = 
"#line 415 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_OUT_ROW_DAV\" (\n"
"inout ses any,\n"
"inout pos integer,\n"
"in name varchar,\n"
"in fname varchar,\n"
"inout ctx varchar,\n"
"inout ini any )\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, 182, ctx);\n"
"declare _len integer;\n"
"_len := length (name);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_LONG\" (ses, pos, _len, ctx);\n"
"declare i, j integer;\n"
"i := 0;\n"
"while (i < _len)\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, aref (name, i), ctx);\n"
"i := i + 1;\n"
"}\n"
"declare data varchar;\n"
"declare tmp any;\n"
"declare search_id integer;\n"
"search_id := DB.DBA.DAV_SEARCH_ID (fname, \'R\');\n"
"if (search_id < 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf(\'Inexistent DAV resource (%s)\', name));\n"
"select RES_CONTENT into tmp from WS.WS.SYS_DAV_RES\n"
"where RES_ID = search_id;\n"
"if (length (tmp) > 10000000)\n"
"{\n"
"data := string_output ();\n"
"http (tmp, data);\n"
"}\n"
"else\n"
"data := blob_to_string (tmp);\n"
"_len := length (data);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_CHAR\" (ses, pos, 223, ctx);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_LONG\" (ses, pos, _len, ctx);\n"
"ctx := md5_update (ctx, data);\n"
"string_to_file (ses, data, -1);\n"
"}\n"
"--src vad_make.sql:413\n"
;

static const char *proc77 = 
"#line 458 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GET_ROW\" (\n"
"inout ses any,\n"
"inout pos integer,\n"
"inout name varchar,\n"
"inout data any)\n"
"{\n"
"declare val integer;\n"
"declare _len integer;\n"
"\n"
"val := \"VAD\".\"DBA\".\"VAD_GET_CHAR\" (ses, pos);\n"
"if (val <> 182)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf(\'VAD file corrupt (pos=%d)\', pos));\n"
"_len := \"VAD\".\"DBA\".\"VAD_GET_LONG\" (ses, pos);\n"
"name := cast (ses_read (ses, _len) as varchar);\n"
"pos := pos + _len;\n"
"\n"
"val := \"VAD\".\"DBA\".\"VAD_GET_CHAR\" (ses, pos);\n"
"if (val <> 223)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf(\'VAD file corrupt (pos=%d)\', pos));\n"
"_len := \"VAD\".\"DBA\".\"VAD_GET_LONG\" (ses, pos);\n"
"if (0 <> _len) \n"
"data := ses_read (ses, _len);\n"
"else\n"
"data := \'\';\n"
"pos := pos + _len;\n"
"\n"
"if (equ (name, \'MD5\'))\n"
"return 0;\n"
"\n"
"return 1;\n"
"}\n"
"--src vad_make.sql:456\n"
;

static const char *proc78 = 
"#line 492 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GET_ROW_FILE\" (\n"
"inout ses any,\n"
"inout pos integer,\n"
"inout name varchar,\n"
"inout resources any,\n"
"inout iniarr any,\n"
"in is_dav integer )\n"
"{\n"
"declare val integer;\n"
"declare _len integer;\n"
"declare data any;\n"
"\n"
"val := \"VAD\".\"DBA\".\"VAD_GET_CHAR\" (ses, pos);\n"
"if (val <> 182)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf(\'VAD file corrupt (pos=%d)\', pos));\n"
"_len := \"VAD\".\"DBA\".\"VAD_GET_LONG\" (ses, pos);\n"
"name := cast (ses_read (ses, _len) as varchar);\n"
"pos := pos + _len;\n"
"\n"
"val := \"VAD\".\"DBA\".\"VAD_GET_CHAR\" (ses, pos);\n"
"if (val <> 223)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf(\'VAD file corrupt (pos=%d)\', pos));\n"
"_len := \"VAD\".\"DBA\".\"VAD_GET_LONG\" (ses, pos);\n"
"if (0 <> _len) \n"
"data := ses_read (ses, _len, 1);\n"
"else\n"
"data := \'\';\n"
"pos := pos + _len;\n"
"\n"
"if (equ (name, \'MD5\'))\n"
"return 0;\n"
"\n"
"declare s, s2, s3, s4, s5, s6, s7, s8, s9 varchar;\n"
"declare tarr any;\n"
"\n"
"tarr := get_keyword (name, resources);\n"
"\n"
"if (tarr is null or length (tarr) = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Illegal item(%s) in package \', name));\n"
"\n"
"s4 := aref (tarr, 0);\n"
"s5 := aref (tarr, 1);\n"
"s6 := aref (tarr, 2);\n"
"s3 := get_keyword (s4, iniarr);\n"
"s7 := aref (tarr, 3);\n"
"s8 := aref (tarr, 4);\n"
"s9 := aref (tarr, 5);\n"
"\n"
"if (s3 is null or not length (s3))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Item(%s) has illegal type\', s4));\n"
"\n"
"declare i, j, k integer;\n"
"\n"
"if (s4 <> \'dav\')\n"
"{\n"
"s4 := sprintf (\'%s/%s\', s3, name);\n"
"declare continue handler for sqlstate \'39000\' { goto error_nofile; };\n"
"declare continue handler for sqlstate \'42000\' { goto error_nofile; };\n"
"val := cast (file_stat (s4, 1) as integer);\n"
"goto file_ok;\n"
"if (0)\n"
"{\n"
"error_nofile:;\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf(\'Inexistent file resource (%s).\', s4));\n"
"return 0;\n"
"}\n"
"val := null;\n"
"file_ok:;\n"
"declare server_root varchar;\n"
"server_root := http_root();\n"
"s4 := concat(server_root, \'/\', s4);\n"
"\"VAD\".\"DBA\".\"VAD_SPLIT_PATH\" (s4, s2, s3);\n"
"if (s5 is null or length(s5)=0)\n"
"s5 := \'equal\';\n"
"if (equ (s5, \'yes\'))\n"
"{\n"
"goto do_it;\n"
"}\n"
"else if (equ (s5, \'no\'))\n"
"{\n"
"if (val is null)\n"
"goto do_it;\n"
"}\n"
"else if (equ (s5, \'equal\'))\n"
"{\n"
"if (val is null or val <> _len)\n"
"goto do_it;\n"
"declare md5_txt, nctx varchar;\n"
"nctx := md5_init();\n"
"nctx := md5_update (nctx, data);\n"
"if (neq (\"VAD\".\"DBA\".\"VAD_MD5_FILE\" (s4, is_dav), md5_final (nctx)))\n"
"goto do_it;\n"
"}\n"
"else if (equ (s5, \'abort\'))\n"
"{\n"
"if (val is not null)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'package registry item (%s) exists & overwrite=abort\', s2));\n"
"goto do_it;\n"
"}\n"
"else if (equ (s5, \'expected\'))\n"
"{\n"
" ;\n"
"}\n"
"return 1;\n"
"do_it:;\n"
"\"DB\".\"DBA\".\"VAD_CREATE_PATH\"(s2);\n"
"\n"
"\n"
"if (s6 is null or length(s6)=0)\n"
"s6 := \'abort\';\n"
"if (equ (s6, \'yes\'))\n"
"{\n"
"goto do_it_again;\n"
"}\n"
"else if (equ (s6, \'abort\') or equ (s6, \'no\'))\n"
"{\n"
"if (s2 is not null or length(s2))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'mkpath forbidden (%s)\', s2));\n"
"}\n"
"do_it_again:;\n"
"\n"
"\"DB\".\"DBA\".\"VAD_CREATE_PATH\"(s2);\n"
"string_to_file (s4, \'\', -2);\n"
"string_to_file (s4, data, -1);\n"
"return 1;\n"
"}\n"
"else\n"
"{\n"
"declare vdata varchar;\n"
"declare id, gd integer;\n"
"id := 0;\n"
"gd := 0;\n"
"s4 := sprintf (\'%s/%s\', s3, name);\n"
"\"VAD\".\"DBA\".\"VAD_SPLIT_PATH\" (s4, s2, s3);\n"
"if (\"VAD\".\"DBA\".\"VAD_DAV_GET_RES\" (iniarr, s4, vdata) < 0)\n"
"goto do_itII;\n"
"val := length (vdata);\n"
"if (s5 is null or length(s5)=0)\n"
"s5 := \'equal\';\n"
"if (equ (s5, \'yes\'))\n"
"{\n"
"goto do_itII;\n"
"}\n"
"else if (equ (s5, \'no\'))\n"
"{\n"
"if (val is null)\n"
"goto do_itII;\n"
"}\n"
"else if (equ (s5, \'equal\'))\n"
"{\n"
"if (val is null or val <> _len)\n"
"goto do_itII;\n"
"if (neq (\"VAD\".\"DBA\".\"VAD_MD5_FILE\" (s4, is_dav), md5 (vdata)))\n"
"goto do_itII;\n"
"}\n"
"else if (equ (s5, \'abort\'))\n"
"{\n"
"if (val is not null)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'package registry item (%s) exists & overwrite=abort\', s2));\n"
"goto do_itII;\n"
"}\n"
"else if (equ (s5, \'expected\'))\n"
"{\n"
" ;\n"
"}\n"
"return 1;\n"
"do_itII:;\n"
"\"VAD\".\"DBA\".\"VAD_MKDAV\" (id, gd, s2, iniarr, 1);\n"
"if (k < 0)\n"
"goto do_it_againII;\n"
"if (s6 is null or length(s6)=0)\n"
"s6 := \'abort\';\n"
"if (equ (s6, \'yes\'))\n"
"{\n"
"goto do_it_againII;\n"
"}\n"
"else if (equ (s6, \'abort\') or equ (s6, \'no\'))\n"
"{\n"
"if (s2 is not null or length(s2))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'mkpath forbidden (%s)\', s2));\n"
"}\n"
"do_it_againII:;\n"
"k := \"VAD\".\"DBA\".\"VAD_MKDAV\" (id, gd, s2, iniarr);\n"
"if (k < 1)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Can\\\'t create collection (%s)\', s2));\n"
"if (val is not null and val > 0)\n"
"\"VAD\".\"DBA\".\"VAD_DAV_UPLOAD_RES\" (iniarr, s4, data, s7, s8, s9);\n"
"return 1;\n"
"}\n"
"}\n"
"--src vad_make.sql:490\n"
;

static const char *proc79 = 
"#line 684 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_TEST_CREATE\" (\n"
"in arr any,\n"
"in fname varchar,\n"
"in sticker varchar,\n"
"in iniarr any := null )\n"
"{\n"
"declare ctx varchar;\n"
"ctx := md5_init();\n"
"declare ses any;\n"
"ses := string_output ();\n"
"declare pos integer;\n"
"pos := 0;\n"
"if (iniarr is null)\n"
"iniarr := \"VAD\".\"DBA\".\"VAD_READ_INI\" (arr);\n"
"declare data any;\n"
"declare continue handler for sqlstate \'39000\' { goto error_nofile; };\n"
"declare continue handler for sqlstate \'42000\' { goto error_nofile; };\n"
"string_to_file (fname, \'\', -2);\n"
"error_nofile:;\n"
"declare _err_code, _err_message varchar;\n"
"declare exit handler for sqlstate \'39000\' { _err_code := __SQL_STATE; _err_message := __SQL_MESSAGE; goto error_fin; };\n"
"declare exit handler for sqlstate \'42000\' { _err_code := __SQL_STATE; _err_message := __SQL_MESSAGE; goto error_fin; };\n"
"data := \'This file consists of binary data and should not be touched by hands!\';\n"
"\"VAD\".\"DBA\".\"VAD_OUT_ROW\" (fname, pos, \'VAD\', data, ctx);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_ROW\" (fname, pos, \'STICKER\', sticker, ctx);\n"
"declare i,r integer;\n"
"data := string_output ();\n"
"r := rnd(100);\n"
"while (i < 1000)\n"
"{\n"
"http (sprintf(\'%09d \',i+r), data);\n"
"i := i + 1;\n"
"}\n"
"declare tree, doc, items any;\n"
"tree := xml_tree (sticker);\n"
"doc := xml_tree_doc (tree);\n"
"declare j, n integer;\n"
"declare s2, s3, s4, s5, s6 varchar;\n"
"items := xpath_eval (\'/sticker/resources/file\', doc, 0);\n"
"n := length (items);\n"
"j := 0;\n"
"while (j<n)\n"
"{\n"
"s2 := cast (xpath_eval (\'@type\', aref (items, j)) as varchar);\n"
"s6 := cast (xpath_eval (\'@source\', aref (items, j)) as varchar);\n"
"s5 := cast (xpath_eval (\'@source_uri\', aref (items, j)) as varchar);\n"
"s3 := cast (xpath_eval (\'@target_uri\', aref (items, j)) as varchar);\n"
"s4 := get_keyword (s6, iniarr);\n"
"if (s4 is null or length(s4)=0)\n"
"{\n"
"_err_message := sprintf (\'Illegal resource type:%s for %s\', s2,s3);\n"
"goto error_fin;\n"
"}\n"
"if (s5 is null or length(s5)=0)\n"
"{\n"
"s5 := sprintf (\'%s/%s\', s4, s3);\n"
"}\n"
"if (neq (s6, \'dav\'))\n"
"\"VAD\".\"DBA\".\"VAD_OUT_ROW_FILE\" (fname, pos, s3, s5, ctx);\n"
"else\n"
"\"VAD\".\"DBA\".\"VAD_OUT_ROW_DAV\" (fname, pos, s3, s5, ctx, iniarr);\n"
"j := j + 1;\n"
"}\n"
"data := md5_final (ctx);\n"
"\"VAD\".\"DBA\".\"VAD_OUT_ROW\" (fname, pos, \'MD5\', data, ctx);\n"
"return 1;\n"
"error_fin:\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (_err_message);\n"
"return 0;\n"
"}\n"
"--src vad_make.sql:682\n"
;

static const char *proc80 = 
"#line 756 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_CHECK_INSTALLABILITY\" (\n"
"in fname varchar,\n"
"in is_dav integer) returns varchar\n"
"{\n"
"declare name, vers, fullname, pkg_date any;\n"
"\"VAD\".\"DBA\".\"VAD_TEST_READ\" (fname, name, vers, fullname, pkg_date, is_dav);\n"
"return \'OK\';\n"
"}\n"
"--src vad_make.sql:754\n"
;

static const char *proc81 = 
"#line 766 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_CHECK_STICKER_DETAILS\" (\n"
"inout parr any,\n"
"in doc any,\n"
"inout pkg_name varchar,\n"
"inout pkg_vers varchar,\n"
"inout pkg_fullname varchar,\n"
"inout pkg_date varchar,\n"
"in need_action integer := 0 )\n"
"{\n"
"declare ddl_install_check_code, proc_install_check_code, s2, s3 varchar;\n"
"declare n, j, tid, tid2, pkgid integer;\n"
"declare items any;\n"
"\n"
"ddl_install_check_code := NULL;\n"
"proc_install_check_code := NULL;\n"
"items := xpath_eval (\'/sticker/caption/name/@package\', doc, 0);\n"
"n := length (items);\n"
"if (n = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD sticker should have name in \"/sticker/caption/name/@package\"\');\n"
"pkg_name := cast (aref (items, 0) as varchar);\n"
"items := xpath_eval (\'/sticker/caption/version/@package\', doc, 0);\n"
"n := length (items);\n"
"if (n = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD sticker should have version in \"/sticker/caption/version/@package\"\');\n"
"pkg_vers := cast (aref (items, 0) as varchar);\n"
"\n"
"s3 := concat(pkg_name, \'/\', pkg_vers);\n"
"s2 := \"VAD\".\"DBA\".\"VAD_CHECK_FOR_HIGH_VERSION\"(s3);\n"
"if (s2 <> \'0\' and s2 <> \'-1\')\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'The package \"%s\" with higher version %s is already installed. Current installing package version is %s.\', pkg_name, s2, pkg_vers));\n"
"if (s2 = \'-1\')\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'The package \"%s\" has incorrect name or version\', s3));\n"
"items := xpath_eval (\'/sticker/caption/name/prop[@name=\\\'Title\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD sticker should mention the title in /sticker/caption/name/prop[@name=\\\'Title\\\']\');\n"
"s2 := cast (xpath_eval (\'@value\', aref (items, 0)) as varchar);\n"
"pkg_fullname := s2;\n"
"pkgid := \"VAD\".\"DBA\".\"VAD_GET_PKG_ID\" (parr, pkg_name, pkg_vers);\n"
"\n"
"\n"
"if (not pkgid and need_action)\n"
"pkgid := \"VAD\".\"DBA\".\"VAD_NEW_PACKAGE\"(parr, pkg_name, pkg_vers);\n"
"items := xpath_eval (\'/sticker/caption/name/prop[@name=\\\'Title\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD sticker should mention the title in /sticker/caption/name/prop[@name=\\\'Title\\\']\');\n"
"s2 := cast (xpath_eval (\'@value\', aref (items, 0)) as varchar);\n"
"pkg_fullname := s2;\n"
"if (need_action)\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'Title\', \'STRING\', s2);\n"
"items := xpath_eval (\'/sticker/caption/name/prop[@name=\\\'Developer\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD sticker should mention the developer in /sticker/caption/name/prop[@name=\\\'Developer\\\']\');\n"
"s2 := cast (xpath_eval (\'@value\', aref (items, 0)) as varchar);\n"
"if (need_action)\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'Developer\', \'STRING\', s2);\n"
"items := xpath_eval (\'/sticker/caption/name/prop[@name=\\\'Copyright\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD sticker should mention the Copyright in /sticker/caption/name/prop[@name=\\\'Copyright\\\']\');\n"
"s2 := cast (xpath_eval (\'@value\', aref (items, 0)) as varchar);\n"
"if (need_action)\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'Copyright\', \'STRING\', s2);\n"
"items := xpath_eval (\'/sticker/caption/version/prop[@name=\\\'Release Date\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD sticker should mention the Release Date in /sticker/caption/version/prop[@name=\\\'Release Date\\\']\');\n"
"s2 := cast (xpath_eval (\'@value\', aref (items, 0)) as varchar);\n"
"pkg_date := s2;\n"
"if (need_action)\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'Release Date\', \'STRING\', s2);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'Install Date\', \'STRING\',\n"
"substring (cast (now () as varchar), 1, 16));\n"
"}\n"
"items := xpath_eval (\'/sticker/caption/version/prop[@name=\\\'Build\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD sticker should mention the Build in /sticker/caption/version/prop[@name=\\\'Build\\\']\');\n"
"s2 := cast (xpath_eval (\'@value\', aref (items, 0)) as varchar);\n"
"if (need_action)\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'Build\', \'STRING\', s2);\n"
"if (need_action)\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, pkgid, \'Download\');\n"
"items := xpath_eval (\'/sticker/caption/name/prop[@name=\\\'Download\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD sticker should mention the Download places in /sticker/caption/name/prop[@name=\\\'Download\\\']\');\n"
"if (need_action)\n"
"{\n"
"j := 0;\n"
"while (j<n)\n"
"{\n"
"s2 := cast (xpath_eval (\'@value\', aref (items, j)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, cast (j + 1 as varchar), \'STRING\', s2);\n"
"j := j + 1;\n"
"}\n"
"}\n"
"if (need_action)\n"
"{\n"
"tid2 := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, pkgid, \'require\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, tid2, \'lt\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, tid2, \'eq\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, tid2, \'gt\');\n"
"}\n"
"items := xpath_eval (\'/sticker/dependencies/require\', doc, 0);\n"
"n := length (items);\n"
"j := 0;\n"
"while (j<n)\n"
"{\n"
"s2 := cast (xpath_eval (\'name/@package\', aref (items, j)) as varchar);\n"
"s3 := cast (xpath_eval (\'versions_earlier/@package\', aref (items, j)) as varchar);\n"
"if (s2 is not null and length(s3))\n"
"{\n"
"if (need_action)\n"
"{\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, tid2, \'lt\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, s2, \'STRING\', s3);\n"
"}\n"
"if (not \"VAD\".\"DBA\".\"VAD_TEST_PACKAGE_LT\" (parr, s2, s3))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'This package requires %s version less than %s\', s2, s3));\n"
"}\n"
"s3 := cast (xpath_eval (\'version/@package\', aref (items, j)) as varchar);\n"
"if (s2 is not null and length(s3))\n"
"{\n"
"if (need_action)\n"
"{\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, tid2, \'eq\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, s2, \'STRING\', s3);\n"
"}\n"
"if (not \"VAD\".\"DBA\".\"VAD_TEST_PACKAGE_EQ\" (parr, s2, s3))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'This package requires %s version %s\', s2, s3));\n"
"}\n"
"s3 := cast (xpath_eval (\'versions_later/@package\', aref (items, j)) as varchar);\n"
"if (s2 is not null and length(s3))\n"
"{\n"
"if (need_action)\n"
"{\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, tid2, \'gt\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, s2, \'STRING\', s3);\n"
"}\n"
"if (not \"VAD\".\"DBA\".\"VAD_TEST_PACKAGE_GT\" (parr, s2, s3))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'This package requires %s version greater than %s\', s2, s3));\n"
"}\n"
"j := j + 1;\n"
"}\n"
"if (need_action)\n"
"{\n"
"tid2 := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, pkgid, \'conflicts\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, tid2, \'lt\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, tid2, \'eq\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, tid2, \'gt\');\n"
"}\n"
"items := xpath_eval (\'/sticker/dependencies/conflict\', doc, 0);\n"
"n := length (items);\n"
"j := 0;\n"
"while (j<n)\n"
"{\n"
"s2 := cast (xpath_eval (\'name/@package\', aref (items, j)) as varchar);\n"
"s3 := cast (xpath_eval (\'versions_earlier/@package\', aref (items, j)) as varchar);\n"
"if (s2 is not null and length(s3))\n"
"{\n"
"if (need_action)\n"
"{\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, tid2, \'lt\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, s2, \'STRING\', s3);\n"
"}\n"
"if (\"VAD\".\"DBA\".\"VAD_TEST_PACKAGE_LT\" (parr, s2, s3))\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'package conflicts with %s lt(%s) \', s2, s3));\n"
"rollback work;\n"
"}\n"
"}\n"
"s3 := cast (xpath_eval (\'version/@package\', aref (items, j)) as varchar);\n"
"if (s2 is not null and length(s3))\n"
"{\n"
"if (need_action)\n"
"{\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, tid2, \'eq\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, s2, \'STRING\', s3);\n"
"}\n"
"if (\"VAD\".\"DBA\".\"VAD_TEST_PACKAGE_EQ\" (parr, s2, s3))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'package conflicts with %s eq(%s) \', s2, s3));\n"
"}\n"
"s3 := cast (xpath_eval (\'versions_later/@package\', aref (items, j)) as varchar);\n"
"if (s2 is not null and length(s3))\n"
"{\n"
"if (need_action)\n"
"{\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, tid2, \'gt\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, s2, \'STRING\', s3);\n"
"}\n"
"if (\"VAD\".\"DBA\".\"VAD_TEST_PACKAGE_GT\" (parr, s2, s3))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'package conflicts with %s gt(%s) \', s2, s3));\n"
"}\n"
"j := j + 1;\n"
"}\n"
"items := xpath_eval (\'/sticker/ddls/sql[@purpose=\\\'install-check\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"ddl_install_check_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"if (need_action)\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'ddl-install-check\', \'STRING\', ddl_install_check_code);\n"
"}\n"
"items := xpath_eval (\'/sticker/ddls/sql[@purpose=\\\'install-check\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"proc_install_check_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"if (need_action)\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'proc-install-check\', \'STRING\', proc_install_check_code);\n"
"}\n"
"if (need_action)\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (ddl_install_check_code);\n"
"if (need_action)\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (proc_install_check_code);\n"
"return 1;\n"
"}\n"
"--src vad_make.sql:764\n"
;

static const char *proc82 = 
"#line 989 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_GET_STICKER_DATA_LEN\" (\n"
"in fname varchar,\n"
"in is_dav integer )\n"
"{\n"
"declare flen, pos, i, n, statusid integer;\n"
"declare s varchar;\n"
"declare data any;\n"
"declare val integer;\n"
"declare _len integer;\n"
"\n"
"pos := 0;\n"
"flen := 200;\n"
"declare v1, v2, parr any;\n"
"parr := null;\n"
"declare continue handler for sqlstate \'39000\' { goto error_nofile; };\n"
"declare continue handler for sqlstate \'42000\' { goto error_nofile; };\n"
"\n"
"if (is_dav = 0)\n"
"{\n"
"v1 := file_to_string_output (fname, 0, flen);\n"
"}\n"
"else\n"
"{\n"
"v1 := string_output();\n"
"\"VAD\".\"DBA\".\"BLOB_2_STRING_OUTPUT\"(fname, 0, flen, v1);\n"
"}\n"
"\n"
"\"VAD\".\"DBA\".\"VAD_GET_ROW\" (v1, pos, s, data);\n"
"if (s <> \'VAD\')\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD file with illegal header\');\n"
"val := \"VAD\".\"DBA\".\"VAD_GET_CHAR\" (v1, pos);\n"
"if (val <> 182)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf(\'VAD file corrupt (pos=%d)\', pos));\n"
"_len := \"VAD\".\"DBA\".\"VAD_GET_LONG\" (v1, pos);\n"
"s := cast (ses_read (v1, _len) as varchar);\n"
"pos := pos + _len;\n"
"if (s <> \'STICKER\')\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD file with illegal sticker\');\n"
"val := \"VAD\".\"DBA\".\"VAD_GET_CHAR\" (v1, pos);\n"
"if (val <> 223)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf(\'VAD file corrupt (pos=%d)\', pos));\n"
"_len := \"VAD\".\"DBA\".\"VAD_GET_LONG\" (v1, pos);\n"
"return pos + _len;\n"
"error_nofile:\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'VAD file (%s) problems:\\n%s\', fname, __SQL_MESSAGE));\n"
"}\n"
"--src vad_make.sql:987\n"
;

static const char *proc83 = 
"#line 1037 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_TEST_READ\" (\n"
"in fname varchar,\n"
"inout pkg_name varchar,\n"
"inout pkg_vers varchar,\n"
"inout pkg_fullname varchar,\n"
"inout pkg_date varchar,\n"
"in is_dav integer,\n"
"in fast_no_md5 integer := 0)\n"
"{\n"
"declare flen, pos, i, n, statusid integer;\n"
"declare fstat integer;\n"
"declare s varchar;\n"
"declare data any;\n"
"pos := 0;\n"
"if (is_dav = 0)\n"
"{\n"
"fstat := file_stat (fname, 1);\n"
"if (fstat is null or fstat = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (concat (\'Could not open filesystem resource \', fname, \' Reason: File not found\'));\n"
"}\n"
"else\n"
"{\n"
"declare _i integer;\n"
"_i := 0;\n"
"fstat := 0;\n"
"for select length (RES_CONTENT) as _temp_content from ws.ws.sys_dav_res where RES_FULL_PATH=fname do\n"
"{\n"
"_i := _i + 1;\n"
"fstat := _temp_content;\n"
"}\n"
"if (_i = 0)\n"
"{\n"
"if (fstat is null or fstat = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (concat (\'Could not open DAV resource \', fname, \' Reason: File not found\'));\n"
"}\n"
"}\n"
"flen := cast (fstat as integer);\n"
"declare v1, v2, parr any;\n"
"parr := null;\n"
"declare continue handler for sqlstate \'39000\' { goto error_nofile; };\n"
"declare continue handler for sqlstate \'42000\' { goto error_nofile; };\n"
"\n"
"if (fast_no_md5)\n"
"flen := \"VAD\".\"DBA\".\"VAD_GET_STICKER_DATA_LEN\" (fname, is_dav);\n"
"\n"
"if (is_dav = 0)\n"
"{\n"
"v1 := file_to_string_output (fname, 0, flen);\n"
"}\n"
"else\n"
"{\n"
"v1 := string_output();\n"
"\"VAD\".\"DBA\".\"BLOB_2_STRING_OUTPUT\"(fname, 0, flen, v1);\n"
"}\n"
"\n"
"if (fast_no_md5 = 0)\n"
"{\n"
"\n"
"v2 := cast (subseq (v1, flen-32, flen) as varchar);\n"
"\n"
"\n"
"declare md5package varchar;\n"
"md5package := md5(subseq (v1, 0, flen-45));\n"
"if (neq (md5package, v2))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD file checksum mismatch\');\n"
"}\n"
"\n"
"i := 0;\n"
"while (\"VAD\".\"DBA\".\"VAD_GET_ROW\" (v1, pos, s, data) <> 0)\n"
"{\n"
"if (i = 0)\n"
"{\n"
"if (s <> \'VAD\')\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD file with illegal header\');\n"
"}\n"
"else if (i = 1)\n"
"{\n"
"declare ddl_install_check_code, proc_install_check_code varchar;\n"
"ddl_install_check_code := NULL;\n"
"proc_install_check_code := NULL;\n"
"declare s2, s3 varchar;\n"
"if (s <> \'STICKER\')\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD file with illegal sticker\');\n"
"declare tree, doc any;\n"
"tree := xml_tree (data);\n"
"doc := xml_tree_doc (tree);\n"
"\"VAD\".\"DBA\".\"VAD_CHECK_STICKER_DETAILS\" (parr, doc, pkg_name, pkg_vers, pkg_fullname, pkg_date);\n"
"return 1;\n"
"}\n"
"i := i + 1;\n"
"}\n"
"return 0;\n"
"error_nofile:\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'VAD file (%s) problems:\\n%s\', fname, __SQL_MESSAGE));\n"
"}\n"
"--src vad_make.sql:1035\n"
;

static const char *proc84 = 
"#line 1134 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_INSTALL\" (\n"
"in fname varchar,\n"
"in is_dav integer := 0,\n"
"in no_exit integer := 0) returns varchar\n"
"{\n"
"declare parr any;\n"
"declare qual varchar;\n"
"declare SQL_STATE, SQL_MESSAGE varchar;\n"
"\n"
"qual := dbname ();\n"
"parr := null;\n"
"SQL_STATE := \'00000\';\n"
"SQL_MESSAGE := \'\';\n"
"result_names (SQL_STATE, SQL_MESSAGE);\n"
"\n"
"if ((is_dav = 0 and 0 = file_stat (fname)) \n"
"or \n"
"(is_dav <> 0 and (not exists (select 1 from WS.WS.SYS_DAV_RES where RES_FULL_PATH = fname))))\n"
"{\n"
"registry_set (\'VAD_wet_run\', \'0\');\n"
"registry_set (\'VAD_errcount\', \'1\');\n"
"connection_set (\'vad_pkg_fullname\', \'unknown\');\n"
"result (\'42VAD\', concat (\'Could not open \',\n"
"case when is_dav = 0 then \'filesystem\' else \'DAV\' end, \n"
"\' resource \', fname, \' Reason: File not found\'));\n"
"goto failure;\n"
"}\n"
"\n"
"commit work;\n"
"if (sys_stat (\'cl_run_local_only\') = 1)\n"
"exec (\'checkpoint\');\n"
"else\n"
"{\n"
"exec (\'rdf_check_init()\');\n"
"cl_exec (\'checkpoint\');\n"
"}\n"
"\n"
"\"VAD\".\"DBA\".\"VAD_ATOMIC\" (1);\n"
"\n"
"registry_set (\'VAD_msg\', \'\');\n"
"registry_set (\'VAD_errcount\', \'0\');\n"
"registry_set (\'VAD_wet_run\', \'0\');\n"
"registry_set (\'VAD_is_run\', \'1\');\n"
"connection_set (\'vad_pkg_fullname\', null);\n"
"\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"SQL_STATE := __SQL_STATE;\n"
"SQL_MESSAGE := __SQL_MESSAGE;\n"
"if (\'\' <> SQL_MESSAGE);\n"
"{\n"
"log_message (sprintf (\'VAD_INSTALL: %s (%s)\', SQL_MESSAGE, SQL_STATE));\n"
"result (SQL_STATE, SQL_MESSAGE);\n"
"}\n"
"goto failure;\n"
"};\n"
"\n"
"\"VAD\".\"DBA\".\"VAD_READ\" (parr, fname, is_dav);\n"
"if (\'0\' = registry_get (\'VAD_errcount\'))\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_ATOMIC\" (0);\n"
"\n"
"result (\'00000\', \'No errors detected\');\n"
"result (\'00000\', sprintf (\'Installation of \"%s\" is complete.\', coalesce (connection_get (\'vad_pkg_fullname\'), fname)));\n"
"\n"
"result (\'00000\', \'Now making a final checkpoint.\');\n"
"\n"
"if (sys_stat (\'cl_run_local_only\') = 1)\n"
"exec (\'checkpoint\');\n"
"else\n"
"cl_exec (\'checkpoint\');\n"
"\n"
"result (\'00000\', \'Final checkpoint is made.\');\n"
"result (\'00000\', \'SUCCESS\');\n"
"result (\'\', \'\');\n"
"registry_set (\'VAD_is_run\', \'0\');\n"
"set_qualifier (qual);\n"
"return \'OK\';\n"
"}\n"
"}\n"
"\n"
"failure:;\n"
"result (\'00000\', \'Errors detected\');\n"
"result (\'00000\', sprintf (\'Installation of \"%s\" was unsuccessful.\', coalesce (connection_get (\'vad_pkg_fullname\'), fname)));\n"
"\n"
"log_message (sprintf (\'Errors where detected during installation of \"%s\".\',\n"
"coalesce (connection_get (\'vad_pkg_fullname\'), fname)));\n"
"\n"
"if (registry_get (\'VAD_wet_run\') = \'0\')\n"
"{\n"
"\n"
"\n"
"\n"
"\"VAD\".\"DBA\".\"VAD_ATOMIC\" (0);\n"
"\n"
"result (\'00000\', \'ERROR\');\n"
"result (\'\', \'\');\n"
"\n"
"registry_set (\'VAD_is_run\', \'0\');\n"
"set_qualifier (qual);\n"
"return \'ERROR\';\n"
"}\n"
"else\n"
"{\n"
"\n"
"\n"
"declare trx, folder varchar;\n"
"declare pos integer;\n"
"trx := coalesce (cfg_item_value(virtuoso_ini_path(), \'Database\',\'TransactionFile\'), \'\');\n"
"folder := server_root ();\n"
"trx := concat(rtrim(folder, \'/\'), \'/\', trx);\n"
"\n"
"log_message(\'The installation of this VAD package has failed.\');\n"
"log_message(\'Please delete the transaction file\');\n"
"log_message(trx);\n"
"log_message(\'and then restart your database server.\');\n"
"log_message(\'Note: Your database will be in its pre VAD installation\');\n"
"log_message(\'state after you restart.\');\n"
"\n"
"result (\'\', \'The installation of this VAD package has failed.\');\n"
"result (\'\', \'Please delete the transaction file \'||trx);\n"
"result (\'\', \'and then restart your database server.\');\n"
"result (\'\', \'Note: Your database will be in its pre VAD installation state after you restart.\');\n"
"\n"
"result (\'00000\', \'FATAL\');\n"
"result (\'\', \'\');\n"
"delay(3);\n"
"if (no_exit = 0)\n"
"{\n"
"if (sys_stat (\'cl_run_local_only\') = 1)\n"
"raw_exit(-1);\n"
"else\n"
"cl_exec (\'raw_exit(-1)\');\n"
"}\n"
"\n"
"registry_set (\'VAD_is_run\', \'0\');\n"
"set_qualifier (qual);\n"
"return \'FATAL\';\n"
"}\n"
"\n"
"\n"
"registry_set (\'VAD_is_run\', \'0\');\n"
"return \'ERROR\';\n"
"}\n"
"--src vad_make.sql:1132\n"
;

static const char *proc85 = 
"#line 1281 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_READ\" (\n"
"inout parr any,\n"
"in fname varchar,\n"
"in is_dav integer,\n"
"in iniarr any := null)\n"
"{\n"
"declare flen, pos, i, statusid integer;\n"
"declare s any;\n"
"declare data, resources any;\n"
"declare ddl_pre_install_code,\n"
"ddl_install_check_code,\n"
"ddl_uninstall_check_code,\n"
"ddl_post_install_code,\n"
"ddl_pre_uninstall_code,\n"
"ddl_post_uninstall_code varchar;\n"
"declare proc_pre_install_code,\n"
"proc_install_check_code,\n"
"proc_uninstall_check_code,\n"
"proc_post_install_code,\n"
"proc_pre_uninstall_code,\n"
"proc_post_uninstall_code varchar;\n"
"declare pkg_name varchar;\n"
"\n"
"pos := 0;\n"
"resources := vector();\n"
"pkg_name := null;\n"
"if (iniarr is null)\n"
"iniarr := \"VAD\".\"DBA\".\"VAD_READ_INI\" (iniarr);\n"
"declare continue handler for sqlstate \'39000\' { goto error_nofile; };\n"
"declare continue handler for sqlstate \'42000\' { goto error_nofile; };\n"
"if (is_dav = 0)\n"
"{\n"
"s := file_stat (fname, 1);\n"
"if (s is null or s = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (concat (\'Could not open filesystem resource \', fname, \' Reason: File not found\'));\n"
"}\n"
"else\n"
"{\n"
"declare _i integer;\n"
"_i := 0;\n"
"s := 0;\n"
"for select length (RES_CONTENT) as _temp_content from ws.ws.sys_dav_res where RES_FULL_PATH = fname do\n"
"{\n"
"_i := _i + 1;\n"
"s := cast(_temp_content as varchar);\n"
"}\n"
"if (_i = 0)\n"
"{\n"
"if (s is null or s = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (concat (\'Could not open DAV resource \', fname, \' Reason: File not found\'));\n"
"}\n"
"}\n"
"flen := cast (s as integer);\n"
"declare v1,v2 any;\n"
"\n"
"if (is_dav = 0)\n"
"{\n"
"v1 := file_to_string_output (fname, 0, flen);\n"
"}\n"
"else\n"
"{\n"
"v1 := string_output();\n"
"\"VAD\".\"DBA\".\"BLOB_2_STRING_OUTPUT\"(fname, 0, flen, v1);\n"
"}\n"
"\n"
"\n"
"v2 := cast (subseq (v1, flen-32, flen) as varchar);\n"
"\n"
"\n"
"declare md5package varchar;\n"
"md5package := md5(subseq (v1, 0, flen-45));\n"
"if (neq (md5package, v2))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD file checksum mismatch\');\n"
"\n"
"i := 0;\n"
"declare flag integer;\n"
"while (1)\n"
"{\n"
"if (i < 2)\n"
"flag := \"VAD\".\"DBA\".\"VAD_GET_ROW\"(v1, pos, s, data);\n"
"else\n"
"flag := \"VAD\".\"DBA\".\"VAD_GET_ROW_FILE\"(v1, pos, s, resources, iniarr, is_dav);\n"
"if (not flag)\n"
"goto fin;\n"
"if (i = 0)\n"
"{\n"
"if (s <> \'VAD\')\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD file with illegal header\');\n"
"}\n"
"else if (i = 1)\n"
"{\n"
"ddl_pre_install_code := NULL;\n"
"ddl_install_check_code := NULL;\n"
"ddl_uninstall_check_code := NULL;\n"
"ddl_post_install_code := NULL;\n"
"ddl_pre_uninstall_code := NULL;\n"
"ddl_post_uninstall_code := NULL;\n"
"proc_pre_install_code := NULL;\n"
"proc_install_check_code := NULL;\n"
"proc_uninstall_check_code := NULL;\n"
"proc_post_install_code := NULL;\n"
"proc_pre_uninstall_code := NULL;\n"
"proc_post_uninstall_code := NULL;\n"
"declare pkg_vers, pkg_fullname, s2, s3, s4, s7, s8, s9, pkg_date varchar;\n"
"declare pkgid, tid, tid2 integer;\n"
"declare docsid, filesid, ddls, docsid2, filesid2, ddls2  integer;\n"
"docsid := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, 0, \'/DOCS\');\n"
"filesid := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, 0, \'/FILES\');\n"
"ddls := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, 0, \'/SCHEMA\');\n"
"if (s <> \'STICKER\')\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (\'VAD file with illegal sticker\');\n"
"declare tree, doc any;\n"
"tree := xml_tree (data);\n"
"doc := xml_tree_doc (tree);\n"
"declare items any;\n"
"declare j, n, ix integer;\n"
"\"VAD\".\"DBA\".\"VAD_CHECK_STICKER_DETAILS\" (parr, doc, pkg_name, pkg_vers, pkg_fullname, pkg_date, 0);\n"
"\n"
"connection_set (\'vad_pkg_fullname\', pkg_fullname);\n"
"\n"
"items := xpath_eval (\'/sticker/procedures/sql[@purpose=\\\'pre-install\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"proc_pre_install_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"items := xpath_eval (\'/sticker/ddls/sql[@purpose=\\\'pre-install\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"ddl_pre_install_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (ddl_pre_install_code);\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (proc_pre_install_code);\n"
"registry_set (\'VAD_wet_run\', \'1\');\n"
"\"VAD\".\"DBA\".\"VAD_CHECK_STICKER_DETAILS\" (parr, doc, pkg_name, pkg_vers, pkg_fullname, pkg_date, 1);\n"
"pkgid := \"VAD\".\"DBA\".\"VAD_GET_PKG_ID\" (parr, pkg_name, pkg_vers);\n"
"if (not pkgid)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'Illegal pkgID for : %s/%s\', pkg_name, pkg_vers));\n"
"docsid2 := \"VAD\".\"DBA\".\"VAD_MKCD\" (parr, docsid, pkg_name);\n"
"filesid2 := \"VAD\".\"DBA\".\"VAD_MKCD\" (parr, filesid, pkg_name);\n"
"ddls2 := \"VAD\".\"DBA\".\"VAD_MKCD\" (parr, ddls, pkg_name);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'sticker\', \'XML\', cast (data as varchar));\n"
"statusid := \"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'Status\', \'STRING\', \'Broken\');\n"
"\n"
"items := xpath_eval (\'/sticker/procedures/sql[@purpose=\\\'pre-install\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"proc_pre_install_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'proc-pre-install\', \'STRING\', proc_pre_install_code);\n"
"}\n"
"items := xpath_eval (\'/sticker/procedures/sql[@purpose=\\\'post-install\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"proc_post_install_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'proc-post-install\', \'STRING\', proc_post_install_code);\n"
"}\n"
"items := xpath_eval (\'/sticker/procedures/sql[@purpose=\\\'pre-uninstall\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"proc_pre_uninstall_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'proc-pre-uninstall\', \'STRING\', proc_pre_uninstall_code);\n"
"}\n"
"items := xpath_eval (\'/sticker/procedures/sql[@purpose=\\\'post-uninstall\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"proc_post_uninstall_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'proc-post-uninstall\', \'STRING\', proc_post_uninstall_code);\n"
"}\n"
"items := xpath_eval (\'/sticker/procedures/sql[@purpose=\\\'uninstall-check\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"proc_uninstall_check_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'proc-uninstall-check\', \'STRING\', proc_uninstall_check_code);\n"
"}\n"
"items := xpath_eval (\'/sticker/ddls/sql[@purpose=\\\'pre-install\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"ddl_pre_install_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'ddl-pre-install\', \'STRING\', ddl_pre_install_code);\n"
"}\n"
"items := xpath_eval (\'/sticker/ddls/sql[@purpose=\\\'post-install\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"ddl_post_install_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'ddl-post-install\', \'STRING\', ddl_post_install_code);\n"
"}\n"
"items := xpath_eval (\'/sticker/ddls/sql[@purpose=\\\'pre-uninstall\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"ddl_pre_uninstall_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'ddl-pre-uninstall\', \'STRING\', ddl_pre_uninstall_code);\n"
"}\n"
"items := xpath_eval (\'/sticker/ddls/sql[@purpose=\\\'post-uninstall\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"ddl_post_uninstall_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'ddl-post-uninstall\', \'STRING\', ddl_post_uninstall_code);\n"
"}\n"
"items := xpath_eval (\'/sticker/ddls/sql[@purpose=\\\'uninstall-check\\\']\', doc, 0);\n"
"n := length (items);\n"
"if (n<>0)\n"
"{\n"
"ddl_uninstall_check_code := cast (xpath_eval (\'node()\', aref (items, 0)) as varchar);\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, pkgid, \'ddl-uninstall-check\', \'STRING\', ddl_uninstall_check_code);\n"
"}\n"
"tid2 := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, pkgid, \'resources\');\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, filesid2, pkg_vers, \'KEY\', \"VAD\".\"DBA\".\"VAD_FULL_PATH\" (parr, tid2));\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, tid2, \'doc\');\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, docsid2, pkg_vers, \'KEY\', \"VAD\".\"DBA\".\"VAD_FULL_PATH\" (parr, tid));\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, tid2, \'dav\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, tid2, \'http\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, tid2, \'code\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, tid2, \'data\');\n"
"items := xpath_eval (\'/sticker/resources/file\', doc, 0);\n"
"n := length (items);\n"
"resources := make_array (n*2, \'any\');\n"
"j := 0;\n"
"ix := 0;\n"
"while (j<n)\n"
"{\n"
"s2 := cast (xpath_eval (\'@type\', aref (items, j)) as varchar);\n"
"s3 := cast (xpath_eval (\'@target_uri\', aref (items, j)) as varchar);\n"
"s7 := cast (xpath_eval (\'@dav_owner\', aref (items, j)) as varchar);\n"
"s8 := cast (xpath_eval (\'@dav_grp\', aref (items, j)) as varchar);\n"
"s9 := cast (xpath_eval (\'@dav_perm\', aref (items, j)) as varchar);\n"
"s4 := get_keyword (s2, iniarr);\n"
"if (s4 is null or length(s4)=0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'resource file %s has unknown type %s\', s3, s2));\n"
"s4 := cast (xpath_eval (\'@overwrite\', aref (items, j)) as varchar);\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, tid2, s2);\n"
"if (0 = tid)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'resource file %s has unknown type %s\', s3, s2));\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, cast (j + 1 as varchar), \'STRING\', s3);\n"
"resources [ix] := s3;\n"
"resources [ix+1] := vector (s2, s4, cast (xpath_eval (\'@makepath\', aref (items, j)) as varchar), s7, s8, s9);\n"
"j := j + 1;\n"
"ix := ix + 2;\n"
"}\n"
"items := xpath_eval (\'/sticker/registry/record\', doc, 0);\n"
"tid2 := \"VAD\".\"DBA\".\"VAD_MKDIR\" (parr, pkgid, \'records\');\n"
"n := length (items);\n"
"j := 0;\n"
"while (j<n)\n"
"{\n"
"s2 := cast (xpath_eval (\'@key\', aref (items, j)) as varchar);\n"
"s3 := cast (xpath_eval (\'@type\', aref (items, j)) as varchar);\n"
"s4 := cast (xpath_eval (\'text()\', aref (items, j)) as varchar);\n"
"declare tpath, tname varchar;\n"
"declare iname, itype, ival varchar;\n"
"\"VAD\".\"DBA\".\"VAD_SPLIT_PATH\" (s2, tpath, tname);\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\" (parr, tid2, tpath);\n"
"if (not tid)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" ( sprintf (\'package registry item (%s) refers to non-existing path\', s2));\n"
"tid2 := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (tid, tname, iname, itype, ival, 0);\n"
"s2 := cast (xpath_eval (\'@overwrite\', aref (items, j)) as varchar);\n"
"if (s2 is null or length(s2)=0)\n"
"s2 := \'equal\';\n"
"if (equ (s2, \'yes\'))\n"
"{\n"
"if (tid2)\n"
"\"VAD\".\"DBA\".\"VAD_UPDATE_NODE\" (tid2, s4, ival);\n"
"else\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, tname, s3, s4);\n"
"}\n"
"else if (equ (s2, \'no\'))\n"
"{\n"
"if (not tid2)\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, tname, s3, s4);\n"
"}\n"
"else if (equ (s2, \'equal\'))\n"
"{\n"
"if (tid2)\n"
"{\n"
"if (neq (ival, s4))\n"
"\"VAD\".\"DBA\".\"VAD_UPDATE_NODE\" (tid2, s4, ival);\n"
"}\n"
"else\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, tname, s3, s4);\n"
"}\n"
"else if (equ (s2, \'abort\'))\n"
"{\n"
"if (tid2)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'package registry item (%s) exists & overwrite=abort\', s2));\n"
"\"VAD\".\"DBA\".\"VAD_MKNODE\" (parr, tid, tname, s3, s4);\n"
"}\n"
"else if (equ (s2, \'expected\'))\n"
"{\n"
"if (tid2)\n"
"\"VAD\".\"DBA\".\"VAD_UPDATE_NODE\" (tid2, s4, ival);\n"
"else\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'package registry item (%s) does not exist & overwrite=expected\', s2));\n"
"}\n"
"j := j + 1;\n"
"}\n"
"\n"
"\n"
"}\n"
"i := i + 1;\n"
"}\n"
"\n"
"fin:\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (ddl_post_install_code);\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (proc_post_install_code);\n"
"\"VAD\".\"DBA\".\"VAD_UPDATE_NODE\" (statusid, \'Installed\', \'Broken\');\n"
"\"DB\".\"DBA\".\"VAD_CLEAN_OLD_VERSIONS\" (pkg_name);\n"
"return 1;\n"
"\n"
"error_nofile:\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'VAD file (%s) problems:\\n%s\', fname, __SQL_MESSAGE));\n"
"}\n"
"--src vad_make.sql:1279\n"
;

static const char *proc86 = 
"#line 1599 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_PKG_UNINSTALL_CHECK\" (\n"
"inout parr any,\n"
"in pkgid integer )\n"
"{\n"
"declare lname, ltype, lval varchar;\n"
"\"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (pkgid, \'Status\', lname, ltype, lval);\n"
"declare install_check_code varchar;\n"
"declare stat integer;\n"
"stat := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (pkgid, \'proc-uninstall-check\', lname, ltype, lval, 0);\n"
"if (stat)\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (lval);\n"
"stat := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (pkgid, \'ddl-uninstall-check\', lname, ltype, lval, 0);\n"
"if (stat)\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (lval);\n"
"return 1;\n"
"}\n"
"--src vad_make.sql:1597\n"
;

static const char *proc87 = 
"#line 1617 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_UNINSTALL_LIST_FOLDER\" (\n"
"inout parr any,\n"
"in id integer,\n"
"in root varchar,\n"
"inout arrout any,\n"
"in type varchar)\n"
"{\n"
"declare tid, i, n integer;\n"
"declare arr, item any;\n"
"declare s varchar;\n"
"arr := \"VAD\".\"DBA\".\"VAD_LIST_FOLDER\" (parr, id, type);\n"
"n := length (arr);\n"
"i := 0;\n"
"while (i < n)\n"
"{\n"
"item := aref (arr, i);\n"
"i := i + 1;\n"
"s := concat (root, \'/\', aref (item, 2));\n"
"arrout := vector_concat (arrout, vector (vector (s, aref(item, 3))));\n"
"}\n"
"return 0;\n"
"}\n"
"--src vad_make.sql:1615\n"
;

static const char *proc88 = 
"#line 1641 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_DO_UNINSTALL\" (\n"
"inout parr any,\n"
"in arr any )\n"
"{\n"
"declare i, n, tid, id, gd integer;\n"
"declare s, sn, sp varchar;\n"
"declare item, ini any;\n"
"ini := null;\n"
"declare continue handler for sqlstate \'39000\' { goto error; };\n"
"declare continue handler for sqlstate \'42000\' { goto error; };\n"
"n := length (arr);\n"
"i := 0;\n"
"id := 0;\n"
"gd := 0;\n"
"while (i < n)\n"
"{\n"
"item := aref(arr, i);\n"
"s := aref (item, 0);\n"
"i := i + 1;\n"
"if (aref (item, 1) = \'file\')\n"
"{\n"
"declare server_root varchar;\n"
"server_root := http_root();\n"
"s := concat(server_root, \'/\', s);\n"
"sys_unlink (s);\n"
"}\n"
"else if (aref (item, 1) = \'dav\')\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_SPLIT_PATH\" (s, sp, sn);\n"
"tid := \"VAD\".\"DBA\".\"VAD_MKDAV\" (id, gd, sp, ini, 1);\n"
"if (tid > 0)\n"
"\"VAD\".\"DBA\".\"VAD_DAV_DELETE\" (ini, s);\n"
"}\n"
"goto cont;\n"
"error:;\n"
"cont:;\n"
"}\n"
"}\n"
"--src vad_make.sql:1639\n"
;

static const char *proc89 = 
"#line 1681 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_UNINSTALL_LIST\" (\n"
"inout parr any,\n"
"in pkgid integer )\n"
"{\n"
"declare tid, curdir integer;\n"
"declare iniarr, arr any;\n"
"declare s varchar;\n"
"arr := vector();\n"
"iniarr := \"VAD\".\"DBA\".\"VAD_READ_INI\" (parr);\n"
"\n"
"for select R_SHKEY from \"VAD\".\"DBA\".\"VAD_REGISTRY\" where R_PRNT=pkgid and R_TYPE=\'FOLDER\' do\n"
"{\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, pkgid, R_SHKEY);\n"
"s := \"PUMP\".\"DBA\".\"__GET_KEYWORD\"(\'code\', iniarr, \'\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, \'resources/code\');\n"
"\"VAD\".\"DBA\".\"VAD_UNINSTALL_LIST_FOLDER\"(parr, tid, s, arr, \'file\');\n"
"s := \"PUMP\".\"DBA\".\"__GET_KEYWORD\"(\'data\', iniarr, \'\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, \'resources/data\');\n"
"\"VAD\".\"DBA\".\"VAD_UNINSTALL_LIST_FOLDER\"(parr, tid, s, arr, \'file\');\n"
"s := \"PUMP\".\"DBA\".\"__GET_KEYWORD\"(\'http\', iniarr, \'\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, \'resources/http\');\n"
"\"VAD\".\"DBA\".\"VAD_UNINSTALL_LIST_FOLDER\"(parr, tid, s, arr, \'file\');\n"
"s := \"PUMP\".\"DBA\".\"__GET_KEYWORD\"(\'dav\', iniarr, \'\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, \'resources/dav\');\n"
"\"VAD\".\"DBA\".\"VAD_UNINSTALL_LIST_FOLDER\"(parr, tid, s, arr, \'dav\');\n"
"}\n"
"return arr;\n"
"}\n"
"--src vad_make.sql:1679\n"
;

static const char *proc90 = 
"#line 1711 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_PKG_UNINSTALL\" (\n"
"inout parr any,\n"
"in pkgid integer,\n"
"in cur_vers varchar)\n"
"{\n"
"declare lname, ltype, lval, install_check_code varchar;\n"
"declare stat, curdir integer;\n"
"declare arr any;\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, pkgid, cur_vers);\n"
"\"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(curdir, \'Status\', lname, ltype, lval);\n"
"\"VAD\".\"DBA\".\"VAD_PKG_UNINSTALL_CHECK\"(parr, curdir);\n"
"stat := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(curdir, \'proc-pre-uninstall\', lname, ltype, lval, 0);\n"
"if (stat)\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (lval);\n"
"stat := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(curdir, \'ddl-pre-uninstall\', lname, ltype, lval, 0);\n"
"if (stat)\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (lval);\n"
"\n"
"arr := \"VAD\".\"DBA\".\"VAD_UNINSTALL_LIST\"(parr, pkgid);\n"
"\"VAD\".\"DBA\".\"VAD_DO_UNINSTALL\"(parr, arr);\n"
"\n"
"\n"
"stat := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(curdir, \'ddl-post-uninstall\', lname, ltype, lval, 0);\n"
"if (stat)\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (lval);\n"
"stat := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(curdir, \'proc-post-uninstall\', lname, ltype, lval, 0);\n"
"if (stat)\n"
"\"VAD\".\"DBA\".\"VAD_EXEC\" (lval);\n"
"\"VAD\".\"DBA\".\"VAD_DEL_SUBTREE\"(pkgid);\n"
"return 1;\n"
"}\n"
"--src vad_make.sql:1709\n"
;

static const char *proc91 = 
"#line 1745 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_CHECK_UNINSTALLABILITY_BY_NAME\"(\n"
"in name varchar) returns varchar\n"
"{\n"
"declare parr any;\n"
"declare curdir, tid, ret integer;\n"
"declare prod, version, lname, ltype, lval varchar;\n"
"parr := null;\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, name);\n"
"if (not tid)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'The package \"%s\" does not exist\', name));\n"
"ret := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(tid, \'CurrentVersion\', lname, ltype, lval, 0);\n"
"if (not ret)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'The installation of \"%s\" does not exist or was corrupted. VAD cannot find its current version.\', name));\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, tid, lval);\n"
"DB.DBA.VAD_DEPS_CHECK (parr, name, lval);\n"
"\"VAD\".\"DBA\".\"VAD_PKG_UNINSTALL_CHECK\"(parr, curdir);\n"
"return \'OK\';\n"
"}\n"
"--src vad_make.sql:1743\n"
;

static const char *proc92 = 
"#line 1767 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_CHECK_UNINSTALLABILITY\"(\n"
"in name varchar) returns varchar\n"
"{\n"
"declare parr any;\n"
"declare curdir, tid, ret integer;\n"
"declare prod, version, lname, ltype, lval varchar;\n"
"parr := null;\n"
"if (\"VAD\".\"DBA\".\"VAD_GET_NAME_AND_VERSION\"(name, prod, version) = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf (\'The package \"%s\" has incorrect name or version\', name));\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, prod);\n"
"if (not tid)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'The package \"%s\" does not exist\', prod));\n"
"ret := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(tid, \'CurrentVersion\', lname, ltype, lval, 0);\n"
"if (not ret)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'The installation of \"%s\" does not exist or was corrupted. VAD cannot find its current version.\', prod));\n"
"if (neq(lval, version))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'Attempt to remove non-current version of package \"%s\"\', prod));\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, tid, version);\n"
"DB.DBA.VAD_DEPS_CHECK (parr, prod, lval);\n"
"\"VAD\".\"DBA\".\"VAD_PKG_UNINSTALL_CHECK\"(parr, curdir);\n"
"return \'OK\';\n"
"}\n"
"--src vad_make.sql:1765\n"
;

static const char *proc93 = 
"#line 1793 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_UNINSTALL_BY_NAME\"(\n"
"in name varchar) returns varchar\n"
"{\n"
"declare parr any;\n"
"declare curdir, ret, tid integer;\n"
"declare res, lname, ltype, lval varchar;\n"
"parr := null;\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, name);\n"
"if (not tid)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'The package \"%s\" does not exist\', name));\n"
"ret := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(tid, \'CurrentVersion\', lname, ltype, lval, 0);\n"
"if (not ret)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'The installation of \"%s\" does not exist or was corrupted. VAD cannot find its current version.\', name));\n"
"DB.DBA.VAD_DEPS_CHECK (parr, name, lval);\n"
"\"VAD\".\"DBA\".\"VAD_PKG_UNINSTALL\"(parr, tid, lval);\n"
"return \'OK\';\n"
"}\n"
"--src vad_make.sql:1791\n"
;

static const char *proc94 = 
"#line 1814 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_CHECK_VERSION\"(\n"
"in name varchar) returns varchar\n"
"{\n"
"declare parr any;\n"
"declare curdir, ret, tid integer;\n"
"declare res, lname, ltype, lval varchar;\n"
"parr := null;\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, name);\n"
"if (not tid)\n"
"return null;\n"
"\n"
"ret := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(tid, \'CurrentVersion\', lname, ltype, lval, 0);\n"
"if (not ret)\n"
"return null;\n"
"\n"
"return lval;\n"
"}\n"
"--src vad_make.sql:1812\n"
;

static const char *proc95 = 
"#line 1834 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_CLEAN_OLD_VERSIONS\" (in name varchar)\n"
"{\n"
"declare parr any;\n"
"declare curdir, ret, tid integer;\n"
"declare res, lname, ltype, lval varchar;\n"
"\n"
"parr := null;\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, name);\n"
"if (not tid)\n"
"return null;\n"
"ret := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(tid, \'CurrentVersion\', lname, ltype, lval, 0);\n"
"if (not ret)\n"
"return null;\n"
"for select R_SHKEY as old_ver from VAD.DBA.VAD_REGISTRY\n"
"where R_TYPE = \'FOLDER\' and R_KEY = \'/VAD/\'||name||\'/\' || R_SHKEY and R_SHKEY <> lval do\n"
"{\n"
"delete from VAD.DBA.VAD_REGISTRY where R_KEY like \'/VAD/\'||name||\'/\'||old_ver||\'/%\';\n"
"delete from VAD.DBA.VAD_REGISTRY where R_KEY = \'/VAD/\'||name||\'/\'||old_ver;\n"
"\n"
"\n"
"}\n"
"return lval;\n"
"}\n"
"--src vad_make.sql:1832\n"
;

static const char *proc96 = 
"#line 1860 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_RENAME\" (in name varchar, in new_name varchar)\n"
"{\n"
"declare old_pkey, docs, files, ddls, ver varchar;\n"
"\n"
"ver := \"DB\".\"DBA\".\"VAD_CLEAN_OLD_VERSIONS\" (name);\n"
"\n"
"if (ver is null)\n"
"return;\n"
"\n"
"old_pkey := \'/VAD/\'||name;\n"
"docs := \'/DOCS/\' || name;\n"
"files := \'/FILES/\' || name;\n"
"ddls := \'/SCHEMA/\' || name;\n"
"\n"
"for select R_KEY as rkey, R_ID as rid from VAD.DBA.VAD_REGISTRY where R_KEY like old_pkey || \'/%\' or R_KEY = old_pkey\n"
"do\n"
"{\n"
"declare new_key varchar;\n"
"if (rkey <> old_pkey)\n"
"{\n"
"new_key := \'/VAD/\' || new_name || substring (rkey, length (old_pkey)+1, length (rkey));\n"
"update VAD.DBA.VAD_REGISTRY set R_KEY = new_key where R_ID = rid;\n"
"}\n"
"else\n"
"{\n"
"new_key := \'/VAD/\' || new_name;\n"
"update VAD.DBA.VAD_REGISTRY set R_KEY = new_key, R_SHKEY = new_name where R_ID = rid;\n"
"}\n"
"}\n"
"\n"
"for select R_KEY as rkey, R_ID as rid, blob_to_string (R_VALUE) as val, R_TYPE as tp from VAD.DBA.VAD_REGISTRY\n"
"where\n"
"R_KEY = docs\n"
"or R_KEY = files\n"
"or R_KEY = ddls\n"
"or R_KEY = docs ||\'/\' || ver\n"
"or R_KEY = files || \'/\' || ver\n"
"or R_KEY = ddls ||\'/\' || ver\n"
"do\n"
"{\n"
"declare new_key varchar;\n"
"if (rkey like \'/DOCS/%\')\n"
"{\n"
"new_key := \'/DOCS/\'||new_name||substring (rkey, length (docs)+1, length (rkey));\n"
"}\n"
"else if (rkey like \'/FILES/%\')\n"
"{\n"
"new_key := \'/FILES/\'||new_name||substring (rkey, length (files)+1, length (rkey));\n"
"}\n"
"else if (rkey like \'/SCHEMA/%\')\n"
"{\n"
"new_key := \'/SCHEMA/\'||new_name||substring (rkey, length (ddls)+1, length (rkey));\n"
"}\n"
"\n"
"if (tp = \'FOLDER\')\n"
"{\n"
"update VAD.DBA.VAD_REGISTRY set R_KEY = new_key, R_SHKEY = new_name where R_ID = rid;\n"
"}\n"
"else if (tp = \'KEY\' and val like old_pkey || \'/%\')\n"
"{\n"
"declare new_value varchar;\n"
"new_value := \'/VAD/\'||new_name||substring (val, length (old_pkey)+1, length (val));\n"
"update VAD.DBA.VAD_REGISTRY set R_KEY = new_key, R_VALUE = new_value where R_ID = rid;\n"
"}\n"
"}\n"
"for select R_KEY as rkey, R_ID as rid, R_SHKEY as shkey from VAD.DBA.VAD_REGISTRY where\n"
"R_KEY like \'%/require/__/\' || name and R_SHKEY = name do\n"
"{\n"
"declare new_key varchar;\n"
"new_key := substring (rkey, 1, length (rkey) - length (name)) || new_name;\n"
"update VAD.DBA.VAD_REGISTRY set R_KEY = new_key, R_SHKEY = new_name where R_ID = rid;\n"
"}\n"
"}\n"
"--src vad_make.sql:1858\n"
;

static const char *proc97 = 
"#line 1935 \"[executable]/vad_make.sql\"\n"
"create procedure DB.DBA.VAD_LIST_PACKAGES ()\n"
"{\n"
"declare pkgs any;\n"
"declare name, title, build_date, install_date, version varchar;\n"
"\n"
"result_names (name, title, version, build_date, install_date);\n"
"pkgs := \"VAD\".\"DBA\".\"VAD_GET_PACKAGES\" ();\n"
"foreach (any elm in pkgs) do\n"
"{\n"
"result (elm[1], elm[5], elm[2], elm[3], elm[4]);\n"
"}\n"
"\n"
"}\n"
"--src vad_make.sql:1933\n"
;

static const char *proc98 = 
"#line 1951 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_UNINSTALL\"(\n"
"in name varchar) returns varchar\n"
"{\n"
"declare parr any;\n"
"declare curdir, ret, tid integer;\n"
"declare prod, version, lname, ltype, lval varchar;\n"
"parr := null;\n"
"if (\"VAD\".\"DBA\".\"VAD_GET_NAME_AND_VERSION\"(name, prod, version) = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'The package \"%s\" has incorrect name or version\', name));\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, prod);\n"
"if (not tid)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'The package \"%s\" does not exist\', prod));\n"
"ret := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(tid, \'CurrentVersion\', lname, ltype, lval, 0);\n"
"if (not ret)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'The installation of \"%s\" does not exist or was corrupted. VAD cannot find its current version.\', prod));\n"
"if (neq(lval, version))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'Attempt to remove non-current version of package \"%s\"\', prod));\n"
"DB.DBA.VAD_DEPS_CHECK (parr, prod, lval);\n"
"\"VAD\".\"DBA\".\"VAD_PKG_UNINSTALL\"(parr, tid, version);\n"
"return \'OK\';\n"
"}\n"
"--src vad_make.sql:1949\n"
;

static const char *proc99 = 
"#line 1975 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_PKG_DIFF\" (\n"
"inout parr any,\n"
"in pkgid integer )\n"
"{\n"
"declare outarr any;\n"
"outarr := vector();\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"return outarr;\n"
"}\n"
"--src vad_make.sql:1973\n"
;

static const char *proc100 = 
"#line 2002 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_CHECK_INSTALLED\" (\n"
"in name varchar ) returns integer\n"
"{\n"
"declare parr any;\n"
"declare curdir, ret, tid integer;\n"
"declare prod, version, lname, ltype, lval varchar;\n"
"parr := null;\n"
"if (\"VAD\".\"DBA\".\"VAD_GET_NAME_AND_VERSION\"(name, prod, version) = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'The package \"%s\" has incorrect name or version\', name));\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, prod);\n"
"if (not tid)\n"
"return 0;\n"
"ret := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(tid, \'CurrentVersion\', lname, ltype, lval, 0);\n"
"if (not ret)\n"
"return 0;\n"
"if (neq(lval, version))\n"
"return 0;\n"
"return 1;\n"
"}\n"
"--src vad_make.sql:2000\n"
;

static const char *proc101 = 
"#line 2024 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_CHECK\" (\n"
"in name varchar ) returns any\n"
"{\n"
"declare parr any;\n"
"declare curdir, ret, tid integer;\n"
"declare prod, version, lname, ltype, lval varchar;\n"
"parr := null;\n"
"if (\"VAD\".\"DBA\".\"VAD_GET_NAME_AND_VERSION\"(name, prod, version) = 0)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf (\'The package \"%s\" has incorrect name or version\', name));\n"
"curdir := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, 0, \'/VAD\');\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, curdir, prod);\n"
"if (not tid)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'The package \"%s\" does not exist\', prod));\n"
"ret := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\"(tid, \'CurrentVersion\', lname, ltype, lval, 0);\n"
"if (not ret)\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'The installation of \"%s\" does not exist or was corrupted. VAD cannot find its current version.\', prod));\n"
"if (neq(lval, version))\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'Attempt to check non-current version of package \"%s\"\', prod));\n"
"tid := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, tid, version);\n"
"return \"VAD\".\"DBA\".\"VAD_PKG_DIFF\" (parr, tid);\n"
"}\n"
"--src vad_make.sql:2022\n"
;

static const char *proc102 = 
"#line 2047 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_PACK\"(\n"
"in sticker_uri varchar,\n"
"in base_uri_of_resources varchar,\n"
"in package_uri varchar) returns varchar\n"
"{\n"
"declare parr any;\n"
"parr := null;\n"
"if (equ (subseq (package_uri, 0, 7), \'file://\'))\n"
"package_uri := subseq (package_uri, 7);\n"
"declare sticker varchar;\n"
"if (neq (subseq (sticker_uri, 0, 7), \'http://\'))\n"
"sticker := file_to_string (sticker_uri);\n"
"else\n"
"sticker := http_get (sticker_uri);\n"
"\"VAD\".\"DBA\".\"VAD_TEST_CREATE\" (parr, package_uri, sticker);\n"
"return \'OK\';\n"
"}\n"
"--src vad_make.sql:2045\n"
;

static const char *proc103 = 
"#line 2066 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_LOAD_SQL_FILE\" (\n"
"in sql_file_name varchar,\n"
"in _grouping integer,\n"
"in _report_errors varchar,\n"
"in is_dav integer,\n"
"in already integer := 0)\n"
"{\n"
"declare _file_ses any;\n"
"declare _cmd any;\n"
"declare _cmd_line, _cmd_line_rtrim varchar;\n"
"declare _cmd_text, _sqlstate, _sqlmsg, SQL_STATE, SQL_MESSAGE varchar;\n"
"declare _cmd_complete integer;\n"
"declare server_root varchar;\n"
"whenever not found goto fin1;\n"
"if (is_dav = 0)\n"
"{\n"
"server_root := http_root();\n"
"sql_file_name := concat(server_root, \'/\', sql_file_name);\n"
"if (file_stat(sql_file_name, 0) = 0)\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf(\'Inexistent file resource (%s). Unable to load file.\', sql_file_name));\n"
"}\n"
"_file_ses := file_to_string_output (sql_file_name);\n"
"}\n"
"else\n"
"{\n"
"select blob_to_string_output(RES_CONTENT) into _file_ses from WS.WS.SYS_DAV_RES where RES_FULL_PATH=sql_file_name;\n"
"if (\'STRING_SESSION\' <> internal_type_name (__tag (_file_ses)) and _file_ses is not null)\n"
"{\n"
"declare _tmpval any;\n"
"_tmpval := _file_ses;\n"
"_file_ses := string_output ();\n"
"http (_tmpval, _file_ses);\n"
"}\n"
"}\n"
"if (0)\n"
"{\n"
"fin1:\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\" (sprintf(\'Inexistent file resource (%s). Unable to load file.\', sql_file_name));\n"
"return 0;\n"
"}\n"
"\n"
"commit work;\n"
"declare parsed_text any;\n"
"declare err_sqlstate, commit_err_sqlstate, err_msg, commit_err_msg, err_rep varchar;\n"
"declare m_dta, result any;\n"
"declare stmt_text varchar;\n"
"declare _maxres integer;\n"
"_maxres := 100;\n"
"commit_err_sqlstate := \'00000\';\n"
"parsed_text := sql_split_text (\n"
"sprintf (\'#pragma line 1 \"%s\"\\n\', sql_file_name) ||\n"
"string_output_string(_file_ses)\n"
");\n"
"declare i int;\n"
"i := 0;\n"
"while( i < length(parsed_text) )\n"
"{\n"
"if (193 = __tag (parsed_text[i]))\n"
"{\n"
"rollback work;\n"
"err_rep := parsed_text[i][1];\n"
"if (_report_errors = \'report\')\n"
"{\n"
"if (registry_get (\'VAD_wet_run\') <> \'0\')\n"
"log_message (err_rep);\n"
"result (\'37000\', err_rep);\n"
"registry_set (\'VAD_errcount\', cast (1 + cast (registry_get (\'VAD_errcount\') as integer) as varchar));\n"
"}\n"
"if (_report_errors = \'signal\')\n"
"signal (\'37000\', err_rep);\n"
"}\n"
"aset(parsed_text, i, concat (\'--no_c_escapes-\\r\\n\', trim(parsed_text[i], \'\\r\\n \')));\n"
"err_sqlstate := \'00000\';\n"
"err_msg := \'\';\n"
"exec ( parsed_text[i], err_sqlstate, err_msg, vector(), _maxres, m_dta, result);\n"
"if( err_sqlstate <> \'00000\' )\n"
"{\n"
"rollback work;\n"
"err_rep := concat (err_msg, \'\\nwhile executing the following statement:\\n\', parsed_text[i], \'\\nin file:\\n\', sql_file_name);\n"
"if (_report_errors = \'report\')\n"
"{\n"
"if (not (parsed_text[i] like \'drop %\'))\n"
"{\n"
"if (registry_get (\'VAD_wet_run\') <> \'0\')\n"
"log_message(err_rep);\n"
"result (err_sqlstate, err_rep);\n"
"registry_set (\'VAD_errcount\', cast (1 + cast (registry_get (\'VAD_errcount\') as integer) as varchar));\n"
"}\n"
"}\n"
"if (_report_errors = \'signal\')\n"
"{\n"
"if (not (parsed_text[i] like \'drop %\'))\n"
"signal (err_sqlstate, err_rep);\n"
"}\n"
"}\n"
"i := i+1;\n"
"}\n"
"end_of_file:  \n"
"exec (\'commit work\', commit_err_sqlstate, commit_err_msg);\n"
"}\n"
"--src vad_make.sql:2064\n"
;

static const char *proc104 = 
"#line 2169 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_REMOVE_FILE\"(\n"
"in folder varchar )\n"
"{\n"
"folder := concat(http_root(), \'/\', folder);\n"
"folder := replace(folder, \'\\\\\', \'/\');\n"
"folder := replace(folder, \'//\', \'/\');\n"
"folder := replace(folder, \'//\', \'/\');\n"
"file_delete(folder, 1);\n"
"}\n"
"--src vad_make.sql:2167\n"
;

static const char *proc105 = 
"#line 2180 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_CREATE_INSTALL_FOLDER_TREE\" (\n"
")\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'VAD folder tree creation problems:\\n%s\', __SQL_MESSAGE));\n"
"};\n"
"file_mkdir(concat(http_root(), \'/vad\'));\n"
"file_mkdir(concat(http_root(), \'/vad/doc\'));\n"
"file_mkdir(concat(http_root(), \'/vad/vsp\'));\n"
"file_mkdir(concat(http_root(), \'/vad/code\'));\n"
"file_mkdir(concat(http_root(), \'/vad/data\'));\n"
"}\n"
"--src vad_make.sql:2178\n"
;

static const char *proc106 = 
"#line 2195 \"[executable]/vad_make.sql\"\n"
"create procedure \"DB\".\"DBA\".\"VAD_CREATE_PATH\"(\n"
"in full_path varchar )\n"
"{\n"
"declare path_vec any;\n"
"declare path, httproot varchar;\n"
"declare i integer;\n"
"httproot := replace(http_root(), \'\\\\\', \'/\');\n"
"if (length(httproot) > 1)\n"
"httproot := rtrim(httproot, \'/\');\n"
"path := full_path;\n"
"path_vec := vector();\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"(sprintf(\'VAD folder tree creation problems (%s):\\n%s\', path, __SQL_MESSAGE));\n"
"};\n"
"path := replace(path, \'\\\\\', \'/\');\n"
"path_vec := split_and_decode(path, 0, \'=//\');\n"
"i := 1;\n"
"path := path_vec[0];\n"
"while (i < length(path_vec))\n"
"{\n"
"if (path_vec[i] <> \'.\')\n"
"path := concat(path, \'/\', path_vec[i]);\n"
"if (length(httproot) < length(path))\n"
"{\n"
"if (file_stat(path) = 0)\n"
"{\n"
"file_mkdir(path);\n"
"}\n"
"}\n"
"i := i + 1;\n"
"}\n"
"}\n"
"--src vad_make.sql:2193\n"
;

static const char *proc107 = 
"#line 2230 \"[executable]/vad_make.sql\"\n"
"create procedure DB.DBA.VAD_DEPS_CHECK (in parr any, in name varchar, in version varchar)\n"
"{\n"
"declare pkgs, arr any;\n"
"declare id int;\n"
"declare val any;\n"
"\n"
"pkgs := VAD..VAD_GET_PACKAGES ();\n"
"\n"
"foreach (any pkg in pkgs) do\n"
"{\n"
"declare nam, ver varchar;\n"
"declare did, iid int;\n"
"declare nam1, val1, ty1 any;\n"
"\n"
"nam := pkg [1];\n"
"ver := pkg [2];\n"
"did := 0;\n"
"id := 0;\n"
"iid := 0;\n"
"if (nam <> name)\n"
"{\n"
"id := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, 0, sprintf (\'/VAD/%s/%s/require\', nam, ver));\n"
"if (not iid and (did := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, id, \'eq\')) <> 0)\n"
"{\n"
"iid := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (did, name, nam1, ty1, val1, 0);\n"
"}\n"
"if (not iid and (did := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, id, \'gt\')) <> 0)\n"
"{\n"
"iid := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (did, name, nam1, ty1, val1, 0);\n"
"}\n"
"if (not iid and (did := \"VAD\".\"DBA\".\"VAD_CHDIR\"(parr, id, \'lt\')) <> 0)\n"
"{\n"
"iid := \"VAD\".\"DBA\".\"VAD_NODE_INFO_BY_NAME\" (did, name, nam1, ty1, val1, 0);\n"
"}\n"
"if (iid)\n"
"{\n"
"\"VAD\".\"DBA\".\"VAD_FAIL_CHECK\"\n"
"(sprintf (\'Package \"%s/%s\" depends from \"%s\" version \"%s\"\', nam, ver, name, val1));\n"
"}\n"
"}\n"
"}\n"
"\n"
"}\n"
"--src vad_make.sql:2228\n"
;

static const char *proc108 = 
"#line 2292 \"[executable]/vad_make.sql\"\n"
"create procedure VAD.DBA.VER_LT (in x varchar, in y varchar)\n"
"{\n"
"return (case when \"VAD\".\"DBA\".\"VERSION_COMPARE\" (x, y) = -1 then 1 else 0 end);\n"
"}\n"
"--src vad_make.sql:2290\n"
;

static const char *proc109 = 
"#line 2298 \"[executable]/vad_make.sql\"\n"
"create procedure \"VAD\".\"DBA\".\"VAD_AUTO_UPGRADE\" ()\n"
"{\n"
"declare vads, name, ver, arr, isdav any;\n"
"declare pname, pver, pfull, pisdav, pdate any;\n"
"declare vaddir any;\n"
"\n"
"vaddir := cfg_item_value (virtuoso_ini_path (), \'Parameters\', \'VADInstallDir\');\n"
"\n"
"if (vaddir is null)\n"
"return;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"log_message (\'Can\\\'t get list of vad packages in \' || vaddir);\n"
"return;\n"
"};\n"
"\n"
"if (vaddir not like \'%/\')\n"
"vaddir := vaddir || \'/\';\n"
"\n"
"arr := sys_dirlist (vaddir, 1);\n"
"\n"
"if (isstring (file_stat (vaddir || \'ods_framework_dav.vad\')))\n"
"arr := vector_concat (vector (\'ods_framework_dav.vad\'), arr);\n"
"\n"
"foreach (any f in arr) do\n"
"{\n"
"if (f like \'%.vad\')\n"
"{\n"
"declare continue handler for sqlstate \'*\';\n"
"pisdav := 0;\n"
"if (f like \'%_dav.vad\')\n"
"pisdav := 1;\n"
"\n"
"VAD.DBA.VAD_TEST_READ (vaddir||f, pname, pver, pfull, pdate, 0, 1);\n"
"\n"
"ver := DB.DBA.VAD_CHECK_VERSION (pname);\n"
"if (ver is not null)\n"
"{\n"
"if (exists (select top 1 1 from VAD.DBA.VAD_REGISTRY\n"
"where R_KEY like sprintf (\'/VAD/%s/%s/resources/dav/%%\', pname, ver)))\n"
"isdav := 1;\n"
"else\n"
"isdav := 0;\n"
"}\n"
"\n"
"\n"
"if (ver is null and pname = \'conductor\')\n"
"{\n"
"isdav := 1;\n"
"ver := \'0.0.0\';\n"
"}\n"
"\n"
"\n"
"if (VAD.DBA.VER_LT (ver, pver) and isdav = pisdav)\n"
"{\n"
"log_message (\'Installing \'||pfull||\' version \'||pver|| \' \'||case when isdav then \'(DAV)\' else \'\' end);\n"
"vad_install (vaddir||f);\n"
"}\n"
"}\n"
"}\n"
"}\n"
"--src vad_make.sql:2296\n"
;

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name, const int report)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  if (report && proc != NULL)
     log_debug ("built-in procedure \"%s\" overruled by the RDBMS", proc_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_vad (void)
{
  caddr_t saved_qualifier = bootstrap_cli->cli_qualifier;

  /* vad_root.sql */

  DEFINE_PROC ("VAD.DBA.VAD_VERSION", proc0);
  ddl_ensure_table ("do this always", other0);
  ddl_ensure_table ("VAD.DBA.VAD_REGISTRY", tbl0);
  DEFINE_PROC ("VAD.DBA.VAD_READ_INI", proc1);
  DEFINE_PROC ("VAD.DBA.VAD_GET_ROOT", proc2);
  DEFINE_PROC ("VAD.DBA.VAD_SET_ROOT", proc3);
  DEFINE_PROC ("VAD.DBA.VAD_MKDAV", proc4);
  DEFINE_PROC ("VAD.DBA.VAD_ATOMIC", proc5);
  DEFINE_PROC ("VAD.DBA.VAD_FAIL_CHECK", proc6);
  DEFINE_PROC ("VAD.DBA.VAD_CHDIR", proc7);
  DEFINE_PROC ("VAD.DBA.VAD_FIND_SMTH_BY_NAME", proc8);
  DEFINE_PROC ("VAD.DBA.VAD_REGET_HANDLERS", proc9);
  DEFINE_PROC ("VAD.DBA.VAD_FULL_PATH", proc10);
  DEFINE_PROC ("VAD.DBA.VAD_TEST_PARENT", proc11);
  DEFINE_PROC ("VAD.DBA.VAD_TEST_NODE_TYPE", proc12);
  DEFINE_PROC ("VAD.DBA.VAD_MKDIR", proc13);
  DEFINE_PROC ("VAD.DBA.VAD_MKCD", proc14);
  DEFINE_PROC ("VAD.DBA.VAD_RMDIR", proc15);
  DEFINE_PROC ("VAD.DBA.VAD_RMNODE", proc16);
  DEFINE_PROC ("VAD.DBA.VAD_MKNODE", proc17);
  DEFINE_PROC ("VAD.DBA.VAD_UPDATE_NODE", proc18);
  DEFINE_PROC ("VAD.DBA.VAD_TEST_VALUE", proc19);
  DEFINE_PROC ("VAD.DBA.VAD_NODE_INFO", proc20);
  DEFINE_PROC ("VAD.DBA.VAD_NODE_INFO_BY_NAME", proc21);
  DEFINE_PROC ("VAD.DBA.VAD_NEW_PACKAGE", proc22);
  DEFINE_PROC ("VAD.DBA.__VAD_BUILD_TREE", proc23);
  DEFINE_PROC ("VAD.DBA.VAD_BUILD_TREE", proc24);
  DEFINE_PROC ("VAD.DBA.VAD_GET_PACKAGES", proc25);
  DEFINE_PROC ("VAD.DBA.__VAD_DEL_SUBTREE", proc26);
  DEFINE_PROC ("VAD.DBA.VAD_DEL_SUBTREE", proc27);
  DEFINE_PROC ("VAD.DBA.VAD_GET_PKG_ID", proc28);
  DEFINE_PROC ("VAD.DBA.__vad_init", proc29);

  /* vad_misc.sql */
  bootstrap_cli->cli_qualifier = box_string ("VAD");
 
  DEFINE_PUBLIC_PROC ("DB.DBA.DAV_RES_GET", proc30);
  ddl_ensure_table ("VAD.DBA.VAD_HELP", tbl1);
  DEFINE_PROC ("VAD.DBA.HTML_FOOTER_OUT", proc31);
  DEFINE_PROC ("VAD.DBA.OUT_CHK_DFLT_PARS", proc32);
  DEFINE_PROC ("VAD.DBA.VAD_STRIP_RN", proc33);
  DEFINE_PROC ("VAD.DBA.__VAD_TREE_OUT", proc34);
  DEFINE_PROC ("VAD.DBA.__EXPAND_PATH", proc35);
  DEFINE_PROC ("VAD.DBA.VAD_TREE_OUT", proc36);
  DEFINE_PROC ("VAD.DBA.VAD_LIST_FOLDER", proc37);
  DEFINE_PROC ("VAD.DBA.VAD_REG_DIR_OUT", proc38);
  DEFINE_PROC ("VAD.DBA.VAD_REG_TREE_OUT", proc39);
  DEFINE_PROC ("VAD.DBA.VAD_OUT_PACKAGES_LIST", proc40);
  DEFINE_PROC ("VAD.DBA.VAD_GEN_PACKAGES_LIST", proc41);
  DEFINE_PROC ("VAD.DBA.VAD_GEN_PACKAGE_DOCS", proc42);
  DEFINE_PROC ("VAD.DBA.VAD_GEN_PACKAGE_HTTP", proc43);
  DEFINE_PROC ("VAD.DBA.VAD_TEST_PACKAGE_EQ", proc44);
  DEFINE_PROC ("VAD.DBA.VAD_TEST_PACKAGE_LT", proc45);
  DEFINE_PROC ("VAD.DBA.VAD_TEST_PACKAGE_GT", proc46);
  DEFINE_PROC ("VAD.DBA.VAD_TEST_PACKAGE_AND_REMOVE", proc47);
  DEFINE_PROC ("VAD.DBA.VAD_EXEC", proc48);
  DEFINE_PROC ("VAD.DBA.VAD_LOAD_FILE", proc49);
  DEFINE_PROC ("VAD.DBA.VAD_VHOST_DEFINE", proc50);
  DEFINE_PROC ("VAD.DBA.VAD_VHOST_REMOVE", proc51);
  DEFINE_PROC ("VAD.DBA.VAD_EXEC_RETRYING", proc52);
  DEFINE_PROC ("VAD.DBA.VAD_ASSERT2", proc53);
  DEFINE_PROC ("VAD.DBA.VAD_ASSERT", proc54);
  DEFINE_PROC ("VAD.DBA.VAD_SAFE_EXEC", proc55);
  DEFINE_PROC ("VAD.DBA.VAD_GET_NAME_AND_VERSION", proc56);
  DEFINE_PROC ("VAD.DBA.VERSION_COMPARE", proc57);
  DEFINE_PROC ("VAD.DBA.VAD_CHECK_FOR_HIGH_VERSION", proc58);
  DEFINE_PROC ("VAD.DBA.VAD_REMOVE_PREVIOUS_VERSION", proc59);

  dk_free_box (bootstrap_cli->cli_qualifier);
  bootstrap_cli->cli_qualifier =  saved_qualifier;

  /* oper_pars.sql */

  ddl_ensure_table ("do this always", other2);
  ddl_ensure_table ("do this always", other3);
  ddl_ensure_table ("do this always", other4);
  ddl_ensure_table ("do this always", other5);
  ddl_ensure_table ("do this always", other6);
  ddl_ensure_table ("do this always", other7);
  ddl_ensure_table ("do this always", other8);
  ddl_ensure_table ("do this always", other9);
  ddl_ensure_table ("do this always", other10);
  ddl_ensure_table ("do this always", other11);
  ddl_ensure_table ("do this always", other12);
  ddl_ensure_table ("do this always", other13);
  ddl_ensure_table ("do this always", other14);
  ddl_ensure_table ("do this always", other15);
  ddl_ensure_table ("do this always", other16);
  ddl_ensure_table ("do this always", other17);
  ddl_ensure_table ("do this always", other18);
  ddl_ensure_table ("do this always", other19);
  ddl_ensure_table ("do this always", other20);
  ddl_ensure_table ("do this always", other21);
  ddl_ensure_table ("do this always", other22);
  ddl_ensure_table ("do this always", other23);
  ddl_ensure_table ("do this always", other24);

  /* pars_init.sql */

  DEFINE_PROC ("VAD.DBA.RETRIEVE_HTTP_PARS", proc60);

  /* vad_make.sql */

  DEFINE_PROC ("VAD.DBA.DAV_DELETE_VAD", proc61);
  DEFINE_PROC ("VAD.DBA.BLOB_2_STRING_OUTPUT", proc62);
  DEFINE_PROC ("VAD.DBA.VAD_DAV_MKCOL", proc63);
  DEFINE_PROC ("VAD.DBA.VAD_DAV_MOVE", proc64);
  DEFINE_PROC ("VAD.DBA.VAD_DAV_GET_RES", proc65);
  DEFINE_PROC ("VAD.DBA.VAD_DAV_UPLOAD_RES", proc66);
  DEFINE_PROC ("VAD.DBA.VAD_DAV_DELETE", proc67);
  DEFINE_PROC ("VAD.DBA.VAD_MD5_FILE", proc68);
  DEFINE_PROC ("VAD.DBA.VAD_SPLIT_PATH", proc69);
  DEFINE_PROC ("VAD.DBA.VAD_OUT_CHAR", proc70);
  DEFINE_PROC ("VAD.DBA.VAD_GET_CHAR", proc71);
  DEFINE_PROC ("VAD.DBA.VAD_OUT_LONG", proc72);
  DEFINE_PROC ("VAD.DBA.VAD_GET_LONG", proc73);
  DEFINE_PROC ("VAD.DBA.VAD_OUT_ROW", proc74);
  DEFINE_PROC ("VAD.DBA.VAD_OUT_ROW_FILE", proc75);
  DEFINE_PROC ("VAD.DBA.VAD_OUT_ROW_DAV", proc76);
  DEFINE_PROC ("VAD.DBA.VAD_GET_ROW", proc77);
  DEFINE_PROC ("VAD.DBA.VAD_GET_ROW_FILE", proc78);
  DEFINE_PROC ("VAD.DBA.VAD_TEST_CREATE", proc79);
  DEFINE_PROC ("DB.DBA.VAD_CHECK_INSTALLABILITY", proc80);
  DEFINE_PROC ("VAD.DBA.VAD_CHECK_STICKER_DETAILS", proc81);
  DEFINE_PROC ("VAD.DBA.VAD_GET_STICKER_DATA_LEN", proc82);
  DEFINE_PROC ("VAD.DBA.VAD_TEST_READ", proc83);
  DEFINE_PROC ("DB.DBA.VAD_INSTALL", proc84);
  DEFINE_PROC ("VAD.DBA.VAD_READ", proc85);
  DEFINE_PROC ("VAD.DBA.VAD_PKG_UNINSTALL_CHECK", proc86);
  DEFINE_PROC ("VAD.DBA.VAD_UNINSTALL_LIST_FOLDER", proc87);
  DEFINE_PROC ("VAD.DBA.VAD_DO_UNINSTALL", proc88);
  DEFINE_PROC ("VAD.DBA.VAD_UNINSTALL_LIST", proc89);
  DEFINE_PROC ("VAD.DBA.VAD_PKG_UNINSTALL", proc90);
  DEFINE_PROC ("DB.DBA.VAD_CHECK_UNINSTALLABILITY_BY_NAME", proc91);
  DEFINE_PROC ("DB.DBA.VAD_CHECK_UNINSTALLABILITY", proc92);
  DEFINE_PROC ("DB.DBA.VAD_UNINSTALL_BY_NAME", proc93);
  DEFINE_PROC ("DB.DBA.VAD_CHECK_VERSION", proc94);
  DEFINE_PROC ("DB.DBA.VAD_CLEAN_OLD_VERSIONS", proc95);
  DEFINE_PROC ("DB.DBA.VAD_RENAME", proc96);
  DEFINE_PROC ("DB.DBA.VAD_LIST_PACKAGES", proc97);
  DEFINE_PROC ("DB.DBA.VAD_UNINSTALL", proc98);
  DEFINE_PROC ("VAD.DBA.VAD_PKG_DIFF", proc99);
  DEFINE_PROC ("DB.DBA.VAD_CHECK_INSTALLED", proc100);
  DEFINE_PROC ("DB.DBA.VAD_CHECK", proc101);
  DEFINE_PROC ("DB.DBA.VAD_PACK", proc102);
  DEFINE_PROC ("DB.DBA.VAD_LOAD_SQL_FILE", proc103);
  DEFINE_PROC ("DB.DBA.VAD_REMOVE_FILE", proc104);
  DEFINE_PROC ("DB.DBA.VAD_CREATE_INSTALL_FOLDER_TREE", proc105);
  DEFINE_PROC ("DB.DBA.VAD_CREATE_PATH", proc106);
  DEFINE_PROC ("DB.DBA.VAD_DEPS_CHECK", proc107);
  DEFINE_PROC ("VAD.DBA.VER_LT", proc108);
  DEFINE_PROC ("VAD.DBA.VAD_AUTO_UPGRADE", proc109);
}


void
sqls_arfw_define_vad (void)
{
  /* vad_root.sql */

  ddl_ensure_table ("do this always", other1);

}
