.\" zip_file_extra_field_set.mdoc \-- set extra field for file in zip
.\" Copyright (C) 2012-2013 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP files.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_FILE_EXTRA_FIELD_SET 3 "February 20, 2013" NiH
.SH "NAME"
zip_file_extra_field_set \- set extra field for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
int
zip_file_extra_field_set(struct zip *archive, zip_uint64_t index); \
"zip_uint16_t extra_field_id" "zip_uint16_t extra_field_index" \
"const zip_uint8_t *extra_field_data" "zip_uint16_t len" \
"zip_flags_t flags"
.SH "DESCRIPTION"
The
zip_file_extra_field_set
function sets the extra field with ID (two-byte signature)
\fBextra_field_id\fR
and index
\fBextra_field_index\fR
for the file at position
\fBindex\fR
in the zip archive.
The extra field's data will be set to
\fBextra_field_data\fR
and length
\fBlen.\fR
If a new entry shall be appended, set
\fBextra_field_index\fR
to
\fBZIP_EXTRA_FIELD_NEW.\fR
.PP
At least one of the following
\fBflags\fR
must be set:
.RS
.TP 18
\fBZIP_FL_CENTRAL\fR
Set extra field in the archive's central directory.
.TP 18
\fBZIP_FL_LOCAL\fR
Set extra field in the local file headers.
.RE
.PP
Please note that the extra field IDs 0x0001 (ZIP64 extension),
0x6375 (Infozip UTF-8 comment), and
0x7075 (Infozip UTF-8 file name) can not be set using
zip_file_extra_field_set
since they are set by
libzip(3)
automatically when needed.
.SH "RETURN VALUES"
Upon successful completion 0 is returned.
Otherwise, \-1 is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
zip_file_extra_field_set
fails if:
.RS
.TP 4
[ZIP_ER_INVAL]
The extra field size is too large (ID and length need 4 bytes; the
maximum length of all extra fields for one file combined is 65536
bytes).
This error also occurs if
\fBextra_field_index\fR
is too large.
.TP 4
[ZIP_ER_MEMORY]
Required memory could not be allocated.
.TP 4
[ZIP_ER_NOENT]
\fBindex\fR
is not a valid file index in
\fBarchive.\fR
.RE
.SH "SEE ALSO"
libzip(3),
zip_file_extra_field_delete(3),
zip_file_extra_field_get(3),
zip_file_extra_fields_count(3)
.SH "AUTHORS"

Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
