.\" zip_file_strerror.mdoc \-- get string representation for a zip error
.\" Copyright (C) 2003, 2005 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_FILE_STRERROR 3 "December 27, 2004" NiH
.SH "NAME"
zip_file_strerror , \- .Nm zip_strerror
get string representation for a zip error
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
const char *
zip_file_strerror(struct zip_file *file);
.PP
const char *
zip_strerror(struct zip *archive);
.SH "DESCRIPTION"
The
zip_strerror
function returns a string describing the last error for the zip archive
\fBarchive,\fR
while the
zip_file_strerror
function does the same for a zip file
\fBfile\fR
(one file in an archive).
The returned string must not be modified or freed, and becomes invalid when
\fBarchive\fR
or
\fBfile,\fR
respectively,
is closed or on the next call to
zip_strerror
or
zip_file_strerror,
respectively,
for the same archive.
.SH "RETURN VALUES"
zip_file_strerror
and
zip_strerror
return a pointer to the error string.
.SH "SEE ALSO"
libzip(3),
zip_error_to_str(3)
.SH "AUTHORS"

Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
