/* This file is automatically generated by sql_to_c.awk */

#include "sqlnode.h"
#include "sqlfn.h"
#include "sqltype.h"

/* admin.sql */

static const char *proc0 = 
"#line 31 \"[executable]/admin.sql\"\n"
"create procedure\n"
"select_if (in sel varchar, in val varchar)\n"
"{\n"
"\n"
"if (sel = val)\n"
"{\n"
"return (\'SELECTED\');\n"
"}\n"
"return (\'\');\n"
"}\n"
"--src admin.sql:29\n"
;

static const char *proc1 = 
"#line 44 \"[executable]/admin.sql\"\n"
"create procedure\n"
"check_if (in sel varchar, in val varchar)\n"
"{\n"
"\n"
"if (sel = val)\n"
"{\n"
"return (\'CHECKED\');\n"
"}\n"
"return (\'\');\n"
"}\n"
"--src admin.sql:42\n"
;

static const char *proc2 = 
"#line 66 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_http_parm_concat (in name varchar, in delm varchar, inout params any)\n"
"{\n"
"declare pos, found_it integer;\n"
"declare result varchar;\n"
"declare tbl varchar;\n"
"\n"
"pos := 0;\n"
"found_it := 0;\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (name))\n"
"signal(\'42000\', \'adm_http_parm_concat needs a param name\');\n"
"\n"
"if (1 > length (params))\n"
"return \'\';\n"
"\n"
"while (1)\n"
"{\n"
"if (0 = (pos := position (name, params, pos + 1)))\n"
"return result;\n"
"\n"
"tbl := aref (params, pos);\n"
"\n"
"if (not DB.DBA.IS_EMPTY_OR_NULL (tbl))\n"
"if (0 = found_it)\n"
"{\n"
"result := tbl;\n"
"found_it := 42;\n"
"}\n"
"else\n"
"result := concat (result, delm, tbl);\n"
"}\n"
"}\n"
"--src admin.sql:64\n"
;

static const char *proc3 = 
"#line 102 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_new_session (inout tree any)\n"
"{\n"
"declare sesid varchar;\n"
"\n"
"if (not exists (select 1 from \"DB\".\"DBA\".\"SYS_SCHEDULED_EVENT\"\n"
"where SE_NAME = \'ADMIN_SESSION_EXPIRE\'))\n"
"{\n"
"insert into \"DB\".\"DBA\".\"SYS_SCHEDULED_EVENT\" (SE_INTERVAL, SE_LAST_COMPLETED,\n"
"SE_NAME, SE_SQL, SE_START)\n"
"values (10, NULL, \'ADMIN_SESSION_EXPIRE\',\n"
"\'ADMIN_EXPIRE_SESSIONS ()\', now());\n"
"}\n"
"sesid := md5 (concat (datestring (now ()), \'doGsIseliM\'));\n"
"\n"
"insert into ADMIN_SESSION (ASES_ID, ASES_LAST_ACCESS, ASES_TREE)\n"
"values (sesid, now(), serialize (tree));\n"
"\n"
"return (sesid);\n"
"}\n"
"--src admin.sql:100\n"
;

static const char *proc4 = 
"#line 125 \"[executable]/admin.sql\"\n"
"create procedure\n"
"ADMIN_EXPIRE_SESSIONS ()\n"
"{\n"
"delete from ADMIN_SESSION where datediff (\'hour\', ASES_LAST_ACCESS, now()) > 2;\n"
"}\n"
"--src admin.sql:123\n"
;

static const char *proc5 = 
"#line 132 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_get_tree (in sesid varchar)\n"
"{\n"
"declare tree varchar;\n"
"\n"
"whenever not found goto nf;\n"
"update ADMIN_SESSION set ASES_LAST_ACCESS = now ()\n"
"where ASES_ID = sesid and (tree := blob_to_string (ASES_TREE), 1);\n"
"\n"
"if (isstring (tree))\n"
"return deserialize(tree);\n"
"\n"
"nf:\n"
"return 0;\n"
"}\n"
"--src admin.sql:130\n"
;

static const char *proc6 = 
"#line 150 \"[executable]/admin.sql\"\n"
"create procedure adm_get_sesid (inout params any)\n"
"{\n"
"declare sesid varchar;\n"
"\n"
"sesid := get_keyword (\'sid\', params, \'\');\n"
"\n"
"if (\'\' = sesid)\n"
"{\n"
"\n"
"sesid := adm_new_session (adm_new_menu_tree());\n"
"if (isarray (params))\n"
"params := vector_concat (params, vector (\'sid\', sesid));\n"
"else\n"
"params := vector (\'sid\', sesid);\n"
"}\n"
"return sesid;\n"
"}\n"
"--src admin.sql:148\n"
;


static const char *proc7 = 
"#line 171 \"[executable]/admin.sql\"\n"
" create procedure\n"
"adm_get_ses_var (in sesid varchar, in name varchar, in deflt any)\n"
"{\n"
"declare vars varchar;\n"
"\n"
"vars := null;\n"
"whenever not found goto nf;\n"
"update ADMIN_SESSION set ASES_LAST_ACCESS = now ()\n"
"where ASES_ID = sesid and (vars := blob_to_string (ASES_VARS), 1);\n"
"\n"
"vars := deserialize (vars);\n"
"if (vars is not null)\n"
"return get_keyword (name, vars, deflt);\n"
"nf:\n"
"return deflt;\n"
"}\n"
"--src admin.sql:169\n"
;


static const char *proc8 = 
"#line 191 \"[executable]/admin.sql\"\n"
" create procedure\n"
"adm_set_ses_var (in sesid varchar, in name varchar, in value any)\n"
"{\n"
"declare vars varchar;\n"
"declare inx, is_set integer;\n"
"\n"
"vars := null;\n"
"whenever not found goto nf;\n"
"update ADMIN_SESSION set ASES_LAST_ACCESS = now ()\n"
"where ASES_ID = sesid and (vars := blob_to_string (ASES_VARS), 1);\n"
"\n"
"vars := deserialize (vars);\n"
"inx := 0;\n"
"is_set := 0;\n"
"while (inx < length (vars))\n"
"{\n"
"if (aref (vars, inx) = name)\n"
"{\n"
"aset (vars, inx + 1, value);\n"
"is_set := 1;\n"
"inx := length (vars);\n"
"}\n"
"else\n"
"inx := inx + 2;\n"
"}\n"
"if (is_set = 0)\n"
"vars := vector_concat (vector (name, value), vars);\n"
"\n"
"update ADMIN_SESSION set ASES_LAST_ACCESS = now (), ASES_VARS = serialize (vars)\n"
"where ASES_ID = sesid;\n"
"return value;\n"
"nf:\n"
"return NULL;\n"
"}\n"
"--src admin.sql:189\n"
;

static const char *proc9 = 
"#line 228 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_dav_u_name (in _u_id integer)\n"
"{\n"
"declare _u_name varchar;\n"
"\n"
"whenever not found goto nf;\n"
"\n"
"select U_NAME into _u_name from WS.WS.SYS_DAV_USER where U_ID = _u_id;\n"
"return (_u_name);\n"
"\n"
"nf:\n"
"return (\'No user\');\n"
"}\n"
"--src admin.sql:226\n"
;

static const char *proc10 = 
"#line 245 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_dav_g_name (in _g_id integer)\n"
"{\n"
"declare _g_name varchar;\n"
"\n"
"whenever not found goto nf;\n"
"\n"
"select G_NAME into _g_name from WS.WS.SYS_DAV_GROUP where G_ID = _g_id;\n"
"return (_g_name);\n"
"\n"
"nf:\n"
"return (\'No group\');\n"
"}\n"
"--src admin.sql:243\n"
;

static const char *proc11 = 
"#line 262 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_unauth_response ()\n"
"{\n"
"http_request_status (\'HTTP/1.1 401 Unauthorized\');\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>401 Unauthorized</TITLE>\',\n"
"\'</HEAD><BODY><H1>Unauthorized</H1>\',\n"
"\'Access to page is forbidden.</BODY></HTML>\'));\n"
"}\n"
"--src admin.sql:260\n"
;

static const char *proc12 = 
"#line 276 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_dav_check_auth (in lines any, in all_dav_acct integer := 0)\n"
"{\n"
"declare _u_name, _u_pwd varchar;\n"
"declare _u_group, _u_id integer;\n"
"\n"
"declare auth any;\n"
"declare _user, domain varchar;\n"
"declare ses_dta any;\n"
"\n"
"domain := http_path ();\n"
"if (domain like \'/admin/admin_dav/%\')\n"
"domain := \'/admin/admin_dav\';\n"
"else if (domain like \'/mime/%\')\n"
"domain := \'/mime\';\n"
"else\n"
"domain := \'/DAV\';\n"
"\n"
"auth := vsp_auth_vec (lines);\n"
"\n"
"if (0 <> auth)\n"
"{\n"
"\n"
"_user := get_keyword (\'username\', auth, \'\');\n"
"\n"
"if (\'\' = _user)\n"
"return -1;\n"
"\n"
"whenever not found goto nf;\n"
"\n"
"select U_NAME, U_PWD, U_GROUP, U_ID\n"
"into _u_name, _u_pwd, _u_group, _u_id from WS.WS.SYS_DAV_USER\n"
"where U_NAME = _user and U_ACCOUNT_DISABLED = 0;\n"
"\n"
"if (vsp_auth_verify_pass (auth, _u_name,\n"
"get_keyword (\'realm\', auth, \'\'),\n"
"get_keyword (\'uri\', auth, \'\'),\n"
"get_keyword (\'nonce\', auth, \'\'),\n"
"get_keyword (\'nc\', auth, \'\'),\n"
"get_keyword (\'cnonce\', auth, \'\'),\n"
"get_keyword (\'qop\', auth, \'\'),\n"
"_u_pwd))\n"
"{\n"
"if (_user = \'dba\')\n"
"_u_id := http_dav_uid ();\n"
"connection_set (\'DAVUserID\', _u_id);\n"
"if (all_dav_acct or _u_id = http_dav_uid ())\n"
"{\n"
"if (all_dav_acct)\n"
"return (_u_id);\n"
"else\n"
"return 1;\n"
"}\n"
"else\n"
"return -1;\n"
"}\n"
"}\n"
"nf:\n"
"vsp_auth_get (\'virtuoso_dav_admin\', domain,\n"
"md5 (datestring (now ())),\n"
"md5 (\'FloppyBootStompedOntoTheGround\'),\n"
"\'false\', lines, 1);\n"
"return -1;\n"
"}\n"
"--src admin.sql:274\n"
;

static const char *proc13 = 
"#line 342 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_tell_unauth_dav (in lines any)\n"
"{\n"
"http_request_status (\'HTTP/1.1 401 Unauthorized\');\n"
"DB.DBA.vsp_auth_get (\'virtuoso_dav_admin\', \'/admin/admin_dav\',\n"
"md5 (datestring (now ())),\n"
"md5 (\'FloppyBootStompedOntoTheGround\'),\n"
"\'false\', lines, 1);\n"
"\n"
"http ( concat (\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\',\n"
"\'<HTML><HEAD>\',\n"
"\'<TITLE>401 Unauthorized</TITLE>\',\n"
"\'</HEAD><BODY><H1>Unauthorized</H1>\',\n"
"\'Access to page is forbidden.</BODY></HTML>\'));\n"
"}\n"
"--src admin.sql:340\n"
;

static const char *proc14 = 
"#line 359 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_check_auth (in lines any)\n"
"{\n"
"declare _u_name, _u_password varchar;\n"
"declare _u_group, _u_id integer;\n"
"declare auth any;\n"
"declare _user varchar;\n"
"declare ses_dta any;\n"
"declare rc integer;\n"
"\n"
"auth := vsp_auth_vec (lines);\n"
"\n"
"if (0 <> auth)\n"
"{\n"
"\n"
"_user := get_keyword (\'username\', auth, \'\');\n"
"\n"
"rc := -1;\n"
"if (sys_stat (\'dbev_enable\') and __proc_exists (\'DB.DBA.DBEV_LOGIN\'))\n"
"{\n"
"declare _pwd, _atype varchar;\n"
"\n"
"_atype := lower (get_keyword (\'authtype\', auth, \'unknown\'));\n"
"\n"
"if (_atype = \'basic\')\n"
"_pwd := get_keyword (\'pass\', auth, \'\');\n"
"else\n"
"_pwd := auth;\n"
"\n"
"_atype := sprintf (\'<http_%s>\', _atype);\n"
"\n"
"rc := DB.DBA.DBEV_LOGIN (_user, _pwd, _atype);\n"
"}\n"
"\n"
"if (rc = 0 or \'\' = _user) /* PLLH_INVALID, must reject */\n"
"{\n"
"goto nf;\n"
"}\n"
"\n"
"whenever not found goto nf;\n"
"\n"
"select U_NAME, U_PASSWORD, U_GROUP, U_ID\n"
"into _u_name, _u_password, _u_group, _u_id from DB.DBA.SYS_USERS\n"
"where U_NAME = _user;\n"
"\n"
"if (rc = 1) /* PLLH_VALID, authentication is already done */\n"
"{\n"
"return 1;\n"
"}\n"
"\n"
"/* rc = -1 PLLH_NO_AUTH, should check */\n"
"\n"
"if (0 = _u_group and 1 = vsp_auth_verify_pass (auth, _u_name,\n"
"get_keyword (\'realm\', auth, \'\'),\n"
"get_keyword (\'uri\', auth, \'\'),\n"
"get_keyword (\'nonce\', auth, \'\'),\n"
"get_keyword (\'nc\', auth, \'\'),\n"
"get_keyword (\'cnonce\', auth, \'\'),\n"
"get_keyword (\'qop\', auth, \'\'),\n"
"_u_password))\n"
"{\n"
"__set_user_id (_u_name, 0);\n"
"return 1;\n"
"}\n"
"}\n"
"nf:\n"
"vsp_auth_get (\'virtuoso_admin\', \'/admin\',\n"
"md5 (datestring (now ())),\n"
"md5 (\'FloppyBootStompedOntoTheGround\'),\n"
"\'false\', lines, 1);\n"
"return 0;\n"
"}\n"
"--src admin.sql:357\n"
;

static const char *proc15 = 
"#line 435 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_unqualify (in name varchar)\n"
"{\n"
"declare name_str varchar;\n"
"\n"
"if (not isstring (name))\n"
"{\n"
"name_str := cast (name as varchar);\n"
"}\n"
"else\n"
"{\n"
"name_str := name;\n"
"}\n"
"return (subseq (name_str, coalesce (strrchr (name_str, \'.\') + 1, 0)));\n"
"}\n"
"--src admin.sql:433\n"
;

static const char *proc16 = 
"#line 459 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_param_default (inout dest any, in p_name varchar,\n"
"in p_vec any, in p_def varchar)\n"
"{\n"
"dest := get_keyword (p_name, p_vec);\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (dest) or 0 = dest)\n"
"{\n"
"dest := p_def;\n"
"}\n"
"}\n"
"--src admin.sql:457\n"
;

static const char *proc17 = 
"#line 478 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_get_param (inout dest varchar, in p_name varchar,\n"
"in p_vec varchar, in err_sql_state varchar)\n"
"{\n"
"\n"
"dest := get_keyword (p_name, p_vec);\n"
"if ((\'\' = dest) or isnull (dest))\n"
"{\n"
"signal (err_sql_state,\n"
"concat (\'Empty or NULL parameter \', p_name));\n"
"}\n"
"}\n"
"--src admin.sql:476\n"
;

static const char *proc18 = 
"#line 499 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_date_fmt (in d datetime)\n"
"{\n"
"declare l, r, d_str, day_str, time_str varchar;\n"
"\n"
"if (d is not null)\n"
"d_str := datestring (d);\n"
"else\n"
"return \'\';\n"
"day_str := \"LEFT\" (d_str, 10);\n"
"time_str := concat (subseq (d_str, 11, 13), \':\', subseq (d_str, 14, 16));\n"
"\n"
"return (concat (day_str, \' \', time_str));\n"
"}\n"
"--src admin.sql:497\n"
;

static const char *proc19 = 
"#line 518 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_make_date (in d_str varchar)\n"
"{\n"
"return (stringdate (d_str));\n"
"}\n"
"--src admin.sql:516\n"
;

static const char *proc20 = 
"#line 537 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_result_tbl_hdrs (in m_dta any)\n"
"{\n"
"\n"
"declare m_dta_col varchar;\n"
"declare inx, n_cols integer;\n"
"declare col_names varchar;\n"
"\n"
"n_cols := length (aref (m_dta,0));\n"
"\n"
"while (inx < n_cols)\n"
"{\n"
"m_dta_col := aref (aref (m_dta, 0), inx);\n"
"\n"
"http (\'<td class=\"resheader\"><SPAN class=\"rescolname\">\');\n"
"col_names := aref (m_dta_col, 0);\n"
"\n"
"http_value (adm_unqualify (col_names));\n"
"\n"
"http (\'</SPAN><BR><SPAN class=\"rescoltype\">\');\n"
"http (dv_type_title (aref (m_dta_col, 1)));\n"
"http (\'</SPAN></td>\\n\');\n"
"\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"--src admin.sql:535\n"
;

static const char *proc21 = 
"#line 577 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_result_to_table (in result any, in m_dta any)\n"
"{\n"
"declare inx, jnx integer;\n"
"declare res_row varchar;\n"
"declare res_col varchar;\n"
"declare res_cols, n_cols integer;\n"
"declare res_len integer;\n"
"declare dt_nfo any;\n"
"declare col_type integer;\n"
"\n"
"http (\'<table class=\"restable\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\">\');\n"
"\n"
"if (0 = m_dta)\n"
"{\n"
"http(\'<tr><td class=\"resdata\">The statement execution did not return a result set.</td></tr></table>\');\n"
"return 0;\n"
"}\n"
"\n"
"n_cols := length (aref (m_dta, 0));\n"
"http (\'<tr><td class=\"restitle\" colspan=\"\');\n"
"http (cast (n_cols as varchar));\n"
"http (\'\">Query result:</td></tr>\');\n"
"http (\'<tr>\');\n"
"adm_result_tbl_hdrs (m_dta);\n"
"http (\'</tr>\');\n"
"\n"
"res_len := length (result);\n"
"dt_nfo := aref(m_dta, 0);\n"
"inx := 0;\n"
"\n"
"while (inx < res_len)\n"
"{\n"
"http (sprintf (\'<tr class=\"%s\">\', case when mod(inx, 2) then \'resrowodd\' else \'resroweven\' end));\n"
"\n"
"res_row := aref (result, inx);\n"
"res_cols := length (res_row);\n"
"\n"
"jnx := 0;\n"
"\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"http (\'Cant display result</TD>\');\n"
"goto next;\n"
"};\n"
"while (jnx < res_cols)\n"
"{\n"
"http (\'<td class=\"resdata\"> &nbsp;\');\n"
"res_col := aref (res_row, jnx);\n"
"col_type := aref (aref (dt_nfo, jnx), 1);\n"
"if (__tag (res_col) = 193)\n"
"http_value (concat (\'(\', vector_print (res_col), \')\'));\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"else if (__tag (res_col) = 230 and res_col is not null)\n"
"{\n"
"declare ses any;\n"
"ses := string_output ();\n"
"http_value (res_col, NULL, ses);\n"
"http_value (string_output_string (ses));\n"
"}\n"
"else\n"
"http_value (coalesce (res_col, \'<DB NULL>\'));\n"
"next:\n"
"http (\'</td>\');\n"
"jnx := jnx + 1;\n"
"}\n"
"\n"
"whenever SQLSTATE \'*\' default;\n"
"\n"
"http (\'</tr>\\n\');\n"
"inx := inx + 1;\n"
"}\n"
"http (concat (\'<tr><td class=\"resfooter\" colspan=\"\',\n"
"cast (res_cols as varchar),\n"
"\'\">No. of rows in result: \',\n"
"cast (inx as varchar),\n"
"\'</td></tr>\'));\n"
"http (\'</table>\');\n"
"\n"
"}\n"
"--src admin.sql:575\n"
;

static const char *proc22 = 
"#line 674 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_evt_action (in params varchar)\n"
"{\n"
"declare _se_name, _se_sql varchar;\n"
"declare _se_start datetime;\n"
"declare _se_start_str varchar;\n"
"declare _se_interval integer;\n"
"declare _se_interval_str varchar;\n"
"declare _del varchar;\n"
"declare _add varchar;\n"
"declare _edt varchar;\n"
"\n"
"if (\'\' <> get_keyword (\'add\', params))\n"
"{\n"
"adm_get_param (_se_name, \'evt_name\', params, \'AE001\');\n"
"adm_get_param (_se_sql, \'evt_sql\', params, \'AE002\');\n"
"adm_get_param (_se_start_str, \'evt_stime\', params, \'AE003\');\n"
"adm_get_param (_se_interval_str, \'evt_interval\', params, \'AE004\');\n"
"\n"
"_se_start := adm_make_date (_se_start_str);\n"
"\n"
"if (isnull (_se_start))\n"
"{\n"
"signal (\'AE005\',\'Invalid datetime for scheduled event\');\n"
"}\n"
"\n"
"_se_interval := atoi (_se_interval_str);\n"
"\n"
"if (1 > _se_interval)\n"
"{\n"
"signal (\'AE006\',\'Invalid interval for scheduled event\');\n"
"}\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_SCHEDULED_EVENT where SE_NAME = _se_name))\n"
"{\n"
"update DB.DBA.SYS_SCHEDULED_EVENT\n"
"set SE_START = _se_start,\n"
"SE_SQL = _se_sql,\n"
"SE_INTERVAL = _se_interval\n"
"where SE_NAME = _se_name;\n"
"}\n"
"else\n"
"{\n"
"insert into DB.DBA.SYS_SCHEDULED_EVENT\n"
"(SE_NAME, SE_START, SE_SQL, SE_INTERVAL)\n"
"values (_se_name, _se_start, _se_sql, _se_interval);\n"
"}\n"
"}\n"
"\n"
"if (\'\' <> (_del := get_keyword (\'DEL2\', params)) and get_keyword (\'proceed\', params) = \'Delete\')\n"
"{\n"
"delete from DB.DBA.SYS_SCHEDULED_EVENT where SE_NAME = _del;\n"
"return 0;\n"
"}\n"
"else\n"
"{\n"
"return 0;\n"
"}\n"
"}\n"
"--src admin.sql:672\n"
;

static const char *proc23 = 
"#line 736 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_users_u_group (in grp integer)\n"
"{\n"
"declare u_group_name varchar;\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_USERS where U_ID = grp))\n"
"select U_NAME into u_group_name from DB.DBA.SYS_USERS where U_ID = grp;\n"
"else\n"
"u_group_name := \'\';\n"
"\n"
"http (sprintf (\'%s\', u_group_name));\n"
"}\n"
"--src admin.sql:734\n"
;

static const char *proc24 = 
"#line 762 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_users_action (in params varchar)\n"
"{\n"
"declare _u_name, _u_password, _u_password2 varchar;\n"
"declare _os_name, _os_password varchar;\n"
"declare _u_id integer;\n"
"declare _u_data varchar;\n"
"declare _del any;\n"
"declare _action varchar;\n"
"declare msg, state varchar;\n"
"declare _u_group any;\n"
"\n"
"state := \'00000\';\n"
"\n"
"if (\'\' <> (_action := get_keyword (\'add\', params, \'\')))\n"
"{\n"
"\n"
"_u_name := get_keyword (\'u_name\', params, \'\');\n"
"_u_password := get_keyword (\'u_password\', params, \'\');\n"
"_u_password2 := get_keyword (\'u_password2\', params, \'\');\n"
"_os_name := get_keyword (\'os_name\', params, \'\');\n"
"_os_password := get_keyword (\'os_password\', params, \'\');\n"
"_u_data := get_keyword (\'u_data\', params, \'\');\n"
"_u_group := get_keyword (\'u_group\', params, \'\');\n"
"_u_id := atoi(get_keyword (\'u_id\', params, \'\'));\n"
"\n"
"if (_u_password <> _u_password2)\n"
"return -1;\n"
"\n"
"if (_u_password = \'__not_changed\')\n"
"select pwd_magic_calc (U_NAME, U_PASSWORD, 1) into _u_password from DB.DBA.SYS_USERS where U_ID = _u_id;\n"
"\n"
"if (\'Add\' = _action or \'Retry\' = _action)\n"
"{\n"
"if (\'\' = _u_name)\n"
"{\n"
"return -5;\n"
"}\n"
"select max (U_ID) into _u_id from DB.DBA.SYS_USERS;\n"
"_u_id := _u_id + 1;\n"
"}\n"
"\n"
"if (\'** NONE **\' = _u_group)\n"
"{\n"
"_u_group := _u_id;\n"
"}\n"
"else\n"
"{\n"
"_u_group := atoi (_u_group);\n"
"if (not exists (select 1 from DB.DBA.SYS_USERS\n"
"where U_ID = _u_group and U_ID = U_GROUP))\n"
"return -2;\n"
"}\n"
"\n"
"if (\'dba\' = _u_name)\n"
"{\n"
"_u_id := 0;\n"
"_u_group := 0;\n"
"}\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_USERS where U_NAME = _u_name))\n"
"{\n"
"if (\'\' <> _u_data)\n"
"{\n"
"_u_data := sprintf(\'Q %s\', _u_data);\n"
"}\n"
"\n"
"if (\'\' = get_keyword (\'EDIT\', params, \'\'))\n"
"{\n"
"return -6;\n"
"}\n"
"else\n"
"{\n"
"if (_os_name <> \'\' and _os_password <> \'\')\n"
"{\n"
"if (DB.DBA.SET_USER_OS_ACOUNT (_u_name, _os_name, _os_password) = 0)\n"
"return -7;\n"
"}\n"
"update DB.DBA.SYS_USERS set U_GROUP = _u_group, U_PASSWORD = pwd_magic_calc (_u_name, _u_password),\n"
"U_DATA = _u_data where U_NAME = _u_name;\n"
"}\n"
"sec_set_user_struct (_u_name, _u_password, _u_id, _u_group, _u_data);\n"
"}\n"
"else\n"
"{\n"
"if (_os_name <> \'\' and _os_password <> \'\')\n"
"{\n"
"if (DB.DBA.SET_USER_OS_ACOUNT (_u_name, _os_name, _os_password, 1) = 0)\n"
"return -7;\n"
"_u_id := USER_CREATE (_u_name, _u_password, vector (\n"
"\'SQL_ENABLE\',1,\n"
"\'DAV_ENABLE\',0,\n"
"\'LOGIN_QUALIFIER\', _u_data,\n"
"\'PRIMARY_GROUP\', _u_group,\n"
"\'SYSTEM_UNAME\', pwd_magic_calc (_u_name, _os_name, 0),\n"
"\'SYSTEM_UPASS\', pwd_magic_calc (_u_name, _os_password, 0)));\n"
"if (DB.DBA.SET_USER_OS_ACOUNT (_u_name, _os_name, _os_password) = 0)\n"
"return -7;\n"
"}\n"
"else\n"
"{\n"
"_u_id := USER_CREATE (_u_name, _u_password, vector (\n"
"\'SQL_ENABLE\',1,\n"
"\'DAV_ENABLE\',0,\n"
"\'LOGIN_QUALIFIER\', _u_data,\n"
"\'PRIMARY_GROUP\', _u_group));\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (\'\' <> (_del := get_keyword (\'DEL2\', params, \'\')) and\n"
"\'Delete\' = get_keyword (\'proceed\', params))\n"
"{\n"
"_del := atoi(_del);\n"
"\n"
"if (0 = _del)\n"
"return -3;\n"
"\n"
"if (not exists (select 1 from DB.DBA.SYS_USERS\n"
"where U_GROUP = _del and U_ID <> _del))\n"
"{\n"
"select U_NAME into _u_name from DB.DBA.SYS_USERS where U_ID = _del;\n"
"exec (sprintf (\'delete user \"%s\"\', _u_name),\n"
"state, msg, vector (), 0, NULL, NULL);\n"
"if (\'00000\' <> state)\n"
"{\n"
"return -6;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"return -4;\n"
"}\n"
"}\n"
"}\n"
"--src admin.sql:760\n"
;

static const char *proc25 = 
"#line 900 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_u_group_options(in grp varchar)\n"
"{\n"
"declare g_id integer;\n"
"\n"
"http(\'<option value=\"** NONE **\">** NONE **</option>\');\n"
"\n"
"for (select U_NAME, U_ID from DB.DBA.SYS_USERS where U_ID = U_GROUP and U_SQL_ENABLE = 1) do\n"
"{\n"
"http (sprintf (\'<option value=\"%d\" %s>%s</option>\', U_ID, select_if (U_ID, grp), U_NAME));\n"
"}\n"
"}\n"
"--src admin.sql:898\n"
;

static const char *proc26 = 
"#line 917 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_users_error_msg (in _res integer)\n"
"{\n"
"if (-1 = _res)\n"
"{\n"
"return (\'<P class=\"errorhead\">*** Mismatched passwords, please re-enter</P>\');\n"
"}\n"
"if (-2 = _res)\n"
"{\n"
"return (\'<P class=\"errorhead\">*** Invalid group</P>\');\n"
"}\n"
"if (-3 = _res)\n"
"{\n"
"return (\'<P class=\"errorhead\">*** Cannot delete user dba</P>\');\n"
"}\n"
"if (-4 = _res)\n"
"{\n"
"return (\'<P class=\"errorhead\">*** A group user cannot be removed</P>\');\n"
"}\n"
"if (-5 = _res)\n"
"{\n"
"return (\'<P class=\"errorhead\">*** Blank user name, please re-enter</P>\');\n"
"}\n"
"if (-6 = _res)\n"
"{\n"
"return (\'<P class=\"errorhead\">*** The user name already exist</P>\');\n"
"}\n"
"if (-7 = _res)\n"
"{\n"
"return (\'<P class=\"errorhead\">*** The system account is not valid</P>\');\n"
"}\n"
"\n"
"return (\' \');\n"
"}\n"
"--src admin.sql:915\n"
;

static const char *proc27 = 
"#line 956 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_users_def_qual (in dta varchar)\n"
"{\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (dta))\n"
"{\n"
"return(\'DB\');\n"
"}\n"
"\n"
"dta := split_and_decode (dta, 0, \'   \');\n"
"return (get_keyword (\'Q\', dta, \'\'));\n"
"}\n"
"--src admin.sql:954\n"
;

static const char *proc28 = 
"#line 973 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_is_checked (in cb_name varchar, in params any)\n"
"{\n"
"if (\'on\' = get_keyword (cb_name, params, \'\'))\n"
"{\n"
"return (1);\n"
"}\n"
"else\n"
"{\n"
"return (0);\n"
"}\n"
"}\n"
"--src admin.sql:971\n"
;

static const char *proc29 = 
"#line 990 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_dav_users_get_perms (in params any)\n"
"{\n"
"declare result varchar;\n"
"\n"
"result := \'\';\n"
"result := sprintf(\'%d%d%d%d%d%d%d%d%d\',\n"
"adm_is_checked(\'perm_ur\', params),\n"
"adm_is_checked(\'perm_uw\', params),\n"
"adm_is_checked(\'perm_ux\', params),\n"
"adm_is_checked(\'perm_gr\', params),\n"
"adm_is_checked(\'perm_gw\', params),\n"
"adm_is_checked(\'perm_gx\', params),\n"
"adm_is_checked(\'perm_or\', params),\n"
"adm_is_checked(\'perm_ow\', params),\n"
"adm_is_checked(\'perm_ox\', params));\n"
"\n"
"return \"LEFT\"(result,9);\n"
"\n"
"}\n"
"--src admin.sql:988\n"
;

static const char *proc30 = 
"#line 1018 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_dav_format_perms (in p varchar)\n"
"{\n"
"declare p_arr varchar;\n"
"declare p_str varchar;\n"
"declare one integer;\n"
"declare idx integer;\n"
"\n"
"p_arr := \'rwxrwxrwx\';\n"
"p_str := cast (p as varchar);\n"
"\n"
"if (9 > length (p_str))\n"
"{\n"
"return (\'Invalid permission value.\');\n"
"}\n"
"\n"
"while (idx < 9)\n"
"{\n"
"if (ascii (\'1\') <> aref (p_str, idx))\n"
"{\n"
"aset (p_arr, idx, ascii(\'-\'));\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"return (p_arr);\n"
"}\n"
"--src admin.sql:1016\n"
;


static const char *proc31 = 
"#line 1060 \"[executable]/admin.sql\"\n"
" create procedure\n"
"adm_dav_users_action (in params varchar)\n"
"{\n"
"declare _u_name, _u_pwd, _u_pwd2 varchar;\n"
"declare _u_id integer;\n"
"declare _u_e_mail, _u_full_name varchar;\n"
"declare _u_account_disabled integer;\n"
"declare _del varchar;\n"
"declare _action varchar;\n"
"declare msg, state varchar;\n"
"declare _u_home, _u_p_home, _u_def_perms varchar;\n"
"declare _u_group any;\n"
"\n"
"state := \'00000\';\n"
"\n"
"if (\'\' <> (_action := get_keyword (\'add\', params, \'\')))\n"
"{\n"
"\n"
"_u_name := get_keyword (\'u_name\', params, \'\');\n"
"_u_pwd := get_keyword (\'u_pwd\', params, \'\');\n"
"_u_pwd2 := get_keyword (\'u_pwd2\', params, \'\');\n"
"_u_full_name := get_keyword (\'u_full_name\', params, \'\');\n"
"_u_e_mail := get_keyword (\'u_e_mail\', params, \'\');\n"
"_u_group := get_keyword (\'u_group\', params, \'\');\n"
"_u_id := atoi(get_keyword (\'u_id\', params, \'\'));\n"
"_u_account_disabled := adm_is_checked(\'u_account_disabled\', params);\n"
"_u_def_perms := adm_dav_users_get_perms (params);\n"
"\n"
"if (_u_pwd <> _u_pwd2)\n"
"return -1;\n"
"\n"
"if (\'Add\' = _action or \'Retry\' = _action)\n"
"{\n"
"if (\'\' = _u_name)\n"
"{\n"
"return -5;\n"
"}\n"
"select max (U_ID) into _u_id from WS.WS.SYS_DAV_USER;\n"
"_u_id := _u_id + 1;\n"
"}\n"
"\n"
"if (\'** NONE **\' = _u_group)\n"
"{\n"
"_u_group := NULL;\n"
"}\n"
"else\n"
"_u_group := atoi (_u_group);\n"
"\n"
"_u_p_home := \'\';\n"
"if (\'\' <> get_keyword (\'u_cr_home\', params, \'\'));\n"
"_u_p_home := get_keyword (\'u_home\', params, \'\');\n"
"\n"
"_u_home := coalesce ((select U_HOME from WS.WS.SYS_DAV_USER where U_NAME = _u_name), _u_p_home);\n"
"\n"
"DAV_ADD_USER_INT (_u_name, _u_pwd, _u_group, _u_def_perms, _u_account_disabled,\n"
"_u_home, _u_full_name, _u_e_mail);\n"
"\n"
"}\n"
"\n"
"if (\'\' <> (_del := get_keyword (\'DEL2\', params, \'\')) and get_keyword (\'proceed\', params) = \'Delete\')\n"
"{\n"
"_del := atoi(_del);\n"
"\n"
"delete from WS.WS.SYS_DAV_USER where U_ID = _del;\n"
"}\n"
"}\n"
"--src admin.sql:1058\n"
;

static const char *proc32 = 
"#line 1129 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_dav_u_group_options (in grp varchar)\n"
"{\n"
"\n"
"http(\'<option value=\"** NONE **\">** NONE **</option>\');\n"
"\n"
"for (select G_NAME, G_ID from WS.WS.SYS_DAV_GROUP) do\n"
"{\n"
"http (sprintf (\'<option value=\"%d\" %s>%s</option>\', G_ID, select_if (G_ID, grp), G_NAME));\n"
"}\n"
"}\n"
"--src admin.sql:1127\n"
;

static const char *proc33 = 
"#line 1143 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_dav_res_error_msg (in _res integer)\n"
"{\n"
"if (-1 = _res)\n"
"{\n"
"return (\'<tr><td></td><td class=\"errormsg\">*** Both type and extension are required, please re-try</td></tr>\');\n"
"}\n"
"if (-2 = _res)\n"
"{\n"
"return (\'<tr><td></td><td class=\"errormsg\">*** The resource type/extension combination you tried to is already defined. Nothing done.</td></tr>\');\n"
"}\n"
"return (\' \');\n"
"}\n"
"--src admin.sql:1141\n"
;

static const char *proc34 = 
"#line 1158 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_dav_res_types_action (in params varchar)\n"
"{\n"
"declare _t_type, _t_ext, _t_description varchar;\n"
"declare _del varchar;\n"
"declare _action varchar;\n"
"\n"
"if (\'\' <> (_action := get_keyword (\'add\', params, \'\')))\n"
"{\n"
"\n"
"_t_type := get_keyword (\'t_type\', params, \'\');\n"
"_t_ext := get_keyword (\'t_ext\', params, \'\');\n"
"_t_description := get_keyword (\'t_description\', params, \'\');\n"
"\n"
"if (\'\' = _t_type or \'\' = _t_ext)\n"
"return -1;\n"
"\n"
"if (_action <> \'Accept\' and exists (select 1 from WS.WS.SYS_DAV_RES_TYPES\n"
"where T_TYPE = lcase(_t_type) and T_EXT = _t_ext))\n"
"return -2;\n"
"\n"
"insert replacing WS.WS.SYS_DAV_RES_TYPES (T_TYPE, T_EXT, T_DESCRIPTION)\n"
"values (_t_type, _t_ext, _t_description);\n"
"\n"
"}\n"
"\n"
"if (\'\' <> (_del := get_keyword (\'DEL\', params, \'\')))\n"
"{\n"
"delete from WS.WS.SYS_DAV_RES_TYPES where concat(T_TYPE, T_EXT) = _del;\n"
"}\n"
"}\n"
"--src admin.sql:1156\n"
;

static const char *proc35 = 
"#line 1191 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lt_make_dsn_part (in dsn varchar)\n"
"{\n"
"declare inx, c integer;\n"
"dsn := ucase (dsn);\n"
"inx :=0;\n"
"while (inx < length (dsn)) {\n"
"c := aref (dsn, inx);\n"
"if (not ((c >= aref (\'A\', 0) and c <= aref (\'Z\', 0))\n"
"or (c >= aref (\'0\', 0) and c <= aref (\'9\', 0)) ))\n"
"aset (dsn, inx, aref (\'_\', 0));\n"
"inx := inx + 1;\n"
"}\n"
"return dsn;\n"
"}\n"
"--src admin.sql:1189\n"
;

static const char *proc36 = 
"#line 1221 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_next_keyword (in keyw varchar, inout params varchar, inout spos integer)\n"
"{\n"
"declare pos integer;\n"
"declare len integer;\n"
"\n"
"pos := position (keyw, params, spos, 2);\n"
"\n"
"if (pos)\n"
"{\n"
"spos := pos + 2;\n"
"return (aref (params, pos));\n"
"}\n"
"\n"
"return 0;\n"
"}\n"
"--src admin.sql:1219\n"
;

static const char *proc37 = 
"#line 1242 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_next_checkbox (in keyw varchar, inout params varchar, inout spos integer)\n"
"{\n"
"declare pos integer;\n"
"declare len integer;\n"
"declare klen integer;\n"
"declare s varchar;\n"
"\n"
"len := length (params);\n"
"klen := length (keyw);\n"
"\n"
"while (spos < len)\n"
"{\n"
"s := aref (params, spos);\n"
"if (keyw = \"LEFT\" (s, klen) and\n"
"\'on\' = lcase (coalesce (aref (params, spos + 1),\'\')))\n"
"{\n"
"spos := spos + 2;\n"
"return \"RIGHT\" (s, length (s) - klen);\n"
"}\n"
"spos := spos + 2;\n"
"}\n"
"}\n"
"--src admin.sql:1240\n"
;

static const char *proc38 = 
"#line 1270 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lt_init (inout params any, out step any, out dsn varchar, out _user varchar,\n"
"out pass varchar, out prev_sel varchar, inout two_views varchar, inout keys any,\n"
"inout keys_v any, inout keys_s any, inout tables any, inout views any, inout sys_tables any)\n"
"{\n"
"\n"
"declare state, msg, m_dta, res, dsns varchar;\n"
"declare len, check_all, pos, idx, num integer;\n"
"declare temp, _ch_key, _ch_key_s any;\n"
"\n"
"step := get_keyword (\'step\', params, \'\');\n"
"prev_sel := get_keyword (\'prev_sel\', params, \'\');\n"
"dsn := get_keyword (\'dsn\', params, \'\');\n"
"_user := get_keyword (\'user\', params, \'\');\n"
"pass := get_keyword (\'pass\', params, \'\');\n"
"dsns := get_keyword (\'dsns\', params, \'\');\n"
"two_views := get_keyword (\'two_views\', params, \'00\');\n"
"_ch_key :=  deserialize (decode_base64 (get_keyword (\'ch_key\', params, \'\')));\n"
"_ch_key_s :=  deserialize (decode_base64 (get_keyword (\'ch_key_s\', params, \'\')));\n"
"\n"
"if (\'3\' <> step)\n"
"{\n"
"keys := \'\';\n"
"keys_v := \'\';\n"
"keys_s := \'\';\n"
"}\n"
"\n"
"len := length (params);\n"
"\n"
"if (\'3\' = step)\n"
"{\n"
"if (\'\' <> get_keyword (\'link\', params, \'\'))\n"
"{\n"
"adm_link_table (dsn, params, keys, _ch_key, \'T\');\n"
"adm_link_view (dsn, params, keys_v);\n"
"adm_link_table (dsn, params, keys_s, _ch_key_s, \'S\');\n"
"step := 5;\n"
"}\n"
"}\n"
"\n"
"if (\'2\' = step and (\'\' = get_keyword (\'select_all\', params, \'\')))\n"
"{\n"
"\n"
"idx := 0;\n"
"pos := 0;\n"
"num := 0;\n"
"\n"
"temp := tables;\n"
"while (pos := adm_next_checkbox (\'TBL_T\', params, idx))\n"
"{\n"
"aset (temp, num, aref (tables, atoi (pos)));\n"
"num := num + 1;\n"
"}\n"
"tables := make_array (num, \'any\');\n"
"\n"
"idx := 0;\n"
"while (idx < num)\n"
"{\n"
"aset (tables, idx, aref (temp, idx));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"\n"
"idx := 0;\n"
"pos := 0;\n"
"num := 0;\n"
"temp := make_array (length (views), \'any\');\n"
"\n"
"while (pos := adm_next_checkbox (\'TBL_V\', params, idx))\n"
"{\n"
"aset (temp, num, aref (views, atoi (pos)));\n"
"num := num + 1;\n"
"}\n"
"views := make_array (num, \'any\');\n"
"\n"
"idx := 0;\n"
"while (idx < num)\n"
"{\n"
"aset (views, idx, aref (temp, idx));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"\n"
"idx := 0;\n"
"pos := 0;\n"
"num := 0;\n"
"temp := make_array (length (sys_tables), \'any\');\n"
"\n"
"while (pos := adm_next_checkbox (\'TBL_S\', params, idx))\n"
"{\n"
"aset (temp, num, aref (sys_tables, atoi (pos)));\n"
"num := num + 1;\n"
"}\n"
"sys_tables := make_array (num, \'any\');\n"
"\n"
"idx := 0;\n"
"while (idx < num)\n"
"{\n"
"aset (sys_tables, idx, aref (temp, idx));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"step := \'3\';\n"
"}\n"
"\n"
"if (\'\' <> get_keyword (\'unlink\', params, \'\'))\n"
"{\n"
"adm_unlink_table (params);\n"
"}\n"
"\n"
"if (\'\' <> get_keyword (\'login\', params, \'\'))\n"
"{\n"
"two_views := \'00\';\n"
"if (\'\' <> get_keyword (\'login_2\', params, \'\'))\n"
"aset (two_views, 0, ascii (\'1\'));\n"
"if (\'\' <> get_keyword (\'login_3\', params, \'\'))\n"
"aset (two_views, 1, ascii (\'1\'));\n"
"if (\'\' <> dsns)\n"
"{\n"
"dsn := dsns;\n"
"}\n"
"\n"
"if (\'\' <> dsn)\n"
"{\n"
"state := \'00000\';\n"
"msg := \'none\';\n"
"exec (\'vd_remote_data_source(?,?,?,?)\',\n"
"state, msg, vector (dsn, \'\', _user, pass), m_dta, res);\n"
"\n"
"if (\'00000\' = state)\n"
"{\n"
"step := \'2\';\n"
"if (sys_stat (\'vdb_attach_autocommit\') > 0) vd_autocommit (dsn, 1);\n"
"tables := sql_tables (dsn, NULL, NULL, NULL, \'TABLE\');\n"
"views  := sql_tables (dsn, NULL, NULL, NULL, \'VIEW\');\n"
"sys_tables := sql_tables (dsn, NULL, NULL, NULL, \'SYSTEM TABLE\');\n"
"\n"
"return (0);\n"
"}\n"
"else\n"
"{\n"
"step := \'\';\n"
"http (\'<TABLE CLASS=\"genlist\" BORDER=\"0\" CELLPADDING=\"0\">\');\n"
"http (sprintf (\'<TR><TD CLASS=\"errorhead\" COLSPAN=\"2\">Connection to %s failed:</TD></TR>\', dsn));\n"
"http (\'<TR><TD CLASS=\"AdmBorders\" COLSPAN=\"2\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\');\n"
"http (sprintf (\'<TR><TD CLASS=\"genlisthead\">SQL State</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (state, \'\')));\n"
"http (sprintf (\'<TR><TD CLASS=\"genlisthead\">Error Message</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (msg, \'\')));\n"
"http (\'</TABLE>\');\n"
"}\n"
"}\n"
"}\n"
"\n"
"if (\'\' <> dsns)\n"
"{\n"
"if (exists (select 1 from DB.DBA.SYS_DATA_SOURCE where DS_DSN = dsns))\n"
"{\n"
"select DS_UID, pwd_magic_calc (DS_UID, DS_PWD, 1) into _user, pass from DB.DBA.SYS_DATA_SOURCE\n"
"where DS_DSN = dsns;\n"
"}\n"
"else\n"
"{\n"
"declare arri, elm any;\n"
"declare fnd, ix, ln integer;\n"
"\n"
"arri := sql_get_private_profile_string (dsns, \'user\');\n"
"if (length (arri) < 1)\n"
"arri := sql_get_private_profile_string (dsns, \'system\');\n"
"fnd := 0;\n"
"ix := 0; ln := length (arri);\n"
"while (ix < ln)\n"
"{\n"
"elm := arri [ix];\n"
"if (lower (elm[0]) = \'username\' or lower (elm[0]) = \'userid\' or lower (elm[0]) = \'lastuser\')\n"
"{\n"
"_user := elm [1];\n"
"ix := ln;\n"
"fnd := 1;\n"
"}\n"
"ix := ix + 1;\n"
"}\n"
"\n"
"if (not fnd)\n"
"_user := \'\';\n"
"pass := \'\';\n"
"}\n"
"}\n"
"}\n"
"--src admin.sql:1268\n"
;

static const char *proc39 = 
"#line 1461 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lt_rt_options ()\n"
"{\n"
"declare cnt integer;\n"
"for (select RT_NAME from DB.DBA.SYS_REMOTE_TABLE) do\n"
"{\n"
"cnt := cnt + 1;\n"
"http (sprintf (\'<option>%s</option>\', RT_NAME));\n"
"}\n"
"if (0 = cnt)\n"
"{\n"
"http (\'<option>-No External Tables Linked-</option>\');\n"
"}\n"
"}\n"
"--src admin.sql:1459\n"
;

static const char *proc40 = 
"#line 1478 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lt_dsn_options (in dsn varchar)\n"
"{\n"
"declare dsns, f_dsns any;\n"
"declare len, len_f, idx integer;\n"
"\n"
"dsns := sql_data_sources(1);\n"
"\n"
"idx := 0;\n"
"len := length (dsns);\n"
"len_f := 0;\n"
"\n"
"if (sys_stat(\'st_build_opsys_id\') = \'Win32\')\n"
"{\n"
"f_dsns := adm_get_file_dsn ();\n"
"len_f := length (f_dsns);\n"
"}\n"
"\n"
"if (len = 0 and len_f = 0)\n"
"{\n"
"http(\'<option value=NONE>No pre-defined DSNs</option>\');\n"
"}\n"
"else\n"
"{\n"
"while (idx < len)\n"
"{\n"
"http (sprintf (\'<option value=\"%s\" %s>%s</option>\' ,\n"
"aref (aref (dsns, idx), 0),\n"
"select_if (aref (aref (dsns, idx), 0), dsn),\n"
"aref (aref ( dsns, idx), 0) ));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"if (sys_stat(\'st_build_opsys_id\') = \'Win32\' and len_f > 0)\n"
"{\n"
"idx := 0;\n"
"while (idx < len_f)\n"
"{\n"
"http (sprintf (\'<option value=\"%s\" %s>%s</option>\' ,\n"
"aref (f_dsns, idx), select_if (aref (f_dsns, idx), dsn),\n"
"aref (f_dsns, idx)));\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"--src admin.sql:1476\n"
;

static const char *proc41 = 
"#line 1528 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_do_unlink (in tbl varchar)\n"
"{\n"
"declare _m_dta, _res varchar;\n"
"declare state, msg, state1, msg1 varchar;\n"
"\n"
"state := \'00000\';\n"
"state1 := \'00000\';\n"
"\n"
"commit work;\n"
"\n"
"exec (sprintf (\'drop table \"%s\".\"%s\".\"%s\"\', name_part (tbl, 0, \'DB\'),\n"
"name_part (tbl, 1, \'DBA\'),\n"
"name_part (tbl, 2, null)),\n"
"state, msg,\n"
"vector (), _m_dta, _res);\n"
"exec (\'commit work\', state1, msg1);\n"
"\n"
"if (\'00000\' <> state)\n"
"{\n"
"http (\'<TABLE CLASS=\"genlist\" BORDER=\"0\" CELLPADDING=\"0\">\');\n"
"http (sprintf (\'<TR><TD CLASS=\"errorhead\" COLSPAN=\"2\">Unlinking %V failed:</TD></TR>\', tbl));\n"
"http (\'<TR><TD CLASS=\"AdmBorders\" COLSPAN=\"2\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\');\n"
"http (sprintf (\'<TR><TD CLASS=\"genlisthead\">SQL State</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (state, \'\')));\n"
"http (sprintf (\'<TR><TD CLASS=\"genlisthead\">Error Message</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (msg, \'\')));\n"
"if (\'00000\' <> state1)\n"
"{\n"
"http(sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn SQL State</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(state1, \'\')));\n"
"http(sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn Error Message</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(msg1, \'\')));\n"
"}\n"
"http (\'</TABLE>\');\n"
"}\n"
"}\n"
"--src admin.sql:1526\n"
;

static const char *proc42 = 
"#line 1564 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_unlink_table (inout params any)\n"
"{\n"
"declare _idx integer;\n"
"declare _len integer;\n"
"declare _tbl any;\n"
"\n"
"_idx := 0;\n"
"\n"
"_len := length (params);\n"
"\n"
"if (2 > _len)\n"
"return (0);\n"
"\n"
"while (_tbl := adm_next_keyword (\'remote_tbls\', params, _idx))\n"
"{\n"
"adm_do_unlink (_tbl);\n"
"}\n"
"}\n"
"--src admin.sql:1562\n"
;

static const char *proc43 = 
"#line 1586 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_link_table (in dsn varchar, inout params varchar, in keys any, in _ch_key any, in _type varchar)\n"
"{\n"
"declare _rname, _dbqual, _dbuser, _dbtbl, _rname_temp varchar;\n"
"declare tblname, tbln varchar;\n"
"declare state1, msg1, state, msg varchar;\n"
"declare idx, pos integer;\n"
"declare tbl_key any;\n"
"\n"
"idx := 0;\n"
"\n"
"while (pos := adm_next_checkbox (concat (\'TBL_\', _type), params, idx))\n"
"{\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (_rname := get_keyword (concat (\'R_NAME_\', _type, pos), params, \'\')))\n"
"{\n"
"return (0);\n"
"}\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (_dbqual := get_keyword (concat (\'dbqual_\', _type, pos), params, \'\')))\n"
"{\n"
"return (0);\n"
"}\n"
"\n"
"_dbuser := get_keyword (concat (\'dbuser_\', _type, pos), params, adm_lt_make_dsn_part (dsn));\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (_dbtbl := get_keyword (concat (\'TBL_NAME_\', _type, pos), params, \'\')))\n"
"{\n"
"return (0);\n"
"}\n"
"\n"
"_rname_temp :=  deserialize (decode_base64 (_rname));\n"
"\n"
"if (length (_rname_temp) = 2)\n"
"_rname := concat (replace (aref (_rname_temp, 0), \'.\', \'\\x0A\'), \'.\',\n"
"replace (aref (_rname_temp, 1), \'.\', \'\\0A\'));\n"
"else\n"
"_rname := replace (aref (_rname_temp, 0), \'.\', \'\\x0A\');\n"
"\n"
"tbl_key := aref (keys, atof (pos));\n"
"If ((tbl_key = \'Add\') or (aref (tbl_key,0) = \'Add\'))\n"
"tbl_key := NULL;\n"
"\n"
"If (not (aref (_ch_key, atof (pos)) = \'1\'))\n"
"tbl_key := NULL;\n"
"\n"
"tblname := concat (_dbqual, \'.\', _dbuser, \'.\', _dbtbl);\n"
"state := \'00000\';\n"
"msg := \'none\';\n"
"state1 := \'00000\';\n"
"msg1 := \'none\';\n"
"\n"
"if (exists (select 1 from DB.DBA.SYS_REMOTE_TABLE where RT_REMOTE_NAME = _rname and RT_DSN = dsn))\n"
"{\n"
"http (\'<TABLE CLASS=\"genlist\" BORDER=\"0\" CELLPADDING=\"0\">\');\n"
"http(sprintf(\'<TR><TD CLASS=\"genlisthead\">Table</TD><TD CLASS=\"gendata\">%V</TD></TR>\', _rname));\n"
"http(sprintf(\'<TR><TD CLASS=\"genlisthead\">&nbsp</TD><TD CLASS=\"gendata\">Already linked</TD></TR>\'));\n"
"http (\'</TABLE>\');\n"
"}\n"
"\n"
"if (not exists (select RT_NAME from DB.DBA.SYS_REMOTE_TABLE where RT_NAME = tblname))\n"
"{\n"
"exec (\'DB.DBA.vd_attach_view (?, ?, ?, ?, ?, ?, 1)\', state, msg,\n"
"vector (dsn, _rname, tblname, NULL, NULL, tbl_key), 0, NULL, NULL);\n"
"exec (\'commit work\', state1, msg1);\n"
"}\n"
"\n"
"\n"
"if (\'00000\' <> state)\n"
"{\n"
"rollback work;\n"
"http (\'<TABLE CLASS=\"genlist\" BORDER=\"0\" CELLPADDING=\"0\">\');\n"
"http (sprintf (\'<TR><TD CLASS=\"errorhead\" COLSPAN=\"2\">Connection to %s failed:</TD></TR>\', dsn));\n"
"http (\'<TR><TD CLASS=\"AdmBorders\" COLSPAN=\"2\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\');\n"
"http (sprintf (\'<TR><TD CLASS=\"genlisthead\">External Table</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce (_rname, \'\')));\n"
"http (sprintf (\'<TR><TD CLASS=\"genlisthead\">Local Table</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce (tblname, \'\')));\n"
"http (sprintf (\'<TR><TD CLASS=\"genlisthead\">SQL State</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (state, \'\')));\n"
"http (sprintf (\'<TR><TD CLASS=\"genlisthead\">Error Message</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (msg, \'\')));\n"
"\n"
"if (\'00000\' <> state1)\n"
"{\n"
"http(sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn SQL State</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(state1, \'\')));\n"
"http(sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn Error Message</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(msg1, \'\')));\n"
"}\n"
"http (\'</TABLE>\');\n"
"}\n"
"\n"
"}\n"
"}\n"
"--src admin.sql:1584\n"
;

static const char *proc44 = 
"#line 1686 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lt_wiz_link_tables (in tablelist varchar, in dsn varchar, in town varchar, in tqual varchar)\n"
"{\n"
"declare cnt integer;\n"
"declare rtbl_vec any;\n"
"declare rname, lname varchar;\n"
"declare state, msg varchar;\n"
"\n"
"rtbl_vec := split_and_decode (tablelist, 0, \'^^^\');\n"
"\n"
"cnt := 0;\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (rtbl_vec))\n"
"return -1;\n"
"\n"
"while (cnt < length (rtbl_vec))\n"
"{\n"
"rname := aref (rtbl_vec, cnt);\n"
"lname := concat (town, \'.\', tqual, \'.\', adm_unqualify (rname));\n"
"cnt := cnt + 1;\n"
"\n"
"state := \'00000\';\n"
"exec (\'DB.DBA.vd_attach_table (?, ?, ?, ?, ?)\', state, msg,\n"
"vector (dsn, rname, lname, NULL, NULL), 0, NULL, NULL);\n"
"if (\'00000\' <> state)\n"
"{\n"
"rollback work;\n"
"http (\'<tr><td align=\"CENTER\">\');\n"
"http (\'<a href=\"\" onclick=\"alert(\'\'Link failed, reason:\\\\n\');\n"
"http (concat (msg, \'\\\\nSQLState: \', state, \'\\\\n\'\'); return false;\">\'));\n"
"http (concat (\'<img src=\"/images/cross.gif\" border=\"0\" alt=\"\', msg, \'\"></a></td>\'));\n"
"http (concat (\'<td><font size=\"2\">\', rname,\n"
"\'</font></td><td><font size=\"2\">\', lname, \'</font></td></tr>\'));\n"
"}\n"
"else\n"
"{\n"
"http (\'<tr><td align=\"CENTER\">\');\n"
"http (\'<img src=\"/images/tick.gif\" border=\"0\" alt=\"SUCCESS\"></td>\');\n"
"http (concat (\'<td><font size=\"2\">\', rname,\n"
"\'</font></td><td><font size=\"2\">\', lname, \'</font></td></tr>\'));\n"
"commit work;\n"
"}\n"
"}\n"
"}\n"
"--src admin.sql:1684\n"
;

static const char *proc45 = 
"#line 1733 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_new_menu_tree ()\n"
"{\n"
"return\n"
"vector (\n"
"vector (\'Runtime Hosting\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'Loaded Modules\', \'Hosted_Modules.vspx\', \'\', \'C\', vector ()),\n"
"vector (\'Import Files\', \'/admin/Hosted_Modules_load.vspx\', \'\', \'C\', vector ()),\n"
"vector (\'Load Modules\', \'/admin/Hosted_Modules_select.vspx\', \'\', \'C\', vector()),\n"
"vector (\'Modules Grant\'\'s\', \'/admin/hosted_modules_grants.vsp\', \'\', \'C\', vector())\n"
")\n"
"),\n"
"vector (\'Web Services\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'Import Targets\', \'/admin/admin_dav/admin_vfs_site.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Import Queues\', \'/admin/admin_dav/admin_vfs_queue.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Retrieved sites\', \'/admin/admin_dav/admin_vfs_urls.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Export\', \'/admin/admin_dav/admin_vfs_export_main.vsp\', \'\', \'C\', vector()),\n"
"vector (\'Access control\', \'/admin/admin_dav/adm_acl_main.vsp\', \'\', \'C\', vector()),\n"
"vector (\'Import WSDL\', \'/admin/admin_dav/adm_wsdl_gen.vsp\', \'\', \'C\', vector())\n"
")\n"
"),\n"
"vector (\'WebDAV\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'User Accounts\', \'/admin/admin_dav/admin_dav_users.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Resource Types\', \'/admin/admin_dav/admin_dav_res_types.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Content Management\', \'/admin/admin_dav/admin_dav_documents.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Free Text\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'Indexing Mode\', \'/admin/admin_dav/admin_dav_ftext_upd.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Search\', \'/admin/admin_dav/admin_dav_document_search.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Trigger Queries\', \'/admin/admin_dav/ftt_query.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Trigger Results\', \'/admin/admin_dav/ftt_hits.vsp\', \'\', \'C\', vector ())\n"
")\n"
")\n"
")\n"
"),\n"
"vector (\'Internet Domains\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'HTTP Virtual Directories\', \'/admin/admin_dav/admin_virt_dir.vsp\', \'\', \'C\', vector ())\n"
")\n"
"),\n"
"vector (\'XML Services\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'SQL->XML Translation\', \'/admin/admin_dav/admin_dav_xslt.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'XPATH Search\', \'/admin/admin_dav/admin_dav_document_search.vsp?qtype=XPATH\', \'\', \'C\', vector ())\n"
")\n"
"),\n"
"vector (\'Query Tools\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'Relational Data using SQL\', \'/admin/admin_isql_main.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'XQuery\', \'/admin/admin_xquery_main.vsp\', \'\', \'C\', vector ())\n"
")\n"
"),\n"
"vector (\'Replication & Synchronization\', \'\', \'\', \'C\',\n"
"either (sys_stat (\'fe_replication_support\'),\n"
"vector (\n"
"vector (\'Snapshot Replication\', \'/admin/admin_repl/admin_repl_main.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Bidirectional Snapshot Replication\', \'/admin/admin_repl/snp_bidir.vsp\', \'\', \'C\', vector()),\n"
"vector (\'Transactional Replication\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'Publications\', \'/admin/admin_trx_repl/trx_repl_pub.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Subscriptions\', \'/admin/admin_trx_repl/trx_sub.vsp\', \'\', \'C\', vector ())\n"
")\n"
")\n"
"),\n"
"vector (\n"
"vector (\'Snapshot Replication\', \'/admin/admin_repl/admin_repl_main.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Bidirectional Snapshot Replication\', \'/admin/admin_repl/snp_bidir.vsp\', \'\', \'C\', vector())\n"
")\n"
")\n"
"),\n"
"vector (\'Database\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'Users & Group Accounts\', \'/admin/admin_users.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Startup Parameters\', \'/admin/admin_virtini.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Databases\', \'\', \'\', \'C\', adm_make_qual_menus ()),\n"
"vector (\'External Databases\', \'\', \'\', \'C\',\n"
"vector (\n"
"\n"
"vector (\'Connected Data Sources\', \'/admin/admin_conn_ds.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Configure Data Sources\', \'/admin/admin_dsn.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'External Tables\', \'/admin/admin_link_tables.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'External Procedures\', \'/admin/admin_link_proc.vsp\', \'\', \'C\', vector ())\n"
")\n"
"),\n"
"vector (\'Event Scheduler\', \'/admin/admin_evt_main.vsp\', \'\', \'C\', vector ()),\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"vector (\'Statistics\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'General\', \'/admin/admin_stat.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Disk\', \'/admin/admin_stat_disk.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Index\', \'/admin/admin_stat_idx.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Lock\', \'/admin/admin_stat_lock.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Space\', \'/admin/admin_stat_space.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'HTTP\', \'/admin/admin_stat_www.vsp\', \'\', \'C\', vector ()),\n"
"\n"
"vector (\'Profiling\', \'/admin/admin_stat_prof.vsp\', \'\', \'C\', vector())\n"
")\n"
")\n"
")\n"
"),\n"
"vector (\'Mail\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'Message Composition\', \'../mime/mime_compose.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'Messages\', \'../mime/mime_plain.vsp\', \'\', \'C\', vector ()),\n"
"\n"
"vector (\'Get Mail with POP3\', \'../mime/pop3_get.vsp\', \'\', \'C\', vector ())\n"
"\n"
")\n"
"),\n"
"vector (\'News\', \'\', \'\', \'C\',\n"
"vector (\n"
"vector (\'NNTP Servers\', \'/admin/admin_news/news_server_list.vsp\', \'\', \'C\', vector ()),\n"
"vector (\'NNTP Access Control List\', \'/admin/admin_dav/adm_http_acl.vsp?edit=NEWS&hide_main=1\', \'\', \'C\', vector ()),\n"
"vector (\'News Text Search\', \'/admin/admin_news/news_search.vsp\', \'\', \'C\', vector ())\n"
")\n"
")\n"
");\n"
"}\n"
"--src admin.sql:1731\n"
;

static const char *proc46 = 
"#line 1872 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lm_update_ses (in sesid varchar, inout tree varchar)\n"
"{\n"
"\n"
"update ADMIN_SESSION set ASES_TREE = serialize (tree)\n"
"where ASES_ID = sesid;\n"
"}\n"
"--src admin.sql:1870\n"
;

static const char *proc47 = 
"#line 1884 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_left_menu_init (inout params any, inout sesid varchar)\n"
"{\n"
"declare nodenum any;\n"
"declare tree any;\n"
"declare curr_node integer;\n"
"\n"
"sesid := get_keyword (\'sid\', params, \'\');\n"
"\n"
"if (\'\' = sesid)\n"
"{\n"
"sesid := adm_new_session (adm_new_menu_tree());\n"
"}\n"
"\n"
"if (0 = (tree := adm_get_tree (sesid)))\n"
"{\n"
"tree := adm_new_menu_tree ();\n"
"sesid := adm_new_session (tree);\n"
"}\n"
"\n"
"nodenum := get_keyword (\'t\', params, \'\');\n"
"\n"
"\n"
"if (\'\' <> nodenum)\n"
"{\n"
"nodenum := atoi (nodenum);\n"
"curr_node := 0;\n"
"adm_lm_toggle (tree, nodenum, curr_node, 1);\n"
"adm_lm_update_ses (sesid, tree);\n"
"}\n"
"return (tree);\n"
"}\n"
"--src admin.sql:1882\n"
;

static const char *proc48 = 
"#line 1921 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_make_qual_menus ()\n"
"{\n"
"declare qual_dta any;\n"
"declare param varchar;\n"
"\n"
"qual_dta := vector ();\n"
"\n"
"for select distinct name_part (KEY_TABLE, 0, \'DB\') as qual from DB.DBA.SYS_KEYS\n"
"union\n"
"select distinct name_part (P_NAME, 0, \'DB\') as qual from DB.DBA.SYS_PROCEDURES\n"
"union\n"
"select distinct name_part (UT_NAME, 0, \'DB\') as qual from DB.DBA.SYS_USER_TYPES\n"
"do\n"
"{\n"
"param := concat (\'q=\', qual);\n"
"qual_dta :=\n"
"vector_concat (qual_dta,\n"
"vector (vector (qual, \'\', \'\', \'C\',\n"
"vector (vector (\'Tables\', \'admin_tables.vsp\', param, \'C\', vector ()),\n"
"vector (\'Views\', \'admin_views.vsp\', param, \'C\', vector ()),\n"
"vector (\'Stored Procedures\', \'admin_procs.vsp\', param, \'C\', vector ()),\n"
"vector (\'User Defined Types\', \'admin_user_types.vsp\', param, \'C\', vector ())\n"
"))));\n"
"}\n"
"return (qual_dta);\n"
"}\n"
"--src admin.sql:1919\n"
;

static const char *proc49 = 
"#line 1951 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lm_toggle (inout tree any, in nodenum integer, inout curr_node integer, in vis integer)\n"
"{\n"
"declare inx integer;\n"
"declare len integer;\n"
"declare node any;\n"
"\n"
"len := 0;\n"
"\n"
"len := length (tree);\n"
"\n"
"while (inx < len)\n"
"{\n"
"aset (tree, inx, adm_lm_toggle_node (aref (tree, inx), nodenum, curr_node, vis));\n"
"inx := inx + 1;\n"
"}\n"
"return tree;\n"
"}\n"
"--src admin.sql:1949\n"
;

static const char *proc50 = 
"#line 1974 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lm_toggle_node (in node any, in nodenum integer, inout curr_node integer, in vis integer)\n"
"{\n"
"\n"
"declare ret_node any;\n"
"\n"
"if (vis)\n"
"{\n"
"curr_node := curr_node + 1;\n"
"\n"
"if (curr_node = nodenum)\n"
"{\n"
"if (\'C\' = aref (node, 3))\n"
"{\n"
"aset (node, 3, \'O\');\n"
"}\n"
"else\n"
"{\n"
"aset (node, 3, \'C\');\n"
"}\n"
"}\n"
"}\n"
"if (0 < length (aref (node, 4)))\n"
"{\n"
"if (\'C\' = aref(node, 3))\n"
"vis := 0;\n"
"aset (node, 4, adm_lm_toggle (aref (node, 4), nodenum, curr_node, vis));\n"
"}\n"
"\n"
"return node;\n"
"}\n"
"--src admin.sql:1972\n"
;

static const char *proc51 = 
"#line 2008 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_table_pad (in d integer)\n"
"{\n"
"while (d > 0)\n"
"{\n"
"http(\'<td></td>\');\n"
"d := d - 1;\n"
"}\n"
"}\n"
"--src admin.sql:2006\n"
;

static const char *proc52 = 
"#line 2020 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lm_show_node (inout node any, in  nodenum integer, inout sesid varchar)\n"
"{\n"
"\n"
"declare url, target, parm  varchar;\n"
"declare pad varchar;\n"
"declare i integer;\n"
"\n"
"url := aref(node, 1);\n"
"if (\'\' = url)\n"
"{\n"
"url := \'admin_left.vsp\';\n"
"target := \'left\';\n"
"}\n"
"else\n"
"{\n"
"target := \'main\';\n"
"}\n"
"\n"
"parm := aref(node, 2);\n"
"\n"
"declare __delim varchar;\n"
"__delim := \'?\';\n"
"if (isstring (url))\n"
"{\n"
"if (strchr (url, \'?\') > 0)\n"
"__delim := \'&\';\n"
"}\n"
"if (\'\' = parm)\n"
"{\n"
"parm := sprintf(\'%st=%d&sid=%s\', __delim, nodenum, sesid);\n"
"}\n"
"else\n"
"{\n"
"parm := sprintf(\'%s%s&t=%d&sid=%s\', __delim, parm, nodenum, sesid);\n"
"}\n"
"\n"
"if (0 < length(aref(node, 4)))\n"
"{\n"
"if (\'O\' = aref(node, 3))\n"
"{\n"
"http (sprintf (\'<td class=\"lmenubranch\"><a class=\"lmenuminus\" href=\"%s%s\" target=\"%s\"><img src=\"images/minus.gif\" border=\"0\" align=\"left\"></a></td><td><a class=\"lmenuitem\" href=\"%s%s\" target=\"%s\">%s</a></td>\\n\',\n"
"url, parm, target, url, parm, target, aref (node, 0)));\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<td class=\"lmenubranch\"><a class=\"lmenuplus\" href=\"%s%s\" target=\"%s\"><img src=\"images/plus.gif\" border=\"0\" align=\"left\"></a></td><td><a class=\"lmenuitem\" href=\"%s%s\" target=\"%s\">%s</a></td>\\n\',\n"
"url, parm, target, url, parm, target, aref (node, 0)));\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<td class=\"lmenuleaf\"><img src=\"images/1x1.gif\" WIDTH=\"11\" border=\"0\" align=\"left\"></td><td><a class=\"lmenuitem\" href=\"%s%s\" target=\"%s\">%s</a></td>\\n\',\n"
"url, parm, target, aref (node, 0)));\n"
"}\n"
"}\n"
"--src admin.sql:2018\n"
;

static const char *proc53 = 
"#line 2081 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lm_show_tree (inout tree any, inout cnt integer, inout sesid varchar)\n"
"{\n"
"declare inx integer;\n"
"declare len integer;\n"
"\n"
"len := 0;\n"
"\n"
"len := length (tree);\n"
"\n"
"http(\'<TABLE BORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"1\">\\n\');\n"
"\n"
"while (inx < len)\n"
"{\n"
"adm_lm_show_tree_node (aref (tree, inx), cnt, sesid);\n"
"inx := inx + 1;\n"
"}\n"
"\n"
"http(\'</table>\\n\');\n"
"}\n"
"--src admin.sql:2079\n"
;

static const char *proc54 = 
"#line 2105 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lm_show_tree_node (inout node any, inout cnt integer, inout sesid any)\n"
"{\n"
"cnt := cnt + 1;\n"
"http(\'<tr>\\n\');\n"
"adm_lm_show_node (node, cnt, sesid);\n"
"http(\'</tr>\\n\');\n"
"if (0 < length (aref (node, 4)) and \'O\' = aref (node, 3))\n"
"{\n"
"http(\'<tr><td></td><td>\\n\');\n"
"adm_lm_show_tree (aref (node, 4), cnt, sesid);\n"
"http(\'</td></tr>\\n\');\n"
"}\n"
"}\n"
"--src admin.sql:2103\n"
;

static const char *proc55 = 
"#line 2123 \"[executable]/admin.sql\"\n"
"create procedure\n"
"dbg_dump_menu_tree (inout tree any, in depth integer, inout cnt integer)\n"
"{\n"
"declare inx integer;\n"
"declare len integer;\n"
"\n"
"len := 0;\n"
"\n"
"len := length (tree);\n"
"\n"
"while (inx < len)\n"
"{\n"
"dbg_dump_node (aref (tree, inx), depth, cnt);\n"
"inx := inx + 1;\n"
"}\n"
"}\n"
"--src admin.sql:2121\n"
;

static const char *proc56 = 
"#line 2142 \"[executable]/admin.sql\"\n"
"create procedure\n"
"dbg_dump_node (inout node any, in depth integer, inout cnt integer)\n"
"{\n"
"cnt := cnt + 1;\n"
"\n"
"dbg_printf (\'%s %s, url=%s?%s, %d\',\n"
"space (depth * 4), aref (node, 0),\n"
"aref (node, 1), aref (node, 2), aref (node, 3));\n"
"\n"
"if (0 < length (aref (node, 4)))\n"
"{\n"
"dbg_dump_menu_tree (aref (node, 4), depth + 1, cnt);\n"
"}\n"
"return 1;\n"
"}\n"
"--src admin.sql:2140\n"
;

static const char *proc57 = 
"#line 2161 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_tbls_list (in qual varchar, in TabShCol varchar, in TabShColOwn varchar := \'\')\n"
"{\n"
"\n"
"declare len integer;\n"
"declare n_trigs integer;\n"
"\n"
"len := 0;\n"
"\n"
"for (select distinct KEY_TABLE as tblname\n"
"from DB.DBA.SYS_KEYS where name_part (KEY_TABLE, 0) = qual and\n"
"not exists (select 1 from DB.DBA.SYS_VIEWS where V_NAME = KEY_TABLE)\n"
"order by concat (name_part (KEY_TABLE, 1, \'DBA\'), \'.\', name_part (KEY_TABLE, 2))) do\n"
"{\n"
"len := len + 1;\n"
"if (exists (select 1 from DB.DBA.SYS_TRIGGERS where T_TABLE = tblname))\n"
"{\n"
"select count(*) into n_trigs from DB.DBA.SYS_TRIGGERS\n"
"where T_TABLE = tblname;\n"
"\n"
"http (sprintf (\'<tr><td CLASS=\"gendata\"><input type=\"checkbox\" name=\"CB_%s\"></td><td CLASS=\"gendata\"><A NAME=\"%s\"></A><A HREF=\"admin_tables.vsp?tab=%s&q=%s&own=%s#%s\">%s.%s</A></td><td CLASS=\"gendata\"><a class=\"tablelistaction\" href=\"admin_triggers.vsp?tbl=%s\">Triggers (%d)</a></td></tr>\\n\',\n"
"tblname, name_part (tblname, 2), name_part (tblname, 2), qual, name_part (tblname, 1), name_part (tblname, 2), name_part (tblname, 1), name_part (tblname, 2), tblname, n_trigs));\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<tr><td CLASS=\"gendata\"><input type=\"checkbox\" name=\"CB_%s\"></td><td CLASS=\"gendata\"><A NAME=\"%s\"></A><A HREF=\"admin_tables.vsp?tab=%s&q=%s&own=%s#%s\">%s.%s</A></td><td CLASS=\"gendata\"><a class=\"tablelistaction\" href=\"admin_triggers.vsp?tbl=%s\">Triggers</a></td></tr>\\n\',\n"
"tblname, name_part (tblname, 2), name_part (tblname, 2), qual, name_part (tblname, 1), name_part (tblname, 2), name_part (tblname, 1), name_part (tblname, 2), tblname));\n"
"}\n"
"if (TabShCol = name_part (tblname, 2) and TabShColOwn <> \'\' and TabShColOwn = name_part (tblname, 1))\n"
"{  http(\'<TR><TD COLSPAN=\"3\"><TABLE WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\"><TR><TD CLASS=\"AdmBorders\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR></TABLE></TD></TR><tr><td colspan=\"3\">\\n\');\n"
"adm_sql_columns(sprintf(\'%s.%s.%s\',qual, name_part (tblname, 1), TabShCol));\n"
"http(\'</td></tr><TR><TD COLSPAN=\"3\"><TABLE WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\"><TR><TD CLASS=\"AdmBorders\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR></TABLE></TD></TR>\\n\');\n"
"}\n"
"}\n"
"if (0 = len)\n"
"{\n"
"http (sprintf (\'<tr><td colspan=\"3\" CLASS=\"gendata\">No tables defined for %s, odd...</td></tr>\', qual));\n"
"}\n"
"}\n"
"--src admin.sql:2159\n"
;

static const char *proc58 = 
"#line 2205 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_tbls_list_drop (in params any, inout _all varchar)\n"
"{\n"
"declare idx integer;\n"
"declare tblname any;\n"
"idx := 0;\n"
"\n"
"while (tblname := adm_next_checkbox (\'CB_\', params, idx))\n"
"{\n"
"http (sprintf (\'<tr><td CLASS=\"gendata\">%s<input type=\"hidden\" name=\"tbls\" value=\"%s\"></td></tr>\',\n"
"tblname, tblname));\n"
"if (_all = \'\')\n"
"_all := tblname;\n"
"else\n"
"_all := concat (_all, \', \', tblname);\n"
"}\n"
"}\n"
"--src admin.sql:2203\n"
;

static const char *proc59 = 
"#line 2227 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_tbls_action (in params any)\n"
"{\n"
"declare tblname any;\n"
"declare idx integer;\n"
"declare state, trx_state, msg, trx_msg varchar;\n"
"declare ret_msg varchar;\n"
"\n"
"idx := 0;\n"
"ret_msg := \'\';\n"
"\n"
"if (\'Drop\' = get_keyword (\'proceed\', params))\n"
"{\n"
"while (tblname := adm_next_keyword (\'tbls\', params, idx))\n"
"{\n"
"declare state1, msg1 varchar;\n"
"state := \'00000\';\n"
"msg := \'\';\n"
"state1 := \'00000\';\n"
"msg1 := \'\';\n"
"commit work;\n"
"exec (sprintf (\'drop table \"%I\"\', tblname), state, msg,\n"
"NULL, 0, NULL, NULL);\n"
"exec (\'commit work\', state1, msg1);\n"
"\n"
"if (\'00000\' <> state)\n"
"{\n"
"ret_msg := concat (ret_msg, \'<TABLE CLASS=\"genlist\" BORDER=\"0\" CELLPADDING=\"0\">\');\n"
"ret_msg := concat (ret_msg, sprintf (\'<TR><TD CLASS=\"errorhead\" COLSPAN=\"2\">Dropping Table %V failed</TD></TR>\', tblname));\n"
"ret_msg := concat (ret_msg,\n"
"sprintf (\'<TR><TD CLASS=\"genlisthead\">SQL State</TD><TD CLASS=\"gendata\">%V</TD></TR>\', state),\n"
"sprintf (\'<TR><TD CLASS=\"genlisthead\">Error Message</TD><TD CLASS=\"gendata\">%V</TD></TR>\', msg));\n"
"}\n"
"if (state1 <> \'00000\')\n"
"{\n"
"ret_msg := concat (ret_msg,\n"
"sprintf (\'<TR><TD CLASS=\"genlisthead\">Txn SQL State</TD><TD CLASS=\"gendata\">%V</TD></TR>\', state1),\n"
"sprintf (\'<TR><TD CLASS=\"genlisthead\">Txn Error Message</TD><TD CLASS=\"gendata\">%V</TD></TR>\', msg1));\n"
"}\n"
"if (state <> \'00000\')\n"
"{\n"
"ret_msg := concat (ret_msg, \'</TABLE>\');\n"
"}\n"
"}\n"
"}\n"
"return ret_msg;\n"
"}\n"
"--src admin.sql:2225\n"
;

static const char *proc60 = 
"#line 2277 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_trigs_list (in tbl varchar, in q varchar)\n"
"{\n"
"\n"
"declare idx integer;\n"
"declare t_txt varchar;\n"
"\n"
"for (select T_NAME as _t_name, T_TEXT, T_MORE\n"
"from DB.DBA.SYS_TRIGGERS where T_TABLE = tbl) do\n"
"{\n"
"t_txt := coalesce (coalesce (T_TEXT, blob_to_string(T_MORE)), \'\');\n"
"if (idx := strchr(t_txt, \'\\n\'))\n"
"{\n"
"t_txt := \"LEFT\" (t_txt, idx);\n"
"}\n"
"else\n"
"{\n"
"t_txt := \"LEFT\" (t_txt, 35);\n"
"}\n"
"http (sprintf (\'<tr><td CLASS=\"gendata\">%s</td><td CLASS=\"gendesc\">%s</td><td CLASS=\"geninput\"><input type=\"checkbox\" name=\"CB_%s\"></td><td CLASS=\"gendata\"><a class=\"tablelistaction\" href=\"admin_triggers_edit.vsp?trg=%s&q=%s&tbl=%s\">Edit</a></td>\', _t_name, t_txt, _t_name, _t_name, q, tbl));\n"
"}\n"
"}\n"
"--src admin.sql:2275\n"
;

static const char *proc61 = 
"#line 2304 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_trigs_list_drop (in params any, inout _all varchar)\n"
"{\n"
"declare idx integer;\n"
"declare tblname any;\n"
"idx := 0;\n"
"\n"
"while (tblname := adm_next_checkbox (\'CB_\', params, idx))\n"
"{\n"
"http (sprintf (\'<tr><td CLASS=\"gendata\">%s<input type=\"hidden\" name=\"trigs\" value=\"%s\"></td></tr>\',\n"
"tblname, tblname));\n"
"if (_all = \'\')\n"
"_all := tblname;\n"
"else\n"
"_all := concat (_all, \', \', tblname);\n"
"}\n"
"}\n"
"--src admin.sql:2302\n"
;

static const char *proc62 = 
"#line 2324 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_trigs_action (in params any, inout _state varchar, inout _msg varchar)\n"
"{\n"
"declare tblname any;\n"
"declare idx integer;\n"
"declare _stmt varchar;\n"
"declare trgname varchar;\n"
"declare qual varchar;\n"
"\n"
"idx := 0;\n"
"\n"
"if (\'Drop\' = get_keyword (\'proceed\', params))\n"
"{\n"
"qual := get_keyword (\'tbl\', params, \'\');\n"
"while (tblname := adm_next_keyword (\'trigs\', params, idx))\n"
"{\n"
"_stmt := sprintf (\'drop trigger \"%I\".\"%I\".\"%I\"\', name_part (qual, 0), name_part (qual, 1, name_part(tblname,1)), name_part (tblname, 2));\n"
"if (-1 = adm_exec_stmt (_stmt))\n"
"{\n"
"return -1;\n"
"}\n"
"}\n"
"}\n"
"if (\'Save\' = get_keyword (\'save\', params))\n"
"{\n"
"declare old_cnt varchar;\n"
"old_cnt := \'\';\n"
"if ((\'\' <> trgname := get_keyword (\'trg\', params)) and\n"
"(\'\' <> _stmt := get_keyword (\'stmt\', params,\'\')))\n"
"{\n"
"\n"
"qual := get_keyword (\'tbl\', params, \'\');\n"
"if (exists (select 1 from DB.DBA.SYS_TRIGGERS where T_NAME = trgname))\n"
"{\n"
"old_cnt := coalesce ((select coalesce(T_TEXT, blob_to_string(T_MORE)) from DB.DBA.SYS_TRIGGERS\n"
"where T_TABLE = qual and T_NAME = trgname), \'\');\n"
"adm_exec_stmt (sprintf (\'drop trigger \"%I\".\"%I\".\"%I\"\', name_part (qual, 0), name_part (qual, 1,name_part (trgname, 1)), name_part (trgname, 2)));\n"
"}\n"
"}\n"
"if (\'\' <> _stmt := get_keyword (\'stmt\', params,\'\'))\n"
"{\n"
"declare trgname_last any;\n"
"trgname_last := name_part (trgname, 2);\n"
"if (trgname_last <> 0)\n"
"{\n"
"_stmt := concat (\'create trigger \"\', name_part (trgname, 2), \'\" \', _stmt);\n"
"_state := \'00000\'; _msg := \'\';\n"
"set_qualifier (name_part (qual, 0));\n"
"exec (_stmt, _state, _msg, vector(), 0, NULL, NULL);\n"
"set_qualifier (\'DB\');\n"
"}\n"
"else\n"
"{\n"
"_msg := \'The trigger name is empty.\';\n"
"return -2;\n"
"}\n"
"if (_state <> \'00000\')\n"
"{\n"
"set_qualifier (name_part (qual, 0));\n"
"DB.DBA.adm_exec_stmt (old_cnt);\n"
"set_qualifier (\'DB\');\n"
"return -2;\n"
"}\n"
"}\n"
"}\n"
"}\n"
"--src admin.sql:2322\n"
;

static const char *proc63 = 
"#line 2392 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_get_trg_body (in t_text varchar)\n"
"{\n"
"declare b_start integer;\n"
"declare idx, i integer;\n"
"declare c_stmt, nam varchar;\n"
"declare arr any;\n"
"\n"
"arr := sql_lex_analyze (t_text);\n"
"\n"
"i := 0; nam := null;\n"
"foreach (any x in arr) do\n"
"{\n"
"if (lower(x[1]) in (\'create\',\'trigger\') and i < 2)\n"
"{\n"
"i := i + 1;\n"
"}\n"
"else if (i = 2)\n"
"{\n"
"nam := x[1];\n"
"goto end_loop;\n"
"}\n"
"}\n"
"end_loop:;\n"
"\n"
"if (nam is not null)\n"
"{\n"
"b_start := strstr (t_text, nam) + length (nam);\n"
"return \"RIGHT\" (t_text, length (t_text) - b_start);\n"
"}\n"
"}\n"
"--src admin.sql:2390\n"
;

static const char *proc64 = 
"#line 2426 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_views_list (in qual varchar)\n"
"{\n"
"declare cnt integer;\n"
"\n"
"cnt := 0;\n"
"for (select V_NAME from DB.DBA.SYS_VIEWS where name_part (V_NAME, 0) = qual) do\n"
"{\n"
"cnt := cnt + 1;\n"
"http (sprintf(\'<tr><td CLASS=\"gendata\"><input type=\"checkbox\" name=\"CB_%s\"></td><td CLASS=\"gendata\">%s.%s</td><td CLASS=\"gendata\"><a class=\"tablelistaction\" href=\"admin_views_edit.vsp?vw=%s&q=%s\">Edit</a></td></TR>\',\n"
"V_NAME, name_part (V_NAME, 1), name_part (V_NAME, 2), V_NAME, qual));\n"
"}\n"
"if (0 = cnt)\n"
"{\n"
"http (sprintf (\'<tr><td colspan=\"3\" CLASS=\"gendata\">There are currently no views defined for %s</td></tr>\', qual));\n"
"}\n"
"}\n"
"--src admin.sql:2424\n"
;

static const char *proc65 = 
"#line 2446 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_views_list_drop (in params any, inout _all varchar)\n"
"{\n"
"declare idx integer;\n"
"declare vwname any;\n"
"idx := 0;\n"
"\n"
"while (vwname := adm_next_checkbox (\'CB_\', params, idx))\n"
"{\n"
"http (sprintf (\'<tr><td CLASS=\"gendata\">%s<input type=\"hidden\" name=\"views\" value=\"%s\"></td></tr>\',\n"
"vwname, vwname));\n"
"if (_all = \'\')\n"
"_all := vwname;\n"
"else\n"
"_all := concat (_all, \', \', vwname);\n"
"}\n"
"}\n"
"--src admin.sql:2444\n"
;

static const char *proc66 = 
"#line 2466 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_views_action (in params any)\n"
"{\n"
"declare vwname any;\n"
"declare idx integer;\n"
"declare _stmt varchar;\n"
"declare vw_cols varchar;\n"
"declare _qual varchar;\n"
"declare err_ret varchar;\n"
"declare old_view_text varchar;\n"
"\n"
"idx := 0;\n"
"err_ret := \'\';\n"
"\n"
"if (\'Drop\' = get_keyword (\'proceed\', params))\n"
"{\n"
"while (vwname := adm_next_keyword (\'views\', params, idx))\n"
"{\n"
"declare state, state1, msg, msg1 varchar;\n"
"state := \'00000\';\n"
"state1 := \'00000\';\n"
"if (exists (select 1 from DB.DBA.SYS_PROCEDURES where P_NAME = concat (\'DB.DBA.http_view_\', vwname)))\n"
"exec (sprintf (\'drop xml view \"%I\"\', vwname), state, msg);\n"
"else\n"
"exec (sprintf (\'drop view \"%I\"\', vwname), state, msg);\n"
"exec (\'commit work\', state1, msg1);\n"
"if (state <> \'00000\')\n"
"{\n"
"err_ret := concat (err_ret, \'<TABLE CLASS=\"genlist\" BORDER=\"0\" CELLPADDING=\"0\">\');\n"
"err_ret := concat (err_ret, sprintf (\'<TR><TD CLASS=\"errorhead\" COLSPAN=\"2\">Dropping view %V failed:</TD></TR>\', vwname));\n"
"err_ret := concat (err_ret, \'<TR><TD CLASS=\"AdmBorders\" COLSPAN=\"2\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\');\n"
"err_ret := concat (err_ret, sprintf (\'<TR><TD CLASS=\"genlisthead\">SQL State</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (state, \'\')));\n"
"err_ret := concat (err_ret, sprintf (\'<TR><TD CLASS=\"genlisthead\">Error Message</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (msg, \'\')));\n"
"if (\'00000\' <> state1)\n"
"{\n"
"err_ret := concat (err_ret, sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn SQL State</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(state1, \'\')));\n"
"err_ret := concat (err_ret, sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn Error Message</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(msg1, \'\')));\n"
"}\n"
"}\n"
"}\n"
"return err_ret;\n"
"}\n"
"\n"
"if (\'Save\' = get_keyword (\'save\', params) and \'\' = get_keyword (\'xml_view\', params, \'\'))\n"
"{\n"
"if ((\'\' <> vwname := get_keyword (\'vw\', params)) and\n"
"(\'\' <> _stmt := get_keyword (\'stmt\', params,\'\')))\n"
"{\n"
"vw_cols := get_keyword (\'vw_cols\', params);\n"
"old_view_text := NULL;\n"
"select coalesce (V_TEXT, blob_to_string (V_EXT)) into old_view_text from SYS_VIEWS where V_NAME = vwname;\n"
"if (old_view_text is not null)\n"
"{\n"
"declare state, state1, msg, msg1 varchar;\n"
"state := \'00000\';\n"
"state1 := \'00000\';\n"
"exec (sprintf (\'drop view \"%I\"\', vwname), state, msg);\n"
"exec (\'commit work\', state1, msg1);\n"
"if (state <> \'00000\')\n"
"{\n"
"err_ret := concat (err_ret, \'<TABLE CLASS=\"genlist\" BORDER=\"0\" CELLPADDING=\"0\">\');\n"
"err_ret := concat (err_ret, sprintf (\'<TR><TD CLASS=\"errorhead\" COLSPAN=\"2\">Dropping view %V failed:</TD></TR>\', vwname));\n"
"err_ret := concat (err_ret, \'<TR><TD CLASS=\"AdmBorders\" COLSPAN=\"2\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\');\n"
"err_ret := concat (err_ret, sprintf (\'<TR><TD CLASS=\"genlisthead\">SQL State</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (state, \'\')));\n"
"err_ret := concat (err_ret, sprintf (\'<TR><TD CLASS=\"genlisthead\">Error Message</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (msg, \'\')));\n"
"if (\'00000\' <> state1)\n"
"{\n"
"err_ret := concat (err_ret, sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn SQL State</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(state1, \'\')));\n"
"err_ret := concat (err_ret, sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn Error Message</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(msg1, \'\')));\n"
"}\n"
"}\n"
"}\n"
"}\n"
"if (\'\' <> _stmt := get_keyword (\'stmt\', params,\'\'))\n"
"{\n"
"\n"
"declare state, state1, msg, msg1 varchar;\n"
"state := \'00000\';\n"
"state1 := \'00000\';\n"
"if (\'\' <> vw_cols := get_keyword (\'vw_cols\', params, \'\'))\n"
"exec (sprintf (\'create view %s (%s) as %s\', vwname, vw_cols, _stmt), state, msg);\n"
"else\n"
"exec (sprintf (\'create view %s as %s\', vwname, _stmt), state, msg);\n"
"exec (\'commit work\', state1, msg1);\n"
"if (state <> \'00000\')\n"
"{\n"
"err_ret := concat (err_ret, \'<TABLE CLASS=\"genlist\" BORDER=\"0\" CELLPADDING=\"0\">\');\n"
"err_ret := concat (err_ret, sprintf (\'<TR><TD CLASS=\"errorhead\" COLSPAN=\"2\">Creating view %V failed:</TD></TR>\', vwname));\n"
"err_ret := concat (err_ret, \'<TR><TD CLASS=\"AdmBorders\" COLSPAN=\"2\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\');\n"
"err_ret := concat (err_ret, sprintf (\'<TR><TD CLASS=\"genlisthead\">SQL State</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (state, \'\')));\n"
"err_ret := concat (err_ret, sprintf (\'<TR><TD CLASS=\"genlisthead\">Error Message</TD><TD CLASS=\"gendata\">%s</TD></TR>\', coalesce (msg, \'\')));\n"
"if (\'00000\' <> state1)\n"
"{\n"
"err_ret := concat (err_ret, sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn SQL State</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(state1, \'\')));\n"
"err_ret := concat (err_ret, sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn Error Message</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(msg1, \'\')));\n"
"}\n"
"adm_exec_stmt (old_view_text);\n"
"}\n"
"}\n"
"}\n"
"return err_ret;\n"
"}\n"
"--src admin.sql:2464\n"
;

static const char *proc67 = 
"#line 2573 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_exec_stmt (inout _stmt varchar)\n"
"{\n"
"declare state, msg varchar;\n"
"\n"
"state := \'00000\';\n"
"msg := \'\';\n"
"exec (_stmt, state, msg, NULL, 0, NULL, NULL);\n"
"if (\'00000\' <> state)\n"
"{\n"
"return -1;\n"
"}\n"
"}\n"
"--src admin.sql:2571\n"
;

static const char *proc68 = 
"#line 2591 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_next_word (in str varchar, inout pos integer)\n"
"{\n"
"declare idx integer;\n"
"declare start integer;\n"
"declare len integer;\n"
"declare r_str varchar;\n"
"\n"
"len := length (str);\n"
"start := skip_lwsp (str, pos, len);\n"
"r_str := \"RIGHT\" (str, len - start);\n"
"\n"
"pos := start + strchr (\"RIGHT\" (str, len - start), aref (\' \', 0));\n"
"if (pos is null)\n"
"{\n"
"return \'\';\n"
"}\n"
"return subseq (str, start, pos);\n"
"}\n"
"--src admin.sql:2589\n"
;

static const char *proc69 = 
"#line 2615 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_get_view_body (in v_text varchar)\n"
"{\n"
"declare b_start integer;\n"
"declare idx integer;\n"
"declare c_stmt varchar;\n"
"declare n_words, s_len integer;\n"
"\n"
"n_words := 4;\n"
"while (idx < n_words)\n"
"{\n"
"if (\'\' = (c_stmt := lcase (adm_next_word (v_text, b_start))))\n"
"{\n"
"return -1;\n"
"}\n"
"else\n"
"{\n"
"idx := idx + 1;\n"
"if (substring (lower (c_stmt), 1, 3) = \'xml\' and idx = 2)\n"
"n_words := 5;\n"
"}\n"
"}\n"
"c_stmt := lcase (c_stmt);\n"
"idx := length (c_stmt) - 1;\n"
"s_len := idx;\n"
"if (idx > 1)\n"
"{\n"
"while (idx > 1)\n"
"{\n"
"if (aref (c_stmt, idx) = ascii (\'\\r\') or aref (c_stmt, idx) = ascii (\'\\n\'))\n"
"c_stmt := substring (c_stmt, 1, idx);\n"
"idx := idx - 1;\n"
"}\n"
"b_start := b_start - s_len + idx;\n"
"}\n"
"if (\'as\' = c_stmt)\n"
"{\n"
"return \"RIGHT\" (v_text, length (v_text) - b_start);\n"
"}\n"
"else\n"
"return -1;\n"
"}\n"
"--src admin.sql:2613\n"
;

static const char *proc70 = 
"#line 2661 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_proc_list (in q varchar)\n"
"{\n"
"\n"
"declare len integer;\n"
"declare cnt integer;\n"
"\n"
"cnt := 0;\n"
"\n"
"\n"
"for (select P_NAME, \"LEFT\"(coalesce (P_TEXT, blob_to_string (P_MORE), \'empty\\n\'), 150) as text\n"
"from DB.DBA.SYS_PROCEDURES where name_part (P_NAME, 0) = q) do\n"
"{\n"
"cnt := cnt + 1;\n"
"http (sprintf (\'<tr><td CLASS=\"gendata\"><input type=\"checkbox\" name=\"CB_%s\"></td><td CLASS=\"gendata\">%s</td><td CLASS=\"gendesc\">\', P_NAME, P_NAME));\n"
"http_value(text);\n"
"http(sprintf(\'...</td><td CLASS=\"gendata\"><a class=\"tablelistaction\" href=\"admin_proc_edit.vsp?proc=%s&q=%s\">Edit</a>&nbsp;<a class=\"tablelistaction\" href=\"admin_proc_view.vsp?proc=%s&q=%s\">props.</a></td></tr>\', P_NAME, q, P_NAME, q));\n"
"}\n"
"if (0 = cnt)\n"
"{\n"
"http (sprintf (\'<tr><td colspan=\"4\" CLASS=\"gendata\">There are currently no stored procedures for %s</td></tr>\', q));\n"
"}\n"
"}\n"
"--src admin.sql:2659\n"
;

static const char *proc71 = 
"#line 2687 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_proc_list_drop (in params any, inout _all varchar)\n"
"{\n"
"declare idx integer;\n"
"declare proc any;\n"
"idx := 0;\n"
"\n"
"while (proc := adm_next_checkbox (\'CB_\', params, idx))\n"
"{\n"
"http (sprintf (\'<tr><td CLASS=\"gendata\">%s<input type=\"hidden\" name=\"procs\" value=\"%s\"></td></tr>\',\n"
"proc, proc));\n"
"if (_all = \'\')\n"
"_all := proc;\n"
"else\n"
"_all := concat (_all, \', \', proc);\n"
"}\n"
"}\n"
"--src admin.sql:2685\n"
;

static const char *proc72 = 
"#line 2707 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_proc_action (in params any, inout _state varchar, inout _msg varchar)\n"
"{\n"
"declare _stmt varchar;\n"
"declare proc any;\n"
"declare idx integer;\n"
"\n"
"idx := 0;\n"
"\n"
"if (\'Drop\' = get_keyword (\'proceed\', params))\n"
"{\n"
"while (proc := adm_next_keyword (\'procs\', params, idx))\n"
"{\n"
"declare _p_type integer;\n"
"\n"
"if (exists (select 1 from SYS_PROCEDURES where P_NAME = proc))\n"
"select P_TYPE into _p_type from SYS_PROCEDURES where P_NAME = proc;\n"
"\n"
"if (_p_type = 3)\n"
"_stmt := sprintf (\'drop module \"%s\"\', proc);\n"
"else\n"
"_stmt := sprintf (\'drop procedure \"%s\"\', proc);\n"
"\n"
"if (-1 = adm_exec_stmt (_stmt))\n"
"{\n"
"return -1;\n"
"}\n"
"}\n"
"}\n"
"if (\'Save\' = get_keyword (\'save\', params) and (\'\' <> _stmt := get_keyword (\'stmt\', params,\'\')))\n"
"{\n"
"declare _retr integer;\n"
"_retr := 1;\n"
"again:\n"
"_state := \'00000\';\n"
"_stmt := replace (_stmt, \'\\r\', \'\');\n"
"proc := get_keyword (\'proc\', params);\n"
"set_qualifier (name_part (proc, 0));\n"
"exec (_stmt, _state, _msg, vector(), 0, NULL, NULL);\n"
"set_qualifier (\'DB\');\n"
"if (\'37000\' = _state and \"LEFT\" (_msg, 5) = \'SQ140\' and _retr)\n"
"{\n"
"proc := get_keyword (\'proc\', params);\n"
"exec (concat (\'drop module \', proc), _state, _msg);\n"
"_retr := 0;\n"
"goto again;\n"
"}\n"
"if (\'00000\' <> _state)\n"
"{\n"
"return -2;\n"
"}\n"
"}\n"
"return 0;\n"
"}\n"
"--src admin.sql:2705\n"
;

static const char *proc73 = 
"#line 2764 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_e_string (inout xe any)\n"
"{\n"
"declare st any;\n"
"st := string_output ();\n"
"http_value (xe, NULL, st);\n"
"return (string_output_string (st));\n"
"}\n"
"--src admin.sql:2762\n"
;

static const char *proc74 = 
"#line 2775 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_sql_columns(in table_name varchar)\n"
"{\n"
"http(sprintf(\'<TABLE CLASS=\"genlist\"><TR><TD COLSPAN=\"5\" CLASS=\"genlistheadt\">Columns for %s</TD></TR>\\n\', coalesce(table_name,\'Table name not supplied\')));\n"
"http(\'<TR><TD CLASS=\"genlistheadt\">Column Name</TD><TD CLASS=\"genlistheadt\">Data Type</TD><TD CLASS=\"genlistheadt\">Precision</TD><TD CLASS=\"genlistheadt\">Scale</TD><TD CLASS=\"genlistheadt\">Nullable</TD></TR>\\n\');\n"
"for (\n"
"SELECT c.\"COLUMN\" as \"COLUMN\", c.\"COL_DTP\" as \"COL_DTP\", c.\"COL_PREC\" as \"COL_PREC\",\n"
"c.\"COL_SCALE\" as \"COL_SCALE\", c.\"COL_NULLABLE\" as \"COL_NULLABLE\"\n"
"from  DB.DBA.SYS_KEYS k, DB.DBA.SYS_KEY_PARTS kp, \"SYS_COLS\" c\n"
"where\n"
"name_part (k.KEY_TABLE, 0) =  name_part (table_name, 0) and\n"
"name_part (k.KEY_TABLE, 1) =  name_part (table_name, 1) and\n"
"name_part (k.KEY_TABLE, 2) =  name_part (table_name, 2)\n"
"and __any_grants (k.KEY_TABLE)\n"
"and c.\"COLUMN\" <> \'_IDN\'\n"
"and k.KEY_IS_MAIN = 1\n"
"and k.KEY_MIGRATE_TO is null\n"
"and kp.KP_KEY_ID = k.KEY_ID\n"
"and c.COL_ID = kp.KP_COL\n"
"order by kp.KP_COL) do\n"
"{\n"
"http(\'<TR>\');\n"
"http(sprintf(\'<TD CLASS=\"gendata\">%s</TD>\', coalesce(\"COLUMN\",\'Null\')));\n"
"http(sprintf(\'<TD CLASS=\"gendata\">%s</TD>\', coalesce(dv_type_title(COL_DTP),\'Null\')));\n"
"http(sprintf(\'<TD CLASS=\"gendata\">%d</TD>\', coalesce(COL_PREC,0)));\n"
"http(sprintf(\'<TD CLASS=\"gendata\">%d</TD>\', coalesce(COL_SCALE,0)));\n"
"http(sprintf(\'<TD CLASS=\"gendata\">%s</TD>\', either(COL_NULLABLE-1,\'Yes\', \'No\')));\n"
"http(\'</TR>\\n\');\n"
"}\n"
"http(\'</TABLE>\');\n"
"}\n"
"--src admin.sql:2773\n"
;

static const char *proc75 = 
"#line 2809 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_tell_unauth (in lines any)\n"
"{\n"
"declare _user, auth varchar;\n"
"auth := vsp_auth_vec (lines);\n"
"\n"
"_user := get_keyword (\'username\', auth, \'\');\n"
"http_request_status (\'HTTP/1.1 401 Unauthorized\');\n"
"http ( sprintf(\'<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\">\\n<HTML><HEAD><TITLE>401 Unauthorized</TITLE></HEAD>\\n<BODY><H1>Unauthorized</H1>\\n<P>User: %s - Access to page is forbidden.</P></BODY></HTML>\', coalesce(_user, \'unspecified\')));\n"
"}\n"
"--src admin.sql:2807\n"
;

static const char *proc76 = 
"#line 2821 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lt_table_r (in dsn varchar, in params varchar, inout len_dsn integer, inout two_views varchar,\n"
"inout keys any, in step varchar, in user_ varchar, in pass varchar, inout keys_v any,\n"
"inout keys_s any, inout tables any, in views any, in sys_tables any, inout _ch_key any,\n"
"inout _ch_key_s any, inout _dt integer)\n"
"{\n"
"declare temp any;\n"
"\n"
"len_dsn := 3;\n"
"adm_lt_table_draw (dsn, params, len_dsn, \'TABLE\', keys, two_views, step, user_, pass,\n"
"keys_v, tables, _ch_key, _dt);\n"
"\n"
"if (\'\' <> get_keyword (\'login_2\', params, \'\') or (chr (aref (two_views, 0)) = \'1\'))\n"
"adm_lt_table_draw (dsn, params, len_dsn, \'VIEW\', keys, two_views, step, user_, pass, keys_v, views, temp, _dt);\n"
"else\n"
"len_dsn := len_dsn - 1;\n"
"\n"
"if (\'\' <> get_keyword (\'login_3\', params, \'\') or (chr (aref (two_views, 1)) = \'1\'))\n"
"adm_lt_table_draw (dsn, params, len_dsn, \'SYSTEM TABLE\', keys_s, two_views, step, user_,\n"
"pass, keys_s, sys_tables, _ch_key_s, _dt);\n"
"else\n"
"len_dsn := len_dsn - 1;\n"
"\n"
"}\n"
"--src admin.sql:2819\n"
;

static const char *proc77 = 
"#line 2847 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lt_getRPKeys (in dsn varchar, in tbl_qual varchar, in tbl_user varchar, in tbl_name varchar)\n"
"{\n"
"declare pkeys, pkey_curr, pkey_col, my_pkeys any;\n"
"declare pkeys_len, idx integer;\n"
"\n"
"if (length (tbl_qual) = 0)\n"
"tbl_qual := NULL;\n"
"if (length (tbl_user) = 0)\n"
"tbl_user := NULL;\n"
"\n"
"if (sys_stat (\'vdb_attach_autocommit\') > 0) vd_autocommit (dsn, 1);\n"
"{\n"
"declare exit handler for SQLSTATE \'*\'\n"
"goto next;\n"
"\n"
"pkeys := sql_primary_keys (dsn, tbl_qual, tbl_user, tbl_name);\n"
"};\n"
"next:\n"
"\n"
"if (not pkeys) pkeys := NULL;\n"
"\n"
"pkeys_len := length (pkeys);\n"
"idx := 0;\n"
"my_pkeys := vector();\n"
"if (0 <> pkeys_len)\n"
"{\n"
"while (idx < pkeys_len)\n"
"{\n"
"pkey_curr := aref (pkeys, idx);\n"
"pkey_col := aref (pkey_curr, 3);\n"
"my_pkeys := vector_concat (my_pkeys, vector(pkey_col));\n"
"idx := idx +1;\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (sys_stat (\'vdb_attach_autocommit\') > 0) vd_autocommit (dsn, 1);\n"
"{\n"
"declare exit handler for SQLSTATE \'*\'\n"
"goto next2;\n"
"\n"
"pkeys := sql_statistics (dsn, tbl_qual, tbl_user, tbl_name, 0, 1);\n"
"};\n"
"next2:\n"
"\n"
"if (not pkeys) pkeys := NULL;\n"
"\n"
"pkeys_len := length (pkeys);\n"
"\n"
"if (0 <> pkeys_len)\n"
"{\n"
"while (idx < pkeys_len)\n"
"{\n"
"pkey_curr := aref (pkeys, idx);\n"
"pkey_col := aref (pkey_curr, 8);\n"
"if (idx > 0 and aref (pkey_curr, 7) = 1 and length (my_pkeys) > 0)\n"
"goto key_ends;\n"
"if (pkey_col is not null)\n"
"my_pkeys := vector_concat (my_pkeys, vector(pkey_col));\n"
"idx := idx +1;\n"
"}\n"
"key_ends:;\n"
"}\n"
"else\n"
"{\n"
"pkeys := NULL;\n"
"pkeys_len := 0;\n"
"}\n"
"}\n"
"\n"
"if (0 = length (my_pkeys))\n"
"return vector(\'Add\');\n"
"else\n"
"return vector(my_pkeys);\n"
"}\n"
"--src admin.sql:2845\n"
;

static const char *proc78 = 
"#line 2926 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_save_state (in _params any)\n"
"{\n"
"declare idx, len integer;\n"
"declare _name, _val varchar;\n"
"\n"
"idx := 0;\n"
"len := length (_params);\n"
"\n"
"while (idx < len)\n"
"{\n"
"_name := _params[idx];\n"
"_val  := _params[idx + 1];\n"
"\n"
"if (isstring (_name))\n"
"{\n"
"if (\"LEFT\" (_name, 7) = \'dbqual_\' or\n"
"\"LEFT\" (_name, 7) = \'dbuser_\' or\n"
"\"LEFT\" (_name, 9) = \'TBL_NAME_\')\n"
"{\n"
"http (sprintf (\'<INPUT type=\"hidden\" name=\"%s\" value=\"%s\">\', _name, _val));\n"
"}\n"
"}\n"
"idx := idx + 2;\n"
"}\n"
"}\n"
"--src admin.sql:2924\n"
;

static const char *proc79 = 
"#line 2955 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_lt_table_draw (in dsn varchar,  in params varchar, inout len_dsn integer, in type varchar,\n"
"inout keys any, in two_views varchar, in step varchar, in user_ varchar,\n"
"in pass varchar, inout keys_v any, in tables any, inout _ch_key any, inout _dt integer)\n"
"{\n"
"declare len, idx integer;\n"
"declare tblv, keys_c, keys_cv, _keys_send any;\n"
"declare tbl_type, tbl_qual, tbl_user, tbl_name, tbl_name_local varchar;\n"
"declare additional, s_t, vec_key, tb_chk varchar;\n"
"declare t_idx, v_idx, s_idx, pass_idx integer;\n"
"declare vec_r_name any;\n"
"\n"
"s_t := \"LEFT\" (type, 1);\n"
"len := length (tables);\n"
"idx := 0;\n"
"t_idx := -1;\n"
"v_idx := -1;\n"
"s_idx := -1;\n"
"\n"
"if (0 = len)\n"
"{\n"
"http (sprintf (\'<TR><TD CLASS=\"genhead\" COLSPAN=\"7\" ALIGN=\"CENTER\" WIDTH=\"300\">NO %VS</TD></TR>\',type));\n"
"http (\'<TR><TD CLASS=\"AdmBorders\" COLSPAN=\"7\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\');\n"
"len_dsn := len_dsn - 1;\n"
"return (0);\n"
"}\n"
"else\n"
"{\n"
"if (s_t = \'T\')\n"
"{\n"
"http (\'<TR><TD CLASS=\"genhead\" COLSPAN=\"7\">External Tables</TD></TR>\');\n"
"}\n"
"else if (s_t = \'S\')\n"
"{\n"
"http (\'<TR><TD CLASS=\"genhead\" COLSPAN=\"7\">External System Tables</TD></TR>\');\n"
"}\n"
"else if (s_t = \'V\')\n"
"{\n"
"http (\'<TR><TD CLASS=\"genhead\" COLSPAN=\"7\">External Views</TD></TR>\');\n"
"}\n"
"\n"
"http (\'<TR><TD CLASS=\"AdmBorders\" COLSPAN=\"7\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\');\n"
"\n"
"if (step <> \'2\')\n"
"{\n"
"http (\'<TR><TH CLASS=\"genlistheadt\">Sel.</TH>\n"
"<TH CLASS=\"genlistheadt\" NOWRAP>External Table Name</TH>\n"
"<TH CLASS=\"genlistheadt\" NOWRAP>Link As</TH>\n"
"<TH CLASS=\"genlistheadt\" NOWRAP>Database</TH>\n"
"<TH CLASS=\"genlistheadt\" NOWRAP>Owner (Schema)</TH>\n"
"<TD CLASS=\"genlistheadt\" NOWRAP>Primary Keys</TD>\n"
"<TD CLASS=\"genlistheadt\" NOWRAP>Action</TD></TR>\');\n"
"}\n"
"else\n"
"{\n"
"http (\'<TR><TH CLASS=\"genlistheadt\">Sel.</TH><TH CLASS=\"genlistheadt\">External Table Name</TH></TR>\');\n"
"}\n"
"}\n"
"\n"
"if ((step <> \'2\') and (DB.DBA.IS_EMPTY_OR_NULL (keys)))\n"
"{\n"
"keys := vector();\n"
"_ch_key := make_array (len, \'any\');\n"
"while (idx < len)\n"
"{\n"
"tblv := aref (tables, idx);\n"
"tbl_type := aref (tblv, 3);   tbl_qual := aref (tblv, 0);\n"
"tbl_user := aref (tblv, 1);   tbl_name := aref (tblv, 2);\n"
"tbl_name_local := replace (tbl_name, \'.\', \'_\');\n"
"if (s_t = \'T\' or s_t = \'S\')\n"
"keys := vector_concat (keys, adm_lt_getRPKeys(dsn, tbl_qual, tbl_user, tbl_name));\n"
"else\n"
"keys := vector_concat (keys, vector ());\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"\n"
"idx := 0;\n"
"while (idx < len)\n"
"{\n"
"declare q1,o1,n1 varchar;\n"
"tblv := aref (tables, idx);\n"
"tbl_type := aref (tblv, 3);   tbl_qual := aref (tblv, 0);\n"
"tbl_user := aref (tblv, 1);   tbl_name := aref (tblv, 2);\n"
"tbl_name_local := replace (tbl_name, \'.\', \'_\');\n"
"additional := tbl_name;\n"
"vec_r_name := vector (tbl_name);\n"
"if (not isnull (tbl_user))\n"
"{\n"
"vec_r_name := vector (tbl_user, additional);\n"
"additional := concat (tbl_user, \'.\', additional);\n"
"}\n"
"else\n"
"tbl_user := \'\';\n"
"\n"
"if (s_t = \'T\')\n"
"t_idx := t_idx + 1;\n"
"else if (s_t = \'S\')\n"
"s_idx := s_idx + 1;\n"
"else\n"
"{\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (keys_v)) keys_v := vector (vector (\'Add\'));\n"
"if (length (keys_v) < len) keys_v := vector_concat (keys_v, vector(\'Add\'));\n"
"v_idx := v_idx + 1;\n"
"}\n"
"if ((\'\' <> get_keyword (\'select_all\', params)) and (s_t = \'T\'))\n"
"{\n"
"http (sprintf (\'<TR><TD><input type=\"checkbox\" name=\"TBL_%V%i\" CHECKED>\', s_t, t_idx));\n"
"}\n"
"else if ((\'\' <> get_keyword (\'select_all\', params)) and (s_t = \'S\'))\n"
"{\n"
"http (sprintf (\'<TR><TD><input type=\"checkbox\" name=\"TBL_%V%i\" CHECKED>\', s_t, s_idx));\n"
"}\n"
"else\n"
"{\n"
"if (s_t = \'V\')\n"
"{\n"
"if ((aref (aref (keys_v, v_idx), 0) = \'Add\') or (aref (keys_v, v_idx) = \'Add\'))\n"
"{\n"
"if ( step = \'3\')\n"
"{\n"
"http (sprintf (\'<TR><TD><input type=\"checkbox\" DISABLED name=\"TBL_%V%i\">\', s_t, v_idx));\n"
"}\n"
"else\n"
"if (\'\' <> get_keyword (\'select_all\', params))\n"
"{\n"
"http (sprintf (\'<TR><TD><input type=\"checkbox\" CHECKED name=\"TBL_%V%i\">\', s_t, v_idx));\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<TR><TD><input type=\"checkbox\" name=\"TBL_%V%i\">\', s_t, v_idx));\n"
"}\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<TR><TD><input type=\"checkbox\" CHECKED name=\"TBL_%V%i\">\', s_t, v_idx));\n"
"}\n"
"}\n"
"else if (s_t = \'T\')\n"
"{\n"
"if (step = \'3\')\n"
"{\n"
"http (sprintf (\'<TR><TD><input type=\"checkbox\" CHECKED name=\"TBL_%s%i\">\', s_t, t_idx));\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<TR><TD><input type=\"checkbox\" name=\"TBL_%s%i\">\', s_t, t_idx));\n"
"}\n"
"}\n"
"else if (s_t = \'S\')\n"
"{\n"
"if (step = \'3\')\n"
"{\n"
"http (sprintf (\'<TR><TD><input type=\"checkbox\" CHECKED name=\"TBL_%s%i\">\', s_t, s_idx));\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<TR><TD><input type=\"checkbox\" name=\"TBL_%s%i\">\', s_t, s_idx));\n"
"}\n"
"}\n"
"}\n"
"\n"
"n1 := tbl_name_local;\n"
"o1 := adm_lt_make_dsn_part (dsn);\n"
"q1 := dbname();\n"
"if (exists (select RT_NAME from SYS_REMOTE_TABLE where RT_DSN = dsn and RT_REMOTE_NAME = additional))\n"
"{\n"
"declare rt_rem_name varchar;\n"
"rt_rem_name := coalesce ((select top 1 RT_NAME from SYS_REMOTE_TABLE where RT_DSN = dsn and RT_REMOTE_NAME = additional), concat (q1, \'.\', o1, \'.\', n1));\n"
"q1 := name_part (rt_rem_name, 0);\n"
"o1 := name_part (rt_rem_name, 1);\n"
"n1 := name_part (rt_rem_name, 2);\n"
"tb_chk := \'*\';\n"
"_dt := _dt + 1;\n"
"}\n"
"else\n"
"tb_chk := \'\';\n"
"\n"
"if (\'V\' = s_t)\n"
"pass_idx := v_idx;\n"
"else if (\'T\' = s_t)\n"
"pass_idx := t_idx;\n"
"else if (\'S\' = s_t)\n"
"pass_idx := s_idx;\n"
"\n"
"vec_r_name := encode_base64 (serialize (vec_r_name));\n"
"\n"
"if (step <> \'2\')\n"
"{\n"
"declare in_n1, in_q1, in_o1 any;\n"
"\n"
"in_n1 := get_keyword (concat(\'TBL_NAME_\', s_t, cast (pass_idx as varchar)), params, NULL);\n"
"in_q1 := get_keyword (concat(\'dbqual_\', s_t, cast (pass_idx as varchar)), params, NULL);\n"
"in_o1 := get_keyword (concat(\'dbuser_\', s_t, cast (pass_idx as varchar)), params, NULL);\n"
"\n"
"if (not isnull (in_n1)) n1 := in_n1;\n"
"if (not isnull (in_q1)) q1 := in_q1;\n"
"if (not isnull (in_o1)) o1 := in_o1;\n"
"\n"
"http (concat (\'</TD>\\n<TD CLASS=\"gendata\">\', additional, tb_chk,\n"
"sprintf (\'<input type=\"hidden\" name=\"R_NAME_%V%i\" value=\"%V\">\', s_t, pass_idx, vec_r_name),\n"
"\'</TD>\\n<TD NOWRAP CLASS=\"geninput\">\',\n"
"sprintf (\'<input type=\"text\" size=\"20\" name=\"TBL_NAME_%V%i\" value=\"%V\">\', s_t, pass_idx, n1),\n"
"\'</TD>\\n<TD CLASS=\"geninput\">\',\n"
"sprintf (\'<input type=\"text\" size=\"10\" name=\"dbqual_%V%i\" value=\"%V\">\', s_t, pass_idx, q1),\n"
"\'</TD>\\n<TD CLASS=\"geninput\">\\n\',\n"
"sprintf (\'<input type=\"text\" size=\"20\" name=\"dbuser_%V%i\" value=\"%V\">\', s_t, pass_idx, o1),\n"
"\'</TD>\\n\'));\n"
"}\n"
"else\n"
"{\n"
"http (concat (\'</TD>\\n<TD CLASS=\"gendata\">\', additional, tb_chk,\n"
"\'</TD>\\n<TD NOWRAP CLASS=\"geninput\">\',\n"
"\'</TD>\\n<TD CLASS=\"geninput\">\',\n"
"\'</TD>\\n<TD CLASS=\"geninput\">\\n\',\n"
"\'</TD>\\n\'));\n"
"}\n"
"\n"
"if (step = \'2\')\n"
"{\n"
"http (\'<TD>\\n</TD></TR>\\n\');\n"
"}\n"
"else\n"
"{\n"
"if (s_t = \'T\')\n"
"{\n"
"vec_key := aref (keys, t_idx);\n"
"_keys_send := encode_base64 (serialize (vec_key));\n"
"vec_key := vector_print (vec_key);\n"
"}\n"
"else if (s_t = \'S\')\n"
"{\n"
"vec_key := aref (keys, s_idx);\n"
"_keys_send := encode_base64 (serialize (vec_key));\n"
"vec_key := vector_print (vec_key);\n"
"}\n"
"else\n"
"{\n"
"vec_key := aref (keys_v, v_idx);\n"
"_keys_send := encode_base64 (serialize (vec_key));\n"
"vec_key := vector_print (vec_key);\n"
"}\n"
"\n"
"http (sprintf (\'<INPUT type=\"hidden\" name=\"se_%s%i\" value=\"%s\">\', s_t, idx, tbl_name));\n"
"http (sprintf (\'<INPUT type=\"hidden\" name=\"key_send_%s%i\" value=\"%s\">\', s_t, idx, _keys_send));\n"
"if (vec_key = \'Add\')\n"
"{\n"
"if (s_t = \'T\')\n"
"{\n"
"http (\'<TD>&nbsp</TD>\\n\');\n"
"http (sprintf (\'<TD ALIGN=\"right\"><INPUT type=\"submit\" name=\"pm_k%s%i\" value=\"Define \"></TD></TR>\\n\', s_t, t_idx));\n"
"}\n"
"else if (s_t = \'S\')\n"
"{\n"
"http (\'<TD>&nbsp</TD>\\n\');\n"
"http (sprintf (\'<TD ALIGN=\"right\"><INPUT type=\"submit\" name=\"pm_k%s%i\" value=\"Define \"></TD></TR>\\n\', s_t, s_idx));\n"
"}\n"
"else\n"
"{\n"
"http (\'<TD>&nbsp</TD>\\n\');\n"
"http (sprintf (\'<TD ALIGN=\"right\"><INPUT type=\"submit\" name=\"pm_k%s%i\" value=\"Define \"></TD></TR>\\n\', s_t, v_idx));\n"
"}\n"
"}\n"
"else\n"
"{\n"
"if (s_t = \'T\')\n"
"{\n"
"if (aref (_ch_key, t_idx) = \'1\')\n"
"{\n"
"http (sprintf (\'<TD CLASS=\"genlisthead\"><I>%s</I></TD>\\n\', vec_key));\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<TD CLASS=\"genlisthead\">%s</TD>\\n\', vec_key));\n"
"}\n"
"http (sprintf (\'<TD><INPUT type=\"submit\" name=\"pm_k%s%i\" value=\"Change\"></TD></TR>\\n\', s_t, t_idx));\n"
"}\n"
"else if (s_t = \'S\')\n"
"{\n"
"if (aref (_ch_key, s_idx) = \'1\')\n"
"{\n"
"http (sprintf (\'<TD CLASS=\"genlisthead\"><I>%s</I></TD>\\n\', vec_key));\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<TD CLASS=\"genlisthead\">%s</TD>\\n\', vec_key));\n"
"}\n"
"http (sprintf (\'<TD><INPUT type=\"submit\" name=\"pm_k%s%i\" value=\"Change\"></TD></TR>\\n\', s_t, s_idx));\n"
"}\n"
"else\n"
"{\n"
"http (sprintf (\'<TD CLASS=\"genlisthead\">%s</TD>\\n\', vec_key));\n"
"http (sprintf (\'<TD><INPUT type=\"submit\" name=\"pm_k%s%i\" value=\"Change\"></TD></TR>\\n\', s_t, v_idx));\n"
"}\n"
"}\n"
"\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"--src admin.sql:2953\n"
;

static const char *proc80 = 
"#line 3258 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_l_key_options (in left_v any)\n"
"{\n"
"declare idx integer;\n"
"while (idx < length (left_v))\n"
"{\n"
"http (sprintf (\'<option>%s</option>\', aref (left_v, idx)));\n"
"idx := idx + 1;\n"
"}\n"
"if (0 = idx)\n"
"http (\'<option>No keys</option>\');\n"
"}\n"
"--src admin.sql:3256\n"
;

static const char *proc81 = 
"#line 3272 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_key_init (inout params varchar, in dsn varchar,\n"
"in tab_col varchar, inout left_v any, inout right_v any,\n"
"in _se_ad varchar, in _se_re varchar, in key_in any)\n"
"\n"
"{\n"
"declare idx, len, pos, pos2 integer;\n"
"declare fild_name, col_s, num, _tbl, type, tbl_name varchar;\n"
"\n"
"type := get_keyword (\'type_\', params, \'\');\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (left_v))\n"
"{\n"
"left_v := vector ();\n"
"right_v := key_in;\n"
"if (key_in = \'Add\' or  aref (key_in, 0) = \'Add\')\n"
"right_v := vector ();\n"
"if (sys_stat (\'vdb_attach_autocommit\') > 0) vd_autocommit (dsn, 1);\n"
"col_s := sql_columns (dsn, NULL ,NULL, tab_col, NULL);\n"
"len := length (col_s);\n"
"while (idx < len)\n"
"{\n"
"fild_name := aref (aref (col_s, idx), 3);\n"
"left_v := vector_concat (left_v, vector (fild_name));\n"
"idx := idx + 1;\n"
"}\n"
"idx := 0;\n"
"len := length (right_v);\n"
"while (idx < len)\n"
"{\n"
"pos := vector_num (left_v, aref (right_v, idx));\n"
"left_v := vector_delete (left_v, vector(pos));\n"
"idx := idx + 1;\n"
"}\n"
"if (key_in = \'Add\' or  aref (key_in, 0) = \'Add\')\n"
"right_v := vector ();\n"
"else\n"
"{\n"
"idx := 0;\n"
"len := length (key_in);\n"
"while (idx < len)\n"
"{\n"
"pos := vector_num (left_v, aref (key_in, idx));\n"
"left_v := vector_delete (left_v, vector(pos));\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"}\n"
"if ((\'\' <> get_keyword (\'select_k\', params)) and (_se_ad <>\'\') and (_se_ad <>\'No keys\'))\n"
"{\n"
"if (right_v = \'\') right_v := vector();\n"
"right_v := vector_concat (right_v, vector(_se_ad));\n"
"pos := vector_num (left_v,_se_ad);\n"
"left_v := vector_delete (left_v, vector(pos));\n"
"}\n"
"\n"
"if ((\'\' <> get_keyword (\'un_select_k\', params)) and (_se_re <>\'\') and (_se_re <>\'No keys\'))\n"
"{\n"
"left_v := vector_concat (left_v, vector(_se_re));\n"
"pos := vector_num (right_v, _se_re);\n"
"right_v := vector_delete (right_v, vector(pos));\n"
"}\n"
"if ((\'\' <> get_keyword (\'up\', params)) and (_se_re <>\'\'))\n"
"{\n"
"pos := vector_num (right_v, _se_re);\n"
"right_v := vector_swap (right_v, pos, pos-1);\n"
"}\n"
"if ((\'\' <> get_keyword (\'down\', params)) and (_se_re <>\'\'))\n"
"{\n"
"pos := vector_num (right_v, _se_re);\n"
"right_v := vector_swap (right_v, pos, pos + 1);\n"
"}\n"
"\n"
"if (length (right_v) = 0)\n"
"right_v := \'\';\n"
"\n"
"}\n"
"--src admin.sql:3270\n"
;

static const char *proc82 = 
"#line 3352 \"[executable]/admin.sql\"\n"
"create procedure\n"
"vector_delete (in in_vector any, in numbers any)\n"
"{\n"
"declare len, idx, to_del integer;\n"
"declare res any;\n"
"\n"
"len:=length (in_vector);\n"
"if (len <= 0)\n"
"return in_vector;\n"
"\n"
"res := make_array (len - 1, \'any\');\n"
"idx := 0;\n"
"\n"
"to_del:= aref (numbers, 0);\n"
"\n"
"while (idx < len - 1)\n"
"{\n"
"if (idx < to_del)\n"
"aset (res, idx, aref (in_vector, idx));\n"
"else\n"
"aset (res, idx, aref (in_vector, idx +1));\n"
"\n"
"idx:=idx+1;\n"
"}\n"
"\n"
"return(res);\n"
"}\n"
"--src admin.sql:3350\n"
;

static const char *proc83 = 
"#line 3381 \"[executable]/admin.sql\"\n"
"create procedure\n"
"vector_num (in in_vector any, in wanted any)\n"
"{\n"
"declare len, idx integer;\n"
"\n"
"len := length (in_vector);\n"
"idx := 0;\n"
"\n"
"while ( idx < len )\n"
"{\n"
"if (aref (in_vector, idx) = wanted)\n"
"return (idx);\n"
"\n"
"idx:=idx+1;\n"
"}\n"
"}\n"
"--src admin.sql:3379\n"
;

static const char *proc84 = 
"#line 3399 \"[executable]/admin.sql\"\n"
"create procedure\n"
"vector_swap (in in_vector any, in pos integer, in des integer)\n"
"{\n"
"declare len, idx integer;\n"
"declare res,temp any;\n"
"\n"
"len:=length (in_vector);\n"
"idx := 0;\n"
"res := make_array (len, \'any\');\n"
"if ((des>len-1) or (des<0))\n"
"{\n"
"res := in_vector;\n"
"return (res);\n"
"}\n"
"temp := aref (in_vector, pos);\n"
"\n"
"while ( idx < len )\n"
"{\n"
"if (idx = des)\n"
"aset (res, idx, temp);\n"
"else\n"
"aset (res, idx, aref (in_vector, idx));\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"aset (res, pos, aref (in_vector, des));\n"
"\n"
"return (res);\n"
"}\n"
"--src admin.sql:3397\n"
;

static const char *proc85 = 
"#line 3431 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_link_view (in dsn varchar, in params any, in keys any)\n"
"{\n"
"\n"
"declare state, msg, state1, msg1, rname, dbuser, dbqual, tbl_name, tb_name varchar;\n"
"declare pos, idx int;\n"
"declare view_key, rname_temp any;\n"
"\n"
"idx := 0;\n"
"\n"
"while (pos := adm_next_checkbox (\'TBL_V\', params, idx))\n"
"{\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (rname := get_keyword (concat(\'R_NAME_V\',pos), params, \'\')))\n"
"{\n"
"return (0);\n"
"}\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (dbqual := get_keyword (concat(\'dbqual_V\',pos), params, \'\')))\n"
"{\n"
"return (0);\n"
"}\n"
"\n"
"dbuser := get_keyword (concat(\'dbuser_V\',pos), params, adm_lt_make_dsn_part(dsn));\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL( tbl_name:= get_keyword (concat(\'TBL_NAME_V\',pos), params, \'\')))\n"
"{\n"
"return (0);\n"
"}\n"
"\n"
"tb_name := concat (replace (dbqual, \'.\', \'\\x0A\'), \'.\', replace (dbuser, \'.\', \'\\x0A\'), \'.\', replace (tbl_name, \'.\', \'\\x0A\'));\n"
"view_key := aref (keys, atof (pos));\n"
"If ((view_key = \'Add\') or (aref (view_key,0) = \'Add\'))\n"
"view_key := NULL;\n"
"\n"
"rname_temp :=  deserialize (decode_base64 (rname));\n"
"if (length (rname_temp) = 2)\n"
"rname := concat (replace (aref (rname_temp, 0), \'.\', \'\\x0A\'), \'.\',\n"
"replace (aref (rname_temp, 1), \'.\', \'\\0A\'));\n"
"else\n"
"rname := replace (aref (rname_temp, 0), \'.\', \'\\x0A\');\n"
"\n"
"state := \'00000\';\n"
"msg := \'none\';\n"
"state1 := \'00000\';\n"
"msg1 := \'none\';\n"
"\n"
"if (not exists (select RT_NAME from DB.DBA.SYS_REMOTE_TABLE where RT_NAME = tb_name))\n"
"{\n"
"exec (\'DB.DBA.vd_attach_view (?, ?, ?, ?, ?, ?, 1)\', state, msg,\n"
"vector (dsn, rname, tb_name, NULL, NULL, view_key), 0, NULL, NULL);\n"
"exec (\'commit work\', state1, msg1);\n"
"}\n"
"if (\'00000\' <> state)\n"
"{\n"
"http(\'<TABLE CLASS=\"genlist\" BORDER=\"0\" CELLPADDING=\"0\">\');\n"
"http(sprintf(\'<TR><TD CLASS=\"errorhead\" COLSPAN=\"2\">Connection to %V failed:</TD></TR>\', dsn));\n"
"http(\'<TR><TD CLASS=\"AdmBorders\" COLSPAN=\"2\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\');\n"
"http (sprintf (\'<TR><TD CLASS=\"genlisthead\">External Table</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce (rname, \'\')));\n"
"http (sprintf (\'<TR><TD CLASS=\"genlisthead\">Local Table</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce (tb_name, \'\')));\n"
"http(sprintf(\'<TR><TD CLASS=\"genlisthead\">SQL State</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(state, \'\')));\n"
"http(sprintf(\'<TR><TD CLASS=\"genlisthead\">Error Message</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(msg, \'\')));\n"
"if (\'00000\' <> state1)\n"
"{\n"
"http(sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn SQL State</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(state1, \'\')));\n"
"http(sprintf(\'<TR><TD CLASS=\"genlisthead\">Txn Error Message</TD><TD CLASS=\"gendata\">%V</TD></TR>\', coalesce(msg1, \'\')));\n"
"}\n"
"http(\'</TABLE>\');\n"
"}\n"
"}\n"
"}\n"
"--src admin.sql:3429\n"
;

static const char *proc86 = 
"#line 3504 \"[executable]/admin.sql\"\n"
"create procedure\n"
"vector_print (in in_vector any)\n"
"{\n"
"declare len, idx integer;\n"
"declare temp varchar;\n"
"declare res varchar;\n"
"\n"
"if (isstring (in_vector))\n"
"in_vector := vector (in_vector);\n"
"\n"
"len := length (in_vector);\n"
"idx := 1;\n"
"res := aref (in_vector, 0);\n"
"while ( idx < len )\n"
"{\n"
"res := concat (res, \', \');\n"
"temp := aref (in_vector, idx);\n"
"if (__tag(temp) = 193)\n"
"res := concat (res, \'vector\');\n"
"else\n"
"res := concat (res, temp);\n"
"idx := idx+1;\n"
"}\n"
"return (res);\n"
"}\n"
"--src admin.sql:3502\n"
;

static const char *proc87 = 
"#line 3531 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_dsn_list (in type varchar)\n"
"{\n"
"declare dsns, files any;\n"
"declare dsn, drv, page varchar;\n"
"declare len, idx integer;\n"
"\n"
"\n"
"if (type = \'file\')\n"
"{\n"
"files := adm_get_file_dsn ();\n"
"len := length (files);\n"
"while (idx < len)\n"
"{\n"
"dsn := aref (files, idx);\n"
"http (sprintf (\'<TR><TD CLASS=\"gendata\">%s</TD><TD CLASS=\"gendata\">%s</TD>\n"
"<TD CLASS=\"gendata\">&nbsp</TD>\n"
"<FORM method=\"POST\" action=\"admin_dsn_edit.vsp\">\n"
"<TD CLASS=\"gendata\" ALIGN=\"center\">\n"
"<A CLASS=\"tablelistaction\" href=\"admin_dsn_edit.vsp?edit=Edit&name=%s&type=%s\">Edit</A>\n"
"</TD></FORM></TR>\',\n"
"dsn, type, dsn, type));\n"
"idx := idx + 1;\n"
"}\n"
"return (0);\n"
"}\n"
"\n"
"dsns := sql_data_sources(1,type);\n"
"\n"
"idx := 0;\n"
"len := length (dsns);\n"
"\n"
"if (len = 0)\n"
"{\n"
"http(sprintf (\'No pre-defined %s DSNs\', type));\n"
"}\n"
"else\n"
"{\n"
"if (type = \'\')\n"
"type := \'system\';\n"
"while (idx < len)\n"
"{\n"
"dsn := aref (aref (dsns, idx), 0);\n"
"drv := aref (aref (dsns, idx), 1);\n"
"page := \'admin_dsn_edit.vsp\';\n"
"if ((strcasestr (drv, \'eneric\')) or\n"
"(strcasestr (drv, \'penLink\')) and\n"
"(strcasestr (drv, \'Lite\') is null))\n"
"page := \'admin_dsn_add_generic32.vsp\';\n"
"if (strcasestr (drv, \'irtuoso\'))\n"
"page := \'admin_dsn_edit_virt.vsp\';\n"
"http (sprintf (\'<TR><TD CLASS=\"gendata\">%s</TD>\n"
"<TD CLASS=\"gendata\">%s</TD><TD CLASS=\"gendata\">%s</TD>\n"
"<FORM method=\"POST\" action=\"%s\" name=\"dsn_page_%i\"><TD CLASS=\"gendata\" ALIGN=\"center\">\n"
"<A CLASS=\"tablelistaction\" href=\"%s?edit=Edit&name=%s&type=%s&driver=%s\">Edit</A>\n"
"<A CLASS=\"tablelistaction\" href=\"%s?remove=Remove&name=%s&type=%s&driver=%s\">Remove</A>\n"
"</TD></FORM></TR>\',\n"
"dsn, type, drv, page, idx,\n"
"page, dsn, type, encode_base64(serialize (drv)),\n"
"page, dsn, type, encode_base64(serialize (drv))));\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"\n"
"return (0);\n"
"}\n"
"--src admin.sql:3529\n"
;

static const char *proc88 = 
"#line 3600 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_dsn_update (in params any)\n"
"{\n"
"declare _dsn, _type, _desc, _param, _driver varchar;\n"
"declare _addr, _user, _pass, _database varchar;\n"
"declare l_val, r_val varchar;\n"
"declare pos_eqal, pos_end, len int;\n"
"\n"
"_dsn := get_keyword (\'name\', params, \'\');\n"
"_type := get_keyword (\'type_dsn\', params, \'\');\n"
"_driver := deserialize (decode_base64 (get_keyword (\'driver\', params, \'\')));\n"
"\n"
"if (_type = \'file\' and get_keyword (\'save_file\', params) <> \'\')\n"
"{\n"
"string_to_file (_dsn, get_keyword (\'new_text\', params, \'\'), -2);\n"
"return (0);\n"
"}\n"
"\n"
"if (not DB.DBA.IS_EMPTY_OR_NULL (get_keyword (\'remove_\', params)))\n"
"sql_remove_dsn_from_ini (_dsn, _type);\n"
"\n"
"if (not DB.DBA.IS_EMPTY_OR_NULL (get_keyword (\'update_ini\', params)))\n"
"{\n"
"_desc := get_keyword (\'descrip\', params, \'\');\n"
"_param := get_keyword (\'parameter\', params, \'\');\n"
"\n"
"sql_remove_dsn_from_ini (_dsn, _type);\n"
"sql_config_data_sources (_driver, _type, concat (\'DSN=\', _dsn, \';\'));\n"
"\n"
"if (not DB.DBA.IS_EMPTY_OR_NULL (_desc))\n"
"sql_write_private_profile_string (_dsn, _type, \'Description\', _desc);\n"
"\n"
"_param := replace (_param, chr (10), \';\');\n"
"_param := replace (_param, chr (13), \'\');\n"
"_param := replace (_param, \';;\', \';\');\n"
"\n"
"if (not DB.DBA.IS_EMPTY_OR_NULL (_param))\n"
"len := length (_param);\n"
"\n"
"while (1=1)\n"
"{\n"
"if (len = 0)\n"
"return (1);\n"
"pos_eqal := strchr (_param, \'=\');\n"
"pos_end := strchr (_param, \';\');\n"
"l_val := \"LEFT\" (_param, pos_eqal);\n"
"r_val := subseq (_param, pos_eqal + 1, pos_end);\n"
"_param := subseq (_param, pos_end + 1, len);\n"
"len := length (_param);\n"
"sql_write_private_profile_string (_dsn, _type, l_val, r_val);\n"
"}\n"
"}\n"
"\n"
"if (not DB.DBA.IS_EMPTY_OR_NULL (get_keyword (\'upd_generic\', params)))\n"
"const_string_add_generic32 (params);\n"
"\n"
"sql_remove_dsn_from_ini (\'__temp__dsn__\', \'system\');\n"
"sql_remove_dsn_from_ini (\'__temp__dsn__\', \'user\');\n"
"\n"
"return (0);\n"
"}\n"
"--src admin.sql:3598\n"
;

static const char *proc89 = 
"#line 3664 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_edit_text (in params any)\n"
"{\n"
"declare _dsn, _type, _description, _vals varchar;\n"
"declare parameters, description, vals any;\n"
"declare len, idx, br integer;\n"
"\n"
"_dsn := get_keyword (\'name\', params, \'\');\n"
"_type := get_keyword (\'type\', params, \'\');\n"
"\n"
"parameters := sql_get_private_profile_string (_dsn, _type);\n"
"len := length (parameters);\n"
"description := make_array (len , \'any\');\n"
"vals := make_array (len , \'any\');\n"
"\n"
"idx := 0;\n"
"br :=0;\n"
"while (idx < len)\n"
"{\n"
"_description := aref (aref (parameters, idx), 0);\n"
"_vals := aref (aref (parameters, idx), 1);\n"
"\n"
"if (_description = \'Description\')\n"
"http (sprintf (\'<TR><TD ALIGN=\"Center\" ><TABLE><TR><TD><B>Description:</B></TD><TD>\n"
"<input type=\"text\" name=\"descrip\" value=\"%s\"></TD></TR></TABLE></TD></TR>\n"
"<TR><TD COLSPAN=\"2\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"15\"></TD></TR>\', _vals));\n"
"else\n"
"{\n"
"if (_description = \'Driver\')\n"
"http (sprintf (\'<TR><TD ALIGN=\"Center\"><TABLE><TR><TD><B>Driver:</B></TD><TD>%s</TD></TR></TABLE></TD></TR>\n"
"<INPUT type=\"hidden\" name=\"driver_ini\" value=\"%s\"><TR><TD COLSPAN=\"2\">\n"
"<IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"15\"></TD></TR>\', _vals, _vals));\n"
"else\n"
"{\n"
"aset (description, br, _description);\n"
"aset (vals, br, _vals);\n"
"br := br + 1;\n"
"}\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"http (\'<TR><TD COLSPAN=\"2\" ALIGN=\"Center\"><TEXTAREA WRAP=\"off\" NAME=\"parameter\" COLS=\"55\" ROWS=\"15\">\');\n"
"\n"
"idx := 0;\n"
"while (idx < br)\n"
"{\n"
"http (aref (description, idx));\n"
"http (\'=\');\n"
"http (aref (vals, idx));\n"
"http (\'&#59;&#10;\');\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"http (\'</TEXTAREA></TD></TR>\');\n"
"\n"
"return (0);\n"
"}\n"
"--src admin.sql:3662\n"
;

static const char *proc90 = 
"#line 3725 \"[executable]/admin.sql\"\n"
"create procedure\n"
"const_string_generic32 (in params any, in driver_end any)\n"
"{\n"
"declare idx, len integer;\n"
"declare res, temp, _parameter varchar;\n"
"declare _driver_str any;\n"
"\n"
"_driver_str := deserialize (decode_base64 (get_keyword (\'driver_str\', params, \'\')));\n"
"_parameter := get_keyword (\'parameter\', params, \'\');\n"
"res := \'\';\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (driver_end))\n"
"return (0);\n"
"len := length (driver_end);\n"
"idx := 1;\n"
"while (idx < len)\n"
"{\n"
"temp := aref(driver_end, idx);\n"
"if (not (DB.DBA.IS_EMPTY_OR_NULL (temp)))\n"
"res := concat (res, aref(_driver_str, idx), \'=\', temp, \';\');\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"_parameter := replace (_parameter, chr (10), \';\');\n"
"_parameter := replace (_parameter, chr (13), \'\');\n"
"_parameter := replace (_parameter, \';;\', \';\');\n"
"\n"
"res := concat (res, _parameter);\n"
"\n"
"return res;\n"
"}\n"
"--src admin.sql:3723\n"
;

static const char *proc91 = 
"#line 3758 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_edit_virt (in params any, inout _desc varchar, inout _server varchar, inout _port varchar,\n"
"inout _user varchar, inout _pass varchar, inout _database varchar,\n"
"inout _daylight varchar, inout _ssl varchar)\n"
"{\n"
"declare _dsn, _type, _description varchar;\n"
"declare parameters any;\n"
"declare len, idx, pos integer;\n"
"\n"
"_dsn := get_keyword (\'name\', params, \'\');\n"
"_type := get_keyword (\'type\', params, \'\');\n"
"\n"
"parameters := sql_get_private_profile_string (_dsn, _type);\n"
"len := length (parameters);\n"
"\n"
"_desc := \'\';\n"
"_server := \'\';\n"
"_port := \'\';\n"
"_user := \'\';\n"
"_pass := \'\';\n"
"_database := \'\';\n"
"_daylight := \'\';\n"
"_ssl := \'\';\n"
"idx := 0;\n"
"\n"
"while (idx < len)\n"
"{\n"
"_description := aref (aref (parameters, idx), 0);\n"
"if (_description = \'Description\')\n"
"_desc := aref (aref (parameters, idx), 1);\n"
"if (_description = \'Address\')\n"
"{\n"
"_server := aref (aref (parameters, idx), 1);\n"
"pos := strstr (_server, \':\');\n"
"if (pos > 0)\n"
"{\n"
"_port := subseq (_server, pos + 1);\n"
"_server := \"LEFT\" (_server, pos);\n"
"}\n"
"}\n"
"if (_description = \'LastUser\')\n"
"_user := aref (aref (parameters, idx), 1);\n"
"if (_description = \'UserName\')\n"
"_user := aref (aref (parameters, idx), 1);\n"
"if (_description = \'Database\')\n"
"_database := aref (aref (parameters, idx), 1);\n"
"if (_description = \'Daylight\')\n"
"_daylight := aref (aref (parameters, idx), 1);\n"
"if (_description = \'Encrypt\')\n"
"_ssl := aref (aref (parameters, idx), 1);\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"if (_daylight = \'Yes\')\n"
"_daylight := \'on\';\n"
"else\n"
"_daylight := \'\';\n"
"\n"
"if (_ssl <> \'\')\n"
"_ssl := \'on\';\n"
"else\n"
"_ssl := \'\';\n"
"\n"
"\n"
"return (0);\n"
"}\n"
"--src admin.sql:3756\n"
;

static const char *proc92 = 
"#line 3828 \"[executable]/admin.sql\"\n"
"create procedure\n"
"const_string_add_generic32 (in params any)\n"
"{\n"
"declare _param, _type, _dsn, _dsn_old, _driver varchar;\n"
"declare _read_only, _no_log, _srv_type, _srv_type_text varchar;\n"
"declare _long_data varchar;\n"
"\n"
"_dsn := get_keyword (\'dsn_name\', params, \'\');\n"
"_dsn_old := get_keyword (\'dsn_name_old\', params, \'\');\n"
"_driver := deserialize (decode_base64 (get_keyword (\'driver\', params, \'\')));\n"
"_type := get_keyword (\'type\', params, \'\');\n"
"\n"
"_read_only := get_keyword (\'read_only\', params, \'\');\n"
"_no_log := get_keyword (\'no_log\', params, \'\');\n"
"_long_data := get_keyword (\'long_data\', params, \'\');\n"
"_srv_type_text := get_keyword (\'srv_type_text\', params, \'\');\n"
"_srv_type := get_keyword (\'srv_type\', params, \'\');\n"
"\n"
"if (_dsn = \'\')\n"
"_dsn := \'__temp__dsn__\';\n"
"\n"
"if (_type = \'file\')\n"
"_param := \'\';\n"
"else\n"
"_param := concat (\'DSN=\', _dsn, \';\');\n"
"\n"
"_param := const_from_params (_param, \'desc\', \'Description=\', params);\n"
"_param := const_from_params (_param, \'buff\', \'FetchBufferSize=\', params);\n"
"_param := const_from_params (_param, \'srv_opt\', \'ServerOptions=\', params);\n"
"_param := const_from_params (_param, \'host\', \'Host=\', params);\n"
"_param := const_from_params (_param, \'hport\', \'Port=\', params);\n"
"_param := const_from_params (_param, \'database\', \'Database=\', params);\n"
"\n"
"if (_type <> \'file\')\n"
"_param := const_from_params (_param, \'pass\', \'Password=\', params);\n"
"\n"
"if (sys_stat(\'st_build_opsys_id\') = \'Win32\')\n"
"{\n"
"_param := const_from_params (_param, \'user\', \'LastUser=\', params);\n"
"}\n"
"else\n"
"{\n"
"_param := const_from_params (_param, \'user\', \'UserName=\', params);\n"
"}\n"
"_param := concat (_param, \'Protocol=TCP/IP;\');\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (_srv_type_text))\n"
"_param := concat (_param, \'ServerType=\', _srv_type, \';\');\n"
"else\n"
"_param := concat (_param, \'ServerType=\', _srv_type_text, \';\');\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (_read_only))\n"
"_param := concat (_param, \'ReadOnly=No;\');\n"
"else\n"
"_param := concat (_param, \'ReadOnly=Yes;\');\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (_no_log))\n"
"_param := concat (_param, \'NoLoginBox=No;\');\n"
"else\n"
"_param := concat (_param, \'NoLoginBox=Yes;\');\n"
"\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (_long_data))\n"
"_param := concat (_param, \'DeferLongFetch=No;\');\n"
"else\n"
"_param := concat (_param, \'DeferLongFetch=Yes;\');\n"
"\n"
"if (_type = \'file\')\n"
"{\n"
"_param := replace (_param, \';\', \'\\n\');\n"
"_param := concat (\'[ODBC]\\nServer=OpenLink\\nDRIVER=\', _driver, \'\\n\', _param);\n"
"\n"
"if (\"RIGHT\" (_dsn, 4) <> \'.dsn\')\n"
"_dsn := concat (_dsn, \'.dsn\');\n"
"\n"
"string_to_file (_dsn,  _param, 0);\n"
"\n"
"return (0);\n"
"}\n"
"\n"
"sql_remove_dsn_from_ini (_dsn_old, _type);\n"
"sql_config_data_sources (_driver, _type, _param);\n"
"\n"
"return (0);\n"
"}\n"
"--src admin.sql:3826\n"
;

static const char *proc93 = 
"#line 3915 \"[executable]/admin.sql\"\n"
"create procedure\n"
"const_from_params (inout str varchar, in control varchar, in text_to_ini varchar, in params any)\n"
"{\n"
"declare val varchar;\n"
"val := get_keyword (control, params, \'\');\n"
"if (not DB.DBA.IS_EMPTY_OR_NULL (val))\n"
"return (concat (str, text_to_ini, val, \';\'));\n"
"return (str);\n"
"}\n"
"--src admin.sql:3913\n"
;

static const char *proc94 = 
"#line 3927 \"[executable]/admin.sql\"\n"
"create procedure\n"
"constru_string (in params any, in driver_end any)\n"
"{\n"
"\n"
"declare idx, len, only_v integer;\n"
"declare res, temp, temp2, _parameter, leb varchar;\n"
"declare _driver_str any;\n"
"\n"
"_driver_str := deserialize (decode_base64 (get_keyword (\'driver_str\', params, \'\')));\n"
"_parameter := get_keyword (\'parameter\', params, \'\');\n"
"only_v := atoi (get_keyword (\'only_v\', params, \'0\'));\n"
"\n"
"if (only_v)\n"
"temp2 := concat (get_keyword (\'Server\', params, \'\'), \':\', get_keyword (\'Port\', params, \'\'));\n"
"\n"
"res := \'\';\n"
"if (DB.DBA.IS_EMPTY_OR_NULL (driver_end))\n"
"return (0);\n"
"len := length (driver_end);\n"
"idx := 1;\n"
"while (idx < len)\n"
"{\n"
"temp := aref(driver_end, idx);\n"
"if (not (DB.DBA.IS_EMPTY_OR_NULL (temp)))\n"
"{\n"
"leb := aref(_driver_str, idx);\n"
"if (only_v and leb = \'Port\')\n"
"goto next;\n"
"if (only_v and leb = \'Server\')\n"
"{\n"
"leb := \'Address\';\n"
"temp := temp2;\n"
"}\n"
"res := concat (res, leb, \'=\', temp, \';\');\n"
"}\n"
"next:;\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"_parameter := replace (_parameter, chr (10), \';\');\n"
"_parameter := replace (_parameter, chr (13), \'\');\n"
"_parameter := replace (_parameter, \';;\', \';\');\n"
"\n"
"res := concat (res, _parameter);\n"
"\n"
"if (get_keyword (\'only_v\', params, \'\') = \'1\')\n"
"{\n"
"res := replace (res, \'Daylight=on\', \'Daylight=Yes\');\n"
"res := replace (res, \'SSL=on\', \'Encrypt=1\');\n"
"res := replace (res, \'SSL=off\', \'\');\n"
"res := replace (res, \'Password=\', \'\');\n"
"if (sys_stat(\'st_build_opsys_id\') = \'Win32\')\n"
"res := replace (res, \'User=\', \'LastUser=\');\n"
"else\n"
"res := replace (res, \'User=\', \'UserName=\');\n"
"}\n"
"\n"
"return res;\n"
"}\n"
"--src admin.sql:3925\n"
;

static const char *proc95 = 
"#line 3989 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_dsn_exist (in type varchar, in drv_name varchar)\n"
"{\n"
"declare dsns any;\n"
"declare drv varchar;\n"
"declare len, idx integer;\n"
"\n"
"dsns := sql_data_sources(1,type);\n"
"\n"
"idx := 0;\n"
"len := length (dsns);\n"
"\n"
"while (idx < len)\n"
"{\n"
"drv := aref (aref (dsns, idx), 1);\n"
"if (drv = drv_name)\n"
"return (sql_get_private_profile_string ( (aref (aref (dsns, idx), 0)) , type));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return (NULL);\n"
"}\n"
"--src admin.sql:3987\n"
;

static const char *proc96 = 
"#line 4014 \"[executable]/admin.sql\"\n"
"create procedure\n"
"convert_exist (in type varchar, in drv_name varchar, inout at_str any, inout at_def any)\n"
"{\n"
"declare p_string any;\n"
"declare temp varchar;\n"
"declare len, idx integer;\n"
"\n"
"p_string := adm_dsn_exist (type, drv_name);\n"
"\n"
"if (p_string is NULL)\n"
"return (NULL);\n"
"\n"
"len := length (p_string);\n"
"\n"
"at_str := vector (\'9\', \'DSN\', \'Description\');\n"
"at_def := vector (\'9\', \'\', \'\');\n"
"\n"
"idx := 0;\n"
"while (idx < len)\n"
"{\n"
"temp := aref (aref (p_string, idx), 0);\n"
"if ((temp <> \'Driver\') and (temp <> \'Description\'))\n"
"{\n"
"at_str := vector_concat (at_str, vector (temp));\n"
"at_def := vector_concat (at_def, vector (aref (aref (p_string, idx), 1)));\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return (1);\n"
"}\n"
"--src admin.sql:4012\n"
;

static const char *proc97 = 
"#line 4048 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_button_check (in keyw varchar, inout params varchar)\n"
"{\n"
"declare pos, spos integer;\n"
"declare len integer;\n"
"declare klen integer;\n"
"declare s varchar;\n"
"\n"
"spos := 0;\n"
"len := length (params);\n"
"klen := length (keyw);\n"
"\n"
"while (spos < len)\n"
"{\n"
"s := aref (params, spos);\n"
"if (keyw = \"LEFT\" (s, klen))\n"
"return \"RIGHT\" (s, length (s) - klen);\n"
"spos := spos + 2;\n"
"}\n"
"}\n"
"--src admin.sql:4046\n"
;

static const char *proc98 = 
"#line 4071 \"[executable]/admin.sql\"\n"
"create procedure\n"
"date822_to_date (in in_date varchar)\n"
"{\n"
"declare day, mount, year varchar;\n"
"declare mounts any;\n"
"declare idx, pos integer;\n"
"\n"
"mounts := vector (\'Jan\', \'Feb\', \'Mar\', \'Apr\', \'May\', \'Jun\', \'Jul\', \'Aug\', \'Sep\', \'Oct\', \'Nov\', \'Dec\');\n"
"pos := strstr (in_date, \',\');\n"
"\n"
"if (length (in_date) = 0)\n"
"return 0;\n"
"if (pos)\n"
"in_date := subseq (in_date, pos + 2);\n"
"if (\"LEFT\" (in_date, 1) = \' \')\n"
"in_date := subseq (in_date, 1);\n"
"day := \"LEFT\" (in_date, strstr (in_date, \' \'));\n"
"in_date := subseq (in_date, strstr (in_date, \' \') + 1);\n"
"mount := \"LEFT\" (in_date, 3);\n"
"in_date := subseq (in_date, strstr (in_date, \' \') + 1);\n"
"year := \"LEFT\" (in_date, strstr (in_date, \' \'));\n"
"\n"
"if (length (year) = 2)\n"
"if (atoi (\"LEFT\" (year, 1)) < 5)\n"
"year := concat (\'19\', year);\n"
"else\n"
"year := concat (\'20\', year);\n"
"\n"
"idx := 0;\n"
"\n"
"while (idx < 12)\n"
"{\n"
"if (aref (mounts, idx) = mount)\n"
"{\n"
"mount := cast ((idx + 1) as varchar);\n"
"idx := 12;\n"
"}\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return (cast (concat (mount,\'  \', day, \'  \', year) as date));\n"
"}\n"
"--src admin.sql:4069\n"
;

static const char *proc99 = 
"#line 4116 \"[executable]/admin.sql\"\n"
"create procedure\n"
"mail_to (in _from varchar)\n"
"{\n"
"declare pos integer;\n"
"\n"
"pos := strstr (_from, \'<\');\n"
"\n"
"if (pos)\n"
"_from := subseq (_from, pos + 1, strstr (_from, \'>\'));\n"
"\n"
"return (_from);\n"
"}\n"
"--src admin.sql:4114\n"
;

static const char *proc100 = 
"#line 4131 \"[executable]/admin.sql\"\n"
" create procedure\n"
"adm_send_js_auth_page (in realm varchar, in nonce varchar,\n"
"in path varchar, in _user varchar)\n"
"{\n"
"declare dbg integer;\n"
"dbg := 0;\n"
"\n"
"if (dbg)\n"
"dbg_printf (\'adm_send_js_auth_page: realm %s, nonce %s, path %s, _user %s\'\n"
", realm, nonce, path, _user);\n"
"\n"
"http (\'<html>\');\n"
"http (\'<head>\');\n"
"http (concat (\'<title>Authentication required for \', realm, \'</title>\'));\n"
"http (\'<script language=\"javascript\" src=\"/admin/admin_auth.js\"></script>\');\n"
"http (\'<script language=\"javascript\" src=\"/admin/md5.js\"></script>\');\n"
"http (\'<style type=\"text/css\" src=\"admin_style.css\"></style>\');\n"
"http (\'</head>\');\n"
"http (\'<body>\');\n"
"\n"
"if (dbg)\n"
"{\n"
"http (\'<small><strong>\');\n"
"http (sprintf (\'realm: %s, nonce: %s\', realm, nonce));\n"
"http (\'</strong></small>\');\n"
"}\n"
"\n"
"http (concat (\'<form name=\"l\" method=\"POST\" action=\"\', path, \'\">\\n\'));\n"
"http (concat (\'<input type=\"HIDDEN\" name=\"AUTH_REQ\" value=\"\', realm, \'\">\\n\'));\n"
"http (concat (\'<input type=\"HIDDEN\" name=\"u\" value=\"\">\\n\'));\n"
"http (concat (\'<input type=\"HIDDEN\" name=\"d\" value=\"\">\\n\'));\n"
"http (concat (\'<input type=\"HIDDEN\" name=\"n\" value=\"\', nonce, \'\">\\n\'));\n"
"http (\'</form>\\n\');\n"
"http (\'<form name=\"f\">\\n\');\n"
"http (\'<table align=\"center\" bgcolor=\"green\" border=\"0\" width=\"150\">\\n\');\n"
"http (\'<tr>\\n\');\n"
"http (\'<td>&nbsp;</td>\\n\');\n"
"http (\'<td colspan=\"2\">Authentication required</td>\\n\');\n"
"http (\'</tr>\\n\');\n"
"http (\'<tr>\\n\');\n"
"http (\'<td class=\"widgettitle\"><small><strong>Realm</small></strong></td>\\n\');\n"
"http (concat (\'<td colspan=\"2\">\', realm, \'&nbsp;</td>\\n\'));\n"
"http (\'</tr>\\n\');\n"
"http (\'<tr>\\n\');\n"
"http (\'<td class=\"widgettitle\"><small><strong>Username</small></strong></td>\\n\');\n"
"http (concat (\'<td><input type=\"text\" name=\"u\" value=\"\', _user, \'\"></td>\\n\'));\n"
"http (\'<td>&nbsp;</td>\\n\');\n"
"http (\'</tr>\\n\');\n"
"http (\'<tr>\\n\');\n"
"http (\'<td class=\"widgettitle\"><small><strong>Password</small></strong></td>\\n\');\n"
"http (\'<td><input type=\"password\" name=\"p\"></td>\\n\');\n"
"http (\'<td><input type=\"button\" name=\"login\" value=\"Login\" onClick=\"digest_submit (document.f, document.l);\"></td>\\n\');\n"
"http (\'</tr>\\n\');\n"
"http (\'<tr>\\n\');\n"
"http (\'<td>&nbsp;</td>\\n\');\n"
"http (\'<td><small>Note: Please read <a href=\"\">this</a> about password security.</small></td>\\n\');\n"
"http (\'<td>&nbsp;</td>\\n\');\n"
"http (\'</tr>\\n\');\n"
"http (\'</table>\\n\');\n"
"http (\'</form>\\n\');\n"
"http (\'</body>\\n\');\n"
"http (\'</html>\\n\');\n"
"}\n"
"--src admin.sql:4129\n"
;

static const char *proc101 = 
"#line 4199 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_pre_page(inout lines any)\n"
"{\n"
"\n"
"return 0;\n"
"\n"
"declare pos, len integer;\n"
"declare meth, authstring varchar;\n"
"declare auth any;\n"
"auth := vsp_auth_vec (lines);\n"
"if (not isarray(auth))\n"
"auth := \'\';\n"
"\n"
"\n"
"pos := 0;\n"
"len := length (aref (lines, 0));\n"
"meth := (aref (vsp_auth_next_tok (aref (lines, 0), pos, len), 1));\n"
"\n"
"\n"
"INSERT INTO WS.WS.AUDIT_LOG (\n"
"EVTTIME, REFERER, HOST, COMMAND, AUTHSTRING, USERNAME, REALM,\n"
"AUTHALGORITHM, URI, USERAGENT, CLIENT)\n"
"VALUES(\n"
"now(),\n"
"vsp_ua_match_hdr(lines, \'%[Rr]eferer: %\'),\n"
"vsp_ua_match_hdr(lines, \'%[Hh]ost: %\'),\n"
"aref(lines,0),\n"
"vsp_ua_match_hdr(lines, \'%[Aa]uthori[sz]ation: %\'),\n"
"get_keyword(\'username\', auth, \'\'),\n"
"get_keyword(\'realm\', auth, \'\'),\n"
"get_keyword(\'algorithm\', auth, \'\'),\n"
"get_keyword(\'uri\', auth, \'\'),\n"
"vsp_ua_match_hdr(lines, \'%[Uu]ser-[Aa]gent: %\'),\n"
"http_client_ip()\n"
");\n"
"}\n"
"--src admin.sql:4197\n"
;

static const char *proc102 = 
"#line 4237 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_what_css()\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"return \'/admin/admin_style.css\';\n"
"}\n"
"--src admin.sql:4235\n"
;

static const char *proc103 = 
"#line 4248 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_page_header(in heading varchar, in help_topic varchar)\n"
"{\n"
"http(\'<BODY>\\n\');\n"
"http(\'<TABLE WIDTH=\"100%\" BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"0\">\\n\');\n"
"if (heading is not null)\n"
"{\n"
"http(sprintf(\'<TR CLASS=\"AdmPagesTitle\"><TD><H2>%s</H2></TD>\', coalesce(heading,\'NO HEADING\')));\n"
"if (help_topic is not null and 1=2)\n"
"http(sprintf(\'<TD><A HREF=\"helpme.vsp?topic=%s\">Help</A></TD>\', help_topic));\n"
"else\n"
"http(\'<TD>&nbsp;</TD>\');\n"
"http(\'</TD></TR>\\n\');\n"
"http(\'<TR CLASS=\"AdmBorders\"><TD COLSPAN=\"2\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\\n\');\n"
"http(\'<TR CLASS=\"CtrlMain\"><TD COLSPAN=\"2\" ALIGN=\"middle\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"15\" ALT=\"\"></TD></TR>\\n\');\n"
"}\n"
"http(\'<TR CLASS=\"CtrlMain\"><TD COLSPAN=\"2\" ALIGN=\"middle\">\');\n"
"}\n"
"--src admin.sql:4246\n"
;

static const char *proc104 = 
"#line 4268 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_page_break()\n"
"{\n"
"http(\'</TD></TR>\');\n"
"http(\'<TR><TD CLASS=\"CtrlMain\" COLSPAN=\"2\" ALIGN=\"middle\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"15\" ALT=\"\"></TD></TR>\');\n"
"http(\'<TR><TD CLASS=\"CtrlMain\" COLSPAN=\"2\" ALIGN=\"middle\">\');\n"
"}\n"
"--src admin.sql:4266\n"
;

static const char *proc105 = 
"#line 4277 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_page_footer()\n"
"{\n"
"http(\'</TD></TR>\');\n"
"http(\'<TR><TD CLASS=\"CtrlMain\" COLSPAN=\"2\"><IMG SRC=\"images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"15\" ALT=\"\"></TD></TR>\\n\');\n"
"http(\'<TR><TD CLASS=\"CopyrightBorder\" COLSPAN=\"2\"><IMG SRC=\"/admin/images/1x1.gif\" WIDTH=\"1\" HEIGHT=\"2\" ALT=\"\"></TD></TR>\');\n"
"http(\'<TR><TD ALIGN=\"right\" COLSPAN=\"2\"><P CLASS=\"Copyright\">Virtuoso Universal Server \');\n"
"http(sys_stat(\'st_dbms_ver\'));\n"
"http(\' - Copyright&copy; 1998-2015 OpenLink Software.</P></TD></TR>\');\n"
"http(\'</TABLE>\\n</BODY>\');\n"
"}\n"
"--src admin.sql:4275\n"
;

static const char *proc106 = 
"#line 4291 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_news_status(in STAT integer)\n"
"{\n"
"if (STAT = 1) return \'<DIV CLASS=\"status_ok\">OK</DIV>\';\n"
"else if (STAT is NULL) return \'<DIV CLASS=\"status_ok\">New</DIV>\';\n"
"else if (STAT = 3) return \'<DIV CLASS=\"status_wip\">OK*</DIV>\';\n"
"else if (STAT = 7) return \'<DIV CLASS=\"status_wip\">Pending</DIV>\';\n"
"else if (STAT = 9) return \'<DIV CLASS=\"status_wip\">Updating...</DIV>\';\n"
"else return \'<DIV CLASS=\"status_err\">Unsuccessful</DIV>\';\n"
"}\n"
"--src admin.sql:4289\n"
;

static const char *proc107 = 
"#line 4303 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_mailaddr_pretty(in email_addr varchar)\n"
"{\n"
"declare _email, _name varchar;\n"
"email_addr := coalesce(email_addr, \'Not Provided\');\n"
"_name := email_addr;\n"
"if (strstr(_name, \'<\') = 0)\n"
"_name := null;\n"
"else\n"
"_name := substring(_name, 1, coalesce(strstr(_name, \'<\') -1, length(_name)));\n"
"_email := coalesce(regexp_substr(\'([a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+)\', email_addr, 0), email_addr);\n"
"if (_name is not null)\n"
"_name := replace (_name, \'\"\', \'\');\n"
"_name := coalesce(_name, _email);\n"
"return sprintf(\'\\n<A HREF=\"mailto:%s\">%s</A>\\n\', _email, _name);\n"
"}\n"
"--src admin.sql:4301\n"
;

static const char *proc108 = 
"#line 4321 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_add_dsn_option (in _val varchar, in _sel varchar)\n"
"{\n"
"\n"
"http (sprintf (\'<OPTION VALUE=\"%V\"\', _val));\n"
"\n"
"if (_val = _sel)\n"
"http (\' SELECTED\');\n"
"\n"
"http (sprintf (\'>%V</OPTION>\\r\\n\', _val));\n"
"\n"
"return;\n"
"}\n"
"--src admin.sql:4319\n"
;

static const char *proc109 = 
"#line 4337 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_get_file_dsn ()\n"
"{\n"
"declare idx, len integer;\n"
"declare name, s_root varchar;\n"
"declare ret, _all any;\n"
"declare _err_code, _err_message varchar;\n"
"declare exit handler for sqlstate \'*\' { _err_code := __SQL_STATE; _err_message := __SQL_MESSAGE; goto error; };\n"
"\n"
"if (not sys_dir_is_allowed (\'.\'))\n"
"goto error;\n"
"\n"
"_all := sys_dirlist (\'.\', 1);\n"
"s_root := server_root ();\n"
"\n"
"idx := 0;\n"
"len := length (_all);\n"
"ret := vector ();\n"
"\n"
"while (idx < len)\n"
"{\n"
"name := aref (_all, idx);\n"
"\n"
"if (strstr (name, \'.dsn\'))\n"
"ret := vector_concat (ret, vector (concat (s_root, name)));\n"
"\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"return ret;\n"
"\n"
"error:\n"
"return vector ();\n"
"}\n"
"--src admin.sql:4335\n"
;

static const char *proc110 = 
"#line 4375 \"[executable]/admin.sql\"\n"
"create procedure\n"
"getxmltype(in _id integer)\n"
"{\n"
"declare _type integer;\n"
"if (not exists(select 1 from WS.WS.SYS_DAV_RES\n"
"where RES_ID = _id and\n"
"lower(RES_NAME) like \'%.xml\'))\n"
"return -100;\n"
"else\n"
"_type := coalesce((select PROP_ID from WS.WS.SYS_DAV_PROP\n"
"where PROP_PARENT_ID = _id\n"
"and PROP_TYPE = \'R\'\n"
"and PROP_NAME = \'xml-sql\'),\n"
"-1);\n"
"return _type;\n"
"}\n"
"--src admin.sql:4373\n"
;

static const char *proc111 = 
"#line 4395 \"[executable]/admin.sql\"\n"
"create procedure\n"
"check_dav_perms(in _perms varchar)\n"
"{\n"
"declare i, l integer;\n"
"l := length(_perms);\n"
"if (l <> 10) return 1;\n"
"while (i < length(_perms))\n"
"{\n"
"if (strchr(\'01NRT\', aref(_perms, i)) is null) return 1;\n"
"i := i + 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src admin.sql:4393\n"
;

static const char *proc112 = 
"#line 4412 \"[executable]/admin.sql\"\n"
"create procedure\n"
"create_dav_col (in _col varchar, in _own integer, in _grp integer, in _perms varchar)\n"
"{\n"
"declare _path_v any;\n"
"declare _cname varchar;\n"
"declare _lp, _pid, _cid, ix, _flg integer;\n"
"if (not exists(select 1 from WS.WS.SYS_DAV_GROUP where G_ID = _grp))\n"
"return 2;\n"
"if (not exists(select 1 from WS.WS.SYS_DAV_USER where U_ID = _own))\n"
"return 3;\n"
"if (check_dav_perms(_perms) <> 0)\n"
"return 4;\n"
"if (aref(_col, 0) = ascii(\'/\'))\n"
"_col := \"right\"(_col, length(_col) - 1);\n"
"if (aref(_col, length(_col) - 1)  = ascii(\'/\'))\n"
"_col := \"left\"(_col, length(_col) - 1);\n"
"_path_v := split_and_decode(_col, 0, \'\\0\\0/\');\n"
"_path_v := WS.WS.FIXPATH (_path_v);\n"
"_lp := length(_path_v);\n"
"if (_lp < 1)\n"
"return 1;\n"
"if (aref(_path_v, 0) <> \'DAV\')\n"
"return 1;\n"
"while (ix < _lp)\n"
"{\n"
"if (aref(_path_v, ix) = \'\')\n"
"return 1;\n"
"ix := ix + 1;\n"
"}\n"
"ix := 0;\n"
"_pid := (select min(COL_PARENT) from WS.WS.SYS_DAV_COL);\n"
"_flg := 0;\n"
"while (ix < _lp)\n"
"{\n"
"_cname := aref(_path_v, ix);\n"
"if (exists(select 1 from WS.WS.SYS_DAV_COL\n"
"where COL_PARENT = _pid and COL_NAME = _cname))\n"
"_pid := (select COL_ID from WS.WS.SYS_DAV_COL\n"
"where COL_PARENT = _pid and COL_NAME = _cname);\n"
"else\n"
"{\n"
"_cid := WS.WS.GETID(\'C\');\n"
"insert into WS.WS.SYS_DAV_COL(COL_CR_TIME, COL_GROUP, COL_ID,\n"
"COL_MOD_TIME, COL_NAME, COL_OWNER, COL_PARENT, COL_PERMS)\n"
"values(now(), _grp, _cid, now(), _cname, _own, _pid, _perms);\n"
"_pid := _cid;\n"
"_flg := _flg + 1;\n"
"}\n"
"ix := ix + 1;\n"
"}\n"
"if (_flg = 0) return 7;\n"
"return 0;\n"
"}\n"
"--src admin.sql:4410\n"
;

static const char *proc113 = 
"#line 4469 \"[executable]/admin.sql\"\n"
"create procedure\n"
"create_dav_file (inout _file any, in _name varchar, in _own integer, in _grp integer,\n"
"in _perms varchar, in _col integer, in _rpl integer, in mime_type varchar)\n"
"{\n"
"declare _path, _full_name, _res_type varchar;\n"
"_path := get_dav_path(_col);\n"
"if (_path = \'\')\n"
"return 1;\n"
"if (not exists(select 1 from WS.WS.SYS_DAV_GROUP where G_ID = _grp))\n"
"return 2;\n"
"if (not exists(select 1 from WS.WS.SYS_DAV_USER where U_ID = _own))\n"
"return 3;\n"
"if (check_dav_perms(_perms) <> 0)\n"
"return 4;\n"
"if (strchr (_name, \'/\') is not null)\n"
"return 6;\n"
"\n"
"_full_name := concat(_path, \'/\', _name);\n"
"_full_name := WS.WS.FIXPATH(_full_name);\n"
"if (isstring(mime_type) and (mime_type like \'%/%\' or mime_type like \'link:%\'))\n"
"_res_type := mime_type;\n"
"else\n"
"_res_type := http_mime_type(_name);\n"
"if (exists(select 1 from WS.WS.SYS_DAV_RES\n"
"where RES_FULL_PATH = _full_name))\n"
"{\n"
"if (_rpl = 0) return 5;\n"
"update WS.WS.SYS_DAV_RES set RES_CONTENT = _file,\n"
"RES_GROUP = _grp, RES_MOD_TIME = now(),\n"
"RES_OWNER = _own, RES_PERMS = _perms\n"
"where RES_FULL_PATH = _full_name;\n"
"}\n"
"else insert into WS.WS.SYS_DAV_RES(RES_COL, RES_CONTENT, RES_CR_TIME,\n"
"RES_FULL_PATH, RES_GROUP, RES_ID, RES_MOD_TIME, RES_NAME,\n"
"RES_OWNER, RES_PERMS, RES_TYPE)\n"
"values(_col, _file, now(), _full_name, _grp, WS.WS.GETID(\'R\'),\n"
"now(), _name, _own, _perms, _res_type);\n"
"}\n"
"--src admin.sql:4467\n"
;

static const char *proc114 = 
"#line 4512 \"[executable]/admin.sql\"\n"
"create procedure get_dav_path(in _col_id integer)\n"
"{\n"
"declare _pid, _min_id integer;\n"
"declare _path varchar;\n"
"_path := \'\';\n"
"_min_id := (select min(COL_PARENT) from WS.WS.SYS_DAV_COL);\n"
"_pid := _col_id;\n"
"whenever not found goto endproc;\n"
"while (_pid > _min_id)\n"
"{\n"
"select COL_PARENT, concat(\'/\', COL_NAME, _path)\n"
"into _pid, _path from WS..SYS_DAV_COL\n"
"where COL_ID = _pid;\n"
"}\n"
"endproc:\n"
"return _path;\n"
"}\n"
"--src admin.sql:4510\n"
;

static const char *proc115 = 
"#line 4533 \"[executable]/admin.sql\"\n"
"create procedure adm_get_init_name()\n"
"{\n"
"declare _all varchar;\n"
"\n"
"_all := virtuoso_ini_path();\n"
"\n"
"if (sys_stat(\'st_build_opsys_id\') = \'Win32\')\n"
"{\n"
"while (length (_all) > 0)\n"
"{\n"
"declare pos integer;\n"
"pos := strstr (_all, \'\\\\\');\n"
"if (pos is NULL)\n"
"return _all;\n"
"_all := subseq (_all, pos + 1);\n"
"}\n"
"}\n"
"else\n"
"return _all;\n"
"}\n"
"--src admin.sql:4531\n"
;

static const char *proc116 = 
"#line 4555 \"[executable]/admin.sql\"\n"
"create procedure\n"
"adm_make_option_list (in opts any, in name varchar, in val varchar, in spare integer)\n"
"{\n"
"declare i, l, j, k integer;\n"
"declare ch varchar;\n"
"l := length (opts); i := 0;\n"
"j := 0; k := 1;\n"
"if (spare > 0)\n"
"{\n"
"j := 1;\n"
"k := 2;\n"
"}\n"
"http (sprintf (\'<select name=\"%s\">\', name));\n"
"while (i < l)\n"
"{\n"
"ch := \'\';\n"
"if (opts[i] = val)\n"
"ch := \'SELECTED\';\n"
"http (sprintf (\'<option value=\"%s\" %s>%s</option>\', opts[i+j], ch, opts[i]));\n"
"i := i + k;\n"
"}\n"
"http (\'</select>\');\n"
"}\n"
"--src admin.sql:4553\n"
;

static const char *proc117 = 
"#line 4582 \"[executable]/admin.sql\"\n"
"create procedure adm_is_hosted ()\n"
"{\n"
"declare ret integer;\n"
"\n"
"ret := 0;\n"
"\n"
"if (__proc_exists (\'aspx_get_temp_directory\', 2) is not NULL) ret := 1;\n"
"if (__proc_exists (\'java_load_class\', 2) is not NULL) ret := ret + 2;\n"
"\n"
"return ret;\n"
"}\n"
"--src admin.sql:4580\n"
;

static const char *proc118 = 
"#line 4596 \"[executable]/admin.sql\"\n"
"create procedure adm_hosted_file_filter ()\n"
"{\n"
"declare ret varchar;\n"
"declare _type integer;\n"
"\n"
"ret := \'NONE\';\n"
"_type := adm_is_hosted ();\n"
"\n"
"if (_type = 1) ret := \'*.dll,*.exe\';\n"
"if (_type = 2) ret := \'*.jar,*.zip,*.class\';\n"
"if (_type = 3) ret := \'*.dll,*.exe,*.jar,*.zip,*.class\';\n"
"\n"
"return ret;\n"
"}\n"
"--src admin.sql:4594\n"
;

static const char *proc119 = 
"#line 4612 \"[executable]/admin.sql\"\n"
"create procedure root_node_hosted_import (in path varchar)\n"
"{\n"
"declare idx_files, idx_types integer;\n"
"declare ret, know_types, files, know_files any;\n"
"\n"
"know_types := vector (\'.dll\', \'.exe\', \'.jar\', \'.zip\', \'.class\');\n"
"know_files := vector ();\n"
"files := sys_dirlist (path, 1);\n"
"idx_files := 0;\n"
"\n"
"while (idx_files < length (files))\n"
"{\n"
"idx_types := 0;\n"
"\n"
"\n"
"while (idx_types < length (know_types))\n"
"{\n"
"if (strstr (files[idx_files], know_types[idx_types]) is not NULL)\n"
"{\n"
"know_files := vector_concat (know_files, vector (files[idx_files]));\n"
"idx_types := length (know_types);\n"
"}\n"
"idx_types := idx_types + 1;\n"
"}\n"
"\n"
"idx_files := idx_files + 1;\n"
"}\n"
"\n"
"ret :=\n"
"vector_concat (sys_dirlist (path, 0), know_files);\n"
"\n"
"return ret;\n"
"}\n"
"--src admin.sql:4610\n"
;

static const char *proc120 = 
"#line 4647 \"[executable]/admin.sql\"\n"
"create procedure get_result (in _in varchar)\n"
"{\n"
"\n"
"declare _type, _class varchar;\n"
"declare idx integer;\n"
"declare _list any;\n"
"\n"
"\n"
"_list := udt_find_by_ext_type (\'clr\');\n"
"idx := 0;\n"
"\n"
"RESULT_NAMES (_type, _class);\n"
"\n"
"while (idx < length (_list))\n"
"{\n"
"if (_list[idx] not in\n"
"(\'\"DB\".\"DBA\".\"_Type\"\',\n"
"\'\"DB\".\"DBA\".\"Assembly\"\',\n"
"\'\"DB\".\"DBA\".\"AssemFildInfo\"\',\n"
"\'\"DB\".\"DBA\".\"AssemblyMethod\"\',\n"
"\'\"DB\".\"DBA\".\"ParameterInfo\"\',\n"
"\'\"DB\".\"DBA\".\"ConstructorInfo\"\',\n"
"\'\"DB\".\"DBA\".\"VInvoke\"\',\n"
"\'\"DB\".\"DBA\".\"Virt_aspx_VirtHostUnix\"\',\n"
"\'\"DB\".\"DBA\".\"Virt_aspx_VirtHost\"\',\n"
"\'\"DB\".\"DBA\".\"Virt_aspx_VirtHost+Caller\"\'))\n"
"RESULT (\'clr\', replace (_list[idx], \'\"\', \'\'));\n"
"idx := idx + 1;\n"
"}\n"
"\n"
"_list := udt_find_by_ext_type (\'java\');\n"
"idx := 0;\n"
"\n"
"while (idx < length (_list))\n"
"{\n"
"RESULT (\'java\', replace (_list[idx], \'\"\', \'\'));\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"--src admin.sql:4645\n"
;

static const char *proc121 = 
"#line 4688 \"[executable]/admin.sql\"\n"
"create procedure import_get_types_result (in file_name varchar)\n"
"{\n"
"declare _class varchar;\n"
"declare idx integer;\n"
"declare vec any;\n"
"\n"
"RESULT_NAMES (_class);\n"
"\n"
"if (exists (select 1 from DB.DBA.CLR_VAC where VAC_INTERNAL_NAME = file_name))\n"
"{\n"
"declare temp_name varchar;\n"
"select VAC_REAL_NAME into temp_name from DB.DBA.CLR_VAC where VAC_INTERNAL_NAME = file_name;\n"
"file_name := temp_name || \'.dll\';\n"
"}\n"
"\n"
"idx := 0;\n"
"vec := import_get_types (file_name);\n"
"\n"
"while (idx < length (vec))\n"
"{\n"
"RESULT (vec[idx]);\n"
"idx := idx + 1;\n"
"}\n"
"}\n"
"--src admin.sql:4686\n"
;

static const char *proc122 = 
"#line 4715 \"[executable]/admin.sql\"\n"
"create procedure import_get_types (in sel_name varchar)\n"
"{\n"
"if (__proc_exists (\'DB.DBA.import_get_types_int\', 1) is NULL)\n"
"return vector ();\n"
"return DB.DBA.import_get_types_int (sel_name);\n"
"}\n"
"--src admin.sql:4713\n"
;

static const char *proc123 = 
"#line 4724 \"[executable]/admin.sql\"\n"
"create procedure import_file (in mtd_name varchar, in assem_name varchar,\n"
"in grants integer := 0, in restriction integer := 0, in output_sql integer := 0)\n"
"{\n"
"if ((strstr (assem_name, \'.dll\') is not NULL) or\n"
"(strstr (assem_name, \'.exe\') is not NULL))\n"
"{\n"
"\n"
"\n"
"\n"
"if (strstr (assem_name, \'/\') is NULL)\n"
"{\n"
"assem_name := replace (assem_name, \'.dll\', \'\');\n"
"assem_name := replace (assem_name, \'.exe\', \'\');\n"
"}\n"
"\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"return __SQL_MESSAGE;\n"
"};\n"
"\n"
"mtd_name := replace (mtd_name, \'_\', \'.\');\n"
"\n"
"if (output_sql)\n"
"return import_clr (assem_name, mtd_name, unrestricted=>restriction, _is_return_sql=>1);\n"
"\n"
"DB.DBA.CLR_CREATE_LIBRARY_UI (assem_name, mtd_name, restriction);\n"
"\n"
"if (grants)\n"
"import_clr_grant_to_public (assem_name, mtd_name);\n"
"}\n"
"}\n"
"\n"
"else if (strstr (assem_name, \'.class\') is not NULL)\n"
"{\n"
"\n"
"\n"
"\n"
"\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"return __SQL_MESSAGE;\n"
"};\n"
"\n"
"if (output_sql)\n"
"return import_jar (NULL, import_get_types (assem_name), unrestricted=>restriction, _is_return_sql=>1);\n"
"\n"
"import_jar (NULL, import_get_types (assem_name));\n"
"\n"
"}\n"
"}\n"
"else if ((strstr (assem_name, \'.jar\') is not NULL) or\n"
"(strstr (assem_name, \'.zip\') is not NULL))\n"
"{\n"
"\n"
"\n"
"\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"return __SQL_MESSAGE;\n"
"};\n"
"mtd_name := replace (mtd_name, \'.class\', \'\');\n"
"if (output_sql)\n"
"return import_jar (assem_name, mtd_name, unrestricted=>restriction, _is_return_sql=>1);\n"
"import_jar (assem_name, mtd_name);\n"
"}\n"
"}\n"
"else\n"
"{\n"
"return \'Can\'\'t import file\';\n"
"}\n"
"\n"
"return \'Loaded\';\n"
"}\n"
"--src admin.sql:4722\n"
;

static const char *proc124 = 
"#line 4803 \"[executable]/admin.sql\"\n"
"create procedure adm_import_get_selection_checkbox\n"
"(in _what varchar, in _mask varchar, in _all any, inout _beg integer)\n"
"{\n"
"declare idx, len integer;\n"
"\n"
"idx := _beg;\n"
"len := _beg + 8;\n"
"\n"
"if (len > length (_all))\n"
"len := length (_all);\n"
"\n"
"while (idx < len)\n"
"{\n"
"if (_all[idx] like _what and _all[idx + 1] = _mask)\n"
"return 1;\n"
"idx := idx + 2;\n"
"}\n"
"\n"
"return 0;\n"
"}\n"
"--src admin.sql:4801\n"
;

static const char *proc125 = 
"#line 4826 \"[executable]/admin.sql\"\n"
"create procedure adm_import_get_values\n"
"(in _all integer, inout grants integer,\n"
"inout proxy integer, inout restricted integer)\n"
"{\n"
"restricted := mod (_all, 2);\n"
"_all := _all / 2;\n"
"grants := mod (_all, 2);\n"
"_all := _all / 2;\n"
"proxy := mod (_all, 2);\n"
"_all := _all / 2;\n"
"}\n"
"--src admin.sql:4824\n"
;

static const char *view0 = 
"create procedure view DEFINED_TYPES as get_result (_in) (_type varchar, _class varchar)\n";

static const char *view1 = 
"create procedure view CLASS_LIST as import_get_types_result (_in) (_class varchar)\n";

static const char *proc126 = 
"#line 4847 \"[executable]/admin.sql\"\n"
"create procedure adm_input_vec (in _name varchar, in _vec any)\n"
"{\n"
"declare _n integer;\n"
"_n := 1;\n"
"http (concat (\'<select name=\"\', _name, \'\">\'));\n"
"while (_n <= length (_vec))\n"
"{\n"
"http (sprintf (\'<option label=\"%s\" value=\"%02d\">%s</option>\',\n"
"aref (_vec, _n - 1), _n, aref (_vec, _n - 1)));\n"
"_n := _n + 1;\n"
"}\n"
"http (\'</select>\');\n"
"}\n"
"--src admin.sql:4845\n"
;

static const char *proc127 = 
"#line 4862 \"[executable]/admin.sql\"\n"
"create procedure adm_input_num (in _name varchar, in _from integer, in _to integer)\n"
"{\n"
"http (concat (\'<select name=\"\', _name, \'\">\'));\n"
"declare _n integer;\n"
"_n := _from;\n"
"while (_n <= _to)\n"
"{\n"
"http (sprintf (\'<option label=\"%02d\" value=\"%02d\">%02d</option>\',\n"
"_n, _n, _n));\n"
"_n := _n + 1;\n"
"}\n"
"http (\'</select>\');\n"
"}\n"
"--src admin.sql:4860\n"
;

static const char *proc128 = 
"#line 4877 \"[executable]/admin.sql\"\n"
"create procedure adm_input_time (in _prefix varchar)\n"
"{\n"
"http (\'<table border=\"0\"><tr><td>\');\n"
"adm_input_num (concat (_prefix, \'_hour\'), 0, 23);\n"
"http (\'</td><td>\');\n"
"adm_input_num (concat (_prefix, \'_min\'), 0, 59);\n"
"http (\'</td></table>\');\n"
"}\n"
"--src admin.sql:4875\n"
;

static const char *proc129 = 
"#line 4887 \"[executable]/admin.sql\"\n"
"create procedure adm_config_purger_form (in _srv varchar, in _acct varchar)\n"
"{\n"
"declare _months any;\n"
"_months := vector (\n"
"\'Jan\', \'Feb\', \'Mar\', \'Apr\', \'May\', \'Jun\',\n"
"\'Jul\', \'Aug\', \'Sep\', \'Oct\', \'Nov\', \'Dec\');\n"
"declare _wdays any;\n"
"_wdays := vector (\'Mon\', \'Tue\', \'Wed\', \'Thu\', \'Fri\', \'Sat\', \'Sun\');\n"
"\n"
"declare _month, _day, _wday integer;\n"
"declare _time time;\n"
"select coalesce (P_MONTH, 0), coalesce (P_DAY, 0), coalesce (P_WDAY, 0), P_TIME\n"
"into _month, _day, _wday, _time\n"
"from SYS_REPL_ACCOUNTS where SERVER = _srv and ACCOUNT = _acct;\n"
"\n"
"if (_time is not null)\n"
"{\n"
"http (\'Purger configured to run \');\n"
"if (_month <> 0)\n"
"{\n"
"if (_day = 0)\n"
"_day := 1;\n"
"http (sprintf (\'yearly on <strong>%d %s</strong>\',\n"
"_day, aref (_months, _month - 1)));\n"
"}\n"
"else if (_day <> 0)\n"
"{\n"
"http (sprintf (\'monthly on <strong>%d</strong>\', _day));\n"
"}\n"
"else if (_wday <> 0)\n"
"{\n"
"http (sprintf (\'weekly on <strong>%s</strong>\', aref (_wdays, _wday - 1)));\n"
"}\n"
"else\n"
"{\n"
"http (\'daily\');\n"
"}\n"
"declare _datestr varchar;\n"
"_datestr := datestring (_time);\n"
"\n"
"http (concat (\' at <strong>\', _datestr, \'</strong>.<br>\'));\n"
"\n"
"whenever not found goto nf;\n"
"declare _nextrun datetime;\n"
"select dateadd (\'minute\', SE_INTERVAL, SE_LAST_COMPLETED) into _nextrun\n"
"from SYS_SCHEDULED_EVENT\n"
"where SE_NAME = concat (\'repl_purge_\', _srv, \'_\', _acct)\n"
"and SE_LAST_COMPLETED is not null;\n"
"if (_nextrun is not null and _nextrun > now())\n"
"{\n"
"http (concat (\'Next purger run scheduled on: <strong>\',\n"
"adm_date_fmt (_nextrun), \'</strong>.<br>\'));\n"
"}\n"
"nf:\n"
" ;\n"
"}\n"
"else\n"
"{\n"
"http (\'Purger is not configured for this account.<br>\');\n"
"}\n"
"\n"
"http (\'<table class=\"genlist\" border=\"0\" cellpadding=\"0\"><tr>\');\n"
"http (\'<td><input type=submit name=\"purge_now\" value=\"Purge now\"></td>\');\n"
"http (\'<td><input type=submit name=\"purge_never\" value=\"Disable purger\"></td>\');\n"
"http (\'</tr></table>\');\n"
"\n"
"http (\'Configure purger to be run:\');\n"
"http (\'<table class=\"genlist\" border=\"0\" cellpadding=\"0\">\');\n"
"\n"
"http (\'<tr>\');\n"
"http (\'<td><strong>Yearly:</strong></td>\');\n"
"http (\'<td>\'); adm_input_num (\'yearly_day\', 1, 31); http (\'</td>\');\n"
"http (\'<td>\'); adm_input_vec (\'yearly_month\', _months); http (\'</td>\');\n"
"http (\'<td>Time:</td>\');\n"
"http (\'<td>\'); adm_input_time(\'yearly\'); http (\'</td>\');\n"
"http (\'<td><input type=submit name=\"purge_yearly\" value=\"Set\"></td>\');\n"
"http (\'</tr>\');\n"
"\n"
"http (\'<tr>\');\n"
"http (\'<td><strong>Monthly:</strong></td>\');\n"
"http (\'<td>&nbsp;</td>\');\n"
"http (\'<td>\'); adm_input_num (\'monthly_day\', 1, 31); http (\'</td>\');\n"
"http (\'<td>Time:</td>\');\n"
"http (\'<td>\'); adm_input_time(\'monthly\'); http (\'</td>\');\n"
"http (\'<td><input type=submit name=\"purge_monthly\" value=\"Set\"></td>\');\n"
"http (\'</tr>\');\n"
"\n"
"http (\'<tr>\');\n"
"http (\'<td><strong>Weekly:</strong></td>\');\n"
"http (\'<td>&nbsp;</td>\');\n"
"http (\'<td>\'); adm_input_vec (\'weekly_wday\', _wdays); http (\'</td>\');\n"
"http (\'<td>Time:</td>\');\n"
"http (\'<td>\'); adm_input_time(\'weekly\'); http (\'</td>\');\n"
"http (\'<td><input type=submit name=\"purge_weekly\" value=\"Set\"></td>\');\n"
"http (\'</tr>\');\n"
"\n"
"http (\'<td><strong>Daily:</strong></td>\');\n"
"http (\'<td>&nbsp;</td>\');\n"
"http (\'<td>&nbsp;</td>\');\n"
"http (\'<td>Time:</td>\');\n"
"http (\'<td>\'); adm_input_time(\'daily\'); http (\'</td>\');\n"
"http (\'<td><input type=submit name=\"purge_daily\" value=\"Set\"></td>\');\n"
"http (\'</tr>\');\n"
"\n"
"http (\'</table>\');\n"
"}\n"
"--src admin.sql:4885\n"
;

static const char *proc130 = 
"#line 4995 \"[executable]/admin.sql\"\n"
"create procedure adm_config_purger_actions (in _srv varchar, in _acct varchar,\n"
"inout _params any)\n"
"{\n"
"if (\'\' <> get_keyword (\'purge_now\', _params, \'\'))\n"
"{\n"
"repl_purge (_srv, _acct);\n"
"}\n"
"if (\'\' <> get_keyword (\'purge_never\', _params, \'\'))\n"
"{\n"
"update SYS_REPL_ACCOUNTS set P_MONTH = null, P_DAY = null,\n"
"P_WDAY = null, P_TIME = null\n"
"where SERVER = _srv and ACCOUNT = _acct;\n"
"repl_changed ();\n"
"delete from SYS_SCHEDULED_EVENT\n"
"where SE_NAME = concat (\'repl_purge_\', _srv, \'_\', _acct);\n"
"}\n"
"if (\'\' <> get_keyword (\'purge_yearly\', _params, \'\'))\n"
"{\n"
"declare _month, _day integer;\n"
"_month := get_keyword (\'yearly_month\', _params, 1);\n"
"_day := get_keyword (\'yearly_day\', _params, 1);\n"
"\n"
"declare _hour, _min integer;\n"
"_hour := get_keyword (\'yearly_hour\', _params, 0);\n"
"_min := get_keyword (\'yearly_min\', _params, 0);\n"
"declare _time time;\n"
"_time := stringtime (concat (_hour, \':\', _min));\n"
"\n"
"update SYS_REPL_ACCOUNTS set P_MONTH = _month, P_DAY = _day,\n"
"P_WDAY = null, P_TIME = _time\n"
"where SERVER = _srv and ACCOUNT = _acct;\n"
"repl_changed ();\n"
"repl_sched_purger (_srv, _acct);\n"
"}\n"
"if (\'\' <> get_keyword (\'purge_monthly\', _params, \'\'))\n"
"{\n"
"declare _day integer;\n"
"_day := get_keyword (\'monthly_day\', _params, 1);\n"
"\n"
"declare _hour, _min integer;\n"
"_hour := get_keyword (\'monthly_hour\', _params, 0);\n"
"_min := get_keyword (\'monthly_min\', _params, 0);\n"
"declare _time time;\n"
"_time := stringtime (concat (_hour, \':\', _min));\n"
"\n"
"update SYS_REPL_ACCOUNTS set P_MONTH = null, P_DAY = _day,\n"
"P_WDAY = null, P_TIME = _time\n"
"where SERVER = _srv and ACCOUNT = _acct;\n"
"repl_changed ();\n"
"repl_sched_purger (_srv, _acct);\n"
"}\n"
"if (\'\' <> get_keyword (\'purge_weekly\', _params, \'\'))\n"
"{\n"
"declare _wday integer;\n"
"_wday := get_keyword (\'weekly_wday\', _params, 1);\n"
"\n"
"declare _hour, _min integer;\n"
"_hour := get_keyword (\'weekly_hour\', _params, 0);\n"
"_min := get_keyword (\'weekly_min\', _params, 0);\n"
"declare _time time;\n"
"_time := stringtime (concat (_hour, \':\', _min));\n"
"\n"
"update SYS_REPL_ACCOUNTS set P_MONTH = null, P_DAY = null,\n"
"P_WDAY = _wday, P_TIME = _time\n"
"where SERVER = _srv and ACCOUNT = _acct;\n"
"repl_changed ();\n"
"repl_sched_purger (_srv, _acct);\n"
"}\n"
"if (\'\' <> get_keyword (\'purge_daily\', _params, \'\'))\n"
"{\n"
"declare _hour, _min integer;\n"
"_hour := get_keyword (\'daily_hour\', _params, 0);\n"
"_min := get_keyword (\'daily_min\', _params, 0);\n"
"declare _time time;\n"
"_time := stringtime (concat (_hour, \':\', _min));\n"
"\n"
"update SYS_REPL_ACCOUNTS set P_MONTH = null, P_DAY = null,\n"
"P_WDAY = null, P_TIME = _time\n"
"where SERVER = _srv and ACCOUNT = _acct;\n"
"repl_changed ();\n"
"repl_sched_purger (_srv, _acct);\n"
"}\n"
"}\n"
"--src admin.sql:4993\n"
;

static const char *proc131 = 
"#line 5080 \"[executable]/admin.sql\"\n"
"create procedure adm_lt_status_display (in _lts_type varchar, in params varchar, in _dsn varchar)\n"
"{\n"
"declare idx, pos integer;\n"
"declare _lts_remote_name, _lts_local_name varchar;\n"
"declare _lts_type_name varchar;\n"
"\n"
"_lts_type_name :=\n"
"case _lts_type\n"
"when \'S\' then \'System Table\'\n"
"when \'V\' then \'View\'\n"
"else \'Table\'\n"
"end;\n"
"while (pos := adm_next_checkbox (concat (\'TBL_\', _lts_type), params, idx))\n"
"{\n"
"_lts_remote_name := get_keyword (concat (\'R_NAME_\', _lts_type, pos), params, \'\');\n"
"_lts_remote_name := deserialize (decode_base64 (_lts_remote_name));\n"
"if (length (_lts_remote_name) = 2)\n"
"_lts_remote_name := concat (aref (_lts_remote_name, 0), \'.\',\n"
"aref (_lts_remote_name, 1));\n"
"else\n"
"_lts_remote_name := aref (_lts_remote_name, 0);\n"
"_lts_local_name := concat (\n"
"get_keyword (concat (\'dbqual_\', _lts_type, pos), params, \'\'),\n"
"\'.\',\n"
"get_keyword (concat (\'dbuser_\', _lts_type, pos), params, adm_lt_make_dsn_part (_dsn)),\n"
"\'.\',\n"
"get_keyword (concat (\'TBL_NAME_\', _lts_type, pos), params, \'\')\n"
");\n"
"http (\'<TR>\');\n"
"http (sprintf (\'<TD class=\"gendata\">%s</TD>\', _lts_remote_name));\n"
"http (sprintf (\'<TD class=\"gendata\">%s</TD>\', _lts_type_name));\n"
"http (sprintf (\'<TD class=\"gendata\">%s</TD>\', _dsn));\n"
"http (sprintf (\'<TD class=\"gendata\">%s</TD>\', _lts_local_name));\n"
"http (\'</TR>\');\n"
"}\n"
"}\n"
"--src admin.sql:5078\n"
;

static const char *proc132 = 
"#line 5118 \"[executable]/admin.sql\"\n"
"create procedure adm_opt_array_to_rs (in opt_array any)\n"
"{\n"
"declare inx integer;\n"
"declare OPT_NAME, OPT_VALUE varchar;\n"
"\n"
"result_names (OPT_NAME, OPT_VALUE);\n"
"\n"
"inx := 0;\n"
"\n"
"if (not isarray (opt_array) or mod (length (opt_array), 2) <> 0)\n"
"return;\n"
"\n"
"while (inx < length (opt_array))\n"
"{\n"
"if (opt_array[inx] like \'___\\_page\')\n"
"result (opt_array [inx], opt_array[inx + 1]);\n"
"inx := inx + 2;\n"
"}\n"
"}\n"
"--src admin.sql:5116\n"
;

static const char *view2 = 
"create procedure view ADM_OPT_ARRAY_TO_RS_PVIEW as\n"
"adm_opt_array_to_rs (OPT_ARRAY) (OPT_NAME varchar, OPT_VALUE varchar)\n";

static const char *proc133 = 
"#line 5144 \"[executable]/admin.sql\"\n"
"create procedure ADM_KEYWORD_VALUE_SET (inout _opt_array any, in _key varchar, in _new_val any)\n"
"{\n"
"declare inx integer;\n"
"inx := 0;\n"
"\n"
"if (not isarray (_opt_array))\n"
"return;\n"
"\n"
"while (inx < length (_opt_array))\n"
"{\n"
"if (_opt_array[inx] = _key)\n"
"{\n"
"_opt_array[inx + 1] := _new_val;\n"
"return 1;\n"
"}\n"
"inx := inx + 2;\n"
"}\n"
"_opt_array := vector_concat (_opt_array, vector (_key, _new_val));\n"
"return 0;\n"
"}\n"
"--src admin.sql:5142\n"
;

static const char *proc134 = 
"#line 5166 \"[executable]/admin.sql\"\n"
"create procedure ADM_INDENT_XML (in _xml any) returns varchar\n"
"{\n"
"declare _ses, _res any;\n"
"declare _lines any;\n"
"declare _linecount, _linectr, _depth, _mode integer;\n"
"declare _curline, _prn varchar;\n"
"_ses := string_output();\n"
"if (isstring (_xml) or not isarray(_xml))\n"
"{\n"
"http_value (_xml, null, _ses);\n"
"}\n"
"else\n"
"{\n"
"declare _ctr, _len integer;\n"
"_len := length (_xml);\n"
"_ctr := 0;\n"
"while (_ctr < _len)\n"
"{\n"
"http_value (aref (_xml, _ctr), null, _ses);\n"
"_ctr := _ctr + 1;\n"
"}\n"
"}\n"
"_lines := split_and_decode (string_output_string(_ses),0,\'\\0\\0>\');\n"
"_res := string_output();\n"
"_linecount := length (_lines);\n"
"_linectr := 0;\n"
"_depth := 0;\n"
"while (_linectr < _linecount)\n"
"{\n"
"_curline := trim(aref(_lines,_linectr), \' \\n\\r\\t\');\n"
"if (_linectr < _linecount-1)\n"
"_curline := concat (_curline, \'>\');\n"
"if (_curline<>\'\')\n"
"{\n"
"_mode := 0;\n"
"if (aref (_curline, 0) <> 60)\n"
"_mode := 1;\n"
"if (_mode <> 1)\n"
"{\n"
"if (\n"
"strstr (_curline, \'<!--\') is not null or\n"
"strstr (_curline, \'<first\') is not null or\n"
"strstr (_curline, \'<last\') is not null\n"
")\n"
"_mode := 1;\n"
"}\n"
"if (strstr (_curline, \'</\') is not null)\n"
"_depth := _depth - 1;\n"
"if (_mode <> 1)\n"
"{\n"
"http (\'<BR>\', _res);\n"
"http (repeat (\'&nbsp;\', _depth * 2), _res);\n"
"}\n"
"_prn := _curline;\n"
"_prn := replace (_prn, \'&apos;\', \'&#39;\');\n"
"_prn := replace (_prn, \'<\', \'#<<#\');\n"
"_prn := replace (_prn, \'>\', \'#>>#\');\n"
"_prn := replace (_prn, \'#<<#!--\',\n"
"\'<BR><FONT COLOR=\"990000\">&lt;!--\');\n"
"_prn := replace (_prn, \'#<<#\', \'<FONT COLOR=\"000099\">&lt;\');\n"
"_prn := replace (_prn, \'#>>#\', \'&gt;</FONT>\');\n"
"http (_prn, _res);\n"
"if (	strstr (_curline, \'</\') is null and\n"
"strstr (_curline, \'/>\') is null and\n"
"strstr (_curline, \'<!--\') is null )\n"
"_depth := _depth + 1;\n"
"}\n"
"_linectr := _linectr + 1;\n"
"}\n"
"return string_output_string(_res);\n"
"}\n"
"--src admin.sql:5164\n"
;

static const char *proc135 = 
"#line 5239 \"[executable]/admin.sql\"\n"
"create procedure adm_xml_get_flag (in cont any)\n"
"{\n"
"declare lexems any;\n"
"declare lex_text varchar;\n"
"declare len, flag, pos, i integer;\n"
"\n"
"lexems := sql_lex_analyze(cont);\n"
"len := length(lexems);\n"
"flag := 0;\n"
"i :=  length (aref(lexems,len-1));\n"
"if (i = 3 and len > 3) {\n"
"i := len -1;\n"
"while (i >= 0) {\n"
"lex_text := upper(aref(aref(lexems,i),1));\n"
"if (lex_text = \'XML\' and flag = 0)\n"
"{\n"
"flag:=1;\n"
"pos := i;\n"
"}\n"
"else if (lex_text = \'FOR\' and flag = 1 and pos = (i+1) )\n"
"{\n"
"flag := 2;\n"
"}\n"
"i := i-1;\n"
"}\n"
"}\n"
"\n"
"return flag;\n"
"\n"
"}\n"
"--src admin.sql:5237\n"
;

static const char *proc136 = 
"#line 5272 \"[executable]/admin.sql\"\n"
"create procedure adm_xml_make_xmlelement (in _stmt any, in r_node varchar)\n"
"{\n"
"declare err_sqlstate, err_msg, m_dta, sqlx_result, _rows, row_data, ses, st any;\n"
"declare nrow, cols, ncol, mflag integer;\n"
"declare ret_error varchar;\n"
"\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"ret_error := sprintf(\'Query execution error: %s\',__SQL_MESSAGE);\n"
"return vector (1, ret_error);\n"
"};\n"
"exec (_stmt, err_sqlstate, err_msg, vector(),100, m_dta, sqlx_result);\n"
"}\n"
"\n"
"if (err_sqlstate <> 0)\n"
"{\n"
"ret_error := sprintf(\'Query execution error: %s\',err_msg);\n"
"}\n"
"\n"
"_rows :=  length (sqlx_result);\n"
"nrow := 0;\n"
"\n"
"while (nrow < _rows)\n"
"{\n"
"row_data := aref(sqlx_result, nrow);\n"
"cols := length(row_data);\n"
"ncol := 0;\n"
"mflag := 0;\n"
"\n"
"while (ncol < cols)\n"
"{\n"
"if (aref (row_data, ncol) is not null)\n"
"{\n"
"if (mflag = 0)\n"
"{\n"
"ses := aref(row_data, ncol);\n"
"mflag := 1;\n"
"}\n"
"else\n"
"ses := XMLCONCAT(ses, aref (row_data, ncol));\n"
"}\n"
"ncol := ncol + 1;\n"
"}\n"
"nrow := nrow + 1;\n"
"}\n"
"\n"
"ses := XMLELEMENT(sprintf(\'%s\', r_node),ses);\n"
"st := string_output ();\n"
"http_value(ses,0,st);\n"
"\n"
"return vector (0, string_output_string(st));\n"
"}\n"
"--src admin.sql:5270\n"
;

static const char *proc137 = 
"#line 5328 \"[executable]/admin.sql\"\n"
"create procedure adm_map_xml_build (in _stmt any, in r_node varchar, in _mxml varchar)\n"
"{\n"
"declare err_sqlstate, err_msg, m_dta, sqlx_result, _rows, row_data, ses, st any;\n"
"declare nrow, cols, ncol, mflag integer;\n"
"declare ret_error, _text, _all varchar;\n"
"\n"
"if (trim (_stmt) = \'\')\n"
"_stmt := \'/*\';\n"
"\n"
"_mxml := replace (_mxml, \'DB.DBA.\', \'\', 1);\n"
"\n"
"_text := \'XPATH [__view \'\'\' || _mxml || \'\'\'] \' || _stmt;\n"
"\n"
"{\n"
"declare exit handler for sqlstate \'*\'\n"
"{\n"
"ret_error := sprintf(\'Query execution error: %s\',__SQL_MESSAGE);\n"
"return vector (1, ret_error);\n"
"};\n"
"exec (_text, err_sqlstate, err_msg, vector(),100, m_dta, sqlx_result);\n"
"}\n"
"\n"
"if (err_sqlstate <> 0)\n"
"{\n"
"ret_error := sprintf(\'Query execution error: %s\',err_msg);\n"
"}\n"
"\n"
"if (isinteger (sqlx_result))\n"
"return vector (1, \'This is not valid query.\');\n"
"\n"
"_rows :=  length (sqlx_result);\n"
"nrow := 0;\n"
"\n"
"while (nrow < _rows)\n"
"{\n"
"row_data := aref(sqlx_result, nrow);\n"
"cols := length(row_data);\n"
"ncol := 0;\n"
"mflag := 0;\n"
"\n"
"while (ncol < cols)\n"
"{\n"
"if (aref (row_data, ncol) is not null)\n"
"{\n"
"if (mflag = 0)\n"
"{\n"
"ses := aref(row_data, ncol);\n"
"mflag := 1;\n"
"}\n"
"else\n"
"ses := XMLCONCAT(ses, aref (row_data, ncol));\n"
"}\n"
"ncol := ncol + 1;\n"
"}\n"
"nrow := nrow + 1;\n"
"}\n"
"\n"
"ses := XMLELEMENT(sprintf(\'%s\', r_node),ses);\n"
"st := string_output ();\n"
"http_value(ses,0,st);\n"
"\n"
"return vector (0, string_output_string(st));\n"
"}\n"
"--src admin.sql:5326\n"
;

/* admin_dav_browser.sql */

static const char *proc138 = 
"#line 25 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_dav_br_get_uid (in lines any)\n"
"{\n"
"return 0;\n"
"}\n"
"--src admin_dav_browser.sql:23\n"
;

static const char *proc139 = 
"#line 34 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_dav_user_can_read_col_p (in uid integer, in col_id integer)\n"
"{\n"
"\n"
"\n"
"return col_id;\n"
"}\n"
"--src admin_dav_browser.sql:32\n"
;

static const char *proc140 = 
"#line 45 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_dav_user_can_read_res_p (in uid integer, in res_id integer)\n"
"{\n"
"\n"
"\n"
"return res_id;\n"
"}\n"
"--src admin_dav_browser.sql:43\n"
;

static const char *proc141 = 
"#line 54 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_dav_br_uid_to_user (in uid integer)\n"
"{\n"
"\n"
"declare _u_name varchar;\n"
"\n"
"if (uid is null)\n"
"return (\'DB NULL\');\n"
"\n"
"if (not exists (select 1 from \"WS\".\"WS\".\"SYS_DAV_USER\" where U_ID = uid))\n"
"{\n"
"dbg_printf (\'A collection/resource with non-existing owner, strange!\\n\');\n"
"return (sprintf (\'%d\', uid));\n"
"}\n"
"\n"
"select coalesce (U_NAME, \'\')\n"
"into _u_name\n"
"from WS.WS.SYS_DAV_USER\n"
"where U_ID = uid;\n"
"\n"
"if (isnull (_u_name))\n"
"{\n"
"return (sprintf (\'%d\', uid));\n"
"}\n"
"\n"
"return _u_name;\n"
"}\n"
"--src admin_dav_browser.sql:52\n"
;

static const char *proc142 = 
"#line 83 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_dav_br_uid_to_group (in uid integer)\n"
"{\n"
"\n"
"declare _u_name varchar;\n"
"\n"
"if (uid is null)\n"
"return (\'none\');\n"
"\n"
"if (not exists (select 1 from \"WS\".\"WS\".\"SYS_DAV_GROUP\" where G_ID = uid))\n"
"{\n"
"\n"
"return (sprintf (\'%d\', uid));\n"
"}\n"
"\n"
"select coalesce (G_NAME, \'\')\n"
"into _u_name\n"
"from WS.WS.SYS_DAV_GROUP\n"
"where G_ID = uid;\n"
"\n"
"if (isnull (_u_name))\n"
"{\n"
"return (sprintf (\'%d\', uid));\n"
"}\n"
"\n"
"return _u_name;\n"
"}\n"
"--src admin_dav_browser.sql:81\n"
;

static const char *proc143 = 
"#line 112 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_dav_br_fmt_perm (in obj_perm varchar)\n"
"{\n"
"\n"
"\n"
"return (obj_perm);\n"
"}\n"
"--src admin_dav_browser.sql:110\n"
;

static const char *proc144 = 
"#line 121 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_dav_br_list_error (in message varchar,\n"
"in cur_col integer,\n"
"in new_col integer,\n"
"in uid integer)\n"
"{\n"
"http (\'\');\n"
"http (\'Error: te\');\n"
"}\n"
"--src admin_dav_browser.sql:119\n"
;

static const char *proc145 = 
"#line 134 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_dav_br_map_icon (in type varchar)\n"
"{\n"
"if (\'folder\' = type)\n"
"return (\'images/16x16/folder.gif\');\n"
"if (\'application/pdf\' = type)\n"
"return (\'images/16x16/pdf.gif\');\n"
"if (\'application/ms-word\' = type or \'application/msword\' = type)\n"
"return (\'images/16x16/msword.gif\');\n"
"if (\'application/zip\' = type)\n"
"return (\'images/16x16/zip.gif\');\n"
"if (\'text/html\' = type)\n"
"return (\'images/16x16/html.gif\');\n"
"if (\'text\' = \"LEFT\" (type, 4))\n"
"return (\'images/16x16/text.gif\');\n"
"if (\'image\' = \"LEFT\" (type, 5))\n"
"return (\'images/16x16/image.gif\');\n"
"if (\'audio\' = \"LEFT\" (type, 5))\n"
"return (\'images/16x16/wave.gif\');\n"
"if (\'video\' = \"LEFT\" (type, 5))\n"
"return (\'images/16x16/video.gif\');\n"
"\n"
"return (\'images/16x16/generic_file.gif\');\n"
"}\n"
"--src admin_dav_browser.sql:132\n"
;

static const char *proc146 = 
"#line 164 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_dav_br_fmt_col (in obj_name varchar,\n"
"in col_id any,\n"
"in obj_size any,\n"
"in owner_uid integer,\n"
"in owner_gid integer,\n"
"in mod_time datetime,\n"
"in obj_perm varchar,\n"
"in lst_mode any,\n"
"in browse_mode any,\n"
"in os varchar := \'dav\')\n"
"{\n"
"declare img_tag varchar;\n"
"declare exec_anchor, sel_anchor varchar;\n"
"declare quot varchar;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"quot := \'\';\n"
"\n"
"if (os = \'os\')\n"
"quot := \'\\\'\';\n"
"\n"
"img_tag := sprintf (\'<img class=\"davfilelisticon\" src=\"%s\" />\',\n"
"adm_dav_br_map_icon (\'folder\'));\n"
"\n"
"exec_anchor := sprintf (\'<a class=\"imglink\" href=\"javascript:%s_cd (%s%s%s)\">\', os,\n"
"quot, cast (col_id as varchar), quot);\n"
"if (browse_mode = \'COL\' and obj_name <> \'..\' and obj_name <> \'.\')\n"
"{\n"
"declare curdir, pat varchar;\n"
"if (os = \'os\')\n"
"{\n"
"curdir := http_root ();\n"
"pat := cast (col_id as varchar);\n"
"}\n"
"else\n"
"{\n"
"curdir := \'\';\n"
"pat := WS.WS.COL_PATH (col_id);\n"
"}\n"
"\n"
"sel_anchor :=\n"
"sprintf (\'<a class=\"imglink\" href=\"javascript:dav_res_select (\'\'%s\'\', %s%s%s, \'\'%s%s\'\')\">\',\n"
"obj_name, quot, cast (col_id as varchar), quot, curdir, pat);\n"
"}\n"
"else\n"
"sel_anchor := exec_anchor;\n"
"\n"
"if (1 = lst_mode)\n"
"{\n"
"\n"
"return concat (\'<td width=\"16\" class=\"davfilelisticon\">\',\n"
"exec_anchor,\n"
"img_tag,\n"
"\'</a></td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistname\">\',\n"
"sel_anchor,\n"
"obj_name,\n"
"\'</a></td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistsize\">\',\n"
"cast (obj_size as varchar),\n"
"\'</td>\\n\',\n"
"\n"
"\'<td class=\"davfilelisttype\">\',\n"
"\'folder\',\n"
"\'</td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistuid\">\',\n"
"case os when \'dav\' then adm_dav_br_uid_to_user (owner_uid) else \'\' end,\n"
"\'</td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistuid\">\',\n"
"case os when \'dav\' then adm_dav_br_uid_to_group (owner_gid) else \'\' end,\n"
"\'</td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistmodtime\">\',\n"
"\"LEFT\" (cast (mod_time as varchar), 19),\n"
"\'</td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistpriv\">\',\n"
"case os when \'dav\' then adm_dav_format_perms (obj_perm) else \'\' end,\n"
"\'</td>\\n\');\n"
"}\n"
"}\n"
"--src admin_dav_browser.sql:162\n"
;

static const char *proc147 = 
"#line 260 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_dav_br_fmt_res (in res_type varchar,\n"
"in res_name varchar,\n"
"in res_full_path varchar,\n"
"in res_id integer,\n"
"in res_size integer,\n"
"in res_owner integer,\n"
"in res_group integer,\n"
"in res_mod_time datetime,\n"
"in res_perm varchar,\n"
"in lst_mode any,\n"
"in browse_mode any,\n"
"in os varchar := \'dav\')\n"
"{\n"
"declare img_tag varchar;\n"
"declare exec_anchor varchar;\n"
"\n"
"\n"
"img_tag := sprintf (\'<img class=\"davfilelisticon\" src=\"%s\" />\',\n"
"adm_dav_br_map_icon (res_type));\n"
"\n"
"res_full_path := replace (res_full_path, \'\\\\\', \'/\');\n"
"\n"
"if (\'STANDALONE\' = browse_mode)\n"
"{\n"
"exec_anchor :=\n"
"sprintf (\'<a class=\"imglink\" href=\"javascript:dav_res_view (\'\'%s\'\')\">\',\n"
"res_full_path);\n"
"}\n"
"else\n"
"{\n"
"exec_anchor :=\n"
"sprintf (\'<a class=\"imglink\" href=\"javascript:dav_res_select (\'\'%s\'\', %d, \'\'%s\'\')\">\',\n"
"res_name, res_id, res_full_path);\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"if (1 = lst_mode)\n"
"{\n"
"\n"
"return concat (\'<td width=\"16\" class=\"davfilelisticon\">\',\n"
"exec_anchor,\n"
"img_tag,\n"
"\'</a></td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistname\">\',\n"
"exec_anchor,\n"
"res_name,\n"
"\'</a></td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistsize\">\',\n"
"cast (res_size as varchar),\n"
"\'</td>\\n\',\n"
"\n"
"\'<td class=\"davfilelisttype\">\',\n"
"res_type,\n"
"\'</td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistuid\">\',\n"
"case os when \'dav\' then adm_dav_br_uid_to_user (res_owner) else \'\' end,\n"
"\'</td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistuid\">\',\n"
"case os when \'dav\' then adm_dav_br_uid_to_group (res_group) else \'\' end,\n"
"\'</td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistmodtime\">\',\n"
"\"LEFT\" (cast (res_mod_time as varchar), 19),\n"
"\'</td>\\n\',\n"
"\n"
"\'<td class=\"davfilelistpriv\">\',\n"
"case os when \'dav\' then adm_dav_format_perms (res_perm) else \'\' end,\n"
"\'</td>\\n\');\n"
"}\n"
"}\n"
"--src admin_dav_browser.sql:258\n"
;

static const char *proc148 = 
"#line 339 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_path_normalize (in path varchar)\n"
"{\n"
"declare res any;\n"
"declare arr any;\n"
"path := replace (path, \'\\\\\', \'/\');\n"
"if (path not like \'%/..%\')\n"
"return path;\n"
"arr := split_and_decode (path, 0, \'\\0\\0/\');\n"
"declare i, l int;\n"
"i := length (arr) - 1;\n"
"res := \'\';\n"
"while (i >= 0)\n"
"{\n"
"if (arr[i] = \'..\')\n"
"i := i - 1;\n"
"else if (arr [i] = \'.\')\n"
" ;\n"
"else if (arr [i] <> \'\' and arr[i] like \'_:\' and i = 0)\n"
"res := concat (arr[i], res);\n"
"else if (arr [i] <> \'\')\n"
"res := concat (\'/\', arr[i], res);\n"
"i := i - 1;\n"
"}\n"
"return res;\n"
"}\n"
"--src admin_dav_browser.sql:337\n"
;

static const char *proc149 = 
"#line 367 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_file_like (in name varchar, in pat varchar)\n"
"{\n"
"declare patts any;\n"
"if (pat = \'\') pat := \'*\';\n"
"patts := split_and_decode (pat, 0, \'\\0\\0,\');\n"
"declare i, l int;\n"
"i := 0; l := length (patts);\n"
"while (i < l)\n"
"{\n"
"if (patts[i] <> \'\' and name like patts[i])\n"
"return 1;\n"
"i := i + 1;\n"
"}\n"
"return 0;\n"
"}\n"
"--src admin_dav_browser.sql:365\n"
;

static const char *proc150 = 
"#line 385 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_os_br_gen_col_c_listing (in cur_path varchar,\n"
"in uid integer,\n"
"in flt_pat varchar,\n"
"in lst_mode any,\n"
"in browse_mode any,\n"
"in xfer_mode varchar)\n"
"{\n"
"declare parent_owner integer;\n"
"declare parent_group integer;\n"
"declare parent_mod_time datetime;\n"
"declare parent_perms varchar;\n"
"declare curdir varchar;\n"
"declare dirarr, filearr any;\n"
"declare i, l, flen int;\n"
"declare fst varchar;\n"
"declare modt datetime;\n"
"declare server_root_path varchar;\n"
"\n"
"server_root_path := server_root ();\n"
"\n"
"if (\"RIGHT\" (server_root_path, 1) = \'\\\\\')\n"
"server_root_path := \"LEFT\" (server_root_path, length (server_root_path) - 1);\n"
"\n"
"curdir := concat (server_root_path, cur_path);\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (flt_pat = \'\') flt_pat := \'%\';\n"
"\n"
"declare exit handler for sqlstate \'42000\'\n"
"{\n"
"if (length (__SQL_message) > 5)\n"
"{\n"
"if (\"LEFT\" (__SQL_message, 5) = \'FA018\')\n"
"{\n"
"http (\'<H3>In order to use browser please uncomment DirsAllowed in virtuoso.ini file\\n</H3>\');\n"
"}\n"
"}\n"
"};\n"
"\n"
"dirarr := sys_dirlist (curdir, 0, null, 1);\n"
"filearr := sys_dirlist (curdir, 1, null, 1);\n"
"\n"
"http (\'<table class=\"davbrfilelist\">\\n\');\n"
"i := 0; l := length (dirarr);\n"
"while (i < l)\n"
"{\n"
"fst := file_stat (concat (curdir, \'/\', dirarr[i]));\n"
"if (isstring (fst))\n"
"modt := stringdate (fst);\n"
"else\n"
"modt := now ();\n"
"if (dirarr[i] <> \'.\')\n"
"{\n"
"http (\'  <tr class=\"davbrfilelistrow\">\\n\');\n"
"http (adm_dav_br_fmt_col (dirarr[i], concat (cur_path, \'/\', dirarr[i]), \'N/A\',\n"
"0, 0, modt,\n"
"\'000000000T\', lst_mode, browse_mode, \'os\'));\n"
"}\n"
"http (\'  </tr>\');\n"
"i := i + 1;\n"
"}\n"
"\n"
"i := 0; l := length (filearr);\n"
"while (i < l)\n"
"{\n"
"if (adm_file_like (filearr[i], flt_pat))\n"
"{\n"
"fst := file_stat (concat (curdir, \'/\', filearr[i]));\n"
"flen := atoi(file_stat (concat (curdir, \'/\', filearr[i]), 1));\n"
"if (isstring (fst))\n"
"modt := stringdate (fst);\n"
"else\n"
"modt := now ();\n"
"http (\'  <tr class=\"davbrfilelistrow\">\\n\');\n"
"http (adm_dav_br_fmt_res (http_mime_type (filearr[i]), filearr[i], concat (curdir, \'/\', filearr[i]),\n"
"i, flen, 0, 0, modt,\n"
"\'000000000T\', lst_mode, browse_mode, \'os\'));\n"
"http (\'  </tr>\');\n"
"}\n"
"i := i + 1;\n"
"}\n"
"\n"
"http (\'</table>\\n\');\n"
"\n"
"}\n"
"--src admin_dav_browser.sql:383\n"
;

static const char *proc151 = 
"#line 476 \"[executable]/admin_dav_browser.sql\"\n"
"create procedure\n"
"adm_dav_br_gen_col_c_listing (in cur_col integer,\n"
"in new_col integer,\n"
"in cur_path varchar,\n"
"in uid integer,\n"
"in flt_pat varchar,\n"
"in lst_mode varchar,\n"
"in browse_mode varchar,\n"
"in xfer_mode varchar)\n"
"{\n"
"declare parent_owner integer;\n"
"declare parent_group integer;\n"
"declare _col_parent integer;\n"
"declare parent_mod_time datetime;\n"
"declare parent_perms varchar;\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"if (\'\' = flt_pat) flt_pat := \'%\';\n"
"\n"
"if (null = adm_dav_user_can_read_col_p (uid, new_col))\n"
"{\n"
"\n"
"adm_dav_br_list_error (\'The user has no read access privileges for collection.\',\n"
"cur_col,\n"
"new_col,\n"
"uid);\n"
"return 666;\n"
"}\n"
"\n"
"http (\'<table class=\"davbrfilelist\">\\n\');\n"
"\n"
"\n"
"\n"
"if (new_col <> 0)\n"
"{\n"
"\n"
"http (\'  <tr class=\"davbrfilelistrow\">\\n\');\n"
"select COL_OWNER, COL_GROUP, COL_MOD_TIME, COL_PERMS, COL_PARENT\n"
"into parent_owner, parent_group, parent_mod_time, parent_perms, _col_parent\n"
"from \"WS\".\"WS\".\"SYS_DAV_COL\"\n"
"where COL_ID = new_col;\n"
"http (adm_dav_br_fmt_col (\'..\', _col_parent, \'N/A\',\n"
"parent_owner, parent_group, parent_mod_time,\n"
"parent_perms, lst_mode, browse_mode));\n"
"http (\'  </tr>\\n\');\n"
"}\n"
"\n"
"for select COL_ID, COL_NAME, COL_OWNER, COL_GROUP, COL_MOD_TIME, COL_PERMS\n"
"from \"WS\".\"WS\".\"SYS_DAV_COL\"\n"
"where COL_PARENT = new_col and COL_NAME like flt_pat do\n"
"{\n"
"\n"
"http (\'  <tr class=\"davbrfilelistrow\">\\n\');\n"
"http (adm_dav_br_fmt_col (COL_NAME, COL_ID, \'N/A\',\n"
"COL_OWNER, COL_GROUP, COL_MOD_TIME,\n"
"COL_PERMS, lst_mode, browse_mode));\n"
"http (\'  </tr>\');\n"
"}\n"
"\n"
"\n"
"\n"
"for select RES_ID, RES_NAME, RES_CONTENT, RES_OWNER, RES_GROUP,\n"
"RES_COL, RES_TYPE, RES_MOD_TIME, RES_PERMS, RES_FULL_PATH\n"
"from \"WS\".\"WS\".\"SYS_DAV_RES\"\n"
"where RES_COL=new_col and RES_NAME like flt_pat order by RES_NAME do\n"
"{\n"
"http (\'  <tr class=\"davbrfilelistrow\">\\n\');\n"
"http (adm_dav_br_fmt_res (RES_TYPE, RES_NAME, RES_FULL_PATH,\n"
"RES_ID, length (RES_CONTENT),\n"
"RES_OWNER, RES_GROUP, RES_MOD_TIME,\n"
"RES_PERMS, lst_mode, browse_mode));\n"
"http (\'  </tr>\');\n"
"\n"
"}\n"
"http (\'</table>\\n\');\n"
"\n"
"}\n"
"--src admin_dav_browser.sql:474\n"
;

static int
sch_proc_def_exists (client_connection_t *cli, const char *proc_name, const int report)
{
  query_t *proc = NULL;
  char *full_name = sch_full_proc_name (isp_schema(NULL), proc_name,
	cli->cli_qualifier, CLI_OWNER (cli));
  if (full_name)
    proc = sch_proc_def (isp_schema(NULL), full_name);
  if (report && proc != NULL)
     log_debug ("built-in procedure \"%s\" overruled by the RDBMS", proc_name);
  return (proc != NULL);
}

#define DEFINE_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x0, 1)


#define DEFINE_PUBLIC_PROC(name, proc) \
   if (!sch_proc_def_exists (bootstrap_cli, (name), log_proc_overwrite)) \
     ddl_std_proc_1 (proc, 0x1, 1)


#define DEFINE_OVERWRITE_PROC(name, proc) \
   ddl_std_proc_1 (proc, 0x1, 1)


void
sqls_define_adm (void)
{
  /* admin.sql */

  DEFINE_PROC ("select_if", proc0);
  DEFINE_PROC ("check_if", proc1);
  DEFINE_PROC ("adm_http_parm_concat", proc2);
  DEFINE_PROC ("adm_new_session", proc3);
  DEFINE_PROC ("ADMIN_EXPIRE_SESSIONS", proc4);
  DEFINE_PROC ("adm_get_tree", proc5);
  DEFINE_PROC ("adm_get_sesid", proc6);
  DEFINE_PROC ("adm_dav_u_name", proc9);
  DEFINE_PROC ("adm_dav_g_name", proc10);
  DEFINE_PROC ("adm_unauth_response", proc11);
  DEFINE_PROC ("adm_dav_check_auth", proc12);
  DEFINE_PROC ("adm_tell_unauth_dav", proc13);
  DEFINE_PROC ("adm_check_auth", proc14);
  DEFINE_PROC ("adm_unqualify", proc15);
  DEFINE_PROC ("adm_param_default", proc16);
  DEFINE_PROC ("adm_get_param", proc17);
  DEFINE_PROC ("adm_date_fmt", proc18);
  DEFINE_PROC ("adm_make_date", proc19);
  DEFINE_PROC ("adm_result_tbl_hdrs", proc20);
  DEFINE_PROC ("adm_result_to_table", proc21);
  DEFINE_PROC ("adm_evt_action", proc22);
  DEFINE_PROC ("adm_users_u_group", proc23);
  DEFINE_PROC ("adm_users_action", proc24);
  DEFINE_PROC ("adm_u_group_options", proc25);
  DEFINE_PROC ("adm_users_error_msg", proc26);
  DEFINE_PROC ("adm_users_def_qual", proc27);
  DEFINE_PROC ("adm_is_checked", proc28);
  DEFINE_PROC ("adm_dav_users_get_perms", proc29);
  DEFINE_PROC ("adm_dav_format_perms", proc30);
  DEFINE_PROC ("adm_dav_u_group_options", proc32);
  DEFINE_PROC ("adm_dav_res_error_msg", proc33);
  DEFINE_PROC ("adm_dav_res_types_action", proc34);
  DEFINE_PROC ("adm_lt_make_dsn_part", proc35);
  DEFINE_PROC ("adm_next_keyword", proc36);
  DEFINE_PROC ("adm_next_checkbox", proc37);
  DEFINE_PROC ("adm_lt_init", proc38);
  DEFINE_PROC ("adm_lt_rt_options", proc39);
  DEFINE_PROC ("adm_lt_dsn_options", proc40);
  DEFINE_PROC ("adm_do_unlink", proc41);
  DEFINE_PROC ("adm_unlink_table", proc42);
  DEFINE_PROC ("adm_link_table", proc43);
  DEFINE_PROC ("adm_lt_wiz_link_tables", proc44);
  DEFINE_PROC ("adm_new_menu_tree", proc45);
  DEFINE_PROC ("adm_lm_update_ses", proc46);
  DEFINE_PROC ("adm_left_menu_init", proc47);
  DEFINE_PROC ("adm_make_qual_menus", proc48);
  DEFINE_PROC ("adm_lm_toggle", proc49);
  DEFINE_PROC ("adm_lm_toggle_node", proc50);
  DEFINE_PROC ("adm_table_pad", proc51);
  DEFINE_PROC ("adm_lm_show_node", proc52);
  DEFINE_PROC ("adm_lm_show_tree", proc53);
  DEFINE_PROC ("adm_lm_show_tree_node", proc54);
  DEFINE_PROC ("dbg_dump_menu_tree", proc55);
  DEFINE_PROC ("dbg_dump_node", proc56);
  DEFINE_PROC ("adm_tbls_list", proc57);
  DEFINE_PROC ("adm_tbls_list_drop", proc58);
  DEFINE_PROC ("adm_tbls_action", proc59);
  DEFINE_PROC ("adm_trigs_list", proc60);
  DEFINE_PROC ("adm_trigs_list_drop", proc61);
  DEFINE_PROC ("adm_trigs_action", proc62);
  DEFINE_PROC ("adm_get_trg_body", proc63);
  DEFINE_PROC ("adm_views_list", proc64);
  DEFINE_PROC ("adm_views_list_drop", proc65);
  DEFINE_PROC ("adm_views_action", proc66);
  DEFINE_PROC ("adm_exec_stmt", proc67);
  DEFINE_PROC ("adm_next_word", proc68);
  DEFINE_PROC ("adm_get_view_body", proc69);
  DEFINE_PROC ("adm_proc_list", proc70);
  DEFINE_PROC ("adm_proc_list_drop", proc71);
  DEFINE_PROC ("adm_proc_action", proc72);
  DEFINE_PROC ("adm_e_string", proc73);
  DEFINE_PROC ("adm_sql_columns", proc74);
  DEFINE_PROC ("adm_tell_unauth", proc75);
  DEFINE_PROC ("adm_lt_table_r", proc76);
  DEFINE_PROC ("adm_lt_getRPKeys", proc77);
  DEFINE_PROC ("adm_save_state", proc78);
  DEFINE_PROC ("adm_lt_table_draw", proc79);
  DEFINE_PROC ("adm_l_key_options", proc80);
  DEFINE_PROC ("adm_key_init", proc81);
  DEFINE_PROC ("vector_delete", proc82);
  DEFINE_PROC ("vector_num", proc83);
  DEFINE_PROC ("vector_swap", proc84);
  DEFINE_PROC ("adm_link_view", proc85);
  DEFINE_PROC ("vector_print", proc86);
  DEFINE_PROC ("adm_dsn_list", proc87);
  DEFINE_PROC ("adm_dsn_update", proc88);
  DEFINE_PROC ("adm_edit_text", proc89);
  DEFINE_PROC ("const_string_generic32", proc90);
  DEFINE_PROC ("adm_edit_virt", proc91);
  DEFINE_PROC ("const_string_add_generic32", proc92);
  DEFINE_PROC ("const_from_params", proc93);
  DEFINE_PROC ("constru_string", proc94);
  DEFINE_PROC ("adm_dsn_exist", proc95);
  DEFINE_PROC ("convert_exist", proc96);
  DEFINE_PROC ("adm_button_check", proc97);
  DEFINE_PROC ("date822_to_date", proc98);
  DEFINE_PROC ("mail_to", proc99); 
  DEFINE_PUBLIC_PROC ("adm_send_js_auth_page", proc100);
  DEFINE_PROC ("adm_pre_page", proc101);
  DEFINE_PROC ("adm_what_css", proc102);
  DEFINE_PROC ("adm_page_header", proc103);
  DEFINE_PROC ("adm_page_break", proc104);
  DEFINE_PROC ("adm_page_footer", proc105);
  DEFINE_PROC ("adm_news_status", proc106);
  DEFINE_PROC ("adm_mailaddr_pretty", proc107);
  DEFINE_PROC ("adm_add_dsn_option", proc108);
  DEFINE_PROC ("adm_get_file_dsn", proc109);
  DEFINE_PROC ("getxmltype", proc110);
  DEFINE_PROC ("check_dav_perms", proc111);
  DEFINE_PROC ("create_dav_col", proc112);
  DEFINE_PROC ("create_dav_file", proc113);
  DEFINE_PROC ("get_dav_path", proc114);
  DEFINE_PROC ("adm_get_init_name", proc115);
  DEFINE_PROC ("adm_make_option_list", proc116);
  DEFINE_PROC ("adm_is_hosted", proc117);
  DEFINE_PROC ("adm_hosted_file_filter", proc118);
  DEFINE_PROC ("root_node_hosted_import", proc119);
  DEFINE_PROC ("get_result", proc120);
  DEFINE_PROC ("import_get_types_result", proc121);
  DEFINE_PROC ("import_get_types", proc122);
  DEFINE_PROC ("import_file", proc123);
  DEFINE_PROC ("adm_import_get_selection_checkbox", proc124);
  DEFINE_PROC ("adm_import_get_values", proc125);
  ddl_ensure_table ("DB.DBA.DEFINED_TYPES", view0);
  ddl_ensure_table ("DB.DBA.CLASS_LIST", view1);
  DEFINE_PROC ("adm_input_vec", proc126);
  DEFINE_PROC ("adm_input_num", proc127);
  DEFINE_PROC ("adm_input_time", proc128);
  DEFINE_PROC ("adm_config_purger_form", proc129);
  DEFINE_PROC ("adm_config_purger_actions", proc130);
  DEFINE_PROC ("adm_lt_status_display", proc131);
  DEFINE_PROC ("adm_opt_array_to_rs", proc132);
  ddl_ensure_table ("DB.DBA.ADM_OPT_ARRAY_TO_RS_PVIEW", view2);
  DEFINE_PROC ("ADM_KEYWORD_VALUE_SET", proc133);
  DEFINE_PROC ("ADM_INDENT_XML", proc134);
  DEFINE_PROC ("adm_xml_get_flag", proc135);
  DEFINE_PROC ("adm_xml_make_xmlelement", proc136);
  DEFINE_PROC ("adm_map_xml_build", proc137);

  /* admin_dav_browser.sql */

  DEFINE_PROC ("adm_dav_br_get_uid", proc138);
  DEFINE_PROC ("adm_dav_user_can_read_col_p", proc139);
  DEFINE_PROC ("adm_dav_user_can_read_res_p", proc140);
  DEFINE_PROC ("adm_dav_br_uid_to_user", proc141);
  DEFINE_PROC ("adm_dav_br_uid_to_group", proc142);
  DEFINE_PROC ("adm_dav_br_fmt_perm", proc143);
  DEFINE_PROC ("adm_dav_br_list_error", proc144);
  DEFINE_PROC ("adm_dav_br_map_icon", proc145);
  DEFINE_PROC ("adm_dav_br_fmt_col", proc146);
  DEFINE_PROC ("adm_dav_br_fmt_res", proc147);
  DEFINE_PROC ("adm_path_normalize", proc148);
  DEFINE_PROC ("adm_file_like", proc149);
  DEFINE_PROC ("adm_os_br_gen_col_c_listing", proc150);
  DEFINE_PROC ("adm_dav_br_gen_col_c_listing", proc151);
}


void
sqls_arfw_define_adm (void)
{
  /* admin.sql */

  DEFINE_PROC ("adm_get_ses_var", proc7);
  DEFINE_PROC ("adm_set_ses_var", proc8);
  DEFINE_PROC ("adm_dav_users_action", proc31);

}
