.\" zip_file_get_comment.mdoc \-- get comment for file in zip
.\" Copyright (C) 2006-2013 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP files.
.\" The authors can be contacted at <libzip@nih.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_FILE_GET_COMMENT 3 "February 20, 2013" NiH
.SH "NAME"
zip_file_get_comment \- get comment for file in zip
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
#include <zip.h>
.PP
const char *
zip_file_get_comment(struct zip *archive, zip_uint64_t index, zip_uint32_t *lenp); \
"zip_flags_t flags"
.SH "DESCRIPTION"
The
zip_file_get_comment
function returns the comment for the file at position
\fBindex\fR
in the zip archive.
The name is in UTF-8 encoding unless
\fBZIP_FL_ENC_RAW\fR
was specified (see below).
This pointer should not be modified or
free(3)
Ap d,
and becomes invalid when
\fBarchive\fR
is closed.
If
\fBlenp\fR
is not
\fBNULL,\fR
the integer to which it points will be set to the length of the
comment.
If
\fBflags\fR
is set to
\fBZIP_FL_UNCHANGED,\fR
the original unchanged comment is returned.
.PP
Additionally, the following
\fBflags\fR
are supported:
.RS
.TP 21
\fBZIP_FL_ENC_RAW\fR
Return the unmodified comment as it is in the ZIP archive.
.TP 21
\fBZIP_FL_ENC_GUESS\fR
(Default.)
Guess the encoding of the comment in the ZIP archive and convert it
to UTF-8, if necessary.
.TP 21
\fBZIP_FL_ENC_STRICT\fR
Follow the ZIP specification for file names and extend it to file
comments, expecting them to be encoded in CP-437 in the ZIP archive
(except if it is a UTF-8 comment from the special extra field).
Convert it to UTF-8.
.RE
.I Note:
ASCII is a subset of both CP-437 and UTF-8.
.SH "RETURN VALUES"
Upon successful completion, a pointer to the comment is returned,
or
\fBNULL\fR
if there is no comment.
In case of an error,
\fBNULL\fR
is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
zip_get_file_comment
fails if:
.RS
.TP 4
[ZIP_ER_INVAL]
\fBindex\fR
is not a valid file index in
\fBarchive.\fR
.RE
.SH "SEE ALSO"
libzip(3),
zip_file_set_comment(3),
zip_get_archive_comment(3)
.SH "AUTHORS"

Dieter Baron <dillo@nih.at>
and
Thomas Klausner <tk@giga.or.at>
