/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
#ifndef SKGUNDOREDOPLUGIN_H
#define SKGUNDOREDOPLUGIN_H
/** @file
 * This file is a plugin for undo and redo operation.
*
* @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skginterfaceplugin.h"
#include "ui_skgundoredopluginwidget_pref.h"

class QAction;
class KToolBarPopupAction;
class QMenu;

/**
 * This file is a plugin for undo and redo operation
 */
class SKGUndoRedoPlugin : public SKGInterfacePlugin
{
    Q_OBJECT
    Q_INTERFACES(SKGInterfacePlugin)

public:
    /**
     * Default Constructor
     */
    explicit SKGUndoRedoPlugin(QWidget* iWidget, QObject* iParent, const QVariantList& iArg);

    /**
     * Default Destructor
     */
    virtual ~SKGUndoRedoPlugin();

    /**
     * Called to initialise the plugin
     * @param iDocument the main document
     * @param iArgument the arguments
     * @return true if the plugin is compatible with the document
     */
    virtual bool setupActions(SKGDocument* iDocument, const QStringList& iArgument) Q_DECL_OVERRIDE;

    /**
     * Must be modified to refresh widgets after a modification.
     */
    virtual void refresh() Q_DECL_OVERRIDE;

    /**
     * The preference widget of the plugin.
     * @return The preference widget of the plugin
     */
    virtual QWidget* getPreferenceWidget() Q_DECL_OVERRIDE;

    /**
     * The preference skeleton of the plugin.
     * @return The preference skeleton of the plugin
     */
    virtual KConfigSkeleton* getPreferenceSkeleton() Q_DECL_OVERRIDE;

    /**
     * This function is called when preferences have been modified. Must be used to save some parameters into the document.
     * A transaction is already opened
     * @return an object managing the error.
     *   @see SKGError
     */
    virtual SKGError savePreferences() const Q_DECL_OVERRIDE;

    /**
     * The title of the plugin.
     * @return The title of the plugin
     */
    virtual QString title() const Q_DECL_OVERRIDE;

    /**
     * The icon of the plugin.
     * @return The icon of the plugin
     */
    virtual QString icon() const Q_DECL_OVERRIDE;

    /**
     * The toolTip of the plugin.
     * @return The toolTip of the plugin
     */
    virtual QString toolTip() const Q_DECL_OVERRIDE;

    /**
     * The tips list of the plugin.
     * @return The tips list of the plugin
     */
    virtual QStringList tips() const Q_DECL_OVERRIDE;

    /**
     * Must be implemented to set the position of the plugin.
     * @return integer value between 0 and 999 (default = 999)
     */
    virtual int getOrder() const Q_DECL_OVERRIDE;

    /**
     * The dock widget of the plugin.
     * @return The dock widget of the plugin
     */
    virtual QDockWidget* getDockWidget() Q_DECL_OVERRIDE;

    /**
     * The advice list of the plugin.
     * @return The advice list of the plugin
     */
    virtual SKGAdviceList advice(const QStringList& iIgnoredAdvice) Q_DECL_OVERRIDE;

    /**
     * Must be implemented to execute the automatic correction for the advice.
     * @param iAdviceIdentifier the identifier of the advice
     * @param iSolution the identifier of the possible solution
     * @return an object managing the error. MUST return ERR_NOTIMPL if iAdviceIdentifier is not known
     *   @see SKGError
     */
    virtual SKGError executeAdviceCorrection(const QString& iAdviceIdentifier, int iSolution) Q_DECL_OVERRIDE;

private Q_SLOTS:
    void onUndoSave();
    void onUndo();
    void onRedo();
    void onClearHistory();

    void onShowUndoMenu();
    void onShowRedoMenu();
private:
    Q_DISABLE_COPY(SKGUndoRedoPlugin)

    QAction* m_undoSaveAction;
    KToolBarPopupAction* m_undoAction;
    KToolBarPopupAction* m_redoAction;

    QMenu* m_undoMenu;
    QMenu* m_redoMenu;


    SKGDocument* m_currentDocument;
    QDockWidget* m_dockWidget;

    Ui::skgundoredoplugin_pref ui;
};

#endif  // SKGDEBUGPLUGIN_H
