/***************************************************************************
 *   Copyright (C) 2020 by S. MANKOWSKI / G. DE BURE support@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <https://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * A tree view with more features (qt designer plugin).
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtreeviewdesignerplugin.h"

#include <qicon.h>

#include "skgtreeview.h"

SKGTreeViewDesignerPlugin::SKGTreeViewDesignerPlugin(QObject* iParent)
    : QObject(iParent)
{
    m_initialized = false;
}

void SKGTreeViewDesignerPlugin::initialize(QDesignerFormEditorInterface*  iCore)
{
    Q_UNUSED(iCore)
    if (m_initialized) {
        return;
    }

    m_initialized = true;
}

bool SKGTreeViewDesignerPlugin::isInitialized() const
{
    return m_initialized;
}

QWidget* SKGTreeViewDesignerPlugin::createWidget(QWidget* iParent)
{
    return new SKGTreeView(iParent);
}

QString SKGTreeViewDesignerPlugin::name() const
{
    return QStringLiteral("SKGTreeView");
}

QString SKGTreeViewDesignerPlugin::group() const
{
    return QStringLiteral("SKG Widgets");
}

QIcon SKGTreeViewDesignerPlugin::icon() const
{
    return SKGServices::fromTheme(QStringLiteral("quickopen"));
}

QString SKGTreeViewDesignerPlugin::toolTip() const
{
    return QStringLiteral("A tree view with more features");
}

QString SKGTreeViewDesignerPlugin::whatsThis() const
{
    return QStringLiteral("A tree view with more features");
}

bool SKGTreeViewDesignerPlugin::isContainer() const
{
    return true;
}

QString SKGTreeViewDesignerPlugin::domXml() const
{
    return QStringLiteral("<widget class=\"SKGTreeView\" name=\"SKGTreeView\">\n"
                          " <property name=\"geometry\">\n"
                          "  <rect>\n"
                          "   <x>0</x>\n"
                          "   <y>0</y>\n"
                          "   <width>100</width>\n"
                          "   <height>100</height>\n"
                          "  </rect>\n"
                          " </property>\n"
                          "</widget>\n");
}

QString SKGTreeViewDesignerPlugin::includeFile() const
{
    return QStringLiteral("skgtreeview.h");
}

