#include "propwidget.h"
#include "editwidget.h"

PropWidget::PropWidget( EditWidget **ew, QWidget *parent, const char *name )
   : QWidget( parent, name )
{
  setMinimumSize(0,0);

  editwidget=ew;

  lview = new QListView( this );
  lview->setGeometry(0,25,width(),height()-25);
  lview->addColumn(klocale->translate("Property"));
  lview->addColumn(klocale->translate("Value"));
  lview->setColumnWidthMode(0,QListView::Manual);
  lview->setColumnWidthMode(1,QListView::Manual);

  cbox = new QComboBox( false, this );
  cbox ->setGeometry(0,0,width(), 25);
  connect(cbox, SIGNAL( activated ( int ) ), this, SLOT( cbox_activated( int ) ) );

  lview->setFrameStyle( QFrame::Panel | QFrame::Sunken );
  lview->setSorting(-1);
  lview->setMultiSelection(false);
  lview->show();
  connect(lview, SIGNAL( doubleClicked( QListViewItem * ) ), this, SLOT( doubleClicked( QListViewItem * ) ) );

  lviNr=-1;
  for (int i=0; i<16; i++)
    {
      lvis[i] = 0;
      openStats[i] = true;
    }

}

void PropWidget::resizeEvent( QResizeEvent * )
{
  lview->setGeometry(0,25,width(),height()-25);
  cbox ->setGeometry(0,0,width(), 25);
  lview->setColumnWidth(0, (int)width()/2);
  lview->setColumnWidth(1, (int)width()/2);
}

void PropWidget::cbox_activated( int nr )
{
  if (!lvis[nr])
    return;

  (*editwidget)->setActItem((*editwidget)->getItem(nr));

  refillList();
}

int PropWidget::addFolder( const char *name )
{
  if (lviNr>15)
    return -1;

  QListViewItem *item = 0;
  QPixmap folder(PIXMAP_FOLDER);

  item = new QListViewItem( lview );

  item->setPixmap(0, folder);
  item->setText(0, name);

  lvis[++lviNr] = item;
  lvis[lviNr]->setOpen(openStats[lviNr]);

  return lviNr;
}

void PropWidget::addItem( QListViewItem *par, const char *prop, const char *value)
{
  if (strlen(prop)<=0)
    return;
  QListViewItem *item = new QListViewItem( par );
  item->setText(0, prop);
  item->setText(1, value);
}

void PropWidget::ClearList( )
{
//  for (int i=0; i<=lviNr; i++)
//    if (lvis[i]) { delete lvis[i]; lvis[i]=0; }

  for (int i=0; i<=lviNr; i++)
    if (lvis[i]) openStats[i]=lvis[i]->isOpen();

  lview->clear();

  lviNr=-1;
  for (int i=0; i<16; i++)
    lvis[i]=0;

  cbox->clear();

}

void PropWidget::refillList( )
{
  ClearList();

  anItem *item = (*editwidget)->actItem();

  if (!item)
    return;

  addFolder( klocale->translate( "General" ) );
  addFolder( klocale->translate( "Placement" ) );
  addFolder( klocale->translate( "Style" ) );

  for (int i=item->PropsCount(); i>=0; i--)
    {
      addItem( lvis[item->getProp(i)->group] , item->getProp(i)->prop , item->getProp(i)->value );
    }

  lview->show();

  for (int n=0; n<=(*editwidget)->getNumItems(); n++)
    {
      QString s;
      s = (n<10 ? QString("0") : QString("")) + QString().setNum(n+1) + ". " +
          (*editwidget)->getItem(n)->getProp(0)->value + " (" +
          (*editwidget)->getItem(n)->descr() + ")";

      cbox->insertItem(s);
    }

  cbox->setCurrentItem((*editwidget)->getActNr());
//  (*editwidget)->setActItem((*editwidget)->getItem((*editwidget)->getActNr()));
}

void PropWidget::doubleClicked( QListViewItem *item )
{
  if (!item)
    return;

  dlgChangeItem *it = new dlgChangeItem((QWidget*)parent()->parent()->parent(),
                           (*editwidget)->actItem(),
                           item->text(0), item->text(1) );
  if (it->exec())
    {
      if (it->getPropNr()!=-1)
        {
          if ((editwidget) && (*editwidget)->actItem())
            (*editwidget)->actItem()->setPropVal(it->getPropNr(), it->getVal());
          (*editwidget)->actItem()->rebuildFromProps();
          refillList();
        }
    }

}

QString intToHex2( int src )
{
  switch (src)
    {
      case 0 : return "0";
      case 1 : return "1";
      case 2 : return "2";
      case 3 : return "3";
      case 4 : return "4";
      case 5 : return "5";
      case 6 : return "6";
      case 7 : return "7";
      case 8 : return "8";
      case 9 : return "9";
      case 10 : return "A";
      case 11 : return "B";
      case 12 : return "C";
      case 13 : return "D";
      case 14 : return "E";
      case 15 : return "F";
    }

  return "x";
}

QString intToHex( int src )
{
  int p1 = (int)(src/16);
  int p2 = (int)(src&0x0F);
  return intToHex2(p1)+intToHex2(p2);
}




dlgChangeItem::dlgChangeItem(QWidget *parent, anItem *item, QString pr, QString val)
  : QDialog(parent,klocale->translate("Insert item"), TRUE)
{
  setMinimumSize(300,150);
  setMaximumSize(300,150);

  QPushButton *ok, *cancel;
  ok = new QPushButton( klocale->translate( "&Ok" ), this );
  ok->setDefault(true);
  ok->setGeometry( 10,110, 100,30 );
  connect( ok, SIGNAL(clicked()), SLOT(accept()) );
  cancel = new QPushButton( klocale->translate( "&Cancel" ), this );
  cancel->setGeometry( 190,110, 100,30 );
  connect( cancel, SIGNAL(clicked()), SLOT(reject()) );

  ledit = new QLineEdit ( this );

  propnr = -1;

  for (int i=0; i<item->PropsCount(); i++)
    if (item->getProp(i)->prop.upper() == pr.upper())
      {
        ledit->setText(item->getProp(i)->value);
        propnr = i;
        break;
      }

  if (propnr != -1)
    allowed = item->getProp(propnr)->allowed;

  ledit->setGeometry( 150, 10, 140, 25);
  ledit->show();

  QLabel *lab = new QLabel(pr, this);
  lab->setGeometry(  10, 10, 130, 25);
  lab->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
  lab->show();

  QPushButton *browse;
  browse = new QPushButton( klocale->translate("&Browse") ,this );
  browse->setGeometry( 190 , 45, 100, 25);
  connect( browse, SIGNAL(clicked()), SLOT(browseclicked()));

}

void dlgChangeItem::browseclicked()
{
  if (allowed & ALLOW_COLOR)
    {
      QColor myColor;
      int res = KColorDialog::getColor( myColor );
      if (res)
        {
          QString st = "0x"+intToHex(myColor.red())+intToHex(myColor.green())+intToHex(myColor.blue());
          ledit->setText(st);
        }
    }

  if (allowed & ALLOW_FILE)
    {
      QString fname = KFileDialog::getOpenFileName();
      if (!fname.isNull())
        ledit->setText(fname);
    }

  if (allowed & ALLOW_FONT)
    {
      QFont myFont;
      int res = KFontDialog::getFont( myFont );

      if (res)
        {
          QString st = QString("\"") + myFont.family()    + QString("\" \"") +
                              QString().setNum(myFont.pointSize()) + QString("\" \"") +
                              QString().setNum(myFont.weight())   + QString("\" \"") +
                              QString(myFont.bold() ? QString("TRUE") : QString("FALSE")) + QString("\"");
          ledit->setText(st);
        }
    }
}








