/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include "kledit.h"

IMPLEMENT_KLMETA_STANDALONE(KLLineEdit,KLWidgetBase,"Singleline Texteditor");

KLLineEdit::KLLineEdit(const char *text) : QLineEdit((QWidget *)0,0)
{
  setKLWidget(this); 
  setText(text);
}

bool KLLineEdit::klAskMinMax(KLMinMaxSizes *minMaxSizes)
{
  if( !KLWidgetBase::klAskMinMax(minMaxSizes) )
    return false;
  QSize size = sizeHint();
  minMaxSizes->minX += size.height();
  minMaxSizes->minY += 30; // SizeHint is too big ! size.width();
  minMaxSizes->defX += size.height();
  minMaxSizes->defY += 150;
  minMaxSizes->maxX += size.height();
  minMaxSizes->maxY += KLMaxSize;
  return true;
}


KLMultiLineEdit::KLMultiLineEdit(const char *text) : QMultiLineEdit((QWidget *)0,0)
{
  setKLWidget(this); 
  setText(text);
}

bool KLMultiLineEdit::klAskMinMax(KLMinMaxSizes *minMaxSizes)
{
  if( !KLWidgetBase::klAskMinMax(minMaxSizes) )
    return false;
  enum { YBorder = 6, XBorder = 6 };
  QFontMetrics fm = fontMetrics();
  minMaxSizes->minX += fm.height() + XBorder;
  minMaxSizes->minY += fm.width("WWW") + YBorder;
  minMaxSizes->defX += fm.height() + XBorder;
  minMaxSizes->defY += fm.width("WWW") + YBorder;
  minMaxSizes->maxX += KLMaxSize;
  minMaxSizes->maxY += KLMaxSize;
  return true;
}

IMPLEMENT_KLMETA_STANDALONE(KLMultiLineEdit,KLWidgetBase,"Multiline Texteditor");

#include "kledit.moc"


