/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KLTABGROUP_H
#define KLTABGROUP_H

#include "klwidgetbase.h"
#include "ktabbar.h"
#include "klgroup.h"

class KLTabGroup : public QWidget, public KLWidgetBase {
  Q_OBJECT
public:
  KLTabGroup(KLPageGroup::CalcMode calcMode = KLPageGroup::MaxMax);

  virtual bool klAskMinMax(KLMinMaxSizes *minMaxSizes);
  virtual bool klSetup( KLSetupInfo *setupInfo );
  virtual bool klShow(KLShowInfo *showInfo);
  virtual void klHide();
  virtual void klCleanup();

  virtual void setupGrap();
  virtual void cleanupGrap();

  virtual KLChild *findChild( ulong x, ulong y ) const;
  virtual void addDropMarks( KLDropMarkList * dml ) const;
  virtual bool isAChild( KLChild * ) const;

  /**
  * Refresh the Tabbar. You must call
  * this manualy, if you added or removed a
  * Page from the group (by removing its
  * title and the widget)
  */
  void refreshTabs();

  void paintEvent(QPaintEvent *e);

  KLTabGroup &operator<<(_child_change_func func);
  KLStreamHelp &operator<<(_child_change_p1_func func);
  KLTabGroup &operator<<(KLGroup::_grp_change_func func);
  KLTabGroup &operator<<(KLChild *child);
  KLTabGroup &operator<<(KLChild &child);
  KLTabGroup &operator<<(const char *);

  KLPageGroup &group();
  QStrList    &tabTitles();

  void setActPage(int);
  ulong actPage();

  KLPageGroup::CalcMode calcMode();
  void setCalcMode( KLPageGroup::CalcMode calcMode );

  _KLWIDGET_EVENT_CATCH(QWidget);

public slots:
  void pageSelected(int);

private:
  QRect getChildRect() const;
  KLPageGroup a_group;
  QStrList    a_tabTitles;
  KTabBar    *a_tabBar;
  enum { TopBorder = 5,
         BottomBorder = 7,
         LeftBorder = 7,
         RightBorder = 7 };
};

// Inline attribute GET funcs
inline KLPageGroup& KLTabGroup::group()
{ return a_group; };
inline QStrList &KLTabGroup::tabTitles()
{ return a_tabTitles; };

#endif 

