/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KLWIDGETBASE_H
#define KLWIDGETBASE_H

#include "klchild.h"

/**
* KLWidgetBase 
*
* This is the baseclass for all QWidget based Layoutchilds. It
* provides the most functionality needed for the integration
* of Qt/KDE-Widgets
*/

class QWidget;
class KLWidgetBase : public KLChild {
protected:
  QWidget *a_widget; // Pointer to this widget
  bool a_acceptDrops;
public:
  KLWidgetBase();
  void setKLWidget(QWidget *widget);
  QWidget *klWidget() { return a_widget; };

  virtual bool klSetup( KLSetupInfo *setupInfo );
  virtual bool klShow(KLShowInfo *showInfo);
  virtual void klHide();
  virtual void klCleanup();

  virtual void setupGrap();
  virtual void cleanupGrap();

  DECLARE_KLMETA_STANDALONE_SIMPLE();
};


#endif 

