/* This file is part of the KDE libraries
    Copyright (c) 1998 Emmeran Seehuber (the_emmy@hotmail.com)
 
    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#ifndef KLWINDOW_H
#define KLWINDOW_H

#include "kldevice.h"
#include <ktmainwindow.h>

/**
* Window window for use with KLE.
*
* Will also feature a default button in future
*/
class KLWindow : public KTMainWindow, public KLDevice {
  Q_OBJECT
public:
  KLWindow();
  ~KLWindow();

  void show();
  void hide();

  void setDeviceSize(unsigned long xSize, unsigned long ySize);
  bool refreshDisplay();

  virtual class QWidget *getDeviceHandle();
  virtual void updateRects();

  virtual void resizeEvent(QResizeEvent*e);

protected:
  virtual bool createWindow();
  virtual bool showWindow( KLDeviceShowinfo *deviceShowInfo );
  virtual void setLimits( KLDeviceShowinfo *deviceShowInfo );
  virtual void hideWindow();
  virtual void deleteWindow();

  virtual ulong getLeftBorder() const;
  virtual ulong getRightBorder() const;
  virtual ulong getTopBorder() const;
  virtual ulong getBottomBorder() const;
private:
  QWidget view;
  ulong   leftborder;
  ulong   rightborder;
  ulong   topborder;
  ulong   bottomborder;
};

#endif 

