#ifndef _KPROGRESS_H_
#define _KPROGRESS_H_

#include <Python.h>
#include <kprogress.h>
#include "Baseobject.h"


class _Progress : public KProgress, public BaseObject
{
  Q_OBJECT
public:
  _Progress(Orientation o, QWidget *parent=0, const char *name=0) : KProgress(o,parent,name), BaseObject() {
    connect(this, SIGNAL(percentageChanged(int)), this, SLOT(sigPercentageChanged(int)));
    };
  _Progress(int minValue, int maxValue, int value, Orientation o, QWidget *parent=0, const char *name=0)
    : KProgress(minValue,maxValue,value,o,parent,name), BaseObject() {
    connect(this, SIGNAL(percentageChanged(int)), this, SLOT(sigPercentageChanged(int)));
    };
  ~_Progress() {};
  
protected slots:

    void sigPercentageChanged(int per) {
       PyObject *arg = Py_BuildValue("(i)",per);
       _emit("percentageChanged", arg);  
       Py_DECREF(arg);
    };
    
};

#endif
