%module KSpinbox


%{
#include "KSpinbox.h"
#include "Object.h"
%}


%include Types.i


class _SpinBox : public QWidget
{
public:
  _SpinBox(QWidget *parent=0,const char *name=0,int align=AlignLeft);
  ~_SpinBox();

  const char *getValue();
  void setValue(const char *);

  bool isEditable();
  void setEditable(bool);

  void setAlign(int align);
  int getAlign();

/*	
  signals:
  void valueIncreased();
  void valueDecreased();
*/

  void slotIncrease();
  void slotDecrease();
};


class _NumericSpinBox : public _SpinBox
{
public:
  _NumericSpinBox(QWidget *parent=0,const char *name=0,int align=AlignLeft);
  ~_NumericSpinBox();

  int getStep();
  void setStep(int step);

  void getRange(int &minimum, int &maximum);
  void setRange(int minimum, int maximum);
};


class _ListSpinBox : public _SpinBox
{
public:
  _ListSpinBox(QStrList *list,QWidget *parent=0,const char *name=0,int align=AlignLeft);
  ~_ListSpinBox();

  void setIndex(unsigned int index);
  unsigned int getIndex();
};
