import libqtpythonc
from dialog import *


class MessageBoxPtr(DialogPtr):

    NoIcon = libqtpythonc.QMessageBox_NoIcon
    Information = libqtpythonc.QMessageBox_Information
    Warning = libqtpythonc.QMessageBox_Warning
    Critical = libqtpythonc.QMessageBox_Critical

    Ok = libqtpythonc.QMessageBox_Ok
    Cancel = libqtpythonc.QMessageBox_Cancel
    Yes = libqtpythonc.QMessageBox_Yes
    No = libqtpythonc.QMessageBox_No
    Abort = libqtpythonc.QMessageBox_Abort
    Retry = libqtpythonc.QMessageBox_Retry
    Ignore = libqtpythonc.QMessageBox_Ignore
    ButtonMask = libqtpythonc.QMessageBox_ButtonMask
    Default = libqtpythonc.QMessageBox_Default
    Escape = libqtpythonc.QMessageBox_Escape
    FlagMask = libqtpythonc.QMessageBox_FlagMask

    def __init__(self,this,name=""):
        DialogPtr.__init__(self,this,name)
        self.this = this
        self.thisown = 0

    def __del__(self):
        if self.thisown == 1 :
            libqtpythonc.delete_QMessageBox(self.this)

    def text(self):
        val = libqtpythonc.QMessageBox_text(self.this)
        return val

    def setText(self,arg0):
        val = libqtpythonc.QMessageBox_setText(self.this,arg0)
        return val

    def icon(self):
        val = libqtpythonc.QMessageBox_icon(self.this)
        return val

    def setIcon(self,arg0):
        val = libqtpythonc.QMessageBox_setIcon(self.this,arg0)
        return val

    def iconPixmap(self):
        val = libqtpythonc.QMessageBox_iconPixmap(self.this)
        val = QPixmapPtr(val)
        return val

    def setIconPixmap(self,arg0):
        val = libqtpythonc.QMessageBox_setIconPixmap(self.this,arg0.this)
        return val

    def buttonText(self,arg0):
        val = libqtpythonc.QMessageBox_buttonText(self.this,arg0)
        return val

    def setButtonText(self,arg0,arg1):
        val = libqtpythonc.QMessageBox_setButtonText(self.this,arg0,arg1)
        return val

    def adjustSize(self):
        val = libqtpythonc.QMessageBox_adjustSize(self.this)
        return val

    def setStyle(self,arg0):
        val = libqtpythonc.QMessageBox_setStyle(self.this,arg0)
        return val

    def __repr__(self):
        return "<MessageBox instance at %s>" % self.this

class MessageBox(MessageBoxPtr):
    def __init__(self,parent="",name=""):
	MessagePtr.__init__(self,"NULL",name)
	if not parent:
            self.this = libqtpythonc.new_MessageBox("NULL",name)
            self.thisown = 1
        else:
            self.this = libqtpythonc.new_MessageBox(parent.this,name)
	    self.thisown = 0	    


def MessageBoxInit(caption,text,icon,button0,button1,button2,parent="",name="",modal=0,flags=0) :
    def __init__(self,parent="",name=""):
	MessageBoxPtr.__init__(self,"NULL",name)
	if not parent:
            self.this = libqtpythonc.new_MessageBoxInit(caption,text,icon,button0,button1,button2,"NULL",name,modal,flags)
            self.thisown = 1
        else:
            self.this = libqtpythonc.new_MessageBoxInit(caption,text,icon,button0,button1,button2,parent.this,name,modal,flags)
	    self.thisown = 0	    


def MessageBox_information(arg0,arg1,arg2,arg3,*args):
    val = apply(libqtpythonc.QMessageBox_information,(arg0.this,arg1,arg2,arg3,)+args)
    return val

def MessageBox_informationButtons(arg0,arg1,arg2,*args):
    val = apply(libqtpythonc.QMessageBox_informationButtons,(arg0.this,arg1,arg2,)+args)
    return val

def MessageBox_warning(arg0,arg1,arg2,arg3,arg4,*args):
    val = apply(libqtpythonc.QMessageBox_warning,(arg0.this,arg1,arg2,arg3,arg4,)+args)
    return val

def MessageBox_warningButtons(arg0,arg1,arg2,*args):
    val = apply(libqtpythonc.QMessageBox_warningButtons,(arg0.this,arg1,arg2,)+args)
    return val

def MessageBox_critical(arg0,arg1,arg2,arg3,arg4,*args):
    val = apply(libqtpythonc.QMessageBox_critical,(arg0.this,arg1,arg2,arg3,arg4,)+args)
    return val

def MessageBox_criticalButtons(arg0,arg1,arg2,*args):
    val = apply(libqtpythonc.QMessageBox_criticalButtons,(arg0.this,arg1,arg2,)+args)
    return val

def MessageBox_about(arg0,arg1,arg2):
    val = libqtpythonc.QMessageBox_about(arg0.this,arg1,arg2)
    return val

def MessageBox_aboutQt(arg0,*args):
    val = apply(libqtpythonc.QMessageBox_aboutQt,(arg0.this,)+args)
    return val

def MessageBox_standardIcon(arg0,arg1):
    val = libqtpythonc.QMessageBox_standardIcon(arg0,arg1)
    val = PixmapPtr(val)
    val.thisown = 1
    return val
