from baseobject import *
import libqtpythonc


class ObjectPtr(BaseObjectPtr):

    _classname = "Object"

    def __init__(self,this,name=""):
       BaseObjectPtr.__init__(self,name)
       self.this = this
       self.thisown = 0

    def __del__(self):
       if self.thisown == 1:
          libqtpythonc.delete_Object(self.this)

#    def event(self,arg0):
#        return libqtpythonc.Object_event(self.this,arg0)

#    def eventFilter(self,arg0,arg1):
#        return libqtpythonc.Object_eventFilter(self.this,arg0.this,arg1)

    def isA(self,classname):
        return self._classname == classname

    def setName(self,name):
        self._name = name
        libqtpythonc.Object_setName(self.this,name)

    def getName(self):
        return libqtpythonc.Object_name(self.this)

    def isWidgetType(self):
        return libqtpythonc.Object_isWidgetType(self.this)

    def signalsBlocked(self):
        return libqtpythonc.Object_signalsBlocked(self.this)

    def blockSignals(self,signals):
        libqtpythonc.Object_blockSignals(self.this,signals)

    def children(self):
        result = []
        for child in libqtpythonc.Object_children(self.this):
 	  result.append(ObjectPtr(child))
	return result

#    def queryList(self,*args):
#        return apply(libqtpythonc.Object_queryList,(self.this,)+args)

    def insertChild(self,child):
        libqtpythonc.Object_insertChild(self.this,child.this)
	child.thisown = 0

    def removeChild(self,child):
        libqtpythonc.Object_removeChild(self.this,child.this)
	child.thisown = 1

#    def installEventFilter(self,arg0):
#        libqtpythonc.Object_installEventFilter(self.this,arg0.this)

#    def removeEventFilter(self,arg0):
#        libqtpythonc.Object_removeEventFilter(self.this,arg0.this)

    def dumpObjectTree(self):
        libqtpythonc.Object_dumpObjectTree(self.this)

    def dumpObjectInfo(self):
        libqtpythonc.Object_dumpObjectInfo(self.this)

    def __repr__(self):
        return "<Object instance at %s>" % self.this

    def parent(self):
         return ObjectPtr(libqtpythonc.Object_parent(self.this))

class Object(ObjectPtr):
    def __init__(self,parent="",name=""):
        ObjectPtr.__init__(self,"NULL",name)
	if not parent:
            self.this = libqtpythonc.new_Object("NULL", name)
            self.thisown = 1
        else:
            self.this = libqtpythonc.new_Object(parent.this, name)
	    self.thisown = 0	    
