#ifndef _CHECKBOX_H_
#define _CHECKBOX_H_

#include "Python.h"
#include "qchkbox.h"
#include "Baseobject.h"

class CheckBox : public QCheckBox, BaseObject
{
  Q_OBJECT	

  public:

    CheckBox(const char *text, QWidget *parent=0, const char *name=0) : QCheckBox(text, parent,name), BaseObject() {
      connect(this, SIGNAL(pressed()), this, SLOT(sigPressed()));
      connect(this, SIGNAL(released()), this, SLOT(sigReleased()));
      connect(this, SIGNAL(clicked()), this, SLOT(sigClicked()));
      connect(this, SIGNAL(toggled(bool)), this, SLOT(sigToggled(bool)));
    };
    ~CheckBox() {};

  protected slots:

    void sigPressed() {
      _emit("pressed", 0);
    };
    
    void sigReleased() {
      _emit("release", 0);
    };
    
    void sigClicked() {
      _emit("clicked", 0);
    };
    
    void sigToggled(bool on) {
      PyObject *args = Py_BuildValue("(i)", on);
      _emit("toggled", args);
      Py_DECREF(args);
    };
};

#endif
