/*
    KDE Draw - a small graphics drawing program for the KDE.
    Copyright (C) 1998  Thomas Tanghus (tanghus@earthling.net)

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/  

#ifndef __KNEWICON_H__
#define __KNEWICON_H__

#include <qwidget.h>
#include <qdragobject.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qpoint.h>
#include <qbttngrp.h>
#include <qbutton.h>
#include <qradiobt.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qpainter.h>
#include <kapp.h>

class KIconListBox;

struct KIconTemplate
{
  QPixmap pix;
  QString title;
};

class KIconListBoxItem : public QListBoxItem    
{    
public:      
  KIconListBoxItem( KIconTemplate * );

  KIconTemplate *iconTemplate() { return icontemplate; }

protected:      
  virtual void paint( QPainter * );      
  virtual int height( const QListBox * ) const;      
  virtual int width( const QListBox * ) const;      
private:      
  QPixmap pm;    
  KIconTemplate *icontemplate;
};

class KIconListBox : public QListBox    
{    
  Q_OBJECT
public:      
  KIconListBox( QWidget *parent );
  ~KIconListBox();

protected:
  void mousePressEvent( QMouseEvent * );
  void mouseMoveEvent( QMouseEvent * );

  QPoint start;
  QImage img;
  QImageDrag *di;
  bool dragging;
};


#endif __KNEWICON_H__
