/**********************************/
/* This file is part of QtC 0.0.2 */
/* (c) 1997 Roberto Alsina        */
/* Licensed under the GPL v2      */
/* Read file COPYING for details  */
/**********************************/
#include "qt_QPixmap.h"

#include <qbitmap.h>
#include <qwmatrix.h>
#include <qimage.h>

qt_QPixmap *qt_new_QPixmap( ){
	return (qt_QPixmap *)new QPixmap();
}
qt_QPixmap *qt_new_QPixmap1(int w,int h,int depth)

{
	return (qt_QPixmap *) new QPixmap( (int)w,(int)h,(int)depth );
}

qt_QPixmap *qt_new_QPixmap2(qt_QSize * arg1,int depth)

{
	return (qt_QPixmap *) new QPixmap( (QSize&)*arg1,(int)depth );
}

qt_QPixmap *qt_new_QPixmap3(char* fileName,char* format,int mode)

{
    return (qt_QPixmap *) new QPixmap( (char*)fileName,(char*)format,(QPixmap::ColorMode)mode );
}

qt_QPixmap *qt_new_QPixmap4(char* fileName,char* format,int conversion_flags)

{
	return (qt_QPixmap *) new QPixmap( (char*)fileName,(char*)format,(int)conversion_flags );
}

qt_QPixmap *qt_new_QPixmap5(char* xpm[])

{
	return (qt_QPixmap *) new QPixmap( (const char*)xpm);
}

qt_QPixmap *qt_new_QPixmap6(qt_QPixmap * arg1)

{
	return (qt_QPixmap *) new QPixmap( (QPixmap&)*arg1 );
}

void qt_del_QPixmap (qt_QPixmap *p)
{
delete (QPixmap*) p;
}

int qt_QPixmap_isNull( qt_QPixmap *instPointer){
	return (int)((QPixmap *)instPointer)->isNull();
}
int qt_QPixmap_width( qt_QPixmap *instPointer){
	return (int)((QPixmap *)instPointer)->width();
}
int qt_QPixmap_height( qt_QPixmap *instPointer){
	return (int)((QPixmap *)instPointer)->height();
}
qt_QSize * qt_QPixmap_size( qt_QPixmap *instPointer){
    QSize s=((QPixmap *)instPointer)->size();
    return (qt_QSize *)new QSize(s.width(),s.height());
}
qt_QRect * qt_QPixmap_rect( qt_QPixmap *instPointer){
    QRect r=((QPixmap *)instPointer)->rect();
    return (qt_QRect *)new QRect(r.left(),r.top(),r.width(),r.height());
}
int qt_QPixmap_depth( qt_QPixmap *instPointer){
	return (int)((QPixmap *)instPointer)->depth();
}
int qt_QPixmap_defaultDepth()
{
	return (int)QPixmap::defaultDepth();
}
void qt_QPixmap_fill( qt_QPixmap *instPointer,qt_QColor * fillColor){
	((QPixmap *)instPointer)->fill((QColor& )*fillColor);
}
void qt_QPixmap_fill1( qt_QPixmap *instPointer,qt_QWidget * arg1,int xofs,int yofs){
	((QPixmap *)instPointer)->fill((QWidget* )arg1,(int )xofs,(int )yofs);
}
void qt_QPixmap_fill2( qt_QPixmap *instPointer,qt_QWidget * arg1,qt_QPoint * ofs){
	((QPixmap *)instPointer)->fill((QWidget* )arg1,(QPoint& )*ofs);
}
void qt_QPixmap_resize( qt_QPixmap *instPointer,int width,int height){
	((QPixmap *)instPointer)->resize((int )width,(int )height);
}
void qt_QPixmap_resize1( qt_QPixmap *instPointer,qt_QSize * arg1){
	((QPixmap *)instPointer)->resize((QSize& )*arg1);
}
qt_QBitmap * qt_QPixmap_mask( qt_QPixmap *instPointer){
	return (qt_QBitmap *)((QPixmap *)instPointer)->mask();
}
void qt_QPixmap_setMask( qt_QPixmap *instPointer,qt_QBitmap * arg1){
	((QPixmap *)instPointer)->setMask((QBitmap& )*arg1);
}
int qt_QPixmap_selfMask( qt_QPixmap *instPointer){
	return (int)((QPixmap *)instPointer)->selfMask();
}
qt_QBitmap * qt_QPixmap_createHeuristicMask( qt_QPixmap *instPointer,int clipTight){
	return (qt_QBitmap *)new QBitmap(((QPixmap *)instPointer)->createHeuristicMask((bool )clipTight));
}
qt_QPixmap * qt_QPixmap_grabWindow( uint arg1,int x,int y,int w,int h)
{
	return (qt_QPixmap *)new QPixmap(QPixmap::grabWindow( (WId)arg1,(int)x,(int)y,(int)w,(int)h));
}
qt_QPixmap * qt_QPixmap_xForm( qt_QPixmap *instPointer,qt_QWMatrix * arg1){
	return (qt_QPixmap *)new QPixmap(((QPixmap *)instPointer)->xForm((QWMatrix& )*arg1));
}
qt_QWMatrix * qt_QPixmap_trueMatrix( qt_QWMatrix * arg1,int w,int h)
{
    QWMatrix m=QPixmap::trueMatrix( (QWMatrix&)*arg1,(int)w,(int)h);
    return (qt_QWMatrix *)new QWMatrix(m.m11(),m.m12(),m.m21(),m.m22(),m.dx(),m.dy());
}
qt_QImage * qt_QPixmap_convertToImage( qt_QPixmap *instPointer){
	return (qt_QImage *)new QImage(((QPixmap *)instPointer)->convertToImage());
}
int qt_QPixmap_convertFromImage( qt_QPixmap *instPointer,qt_QImage * arg1,int mode){
	return (int)((QPixmap *)instPointer)->convertFromImage((QImage& )*arg1,(ColorMode )mode);
}
int qt_QPixmap_convertFromImage1( qt_QPixmap *instPointer,qt_QImage * arg1,int conversion_flags){
	return (int)((QPixmap *)instPointer)->convertFromImage((QImage& )*arg1,(int )conversion_flags);
}
char* qt_QPixmap_imageFormat( char* fileName)
{
	return (char*)QPixmap::imageFormat( (char*)fileName);
}
int qt_QPixmap_load( qt_QPixmap *instPointer,char* fileName,char* format,int mode){
	return (int)((QPixmap *)instPointer)->load((char* )fileName,(char* )format,(ColorMode )mode);
}
int qt_QPixmap_load1( qt_QPixmap *instPointer,char* fileName,char* format,int conversion_flags){
	return (int)((QPixmap *)instPointer)->load((char* )fileName,(char* )format,(int )conversion_flags);
}
int qt_QPixmap_loadFromData( qt_QPixmap *instPointer,unsigned char* buf,unsigned int len,char* format,int mode){
	return (int)((QPixmap *)instPointer)->loadFromData((uchar* )buf,(uint )len,(char* )format,(ColorMode )mode);
}
int qt_QPixmap_loadFromData1( qt_QPixmap *instPointer,unsigned char* buf,unsigned int len,char* format,int conversion_flags){
	return (int)((QPixmap *)instPointer)->loadFromData((uchar* )buf,(uint )len,(char* )format,(int )conversion_flags);
}
int qt_QPixmap_save( qt_QPixmap *instPointer,char* fileName,char* format){
	return (int)((QPixmap *)instPointer)->save((char* )fileName,(char* )format);
}
int qt_QPixmap_serialNumber( qt_QPixmap *instPointer){
	return (int)((QPixmap *)instPointer)->serialNumber();
}
int qt_QPixmap_isOptimized( qt_QPixmap *instPointer){
	return (int)((QPixmap *)instPointer)->isOptimized();
}
void qt_QPixmap_optimize( qt_QPixmap *instPointer,int arg1){
	((QPixmap *)instPointer)->optimize((bool )arg1);
}
int qt_QPixmap_isGloballyOptimized()
{
	return (int)QPixmap::isGloballyOptimized();
}
void qt_QPixmap_optimizeGlobally( int arg1)
{
	QPixmap::optimizeGlobally( (bool)arg1);
}
void qt_QPixmap_detach( qt_QPixmap *instPointer){
	((QPixmap *)instPointer)->detach();
}
int qt_QPixmap_isQBitmap( qt_QPixmap *instPointer){
	return (int)((QPixmap *)instPointer)->isQBitmap();
}
