#include <Python.h>
#include "ComboBox.h"

ComboBox::ComboBox(int rw, Widget *parent=0, const char *name=0)
  : Widget("")
{
  if(parent)
    combobox = new QComboBox(rw,parent->widget, name);
  else
    combobox = new QComboBox(rw,NULL, name);

  setWidget(combobox);
}

ComboBox::ComboBox(Widget *parent=0, const char *name=0)
  : Widget("")
{
  if(parent)
    combobox = new QComboBox(parent->widget, name);
  else
    combobox = new QComboBox(NULL, name);

  setWidget(combobox);
}

ComboBox::~ComboBox()
{
}

void ComboBox::setWidget(QComboBox *_combobox)
{
  combobox = _combobox;
  QObject::connect(combobox,SIGNAL(activated(int)),this,SLOT(activated(int))); 
  QObject::connect(combobox,SIGNAL(highlighted(int)),
		   this,SLOT(highlighted(int))); 
  QObject::connect(combobox,SIGNAL(activated(const char *)),
		   this,SLOT(activated(const char *))); 
  QObject::connect(combobox,SIGNAL(highlighted(const char *)),
		   this,SLOT(highlighted(const char *)));

  Widget::setWidget((QWidget*)combobox);
}


int ComboBox::count() const
{
  return combobox->count();
}


// allows a list of text/pixmaps to be inserted
void ComboBox::insertList(PyObject *list)
{
  int length = PyObject_Length(list);
  for(int i =0; i < length; i++)
    {
      PyObject *o = PySequence_GetItem(list,i);
      if(!o)
	continue;
      char *s = PyString_AsString(PyObject_Str(o));
      if(strcmp(s,"<C QPixmap instance>")==0)
	{
	  printf("SORRY!  Cannot insert pixmaps yet.....use insertPixmap"
		 " instead.\n");
	}
      else
	insertItem(s);
    }
}

void ComboBox::insertItem( const char *text, int index=-1 )
{
  combobox->insertItem(text,index);
}

void ComboBox::insertItem( const QPixmap &pixmap, int index=-1 )
{
  combobox->insertItem(pixmap,index);
}

void ComboBox::removeItem( int index )
{
  combobox->removeItem(index);
}

void ComboBox::clear()
{
  combobox->clear();
}

const char *ComboBox::currentText() const
{
  return combobox->currentText();
}

const char *ComboBox::text( int index ) const
{
  return combobox->text(index);
}

const QPixmap *ComboBox::pixmap( int index ) const
{
  return combobox->pixmap(index);
}

void ComboBox::changeItem( const char *text, int index )
{
  combobox->changeItem(text,index);
}

void ComboBox::changeItem( const QPixmap &pixmap, int index )
{
  combobox->changeItem(pixmap,index);
}

int ComboBox::currentItem() const
{
  return combobox->currentItem();
}

void ComboBox::setCurrentItem( int index )
{
  combobox->setCurrentItem(index);
}

bool ComboBox::autoResize() const
{
  return combobox->autoResize();
}

void ComboBox::setAutoResize( bool ar )
{
  combobox->setAutoResize(ar);
}

QSize ComboBox::sizeHint() const
{
  return combobox->sizeHint();
}

void ComboBox::setBackgroundColor( const QColor & c)
{
  combobox->setBackgroundColor(c);
}

void ComboBox::setPalette( const QPalette & p)
{
  combobox->setPalette(p);
}

void ComboBox::setFont( const QFont & f)
{
  combobox->setFont(f);
}

void ComboBox::setEnabled( int e)
{
  combobox->setEnabled(e);
}

void ComboBox::setSizeLimit( int sl)
{
  combobox->setSizeLimit(sl);
}

int ComboBox::sizeLimit() const
{
  return combobox->sizeLimit();
}

void ComboBox::setMaxCount( int c )
{
  combobox->setMaxCount(c);
}

int ComboBox::maxCount() const
{
  return combobox->maxCount();
}


void ComboBox::setInsertionPolicy( ComboBox::Policy policy )
{
  combobox->setInsertionPolicy((QComboBox::Policy) policy);
}
ComboBox::Policy ComboBox::insertionPolicy() const
{
  return (ComboBox::Policy)combobox->insertionPolicy();
}
  
//signals:

void ComboBox::activated( int index )
{
  PyObject *args;
  args = Py_BuildValue("(i)",index);
  emit("activatedIndex",args);
  Py_XDECREF(args);
}

void ComboBox::highlighted( int index )
{
  PyObject *args;
  args = Py_BuildValue("(i)",index);
  emit("highlightedIndex",args);
  Py_XDECREF(args);

}

void ComboBox::activated( const char * t)
{
  PyObject *args;
  args = Py_BuildValue("(s)",t);
  emit("activatedText",args);
  Py_XDECREF(args);
}

void ComboBox::highlighted( const char * t)
{
  PyObject *args;
  args = Py_BuildValue("(s)",index);
  emit("highlightedText",args);
  Py_XDECREF(args);
}

