#ifndef MULTILINEEDIT_H
#define MULTILINEEDIT_H

#include <qmlined.h>
#include "TableView.h"

class MultiLineEdit : public TableView
{
  Q_OBJECT;
public:
  MultiLineEdit(Widget *parent=0, const char *name=0);
  ~MultiLineEdit();

  const char *textLine(int line) const;
  const char *text() const;
  int numLines() const;
  bool isReadOnly() const;
  bool isOverwriteMode() const;
  virtual void setFont(const QFont& font);
  virtual void insertLine(const char* s, int line = -1);
  virtual void insertAt(const char* s, int line, int col);
  virtual void removeLine(int line);
  void setCursorPosition(int line, int col, int mark=FALSE);
  void getCursorPosition(int *line, int *col);
  bool atBeginning() const;
  bool atEnd() const;
  bool autoUpdate() const;
  void setAutoUpdate(int au);

  // SLOTS
  void clear();
  void setText(const char *text);
  void append(const char *text);
  void deselect();
  void selectAll();
  void setReadOnly(int ro);
  void setOverwriteMode(int ow);
  void paste();
  void copyText();
  void cut();

  // SIGNALS
public slots:
  void textChanged();
  void returnPressed();

public:
  virtual void setWidget(QMultiLineEdit *mle);
  QMultiLineEdit *multilineedit;
};

#endif
