
#include "kproptext.h"
#include "kproptext.moc"
#include <kapp.h>

KPropText::KPropText( QWidget *parent, const char *text, int perc, const char *key, const char *group, KConfig *config, const char *name )
	: QLabel( text, parent,name )
{
	setKConfig( config );
	setGroup( group );
	setKey( key );


//	setText( text );
	setFontPropagation( QWidget::SameFont );
	lineEdit = new QLineEdit( this );

	percentage = perc;

	sizeUpdate();
}

KPropText::~KPropText()
{
	delete lineEdit;
}

void KPropText::sizeUpdate()
{
	QFontMetrics fm( font() );
	int h=fm.height();
	
	setFixedHeight( h + 8 );
	lineEdit->setFixedHeight( h + 4 );
}

void KPropText::resizeEvent( QResizeEvent *rev )
{
	int w = width()*percentage/100;
	lineEdit->setGeometry( width() - w - 2, 2, w - 4, 100 );
}

void KPropText::fontChange( const QFont & )
{
	sizeUpdate();
}

void KPropText::setContents( const char *text )
{
	lineEdit->setText( text );
}

const char *KPropText::getContents()
{
	return lineEdit->text();
}

void KPropText::setConfig()
{
  //	printf("kproptext::setConfig()\n");
	if( ConfigObject )
	{
		ConfigObject->setGroup( Group );
		//		printf("kproptext: group=%s key=%s\n",ConfigObject->group(), Key.data() );
		if( Key.data() != 0 )
			ConfigObject->writeEntry( Key.data(), getContents() );
		else printf("kproptext: Null key not allowed\n");
	}
}

void KPropText::getConfig()
{
  //	printf("kproptext::getConfig()\n");
	if( ConfigObject )
	{
		ConfigObject->setGroup( Group );
		//		printf("kproptext: group set.\n");
		QString s = ConfigObject->readEntry( Key.data() );
		//		printf("kproptext: reading config %s = %s\n",Key.data(), s.data() );
		setContents( s.data() );
	}
}


void KPropText::setKey( const char *key )
{
	Key=key;
}

void KPropText::setGroup( const char *group )
{
	Group= group;
}

void KPropText::setKConfig( KConfig *config )
{
	if( config == 0 )
		ConfigObject = kapp->getConfig();
	else 
		ConfigObject=config;
}

KConfig *KPropText::getKConfig()
{
	return ConfigObject;
}

const char *KPropText::getKey()
{
	return Key.data();
}

const char *KPropText::getGroup()
{
	return Group.data();
}
