// $Id: optionsdlg.cpp,v 1.43 1998/10/03 17:33:33 vespa Exp $

#include <qlayout.h>
#include <qlabel.h>
#include <qgrpbox.h>
#include <qbttngrp.h>
#include <qlined.h>
#include <kapp.h>
#include <qbttngrp.h>
#include <kfontdialog.h>
#include <qfont.h>
#include "kproptext.h"
#include "kpropcombo.h"
#include "kpropspin.h"
#include "kpropcheck.h"
#include "kpropradio.h"
#include "kpropfont.h"
#include "kpropcolor.h"
#include "optionsdlg.h"
#include "optionsdlg.moc"

OptionsDialog::OptionsDialog( const char *title, 
						QWidget *parent, char *name, bool modal )
	: KPropDlg( KPropDlg::TREE, KPropDlg::OK | 
				KPropDlg::CANCEL | KPropDlg::APPLY,
				 title, 0, name, modal )
{
	config = kapp->getConfig();

	personalFrame = addPage( -1, i18n("Personal"));
	setupMainTab();

	timeFrame = addPage( -1, i18n("Time & Date"));
	 setupTimeTab();

	fontsFrame = addPage( -1, i18n("Fonts"));
	setupFontsTab();

	colorsFrame = addPage( -1, i18n("Colors"));
	setupColorsTab();

	viewsFrame = addPage( -1, i18n("Views"));
	setupViewsTab();

	//	displayFrame = addPage( -1, i18n("Display"));
	//	setupDisplayTab();

	printerFrame = addPage( -1, i18n("Printing"));
	setupPrinterTab();

	// Layout
	setMinimumSize(400, 450);
	adjustSize();

	// read settings
	emit getConfig();

	// Setup primary page for display
	showPage(personalFrame);
}

///////////////////////////////////////////////////////////////////////////////

OptionsDialog::~OptionsDialog()
{
}

///////////////////////////////////////////////////////////////////////////////

void OptionsDialog::setupMainTab()
{
	KPropText *textbox;
	
	QVBoxLayout *layout = new QVBoxLayout( personalFrame, 10);

	textbox = new KPropText( personalFrame, i18n("Your name:"), 70, "user_name", "Personal Settings" );
	connectConfig( textbox );
	layout->addWidget( textbox );
	
	textbox = new KPropText( personalFrame, i18n("Email address:"), 70, "user_email", "Personal Settings" );
	connectConfig( textbox );
	layout->addWidget( textbox );

	textbox = new KPropText( personalFrame, i18n("Additional:"), 70, "Additional", "Personal Settings" );
	connectConfig( textbox );
	layout->addWidget( textbox );

	KPropCheck *checkbox = new KPropCheck(personalFrame, i18n("Auto-save Calendar"), "Auto Save", "General");
	connectConfig(checkbox);
	layout->addWidget(checkbox);

	checkbox = new KPropCheck(personalFrame, i18n("Confirm Appointment/Todo Deletes"), "Confirm Deletes", "General");
	connectConfig(checkbox);
	layout->addWidget(checkbox);

	layout->addStretch();
}

///////////////////////////////////////////////////////////////////////////////

void OptionsDialog::setupTimeTab()
{
	// Modifications by Fester
	
	const char *tzList[] = { "-1200", "-1130", "-1100", "-1030", "-1000",
			"-0930", "-0900", "-0830", "-0800", "-0730",
			"-0700", "-0630", "-0600", "-0530", "-0500",
			"-0430", "-0400", "-0330", "-0300", "-0230",
			"-0200", "-0130", "-0100", "-0030", "+0000",
			"+0030", "+0100", "+0130", "+0200", "+0230",
			"+0300", "+0330", "+0400", "+0430", "+0500",
			"+0530", "+0600", "+0630", "+0700", "+0730",
			"+0800", "+0830", "+0900", "+0930", "+1000",
			"+1030", "+1100", "+1130", "+1200", 0L };

	const char *alarmList[] = { "1", "5", "10", "15", "30", 0L };

	const char *hourList[] = { "1", "2", "3", "4", "5", "6", 
				   "7", "8", "9", "10", "11", "12",
				   "13", "14", "15", "16", "17", "18",
				   "19", "20", "21", "22", "23", "24", 0L };

	QVBoxLayout *layout = new QVBoxLayout( timeFrame, 10);

	QHBoxLayout *hlayout = new QHBoxLayout(timeFrame, 10);

	layout->addLayout(hlayout);
	
	KPropCombo *combo = new KPropCombo( timeFrame, i18n("Time Zone:"), 50, "Time Zone", "Time & Date" );

	combo->getCombo()->insertStrList(tzList);
	connectConfig( combo );
	hlayout->addWidget( combo );

	KPropRadio *radio = new KPropRadio( timeFrame, i18n("Time Format:"), "Time Format", "Time & Date" );
	radio->addRadio( "24 hour", FALSE);
	radio->addRadio( "AM / PM", FALSE);
	connectConfig( radio );
	hlayout->addWidget( radio );

	combo = new KPropCombo(timeFrame, i18n("Default Appointment Time:"),
			       25, "Default Start Time", "Time & Date");
	combo->getCombo()->insertStrList(hourList);
	connectConfig(combo);
	layout->addWidget(combo);

	combo = new KPropCombo(timeFrame, i18n("Default Alarm Time:"),
			       25, "Default Alarm Time", "Time & Date");
	combo->getCombo()->insertStrList(alarmList);
	connectConfig(combo);
	layout->addWidget(combo);

	radio = new KPropRadio( timeFrame, i18n("Date Format:"), "Date Format", "Time & Date" );
	radio->addRadio( i18n("Day/Month/Year"), FALSE);
	radio->addRadio( i18n("Month/Day/Year"), FALSE);
	radio->addRadio( i18n("Year/Month/Day"), FALSE);
	connectConfig( radio );
	layout->addWidget( radio );

	KPropSpin *spin = new KPropSpin( timeFrame, i18n("Test"), 
						50, 
						"Spintest", "Test tag" );
	connectConfig( spin );
	layout->addWidget( spin );


	layout->addStretch();


}

///////////////////////////////////////////////////////////////////////////////

void OptionsDialog::setupViewsTab()
{
	// I'm working on this section. Expect major revision shortly. (Fester)
	QVBoxLayout *layout = new QVBoxLayout( viewsFrame, 10);

	KPropText *startDisplay = new KPropText(viewsFrame, i18n("Day Begins At:"), 50, "Day Begins", "Views");
	if (!strcmp(startDisplay->text(),""))
	  startDisplay->setText("8");
	connectConfig(startDisplay);
	layout->addWidget(startDisplay);

 	layout->addStretch();
}
///////////////////////////////////////////////////////////////////////////////
void OptionsDialog::setupFontsTab()
{
	// I'm working on this section. Expect major revision shortly. (Fester)
	// Finally :)
	
	QVBoxLayout *layout = new QVBoxLayout( fontsFrame, 10 );

	KPropFont *fontdlg = new KPropFont( fontsFrame, i18n("Appointment"), 
					    "List view font", 50, 
					    "List Font", "Fonts" );
	connectConfig( fontdlg );
	layout->addWidget( fontdlg );

	fontdlg = new KPropFont( fontsFrame, i18n("Appointment"), 
				 "Schedule view font", 50, 
				 "Schedule Font", "Fonts" );
	connectConfig( fontdlg );
	layout->addWidget( fontdlg );

	fontdlg = new KPropFont( fontsFrame, i18n("Appointment"), 
				 "Month view font", 50, 
				 "Month Font", "Fonts" );
	connectConfig( fontdlg );
	layout->addWidget( fontdlg );

	fontdlg = new KPropFont( fontsFrame, "12345", "Time bar font",
				 50, "TimeBar Font", "Fonts" );
	connectConfig( fontdlg );
	layout->addWidget( fontdlg );

	fontdlg = new KPropFont( fontsFrame, i18n("Things to do"),
				 "Todo list font", 50,
				 "Todo Font", "Fonts" );
	connectConfig( fontdlg );
	layout->addWidget( fontdlg );

	layout->addStretch();	

}
///////////////////////////////////////////////////////////////////////////////
void OptionsDialog::setupColorsTab()
{
	// I'm working on this section. Expect major revision shortly. (Fester)
	
	QVBoxLayout *layout = new QVBoxLayout( colorsFrame, 10 );

	KPropColor *colordlg = new KPropColor( colorsFrame, i18n("Appointment"), 
						50, 
						"List Color", "Colors" );
	connectConfig( colordlg );
	layout->addWidget( colordlg );

 	layout->addStretch();

}
///////////////////////////////////////////////////////////////////////////////
void OptionsDialog::setupDisplayTab()
{
	// I'm working on this section. Expect major revision shortly. (Fester)
	QVBoxLayout *layout = new QVBoxLayout( displayFrame, 10 );

	KPropSpin *spin = new KPropSpin( displayFrame, i18n("Test"), 
						50, 
						"Spintest", "Test tag" );
	connectConfig( spin );
	layout->addWidget( spin );

 	layout->addStretch();

}
///////////////////////////////////////////////////////////////////////////////

void OptionsDialog::setupPrinterTab()
{
	
	QVBoxLayout *layout = new QVBoxLayout( printerFrame, 10 );

	KPropRadio *radio = new KPropRadio( printerFrame, i18n("Paper Size"),
					    "Size", "Printer" );
	radio->addRadio( i18n("A4"), FALSE);
	radio->addRadio( i18n("B5"), FALSE);
	radio->addRadio( i18n("Letter"), TRUE);
	radio->addRadio( i18n("Legal"), FALSE);
	radio->addRadio( i18n("Executive"), FALSE);
	connectConfig( radio );
	layout->addWidget( radio );

	radio = new KPropRadio(printerFrame, i18n("Paper Orientation"),
			       "Orientation", "Printer");
	radio->addRadio(i18n("Portrait"), FALSE);
	radio->addRadio(i18n("Landscape"), TRUE);
	connectConfig(radio);
	layout->addWidget(radio);

	KPropText *prevText = new KPropText(printerFrame, 
					    i18n("Preview Program"),
					    50, "Preview", "Printer");
	connectConfig(prevText);
	if (!strcmp(prevText->text(), ""))
	  prevText->setText("gv");
	layout->addWidget(prevText);

 	layout->addStretch();
}

///////////////////////////////////////////////////////////////////////////////





