#include <stdio.h>

#include <qtabdialog.h>

#include <kspell.h>
#include <ktmainwindow.h>
#include <ksconfig.h>
#include <kstdaction.h>
#include <kaction.h>

#include "kspelldemo.moc"

KSpellDemo::KSpellDemo (const char *name=0) :
  KTMainWindow (name)
{

  KAction *spelling = KStdAction::spelling (this, SLOT(slotSpellCheck()),
      actionCollection());

  new KAction ( "&Configure spellchecker...", 0,
		this, SLOT (slotConfigure()), actionCollection(), 
		"configure_spellchecker" );
  
  createGUI();
  

  label = new QLabel ("Som words are mispelled!", this);
  setView (label);
}

void
KSpellDemo::slotSpellCheck()
{
  QString text (label->text());

  KSpell::modalCheck (text);
  label->setText (text);
}

void
KSpellDemo::slotConfigure()
{
  QTabDialog qtabdialog (0, 0, true);
  qtabdialog.setCancelButton();
  KSpellConfig ksconfig (&qtabdialog);
  qtabdialog.addTab (&ksconfig, "&Spellchecker");
  if (qtabdialog.exec())
    ksconfig.writeGlobalSettings();
}
