#ifndef CUPSPAGEPARSER_H
#define CUPSPAGEPARSER_H

#include "cupsparser.h"

#include <qregexp.h>

class QWidget;

class CupsPageParser : public CupsParser
{
	Q_OBJECT
public:
	CupsPageParser( QObject *parent = 0 );
	~CupsPageParser();

	QStringList fields();
	void setupRMB( QListViewItem*, QPopupMenu* );

protected slots:
	void computePagesYear();
	void computePagesMonth();
	void computePagesWeek();
	void computePagesDay();
	void computePagesOther();

protected:
	Item* lineToItem( const QString& );
	void computePages( const QString&, const QDateTime& );

private:
	QRegExp m_re;
	QString m_user;
	QWidget *m_widget;
};

#endif /* CUPSERRORPARSER_H */
