/*
   This file is part of the Nepomuk KDE project.
   Copyright (C) 2007 Sebastian Trueg <trueg@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
 */

#ifndef _NEPOMUK_SEARCH_HIT_MODEL_H_
#define _NEPOMUK_SEARCH_HIT_MODEL_H_

#include <../resource-visualization/resourcemodel.h>

#include "searchresult.h"

#include <nepomuk/nepomuk_export.h>

namespace Nepomuk {
    class NEPOMUK_EXPORT SearchHitModel : public ResourceModel
    {
        Q_OBJECT

    public:
        SearchHitModel( QObject* parent = 0 );
        ~SearchHitModel();

        enum Roles {
            ResourceRole = 6000,
            ScoreRole = 6001
        };
        
        void setResources( const QList<Search::Result>& resources );

        QModelIndex indexForResource( const QUrl& uri ) const;
        QUrl resourceForIndex( const QModelIndex& index ) const;
        double scoreForIndex( const QModelIndex& index ) const;

        QVariant data( const QModelIndex& index, int role ) const;

        int rowCount( const QModelIndex& parent = QModelIndex() ) const;

        QModelIndex index( int row, int column, const QModelIndex& parent = QModelIndex() ) const;

    public Q_SLOTS:
        void updateResource( const Search::Result& resource );

    private:
        class Private;
        Private* const d;
    };
}

#endif
