/************************************************************************
 * kinst - KDE Application Installer - gui.cpp                          *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "gui.h"

#ifndef KIF_MAGIC
#define KIF_MAGIC "[KDE Install Information]"
#endif

#ifndef MAIN_WINDOW_WIDTH
#define MAIN_WINDOW_WIDTH 522
#endif

#ifndef MAIN_WINDOW_HEIGHT
#define MAIN_WINDOW_HEIGHT 262
#endif

#ifndef EOL
#define EOL 10
#endif

#ifndef EOS
#define EOS 0
#endif

// Meta Object Compiler code inclusion
#include "gui.moc"

// some pictures
#include "kinstpic.xpm"

kinstMainWidget::kinstMainWidget():KMainWindow()
{
  QFont AFont;
  KIFReader = new tKIFReader;
  KIFInstall = new tKIFInstall(_KIF_Source_Directory, this);
  KDEConfig = new tKDEConfig();
  GNOMEConfig = new tGNOMEConfig();
  ScriptRun = new tScriptRun(_KIF_Source_Directory);
  SharedLibs = new tInstSharedLibraries();
  KISS = new tKISS(_KIF_Source_Directory);

  // Create YesNoDlg
  YesNoDlg = new tYesNoDlg(this, _i18n("kinst - Shared Libraries"),
			   "YesNoDlg");
  YesNoDlg->hide();

  // Main window properties
  resize(MAIN_WINDOW_WIDTH, MAIN_WINDOW_HEIGHT);
  setMinimumSize(MAIN_WINDOW_WIDTH, MAIN_WINDOW_HEIGHT);

  // Set the program icon
  // - this is done automagically by KDE

  // Create SetupPicture
  SetupPicture = new QPixmap(kinstpic);

  // Create SetupPictureLabel
  SetupPictureLabel = new QLabel(this);
  SetupPictureLabel->setAlignment(AlignCenter);
  SetupPictureLabel->setPixmap(*SetupPicture);
  SetupPictureLabel->setFrameStyle(QFrame::Panel|QFrame::Sunken);
  SetupPictureLabel->setLineWidth(2);
  SetupPictureLabel->setMargin(0);

  // Create TitleLabel
  TitleLabel = new QLabel(this);
  TitleLabel->setText("");
  AFont.setPointSize(20);
  AFont.setBold(true);
  TitleLabel->setFont(AFont);

  // Define rectangular section
  r = new QRect();

  // Create Frame
  Frame = new QFrame(this);
  // Don't actually know if it looks better with or without...
  Frame->setFrameStyle(QFrame::Box|QFrame::Sunken);
  // Frame->hide();

  // Create InfoLabel
  InfoLabel = new QLabel(this);
  InfoLabel->setText("");
  InfoLabel->hide();

  // Create Separation
  Separation = new QFrame(this);
  Separation->setFrameStyle(QFrame::HLine|QFrame::Sunken);

  // Create DestFolderLabel
  DestFolderLabel = new QLabel(this);
  DestFolderLabel->setText(_i18n("Install to folder:"));
  DestFolderLabel->hide();

  // Create DestFolderLineEdit
  DestFolderLineEdit = new QLineEdit(this);
  DestFolderLineEdit->setText("");
  DestFolderLineEdit->hide();

  // Create DestGroupLabel
  DestGroupLabel = new QLabel(this);
  DestGroupLabel->setText(_i18n("Add to program group:"));
  DestGroupLabel->hide();

  // Create DestGroupButton
  DestGroupButton = new QPushButton(this);
  DestGroupButton->setText(_i18n("Browse"));
  DestGroupButton->hide();
  connect(DestGroupButton, SIGNAL(clicked()), SLOT(DestGroupButtonPressed()));

  // Create DestGroupLineEdit
  DestGroupLineEdit = new QLineEdit(this);
  DestGroupLineEdit->setText("");
  DestGroupLineEdit->hide();

  // Create DestFolderButton
  DestFolderButton = new QPushButton(this);
  DestFolderButton->setText(_i18n("Browse"));
  DestFolderButton->hide();
  connect(DestFolderButton,SIGNAL(clicked()),SLOT(DestFolderButtonPressed()));

  // Create DestFolderDialog
  DestFolderDialog = new KFileDialog(getenv("HOME"),"*",this,"",false);
  DestFolderDialog->hide();

  // Create MultiLineEdit
  MultiLineEdit = new QMultiLineEdit(this);
  MultiLineEdit->clear();
  MultiLineEdit->setReadOnly(true);

  // Create URLViewButton
  URLViewButton = new QPushButton(this);
  URLViewButton->setText(_i18n("Go to their WebSite"));
  URLViewButton->hide();
  connect(URLViewButton, SIGNAL(clicked()), SLOT(OpenTheURL()));

  // Create ProgressBar
  ProgressBar = new KProgress(0,5,0,KProgress::Horizontal,this);
  ProgressBar->setTextEnabled(true);
  ProgressBar->hide();

  // Create Install1_check
  Install1_check = new QCheckBox(this);
  Install1_check->setText("");
  Install1_check->setChecked(true);
  Install1_check->setEnabled(false);
  Install1_check->hide();

  // Create Install2_check
  Install2_check = new QCheckBox(this);
  Install2_check->setText("");
  Install2_check->setChecked(false);
  Install2_check->hide();

  // Create Install3_check
  Install3_check = new QCheckBox(this);
  Install3_check->setText("");
  Install3_check->setChecked(false);
  Install3_check->hide();

  // Create Install4_check
  Install4_check = new QCheckBox(this);
  Install4_check->setText("");
  Install4_check->setChecked(false);
  Install4_check->hide();

  // Create Install5_check
  Install5_check = new QCheckBox(this);
  Install5_check->setText("");
  Install5_check->setChecked(false);
  Install5_check->hide();

  // Create Install6_check
  Install6_check = new QCheckBox(this);
  Install6_check->setText("");
  Install6_check->setChecked(false);
  Install6_check->hide();

  // Create KMenuTree
  KMenuTreeDlg = new tKMenuTreeDlg(this, "KMenuTree");
  KMenuTreeDlg->hide();

  // Create RPMDepDlg
  RPMDepDlg = new tRPMDepDlg(this, "RPMDepDlg");
  RPMDepDlg->hide();

  // Create ExitButton
  ExitButton = new QPushButton(this);
  ExitButton->setText(_i18n("Exit"));
  connect(ExitButton,SIGNAL(clicked()),kapp,SLOT(quit()));

  // Create NextButton
  NextButton = new QPushButton(this);
  NextButton->setText(_i18n("Next >"));
  NextButton->setDefault(true);
  NextButton->setFocus();
  connect(NextButton,SIGNAL(clicked()),SLOT(NextPressed()));

  // Create PreviousButton
  PreviousButton = new QPushButton(this);
  PreviousButton->setText(_i18n("< Back"));
  PreviousButton->setEnabled(false);
  connect(PreviousButton,SIGNAL(clicked()),SLOT(PreviousPressed()));

  // Create About Button
  AboutButton = new QPushButton(this);
  AboutButton->setText(_i18n("About..."));
  connect(AboutButton,SIGNAL(clicked()),SLOT(AboutPressed()));

  // Create FileProgress
  FileProgress = new KProgress(this, "fileprogress");
  FileProgress->hide();

  // Create ProcessingFile_label
  ProcessingFile_label = new QLabel(this);
  ProcessingFile_label->hide();

  StepNr = 1;
}

int kinstMainWidget::kinstMainWidgetKIFinit(char *infofilename)
{
  QString String;
  char String2[1024];
  FILE* ReadMeFile;

  if(!KIFReader->OpenKIFfile(infofilename)) return(0);

  if(!KIFReader->CheckFileType(KIF_MAGIC)) return(0);

  if(!KIFReader->ParseKIFfile()) return(0);

  String = KIFReader->KIFOptions->ProgramName;
  String += _i18n(" Installation");
  TitleLabel->setText(String);

  Install1_check->setText(KIFReader->KIFOptions->ProgramName);

  if(strlen(KIFReader->KIFOptions->ProgramName2[0]) != 0) {
    Install2_check->setText(KIFReader->KIFOptions->ProgramName2[0]);
    Install2_check->setChecked(true);
  }

  if(strlen(KIFReader->KIFOptions->ProgramName2[1]) != 0) {
    Install3_check->setText(KIFReader->KIFOptions->ProgramName2[1]);
    Install3_check->setChecked(true);
  }

  if(strlen(KIFReader->KIFOptions->ProgramName2[2]) != 0) {
    Install4_check->setText(KIFReader->KIFOptions->ProgramName2[2]);
    Install4_check->setChecked(true);
  }

  if(strlen(KIFReader->KIFOptions->ProgramName2[3]) != 0) {
    Install5_check->setText(KIFReader->KIFOptions->ProgramName2[3]);
    Install5_check->setChecked(true);
  }

  if(strlen(KIFReader->KIFOptions->ProgramName2[4]) != 0) {
    Install6_check->setText(KIFReader->KIFOptions->ProgramName2[4]);
    Install6_check->setChecked(true);
  }

  String = _i18n("This program installs ");
  String += KIFReader->KIFOptions->ProgramName;
  String += _i18n(" on this host.");
  MultiLineEdit->append(String);

  DestFolderLineEdit->setText(KIFReader->KIFOptions->DefaultInstallPath);

  if(strcmp(KIFReader->KIFOptions->RelocatablePackage, "NO") == 0)
    {
      DestFolderLineEdit->setEnabled(false);
      DestFolderButton->setEnabled(false);
    }

  if(strlen(KIFReader->KIFOptions->DefaultMenuEntry) != 0)
    DestGroupLineEdit->setText(KIFReader->KIFOptions->DefaultMenuEntry);
  else
    DestGroupLineEdit->setEnabled(false);

  if(strlen(KIFReader->KIFOptions->GraphicsFile) != 0)
    {
      QPixmap pixmap(KIFReader->KIFOptions->GraphicsFile);
      SetupPictureLabel->setPixmap(pixmap);
    }
    
  realpath(infofilename, String2);
  strncpy(_KIF_Source_Directory, dirname(String2), FILENAME_MAX);

  // let's get the readme
  ReadMeFile = NULL;
  String = _KIF_Source_Directory;
  String += "/";
  String += KIFReader->KIFOptions->ReadMeFile;
  qstrncpy(String2, String, 1024);
  if(strlen(KIFReader->KIFOptions->ReadMeFile) > 0)
    ReadMeFile = fopen(String2, "r");
#ifdef _DEBUG_
  perror("gui: getReadme");
#endif

  if(ReadMeFile != NULL) MultiLineEdit->clear();

#ifdef _DEBUG_
  if(ReadMeFile == NULL)
    printf("gui: Error reading %s\n", KIFReader->KIFOptions->ReadMeFile);
#endif

  String = "";

  if(ReadMeFile != NULL)
    while(!feof(ReadMeFile))
      {
    	fgets(String2, 1024, ReadMeFile);
    	if(strlen(String2)>0) String2[strlen(String2)-1] = EOS;
	else String2[0] = EOS;
    	MultiLineEdit->append(String2);
      }

  if(ReadMeFile != NULL) fclose(ReadMeFile);

  MultiLineEdit->setCursorPosition(0, 0);

  if(strlen(KIFReader->KIFOptions->URL) > 0) URLViewButton->show();

  return(1);
}

void kinstMainWidget::newContent(int nr)
{
  switch(nr)
    {
      case 1:DestFolderLabel->hide();
	DestFolderLineEdit->hide();
	DestGroupLabel->hide();
	DestGroupLineEdit->hide();
	DestGroupButton->hide();
	InfoLabel->hide();
	DestFolderButton->hide();
	MultiLineEdit->show();
	if(strlen(KIFReader->KIFOptions->URL) > 0) URLViewButton->show();
	NextButton->setText(_i18n("Next >"));
	PreviousButton->setEnabled(false);
	Install1_check->hide();
	Install2_check->hide();
	Install3_check->hide();
	Install4_check->hide();
	Install5_check->hide();
	Install6_check->hide();
	break;
      case 2:if((strlen(Install2_check->text()) == 0) &&
		(strlen(Install3_check->text()) == 0) &&
		(strlen(Install4_check->text()) == 0) &&
		(strlen(Install5_check->text()) == 0) &&
		(strlen(Install6_check->text()) == 0))
	{
	  if(MultiLineEdit->isVisible()) StepNr++; else StepNr--;
	  newContent(StepNr);
	  break;
	}
	DestFolderLabel->hide();
	DestFolderLineEdit->hide();
	DestGroupLabel->hide();
	DestGroupLineEdit->hide();
	DestGroupButton->hide();
	DestFolderButton->hide();
	MultiLineEdit->hide();
	URLViewButton->hide();
	NextButton->setText(_i18n("Next >"));
	PreviousButton->setEnabled(true);
	InfoLabel->setText(_i18n("Please choose which parts of the software\nshould be installed."));
	InfoLabel->show();
	Install1_check->show();
	if(strlen(Install2_check->text()) != 0) Install2_check->show();
	if(strlen(Install3_check->text()) != 0) Install3_check->show();
	if(strlen(Install4_check->text()) != 0) Install4_check->show();
	if(strlen(Install5_check->text()) != 0) Install5_check->show();
	if(strlen(Install6_check->text()) != 0) Install6_check->show();
	break;
      case 3:DestFolderLabel->show();
	DestFolderLineEdit->show();
	DestGroupLabel->hide();
	DestGroupLineEdit->hide();
	DestGroupButton->hide();
	DestFolderButton->show();
	MultiLineEdit->hide();
	URLViewButton->hide();
	NextButton->setText(_i18n("Next >"));
	PreviousButton->setEnabled(true);
	InfoLabel->setText(_i18n("Here you can specify where to install the program files.\nThe specified directory will be used as root directory."));
	InfoLabel->show();
	Install1_check->hide();
	Install2_check->hide();
	Install3_check->hide();
	Install4_check->hide();
	Install5_check->hide();
	Install6_check->hide();
	break;
      case 4:DestFolderLabel->hide();
	DestFolderLineEdit->hide();
	DestGroupLabel->show();
	DestGroupLineEdit->show();
	DestGroupButton->show();
	DestFolderButton->hide();
	MultiLineEdit->hide();
	URLViewButton->hide();
	NextButton->setText(_i18n("Install"));
	PreviousButton->setEnabled(true);
	InfoLabel->setText(_i18n("The installation routine will place a program start link\nto the KDE menu entry you chose here.\nPress 'Install' to start the installation."));
	InfoLabel->show();
	Install1_check->hide();
	Install2_check->hide();
	Install3_check->hide();
	Install4_check->hide();
	Install5_check->hide();
	Install6_check->hide();
	break;
    default:fprintf(stderr, "kinst: Internal widget management error!\n");
    }
}

void kinstMainWidget::NextPressed()
{
  if(StepNr < 4)
    {
      StepNr++;
      newContent(StepNr);
    }
  else
    {
      if(strstr(DestGroupLineEdit->text(), "/") != 0)
	{
	  QMessageBox::information(this, "kinst",
				   _i18n("Specifying a KDE subgroup is currently not supported."));
	  return;
	}
      StartInstallation();
    }
}

void kinstMainWidget::PreviousPressed()
{
  if(StepNr > 1) StepNr--;
  newContent(StepNr);
}

void kinstMainWidget::AboutPressed()
{
  QString AboutMsg;

  AboutMsg = _i18n("kinst - KDE Application Installer\n\n(C) 2000 Steffen Sobiech (ssobiech@cityweb.de)\n\nThis program underlies the GPL.\nkinst comes with ABSOLUTELY NO WARRANTY.");
#ifdef VERSION
  AboutMsg += _i18n("\n\nVersion ");
  AboutMsg += VERSION;
#endif

  QMessageBox::information(this, _i18n("About kinst"), AboutMsg);
}

void kinstMainWidget::DestFolderButtonPressed()
{
  char newdir[FILENAME_MAX];

  qstrncpy(newdir, DestFolderDialog->getExistingDirectory(getenv("HOME"),
							  this, ""),
	   FILENAME_MAX);
  DestFolderDialog->hide();

  // if first char is not '/' it CAN'T be valid
  if(newdir[0] == '/') DestFolderLineEdit->setText(newdir);
}

void kinstMainWidget::closeEvent(QCloseEvent *e)
{
  e->ignore();
}

void kinstMainWidget::resizeEvent(QResizeEvent*)
{
  SetupPictureLabel->setGeometry(1,(height()/2)-130,122,260);

  TitleLabel->setGeometry(SetupPictureLabel->x()+SetupPictureLabel->width()+10,
			  10,
			  /* width()-273, */ /* why was this here? */
			  width()-150, /* should work better ... */
			  23);

  r->setRect(SetupPictureLabel->x()+SetupPictureLabel->width()+10,
	     TitleLabel->y()+TitleLabel->height()+10,
	     width()-SetupPictureLabel->x()-SetupPictureLabel->width()-15,
	     height()-TitleLabel->y()-TitleLabel->height()-52);

  Frame->setGeometry(r->x()+5,
		     r->y()+5,
		     r->width()-10,
		     r->height()-15);

  Separation->setGeometry(r->x()-5,
			  r->bottom()+4,
			  r->width()+7,
			  3);

  DestFolderLabel->setGeometry(Frame->x()+20,
			       Frame->height()-10,
			       Frame->width()-40,
			       20);

  DestFolderLineEdit->setGeometry(Frame->x()+20,
				  Frame->height()+10,
				  Frame->width()-100,
				  20);

  DestGroupLabel->setGeometry(Frame->x()+20,
			      Frame->height()-10,
			      Frame->width()-40,
			      20);

  DestGroupLineEdit->setGeometry(Frame->x()+20,
				 Frame->height()+10,
				 Frame->width()-100,
				 20);

  DestGroupButton->setGeometry(DestGroupLineEdit->x()+
			       DestGroupLineEdit->width()+5,
			       Frame->height()+8,
			       Frame->width()-DestFolderLineEdit->width()-33,
			       24);

  DestFolderButton->setGeometry(DestFolderLineEdit->x()+
				DestFolderLineEdit->width()+5,
				Frame->height()+8,
				Frame->width()-DestFolderLineEdit->width()-33,
				24);

  MultiLineEdit->setGeometry(Frame->x()+10,
			     Frame->y()+10,
			     Frame->width()-20,
			     Frame->height()-20);
  if(strlen(KIFReader->KIFOptions->URL) > 0)
    {
      MultiLineEdit->setGeometry(Frame->x()+10,
				 Frame->y()+10,
				 Frame->width()-20,
				 Frame->height()-40);
      URLViewButton->setGeometry(Frame->x()+10,
				 MultiLineEdit->y()+MultiLineEdit->height()+2,
				 Frame->width()-20,
				 20);
    }

  InfoLabel->setGeometry(Frame->x()+10,
			 Frame->y()+10,
			 Frame->width()-20,
			 Frame->height()-65);

  ProgressBar->setGeometry(Frame->x()+20,
			   Frame->height()+10,
			   Frame->width()-40,
			   20);

  FileProgress->setGeometry(Frame->x()+20,
			    Frame->height()-20,
			    Frame->width()-40,
			    20);

  Install1_check->setGeometry(Frame->x()+20,
			      Frame->height()-10,
			      (Frame->width()-40)/2-2,
			      15);

  Install2_check->setGeometry(Install1_check->x(),
			      Install1_check->y()+
			      Install1_check->height()+2,
			      (Frame->width()-40)/2-2,
			      15);

  Install3_check->setGeometry(Install2_check->x(),
			      Install2_check->y()+
			      Install2_check->height()+2,
			      (Frame->width()-40)/2-2,
			      15);

  Install4_check->setGeometry(Install1_check->x()+Install1_check->width()+4,
			      Install1_check->y(),
			      (Frame->width()-40)/2-2,
			      15);

  Install5_check->setGeometry(Install4_check->x(),
			      Install4_check->y()+
			      Install4_check->height()+2,
			      (Frame->width()-40)/2-2,
			      15);

  Install6_check->setGeometry(Install5_check->x(),
			      Install5_check->y()+
			      Install5_check->height()+2,
			      (Frame->width()-40)/2-2,
			      15);

  ExitButton->setGeometry(width()-82,
			  height()-32,
			  80,
			  30);

  NextButton->setGeometry(width()-192,
			  height()-32,
			  80,
			  30);

  PreviousButton->setGeometry(width()-272,
			      height()-32,
			      80,
			      30);

  AboutButton->setGeometry(SetupPictureLabel->width()+6,
			   height()-32,
			   80,
			   30);
 }

void kinstMainWidget::OpenTheURL()
{
  (void) new KRun(KIFReader->KIFOptions->URL);
}

void kinstMainWidget::DestGroupButtonPressed()
{
  char ChosenMenu[FILENAME_MAX];
  KMenuTreeDlg->getMenuName(ChosenMenu);
  if(strlen(ChosenMenu) > 0) DestGroupLineEdit->setText(ChosenMenu);
}

int kinstMainWidget::StartInstallation()
{
  char libdir[FILENAME_MAX];
  char libsearch[FILENAME_MAX];
  QString errText;
  QString LabelText;
  char s[FILENAME_MAX];
  int inst_err;
  int nonfatal;
  int i, w;

  // Install main package
  // --------------------

  inst_err = 1;
  nonfatal = 1;

  errText = "";

  i = 1;

  DestGroupLabel->hide();
  DestGroupLineEdit->hide();
  DestGroupButton->hide();
  DestFolderLabel->hide();
  DestFolderLineEdit->hide();
  ExitButton->setEnabled(false);
  NextButton->setEnabled(false);
  PreviousButton->setEnabled(false);
  AboutButton->setEnabled(false);

  InfoLabel->setAlignment(AlignCenter);
  LabelText = _i18n("Installing ");
  LabelText += KIFReader->KIFOptions->ProgramName;
  LabelText += _i18n(" ...");
  InfoLabel->setText(LabelText);

  KDEConfig->KDELNKfilename = "";
  GNOMEConfig->GNOMELNKfilename = "";

  ProgressBar->show();

  kapp->processEvents();

  RPMDepDlg->setOptions(*KIFReader->KIFOptions);
  RPMDepDlg->startCyclus(-1);

  qstrncpy(KIFReader->KIFOptions->DefaultMenuEntry, DestGroupLineEdit->text(),
	   1024);

  qstrncpy(KIFReader->KIFOptions->DefaultInstallPath,
	   DestFolderLineEdit->text(), 1024);

  LabelText = _i18n("Installing ");
  LabelText += KIFReader->KIFOptions->ProgramName;
  LabelText += _i18n(" ...\nExecuting Pre-Install-Script...");
  InfoLabel->setText(LabelText);
  
  kapp->processEvents();

  if(inst_err == 1)
    {
      ScriptRun->setOptions(KIFReader->KIFOptions);
      inst_err = ScriptRun->runPreScript(-1);
    }

  if(inst_err == 1)
    {
      LabelText = _i18n("Installing ");
      LabelText += KIFReader->KIFOptions->ProgramName;
      LabelText += _i18n(" ...\nUnpacking Application...");
      InfoLabel->setText(LabelText);
      ProgressBar->setValue(1);
      FileProgress->show();
      kapp->processEvents();
    }

  if(inst_err == 1)
    if((strcmp(KIFReader->KIFOptions->RelocatablePackage, "NO") == 0)&&
       (strcasecmp(KIFReader->KIFOptions->SourceFileType, "RPM") == 0))
      inst_err = KIFInstall->Install(*KIFReader->KIFOptions, "", -1,
				     (void*) this);
    else
    inst_err = KIFInstall->Install(*KIFReader->KIFOptions,
				   DestFolderLineEdit->text(), -1,
				   (void*) this);


  if(inst_err == 1)
    {
      LabelText = _i18n("Installing ");
      LabelText += KIFReader->KIFOptions->ProgramName;
      LabelText += _i18n(" ...\nRegistering to KDE...");
      InfoLabel->setText(LabelText);
      ProgressBar->setValue(2);
      FileProgress->hide(); FileProgress->setValue(0);
      kapp->processEvents();
    }

  if(inst_err == 0) {
    errText = KIFReader->KIFOptions->ProgramName;
    errText += _i18n("\nFailure!");
  }

  if(inst_err == 2) {
    errText = KIFReader->KIFOptions->ProgramName;
    errText += _i18n("\nSource File Error");
  }

  if(inst_err == 3) {
    errText = KIFReader->KIFOptions->ProgramName;
    errText += _i18n("\nWrite error");
  }

  if(inst_err == 4) {
    errText = KIFReader->KIFOptions->ProgramName;
    errText += _i18n("\nAlready Installed!");
  }

  // Go on creating the KDE and GNOME stuff
  if((inst_err == 1) && (strlen(KIFReader->KIFOptions->DefaultMenuEntry) != 0))
    {
      inst_err = 0;
      KDEConfig->setOptions(KIFReader->KIFOptions);
      GNOMEConfig->setOptions(KIFReader->KIFOptions);
      inst_err = KDEConfig->DetermineKDELNK(-1);
      if(GNOMEConfig->isGNOMEinstalled()) GNOMEConfig->DetermineGNOMELNK(-1);
      if(inst_err == 1) inst_err = KDEConfig->OpenKDELNK();
      if(inst_err == 1) inst_err = KDEConfig->WriteKDELNK(-1);
      if(inst_err == 1) KDEConfig->CloseKDELNK();

      if((GNOMEConfig->isGNOMEinstalled()) && (inst_err == 1))
	{
	  GNOMEConfig->OpenGNOMELNK();
	  GNOMEConfig->WriteGNOMELNK(-1);
	  GNOMEConfig->CloseGNOMELNK();
	}

      // Fix the error codes
      if(inst_err != 1)
	{
	  if(inst_err == 3)
	    {
	      inst_err = 1;
	      nonfatal = 6;
	    }
	  else
	    inst_err = 5;
	}
    }

  // Install shared libraries
  if(strlen(KIFReader->KIFOptions->LibraryDir) != 0)
    {
      if(inst_err == 1)
	{
	  LabelText = _i18n("Installing ");
	  LabelText += KIFReader->KIFOptions->ProgramName;
	  LabelText += _i18n(" ...\nInstalling Shared Libraries...");
	  InfoLabel->setText(LabelText);
	  ProgressBar->setValue(3);
	  kapp->processEvents();
	}
      
      if(inst_err == 1)
	{
	  strncpy(libdir, KIFReader->KIFOptions->DefaultInstallPath, FILENAME_MAX);
	  _strncat(libdir, "/", FILENAME_MAX);
	  _strncat(libdir, KIFReader->KIFOptions->LibraryDir, FILENAME_MAX);
#ifdef _DEBUG_
	  printf("gui: libsearchdir %s\n", libdir);
#endif
	  SharedLibs->RestartLibDir(libdir);
	  while(i != 2)
	    {
	      i = SharedLibs->CheckNextLibrary(libsearch);
	      switch(i)
		{
		case 0: sprintf(s, _i18n("This program needs the library %s that is installed\non your system with an insufficient version number.\nShall I install the library with the coreect version?"), libsearch);
		  if(YesNoDlg->getYesNo(s))
		    {
		      strcpy(s, KIFReader->KIFOptions->DefaultInstallPath);
		      strcat(s, "/");
		      strcat(s, KIFReader->KIFOptions->LibraryDir);
		      kapp->processEvents();
		      if(!SharedLibs->InstallLibrary(libsearch, s))
			inst_err = 9;
		    }
		  break;
		case 1: break;
		case 2: break;
		case 3: inst_err = 9;
#ifdef _DEBUG_
		  printf("gui:  SharedLibs err: to search library not found\n");
#endif
		  break;
		case 4: sprintf(s, _i18n("The library %s was not found on your system.\nShall I install the library?"), libsearch);
		  if(YesNoDlg->getYesNo(s))
		    {
		      strcpy(s, KIFReader->KIFOptions->DefaultInstallPath);
		      strcat(s, "/");
		      strcat(s, KIFReader->KIFOptions->LibraryDir);
		      kapp->processEvents();
		      if(!SharedLibs->InstallLibrary(libsearch, s))
			inst_err = 9;
		    }
		  break;
		default: inst_err = 9;
#ifdef _DEBUG_
		  printf("gui:  SharedLibs err: Unknown fatal error\n");
#endif
		  break;
		}
	    }
	}
    }

  if(inst_err == 1)
    {
      LabelText = _i18n("Installing ");
      LabelText += KIFReader->KIFOptions->ProgramName;
      LabelText += _i18n(" ...\nExecuting After-Install-Script...");
      InfoLabel->setText(LabelText);
      ProgressBar->setValue(4);
      kapp->processEvents();
    }

  if(inst_err == 1)
    {
      ScriptRun->setOptions(KIFReader->KIFOptions);
      inst_err = ScriptRun->runDoneScript(-1);
    }

  if(inst_err == 1)
    {
      errText = _i18n("Installation Complete!");
      ProgressBar->setValue(5);
      kapp->processEvents();
    }

  if(inst_err == 5) errText = _i18n("KDE link file error");

  if(nonfatal != 1)
    errText += _i18n("\nNon-fatal error:KDE link already installed!");

  if(inst_err == 1)
    {
      KISS->setOptions(KIFReader->KIFOptions);
      nonfatal = KISS->AddToKISS(DestFolderLineEdit->text(),
				 KDEConfig->KDELNKfilename, -1);
    }

  if(nonfatal != 1)
    errText += _i18n("\nNon-fatal error:Could not add to KISS database");

  if(inst_err == 7) errText = _i18n("Pre-install script failed");

  if(inst_err == 8) errText = _i18n("After-install script failed");

  if(inst_err == 9) errText = _i18n("Shared library installation failed");

  InfoLabel->setText(errText);

  // Install extended packages
  // -------------------------

  if(!Install2_check->isChecked())
    strcpy(KIFReader->KIFOptions->ProgramName2[0], "");
  if(!Install3_check->isChecked())
    strcpy(KIFReader->KIFOptions->ProgramName2[1], "");
  if(!Install4_check->isChecked())
    strcpy(KIFReader->KIFOptions->ProgramName2[2], "");
  if(!Install5_check->isChecked())
    strcpy(KIFReader->KIFOptions->ProgramName2[3], "");
  if(!Install6_check->isChecked())
    strcpy(KIFReader->KIFOptions->ProgramName2[4], "");

  for(w = 0;w < MAX_ADDITIONAL_PACKAGES;w++)
    if((inst_err == 1) &&
       (strlen(KIFReader->KIFOptions->ProgramName2[w]) != 0))
      {
	if(nonfatal != 1)
	  QMessageBox::information(this,
				   "kinst",
				   _i18n("\nNon-fatal error:KDE link already installed!"));

	ProgressBar->setValue(0);

	inst_err = 1;
	nonfatal = 1;

	errText = "";

	i = 1;

	LabelText = _i18n("Installing ");
	LabelText += KIFReader->KIFOptions->ProgramName2[w];
	LabelText += _i18n(" ...");
	InfoLabel->setText(LabelText);

	ProgressBar->show();

	kapp->processEvents();

	RPMDepDlg->setOptions(*KIFReader->KIFOptions);
	RPMDepDlg->startCyclus(w);

	qstrncpy(KIFReader->KIFOptions->DefaultMenuEntry,
		 DestGroupLineEdit->text(), 1024);

	qstrncpy(KIFReader->KIFOptions->DefaultInstallPath,
		 DestFolderLineEdit->text(), 1024);

	LabelText = _i18n("Installing ");
	LabelText += KIFReader->KIFOptions->ProgramName2[w];
	LabelText += _i18n(" ...\nExecuting Pre-Install-Script...");
	InfoLabel->setText(LabelText);
  
	kapp->processEvents();

	if(inst_err == 1)
	  {
	    ScriptRun->setOptions(KIFReader->KIFOptions);
	    inst_err = ScriptRun->runPreScript(w);
	  }

	if(inst_err == 1)
	  {
	    LabelText = _i18n("Installing ");
	    LabelText += KIFReader->KIFOptions->ProgramName2[w];
	    LabelText += _i18n(" ...\nUnpacking Application...");
	    InfoLabel->setText(LabelText);
	    ProgressBar->setValue(1);
	    FileProgress->show();
	    kapp->processEvents();
	  }

	if(inst_err == 1)
	  if((strcmp(KIFReader->KIFOptions->RelocatablePackage, "NO") == 0)&&
	     (strcasecmp(KIFReader->KIFOptions->SourceFileType, "RPM") == 0))
	    inst_err = KIFInstall->Install(*KIFReader->KIFOptions, "", w,
					   (void*) this);
	  else
	    inst_err =
	      KIFInstall->Install(*KIFReader->KIFOptions,
				  DestFolderLineEdit->text(), w, (void*) this);

	if(inst_err == 1)
	  {
	    LabelText = _i18n("Installing ");
	    LabelText += KIFReader->KIFOptions->ProgramName2[w];
	    LabelText += _i18n(" ...\nRegistering to KDE...");
	    InfoLabel->setText(LabelText);
	    ProgressBar->setValue(2);
	    FileProgress->hide(); FileProgress->setValue(0);
	    kapp->processEvents();
	  }

	if(inst_err == 0) {
	  errText = KIFReader->KIFOptions->ProgramName2[w];
	  errText += _i18n("\nFailure!");
	}

	if(inst_err == 2) {
	  errText = KIFReader->KIFOptions->ProgramName2[w];
	  errText += _i18n("\nSource File Error");
	}

	if(inst_err == 3) {
	  errText = KIFReader->KIFOptions->ProgramName2[w];
	  errText += _i18n("\nWrite error");
	}

	if(inst_err == 4) {
	  errText = KIFReader->KIFOptions->ProgramName2[w];
	  errText += _i18n("\nAlready Installed!");
	}

	// Go on creating the KDE stuff
	if((inst_err == 1)
	   && (strlen(KIFReader->KIFOptions->DefaultMenuEntry) != 0))
	  {
	    inst_err = 0;
	    KDEConfig->setOptions(KIFReader->KIFOptions);
	    GNOMEConfig->setOptions(KIFReader->KIFOptions);
	    inst_err = KDEConfig->DetermineKDELNK(w);
	    if(GNOMEConfig->isGNOMEinstalled())
	      GNOMEConfig->DetermineGNOMELNK(w);
	    if(inst_err == 1) inst_err = KDEConfig->OpenKDELNK();
	    if(inst_err == 1) inst_err = KDEConfig->WriteKDELNK(w);
	    if(inst_err == 1) KDEConfig->CloseKDELNK();

	    if((GNOMEConfig->isGNOMEinstalled()) && (inst_err == 1))
	      {
		GNOMEConfig->OpenGNOMELNK();
		GNOMEConfig->WriteGNOMELNK(w);
		GNOMEConfig->CloseGNOMELNK();
	      }

	    // Fix the error codes
	    if(inst_err != 1)
	      {
		if(inst_err == 3)
		  {
		    inst_err = 1;
		    nonfatal = 6;
		  }
		else
		  inst_err = 5;
	      }
	  }

	// Install shared libraries
	if(strlen(KIFReader->KIFOptions->LibraryDir2[w]) != 0)
	  {
	    if(inst_err == 1)
	      {
		LabelText = _i18n("Installing ");
		LabelText += KIFReader->KIFOptions->ProgramName2[w];
		LabelText += _i18n(" ...\nInstalling Shared Libraries...");
		InfoLabel->setText(LabelText);
		ProgressBar->setValue(3);
		kapp->processEvents();
	      }
      
	    if(inst_err == 1)
	      {
		strncpy(libdir, KIFReader->KIFOptions->DefaultInstallPath,
			FILENAME_MAX);
		_strncat(libdir, "/", FILENAME_MAX);
		_strncat(libdir, KIFReader->KIFOptions->LibraryDir2[w],
			 FILENAME_MAX);
#ifdef _DEBUG_
		printf("gui: libsearchdir %s\n", libdir);
#endif
		SharedLibs->RestartLibDir(libdir);
		while(i != 2)
		  {
		    i = SharedLibs->CheckNextLibrary(libsearch);
		    switch(i)
		      {
		      case 0: sprintf(s, _i18n("This program needs the library %s that is installed\non your system with an insufficient version number.\nShall I install the library with the coreect version?"), libsearch);
			if(YesNoDlg->getYesNo(s))
			  {
			    strcpy(s,
				   KIFReader->KIFOptions->DefaultInstallPath);
			    strcat(s, "/");
			    strcat(s, KIFReader->KIFOptions->LibraryDir2[w]);
			    kapp->processEvents();
			    if(!SharedLibs->InstallLibrary(libsearch, s))
			      inst_err = 9;
			  }
			break;
		      case 1: break;
		      case 2: break;
		      case 3: inst_err = 9;
#ifdef _DEBUG_
			printf("gui:  SharedLibs err: to search library not found\n");
#endif
			break;
		      case 4: sprintf(s, _i18n("The library %s was not found on your system.\nShall I install the library?"), libsearch);
			if(YesNoDlg->getYesNo(s))
			  {
			    strcpy(s,
				   KIFReader->KIFOptions->DefaultInstallPath);
			    strcat(s, "/");
			    strcat(s, KIFReader->KIFOptions->LibraryDir2[w]);
			    kapp->processEvents();
			    if(!SharedLibs->InstallLibrary(libsearch, s))
			      inst_err = 9;
			  }
			break;
		      default: inst_err = 9;
#ifdef _DEBUG_
			printf("gui:  SharedLibs err: Unknown fatal error\n");
#endif
			break;
		      }
		  }
	      }
	  }

	if(inst_err == 1)
	  {
	    LabelText = _i18n("Installing ");
	    LabelText += KIFReader->KIFOptions->ProgramName2[w];
	    LabelText += _i18n(" ...\nExecuting After-Install-Script...");
	    InfoLabel->setText(LabelText);
	    ProgressBar->setValue(4);
	    kapp->processEvents();
	  }

	if(inst_err == 1)
	  {
	    ScriptRun->setOptions(KIFReader->KIFOptions);
	    inst_err = ScriptRun->runDoneScript(w);
	  }

	if(inst_err == 1)
	  {
	    errText = _i18n("Installation Complete!");
	    ProgressBar->setValue(5);
	    kapp->processEvents();
	  }

	if(inst_err == 5) errText = _i18n("KDE link file error");

	if(nonfatal != 1)
	  errText += _i18n("\nNon-fatal error:KDE link already installed!");

	if(inst_err == 1)
	  {
	    KISS->setOptions(KIFReader->KIFOptions);
	    nonfatal = KISS->AddToKISS(DestFolderLineEdit->text(),
				       KDEConfig->KDELNKfilename, w);
	  }

	if(nonfatal != 1)
	  errText += _i18n("\nNon-fatal error:Could not add to KISS database");

	if(inst_err == 7) errText = _i18n("Pre-install script failed");

	if(inst_err == 8) errText = _i18n("After-install script failed");

	if(inst_err == 9)
	  errText = _i18n("Shared library installation failed");

	InfoLabel->setText(errText);
      }

  KDEConfig->RestartPanel();
  if(GNOMEConfig->isGNOMEinstalled()) GNOMEConfig->RestartPanel();

  if((strcasecmp(KIFReader->KIFOptions->RecommendReboot, "YES") == 0)
     && (inst_err == 1))
    QMessageBox::information(this,
			     "kinst",
			     _i18n("A system reboot is recommended before you start using the installed software."));

  ExitButton->setEnabled(true);
  AboutButton->setEnabled(true);

  return(inst_err);
}

void kinstMainWidget::setTotalSteps(int steps)
{
  FileProgress->setRange(0, steps);
  KApplication::kApplication()->processEvents();
}

void kinstMainWidget::setStatus(int percent, char* text)
{
  FileProgress->setValue(percent);
  ProcessingFile_label->setText(text);
  KApplication::kApplication()->processEvents();
}

void setTotalSteps(int steps, void* parent)
{
  kinstMainWidget* p;

  p = (kinstMainWidget*) parent;

  p->setTotalSteps(steps);
}

void setStatus(int percent, char* text, void* parent)
{
  kinstMainWidget* p;

  p = (kinstMainWidget*) parent;

  p->setStatus(percent, text);
}
