/************************************************************************
 * kinst - KDE Application Installer - kdeconfig.h                      *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _KDECONFIG_H
#define _KDECONFIG_H

#include <qstring.h>

#include "locale.h"
#include "readfile.h"

class tKDEConfig
{
 private:
  tKIFOptions* options;

  // Should be set to NULL if closed
  FILE* KDELNKfile;

  bool DeLocalized(const char* dir, const char* localized,
                   QString* delocalized);

 public:
  // The actual KDELNKfilename
  QString KDELNKfilename;

  // Set the Options to be used
  void setOptions(tKIFOptions* newoptions);

  // Determines the KDELNK filename with full path
  // 0: general failure
  // 1: success
  int DetermineKDELNK(int extnr);

  // Open a KDELNK file
  // 0: general failure
  // 1: success
  // 2: file already open
  // 3: file exists
  int OpenKDELNK();

  // Write the KDELNK
  // 0: general failure
  // 1: success
  // 2: I/O Error
  // 3: file exists
  // 4: file not open
  // 5: custom extension failed
  int WriteKDELNK(int extnr);

  // Close the KDELNK file
  void CloseKDELNK();

  // Restart the KDE Panel
  void RestartPanel();

  tKDEConfig();
  ~tKDEConfig();
};

#endif
