/************************************************************************
 * kinst - KDE Application Installer - package.h                        *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _PACKAGE_H
#define _PACKAGE_H

#include "locale.h"

struct tPosTableEntry
{
  char filename[256];
  long int startoffset;
  long int endoffset;
  char executable; // 1 = true
  char lastentry; // 1 = true
};

class tKIFPackage
{
 private:
  FILE* sourcefile;
  FILE* destfile;
  char sourcefilename[FILENAME_MAX];
  char destfilename[FILENAME_MAX];
  tPosTableEntry tab[10];

 public:
  // Read the whole offset table
  // returns :
  // 0 - general failure
  // 1 - success
  int ReadOffsetTable(void);

  // Unpack file
  // returns :
  // 0 - general failure
  // 1 - success
  // 2 - source file error
  // 3 - dest file error
  int UnpackFile(tPosTableEntry entry, char* where);

  // Unpack all files
  // returns :
  // 0 - general failure
  // 1 - success
  // 2 - source file error
  // 3 - dest file error
  int UnpackAllFiles(char* dir);

  // Get temporary KIF
  void getTempKIF(char* tempKIF);

  tKIFPackage(char* package);
  ~tKIFPackage();
};

#endif
