/************************************************************************
 * kinst - KDE Application Installer - readfile.h                       *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#ifndef _READFILE_H
#define _READFILE_H

#include <stdio.h>

#include "locale.h"

#include "kifoptions.inc"

// The KIFReader class
class tKIFReader
{
 private:
  // KIF stream; should be set to NULL if closed
  FILE* KIFfile;

 public:
  tKIFOptions* KIFOptions;

  // Open a file (0 error)
  int OpenKIFfile(char* filename);

  // Get the Value of an option (0 error)
  int getOption(char* opt, char* value);

  // Check the file type (0 error)
  int CheckFileType(char* magicstring);

  // Read in all options
  int ParseKIFfile(void);

  tKIFReader();
  ~tKIFReader();
};

#endif
