/************************************************************************
 * kinst - KDE Application Installer - scriptrun.cpp                    *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "scriptrun.h"
#include "stringfunc.h"

#ifndef UNIX_SHELL
#define UNIX_SHELL "/bin/sh"
#endif

tScriptRun::tScriptRun(char* SourceFileDir)
{
  _SourceFileDir = SourceFileDir;
  options = new tKIFOptions;
}

tScriptRun::~tScriptRun()
{
  delete options;
}

void tScriptRun::setOptions(tKIFOptions* newoptions)
{
  *options = *newoptions;
}

int tScriptRun::runPreScript(int extnr)
{
  char InvokeCommand[FILENAME_MAX];
  int err;
  char PreInstallScript[KIFOPTIONS_FIELD_LENGTH];

  if(extnr < 0)
    strncpy(PreInstallScript, options->PreInstallScript,
	    KIFOPTIONS_FIELD_LENGTH);
  else
    strncpy(PreInstallScript, options->PreInstallScript2[extnr],
	    KIFOPTIONS_FIELD_LENGTH);

#ifdef _DEBUG_
  printf("scriptrun:  PreScript: %s\n", PreInstallScript);
#endif

  if(strlen(PreInstallScript) == 0) return(1);

  strncpy(InvokeCommand, UNIX_SHELL, FILENAME_MAX);
  _strncat(InvokeCommand, " -c \"", FILENAME_MAX);
  _strncat(InvokeCommand, _SourceFileDir, FILENAME_MAX);
  _strncat(InvokeCommand, "/", FILENAME_MAX);
  _strncat(InvokeCommand, PreInstallScript, FILENAME_MAX);
  _strncat(InvokeCommand, "\"", FILENAME_MAX);

#ifdef _DEBUG_
  printf("scriptrun:  PreScriptCommand: %s\n", InvokeCommand);
#endif

  err = system(InvokeCommand);

  if(err == 127)
    {
      fprintf(stderr, _i18n("Error invoking shell.\n"));
      return(0);
    }
  if(err == -1)
    {
      fprintf(stderr,
	      _i18n("General failure while running pre-install script.\n"));
      return(0);
    }

  return(1);
}

int tScriptRun::runDoneScript(int extnr)
{
  char InvokeCommand[FILENAME_MAX];
  int err;
  char DoneInstallScript[KIFOPTIONS_FIELD_LENGTH];

  if(extnr < 0)
    strncpy(DoneInstallScript, options->DoneInstallScript,
	    KIFOPTIONS_FIELD_LENGTH);
  else
    strncpy(DoneInstallScript, options->DoneInstallScript2[extnr],
	    KIFOPTIONS_FIELD_LENGTH);

#ifdef _DEBUG_
  printf("scriptrun:  DoneScript: %s\n", DoneInstallScript);
#endif

  if(strlen(DoneInstallScript) == 0) return(1);

  strncpy(InvokeCommand, UNIX_SHELL, FILENAME_MAX);
  _strncat(InvokeCommand, " -c \"", FILENAME_MAX);
  _strncat(InvokeCommand, options->DefaultInstallPath, FILENAME_MAX);
  if(options->
     DefaultInstallPath[strlen(options->DefaultInstallPath) - 1] != '/')
     _strncat(InvokeCommand, "/", FILENAME_MAX);
  _strncat(InvokeCommand, DoneInstallScript, FILENAME_MAX);
  _strncat(InvokeCommand, " ", FILENAME_MAX);
  _strncat(InvokeCommand, options->DefaultInstallPath, FILENAME_MAX);
  _strncat(InvokeCommand, "\"", FILENAME_MAX);

#ifdef _DEBUG_
  printf("scriptrun:  DoneScriptCommand: %s\n", InvokeCommand);
#endif

  err = system(InvokeCommand);

  if(err == 127)
    {
      fprintf(stderr, _i18n("Error invoking shell.\n"));
      return(0);
    }
  if(err == -1)
    {
      fprintf(stderr,
	      _i18n("General failure while running done-install script.\n"));
      return(0);
    }

  return(1);
}
