/************************************************************************
 * kcreateinst - part of kinst package - preferences.cpp                *
 * Copyright (C) 2000  Steffen Sobiech                                  *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the Free Software          *
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 ************************************************************************/

#include "preferences.h"

#ifndef MIN_WIDTH
#define MIN_WIDTH 400
#endif

#ifndef MIN_HEIGHT
#define MIN_HEIGHT 300
#endif

// MOC
#include "preferences.moc"

kcreateinstPreferences::kcreateinstPreferences(QWidget *parent,
					       const char *name)
  : QDialog(parent, name, true)
{
  // General properties
  setCaption(_i18n("kcreateinst - Preferences"));
  resize(MIN_WIDTH, MIN_HEIGHT);
  setMinimumWidth(MIN_WIDTH);
  setMinimumHeight(MIN_HEIGHT);

  // Create FileSelector
  FileSelector = new KFileDialog(getenv("HOME"), "*", this, "FileSelector",
				 false);
  FileSelector->hide();

  // Create params
  origparams = new tParams;
  newparams = new tParams;

  // Create kipackpath_edit
  kipackpath_edit = new QLineEdit(this);
  kipackpath_edit->setText("");
  kipackpath_edit->show();

  // Create selfextractpath_edit
  selfextractpath_edit = new QLineEdit(this);
  selfextractpath_edit->setText("");
  selfextractpath_edit->show();

  // Create kinstpath_edit
  kinstpath_edit = new QLineEdit(this);
  kinstpath_edit->setText("");
  kinstpath_edit->show();

  // Create kinstlocalepath_edit
  kinstlocalepath_edit = new QLineEdit(this);
  kinstlocalepath_edit->setText("");
  kinstlocalepath_edit->show();

  // Create scriptpath_edit
  scriptpath_edit = new QLineEdit(this);
  scriptpath_edit->setText("");
  scriptpath_edit->show();

  // Create help_button
  help_button = new QPushButton(this);
  help_button->setText(_i18n("Help"));
  help_button->show();
  connect(help_button, SIGNAL(clicked()), SLOT(help_pressed()));

  // Create cancel_button
  cancel_button = new QPushButton(this);
  cancel_button->setText(_i18n("Cancel"));
  cancel_button->show();
  connect(cancel_button, SIGNAL(clicked()), SLOT(cancel_pressed()));

  // Create OK button
  ok_button = new QPushButton(this);
  ok_button->setText(_i18n("OK"));
  ok_button->show();
  connect(ok_button, SIGNAL(clicked()), SLOT(ok_pressed()));

  // Create kipackpath_label
  kipackpath_label = new QLabel(this);
  kipackpath_label->setText(_i18n("Path to \"kipack\"-executable"));
  kipackpath_label->show();

  // Create selfextractpath_label
  selfextractpath_label = new QLabel(this);
  selfextractpath_label->setText(_i18n("Path to \"kiselfextract\"-executable"));
  selfextractpath_label->show();

  // Create kinstpath_label
  kinstpath_label = new QLabel(this);
  kinstpath_label->setText(_i18n("Path to \"kinst\"-executable"));
  kinstpath_label->show();

  // Create kinstlocalepath_label
  kinstlocalepath_label = new QLabel(this);
  kinstlocalepath_label->setText(_i18n("Path to the directory containing the kinst locale-files"));
  kinstlocalepath_label->show();

  // Create scriptpath_label
  scriptpath_label = new QLabel(this);
  scriptpath_label->setText(_i18n("Path to script templates"));
  scriptpath_label->show();

  // Create kipackpath_button
  kipackpath_button = new QPushButton(this);
  kipackpath_button->setText(_i18n("Browse"));
  kipackpath_button->show();
  connect(kipackpath_button, SIGNAL(clicked()), SLOT(Browse1Pressed()));

  // Create selfextractpath_button
  selfextractpath_button = new QPushButton(this);
  selfextractpath_button->setText(_i18n("Browse"));
  selfextractpath_button->show();
  connect(selfextractpath_button, SIGNAL(clicked()), SLOT(Browse2Pressed()));

  // Create kinstpath_button
  kinstpath_button = new QPushButton(this);
  kinstpath_button->setText(_i18n("Browse"));
  kinstpath_button->show();
  connect(kinstpath_button, SIGNAL(clicked()), SLOT(Browse3Pressed()));

  // Create kinstlocalepath_button
  kinstlocalepath_button = new QPushButton(this);
  kinstlocalepath_button->setText(_i18n("Browse"));
  kinstlocalepath_button->show();
  connect(kinstlocalepath_button, SIGNAL(clicked()), SLOT(Browse4Pressed()));

  // Create scriptpath_button
  scriptpath_button = new QPushButton(this);
  scriptpath_button->setText(_i18n("Browse"));
  scriptpath_button->show();
  connect(scriptpath_button, SIGNAL(clicked()), SLOT(Browse5Pressed()));
}

void kcreateinstPreferences::resizeEvent(QResizeEvent*)
{
  // Resize kipackpath_edit
  kipackpath_edit->setGeometry(10,
			       27,
			       width()-90,
			       20);

  // Resize selfextractpath_edit
  selfextractpath_edit->setGeometry(10,
				    kipackpath_edit->y()+
				    kipackpath_edit->height()+30,
				    width()-90,
				    20);

  // Resize kinstpath_edit
  kinstpath_edit->setGeometry(10,
			      selfextractpath_edit->y()+
			      selfextractpath_edit->height()+30,
			      width()-90,
			      20);

  // Resize kinstlocalepath_edit
  kinstlocalepath_edit->setGeometry(10,
				    kinstpath_edit->y()+
				    kinstpath_edit->height()+30,
				    width()-90,
				    20);

  // Resize scriptpath_edit
  scriptpath_edit->setGeometry(10,
			       kinstlocalepath_edit->y()+
			       kinstlocalepath_edit->height()+30,
			       width()-90,
			       20);

  // Resize help_button
  help_button->setGeometry(width()-100,
			   height()-35,
			   90,
			   30);

  // Resize cancel_button
  cancel_button->setGeometry((width()/2)-45,
			     height()-35,
			     90,
			     30);

  // Resize OK button
  ok_button->setGeometry(10,
			 height()-35,
			 90,
			 30);

  // Resize kipackpath_label
  kipackpath_label->setGeometry(10,
				10,
				width()-90,
				15);

  // Resize selfextractpath_label
  selfextractpath_label->setGeometry(10,
				     kipackpath_label->y()+
				     kipackpath_label->height()+35,
				     width()-90,
				     15);

  // Resize kinstpath_label
  kinstpath_label->setGeometry(10,
			       selfextractpath_label->y()+
			       selfextractpath_label->height()+35,
			       width()-90,
			       15);

  // Resize kinstlocalepath_label
  kinstlocalepath_label->setGeometry(10,
				     kinstpath_label->y()+
				     kinstpath_label->height()+35,
				     width()-90,
				     15);

  // Resize scriptpath_label
  scriptpath_label->setGeometry(10,
				kinstlocalepath_label->y()+
				kinstlocalepath_label->height()+35,
				width()-90,
				15);

  // Resize kipackpath_button
  kipackpath_button->setGeometry(kinstlocalepath_edit->x()+
				 kinstlocalepath_edit->width()+5,
				 kipackpath_edit->y()-2,
				 width()-kinstlocalepath_edit->width()-25,
				 24);

  // Resize selfextractpath_button
  selfextractpath_button->setGeometry(kinstlocalepath_edit->x()+
				      kinstlocalepath_edit->width()+5,
				      kipackpath_button->y()+
				      kipackpath_button->height()+26,
				      width()-kinstlocalepath_edit->width()-
				      25,
				      24);

  // Resize kinstpath_button
  kinstpath_button->setGeometry(kinstlocalepath_edit->x()+
				kinstlocalepath_edit->width()+5,
				selfextractpath_button->y()+
				selfextractpath_button->height()+26,
				width()-kinstlocalepath_edit->width()-25,
				24);

  // Resize kinstlocalepath_button
  kinstlocalepath_button->setGeometry(kinstlocalepath_edit->x()+
				      kinstlocalepath_edit->width()+5,
				      kinstpath_button->y()+
				      kinstpath_button->height()+26,
				      width()-kinstlocalepath_edit->width()-
				      25,
				      24);

  // Resize scriptpath_button
  scriptpath_button->setGeometry(scriptpath_edit->x()+
				 scriptpath_edit->width()+5,
				 kinstlocalepath_button->y()+
				 kinstlocalepath_button->height()+26,
				 width()-kinstlocalepath_edit->width()-
				 25,
				 24);
}

void kcreateinstPreferences::getPrefs(tParams* actprefs)
{
  newparams->kipackpath = actprefs->kipackpath;
  newparams->selfextractpath = actprefs->selfextractpath;
  newparams->kinstpath = actprefs->kinstpath;
  newparams->kinstlocalepath = actprefs->kinstlocalepath;
  newparams->scriptpath = actprefs->scriptpath;

  origparams->kipackpath = actprefs->kipackpath;
  origparams->selfextractpath = actprefs->selfextractpath;
  origparams->kinstpath = actprefs->kinstpath;
  origparams->kinstlocalepath = actprefs->kinstlocalepath;
  origparams->scriptpath = actprefs->scriptpath;

  kipackpath_edit->setText(newparams->kipackpath);
  selfextractpath_edit->setText(newparams->selfextractpath);
  kinstpath_edit->setText(newparams->kinstpath);
  kinstlocalepath_edit->setText(newparams->kinstlocalepath);
  scriptpath_edit->setText(newparams->scriptpath);

  show();

  actprefs->kipackpath = origparams->kipackpath;
  actprefs->selfextractpath = origparams->selfextractpath;
  actprefs->kinstpath = origparams->kinstpath;
  actprefs->kinstlocalepath = origparams->kinstlocalepath;
  actprefs->scriptpath = origparams->scriptpath;
}

void kcreateinstPreferences::Browse1Pressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", this,
					 "Browse1");
  if(qstrlen(String) > 0)
    {
      newparams->kipackpath = String;
      kipackpath_edit->setText(String);
    }

  FileSelector->hide();
}

void kcreateinstPreferences::Browse2Pressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", this,
					 "Browse2");
  if(qstrlen(String) > 0)
    {
      newparams->selfextractpath = String;
      selfextractpath_edit->setText(String);
    }

  FileSelector->hide();
}

void kcreateinstPreferences::Browse3Pressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", this,
					 "Browse3");
  if(qstrlen(String) > 0)
    {
      newparams->kinstpath = String;
      kinstpath_edit->setText(String);
    }

  FileSelector->hide();
}

void kcreateinstPreferences::Browse4Pressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", this,
					 "Browse4");
  if(qstrlen(String) > 0)
    {
      newparams->kinstlocalepath = String;
      kinstlocalepath_edit->setText(String);
    }

  FileSelector->hide();
}

void kcreateinstPreferences::Browse5Pressed()
{
  QString String;
  String = FileSelector->getOpenFileName(getenv("HOME"),
					 "*", this,
					 "Browse5");
  if(qstrlen(String) > 0)
    {
      newparams->scriptpath = String;
      scriptpath_edit->setText(String);
    }

  FileSelector->hide();
}

void kcreateinstPreferences::ok_pressed()
{
  newparams->kipackpath = kipackpath_edit->text();
  newparams->selfextractpath = selfextractpath_edit->text();
  newparams->kinstpath = kinstpath_edit->text();
  newparams->kinstlocalepath = kinstlocalepath_edit->text();
  newparams->scriptpath = scriptpath_edit->text();

  origparams->kipackpath = newparams->kipackpath;
  origparams->selfextractpath = newparams->selfextractpath;
  origparams->kinstpath = newparams->kinstpath;
  origparams->kinstlocalepath = newparams->kinstlocalepath;
  origparams->scriptpath = newparams->scriptpath;

  hide();
}

void kcreateinstPreferences::cancel_pressed()
{
  hide();
}

void kcreateinstPreferences::help_pressed()
{
  KApplication::kApplication()->invokeHTMLHelp("kcreateinst/index.html", "");
}

