/*
 * KMLOFax
 *
 * A utility to process facsimiles received with the ELSA
 * MicroLink(tm) Office or MicroLink(tm) ISDN Office modem.
 *
 * Copyright (C) 1999-2001 Oliver Gantz <Oliver.Gantz@epost.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ------
 * ELSA and MicroLink are trademarks of ELSA AG, Aachen.
 */

#ifndef KMLOFAX_H 
#define KMLOFAX_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qstring.h>
#include <qpopupmenu.h>

#include <kuniqueapp.h>
#include <klocale.h>
#include <kmainwindow.h>
#include <kconfig.h>
#include <kaccel.h>

#include "faxview.h"
#include "preview.h"
#include "downloaddlg.h"

#include <X11/Xlib.h>



 class KMLOFaxApp : public KUniqueApplication
{
public:
	KMLOFaxApp();
	virtual ~KMLOFaxApp();

protected:
	bool x11EventFilter(XEvent *ev);
};



class KMLOFax : public KMainWindow
{
	Q_OBJECT
public:
	KMLOFax(QWidget *parent = 0, const char *name = 0);
	virtual ~KMLOFax();

	void enableCommand(int id_, bool enable);

protected:
	void readOptions();
	void saveOptions();
	
	void initMenuBar();
	void initToolBar();
	void initStatusBar();
	void initKeyAccel();
	void initWhatsThis();

public slots:
	void commandCallback(int id_);

	void slotFileDownload();
	void slotFileView();
	void slotFilePrint();
	void slotFileExport();
	void slotFileMail();
	void slotFileTrash();
	void slotFileSenderAlias();
	void slotFileRebuildDir();
	void slotFileQuit();

	void slotFolderNew();
	void slotFolderRename();
	void slotFolderEmpty();
	void slotFolderRemove();

	void slotSettingsShowToolbar();
	void slotSettingsShowStatusbar();
	void slotSettingsConfigure();
	void slotSettingsSenderAliases();

	void slotStatusMsg(const QString& text);
	void slotStatusHelpMsg(const QString& text);
	
private slots:
	void slotNewConfig();
	void hasCurrentFolderSlot(bool isRoot, bool isUser);
	void hasCurrentFaxSlot(bool on);
	void fetchFile(const QString& name);
	void fetchDone();

private:
	KConfig *config;

	KAccel *keyAccel;

	QPopupMenu *fileMenu;
	QPopupMenu *folderMenu;
	QPopupMenu *settingsMenu;
	
	FaxFiler *view;
	Preview *preview;
	DownloadDlg *downloaddlg;
};

#endif // KMLOFAX_H 
