/*
 * $Id: helpers.cpp,v 2.5 2001/04/08 11:00:52 ral Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

#include <string>
#include "helpers.h"

#ifndef _WIN32
#include <unistd.h>
#include "qfont.h"
#else
#include <istream>
#include <ostream>
#include <iostream>
#endif

#include <fstream>

using namespace std;

#ifndef rcsid
static const char rcsid[]="$Id: helpers.cpp,v 2.5 2001/04/08 11:00:52 ral Exp $";
#endif

int copy_datei(const char*source, const char*target)
{
	std::ifstream s(source,std::ios::in | std::ios::nocreate);
	if (!s)
		return -1;
	std::ofstream d(target,ios::out | ios::trunc);
	if (!d)
		return -1;
	for (char Byte=s.get(); Byte != EOF; Byte=s.get())
		if (!d.put(Byte))
			return -1;
	return 0;
}
int move_file(const char*source, const char*target)
{
   if (copy_datei(source,target) == -1)
     return -1;
   unlink(source);
   return 0;
}

#ifndef _WIN32
void FontToParameter(const QFont&fnt,std::string&name,int&size,int&weight,
		     bool&italic,int&charset)
{
    name = fnt.family();
    size = fnt.pointSize();
    weight = fnt.weight();
    italic = fnt.italic();
    QFont::CharSet char_set = fnt.charSet();
    charset = (int)char_set;
}

void ParameterToFont(QFont&fnt,const std::string name,int size, int weight, bool italic, int charset)
{
    QFont _fnt(name.c_str(),size,weight,italic,(QFont::CharSet)charset);
    fnt = _fnt;
}
#endif
