// -*-Mode: C++;-*-
#ifndef _PROFILE_H
#define _PROFILE_H

#include "helpers/stringlist.h"
#include "helpers/smart_pointer.h"

//! a simple class to handle ini files
/*!
 * The files has the same format like the win-ini files or
 * the ini files of kde apps. It is implement this way to get
 * a cross-platform mechanism.
 */
class CProfile : virtual public refCounter
{
protected:
    //! the file to use
    std::string m_FileName;
    int m_UseMode;

public:
    //! set the mode the file should have
    void UseMode(int n_Mode){m_UseMode = n_Mode;}
    //! Standart constructor
    CProfile():refCounter(){m_FileName = "";}
    //! constructor 
    /*!
     * This constructor will set the internal filename 
     * to the parameter
     * \param _FileName the ini file to use
     */
    CProfile(const char*_FileName);
    //! destructor
    virtual ~CProfile();
    //! set ini file
    /*!
     * set the ini file to the given name
     * the old value will be deleted
     * \param name the file to use
     */
    virtual void FileName(const std::string& name,int n_Mode=127){m_FileName = name;m_UseMode = n_Mode;}
    //! set ini file
    /*!
     * set the ini file to the given name
     * the old value will be deleted
     * \param name the file to use
     */
    virtual void FileName(const char* name,int n_Mode=127);
    //! retrieves current ini file
    /*!
     * returns the current used ini file
     * \return a stl-string containing the filename
     */
    virtual const std::string& FileName()const{return m_FileName;}
    //! retrieve an integer value
    /*!
     * \param section the name of the section the value is stored
     * \param entry the name of the value searched for
     * \param defaultInt a default value if the entry isn't found
     * \return the integer value
     */
    virtual int getProfileInt( const char *section,
			       const char *entry,
			       int defaultInt)const;
    //! retrieves a string
    /*!
     * \param section the section where the string is stored
     * \param entry the name of the value
     * \param defaultString a value to insert if not found
     * \param target a reference to store the value
     * \return size of read string
     */
    virtual int getProfileString(const char *section,const char *entry,const std::string& defaultString,std::string& target)const;
    //! write a string to ini file
    /*!
     * \param section into which section
     * \param entry the name of the resource
     * \param string the value to write
     * \return true if done false if failure
     */
    virtual bool writeProfileString( const char *section,const char *entry,const char *astring);
    //! write a integer to file
    /*!
     * \param section the section where the value should be stored
     * \param entry the name of the value
     * \param Int the value to save
     * \return true if all where good, else false
     */
    virtual bool writeProfileInt(const char *section,const char *entry,	int Int);
    //! retrieves all values of a section
    virtual int getProfileSection( const char *section,stringIlist&target);
};

//! extended profile class
class eProfile:public CProfile
{
protected:
    std::string m_path;
public:
    const bool useable()const{return (m_path.size()>0 && m_FileName.size() > 0);}
    //! Standart constructor
    eProfile():CProfile(){m_path = "";}
    //! constructor 
    /*!
     * This constructor will set the internal filename 
     * to the parameter
     * \param _FileName the ini file to use
     */
    eProfile(const char*_FileName,const char*_Path);
    //! destructor
    virtual ~eProfile();
    //! setup the path to use
    std::string&Path(){return m_path;}

    bool SetValue(const std::string&name,const std::string&value);
    bool SetValue(const std::string&name,const int value);
    bool SetValue(const std::string&name,const bool value);

    std::string ReadValue(const std::string&name, const std::string& def)const;
    int  ReadValue(const std::string&name, const int def)const;
    bool ReadValue(const std::string&name, const bool def)const;
};

#endif
