// -*-Mode: C++;-*-  
/*
 * $Id: tableview.h,v 2.5 2001/04/24 22:30:55 ral Exp $
 */

#ifndef CTableView_included
#define CTableView_included

#include "tableviewdata.h"
#include <qlist.h>
#include "tabledescr.h"
#include <qmsgbox.h>
#include "PatternPair.h"
#include "stringlist.h"
#include "smart_pointer.h"

class CMySql;
class QListViewItem;

class CTableView : public CTableViewData
{
    Q_OBJECT

public:
    CTableView (smart_pointer<CMySql> &_sql_server,QWidget* parent = NULL, const char* name = NULL);

    virtual ~CTableView();
    virtual bool close ( bool forceKill=FALSE );

protected slots:
    virtual void sort_select(int);
    virtual void column_sel_change();
    virtual void MakeRequest();
    virtual void db_select(int);
    virtual void table_select(int);
    virtual void search_rows();
    virtual void addRow();
    virtual void modifyRow();
    virtual void delete_row();
    virtual void emptyTable();
    virtual void saveResult();
    virtual void FixFontChanged();
    virtual void OutputSelected(QListViewItem*);
    virtual void OutputMarked(QListViewItem*);

public slots:
    void show();
    void RefreshLists();

protected:
    smart_pointer<CMySql> sql_server;
    ColumnList Current_Table_Fields;
    ColumnList Current_Displayed_Fields;
    KeyList CurrentKeys;
    stringlist SelectFields;
 
    void set_buttons(bool how);
    bool KeyDisplayed();
    CColumnDescriptor*FindTableItem(const char*what,bool all_fields=true);
    //! Breaks and filters current item
    /*!
     */
    int BreakIntoParts(PatternList*BreakList,PatternList*KeyList=0,
		       QListViewItem*item = 0,bool no_auto_filter = false);
    void saveAscii(const char*filename);
    void saveHtml(const char*filename);
    void saveLatex(const char*filename);
    
    void build_relevant_keys();
    void _make_fetch_request(bool search_it=false);
};

#endif // CTableView_included

