/*
 *  KSeg
 *  Copyright (C) 1999 Ilya Baran
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 ibaran@mit.edu
 */


#ifndef G_REFS_H
#define G_REFS_H

#include <algorithm>
#include <vector>
#include <qptrdict.h>

class G_ref;

//Here's what happened to this class:
//It started out as a QList but it was
//too slow so I changed it to a vector
//all the weird funcs are for "backward compatibility"
//meaning that I was too lazy to rewrite all
//the code that uses G_refs
class G_refs : public vector<G_ref *>
{
public:
  void appendUnique(G_ref *);

  void topologicalSort(G_refs, const G_ref *target = 0);
  void topologicalSort(G_ref *p, const G_ref *target = 0) { G_refs tmp; tmp.append(p); topologicalSort(tmp, target); }

  void buildReverse(G_refs x); //figure out what to move for reverse dragging

  void update();

  void append(G_ref *x) { push_back(x); }
  unsigned int count() const { return size(); }

  void insert(int pos, G_ref *what) { vector<G_ref *>::insert(begin() + pos, what); }
  void remove(int pos) { if(pos != -1) erase(begin() + pos); }
  void removeRef(G_ref *r) { remove(find(r)); }

  bool containsRef(const G_ref *r) const { return ::find(begin(), end(), r) != end(); }
  int find(const G_ref *r) const
  { int i = ::find(begin(), end(), r) - begin();
    return i == (int)size() ? -1 : i; }
  int findRef(const G_ref *r) const { return find(r); }

  G_ref *at(int i) { return (*this)[i]; }
  //G_ref * operator[](int i) { return at(i); }

  bool operator==(G_refs &r);
  bool operator!=(G_refs &r) { return !(*this == r); }

protected:
  bool addReverse(G_ref * x, G_refs &tmp, G_refs &tmp1, int &sizeIndex, QPtrDict<int> &added); //for reverse dragging
};

#endif //G_REFS_H

