/***************************************************************************
                          cmaptoolzone.h
                      -------------------
    description          :
    begin                : Mon Dec 4 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMAPTOOLZONE_H
#define CMAPTOOLZONE_H

#include <cmaptoolbase.h>

/**This tool is used to create new zones on the map
  *@author John-Paul Stanford
  */

class CMapToolZone : public CMapToolBase
{
public:
	CMapToolZone(CMapData *mapData,CMapWidget *map,int id, QString name,QPixmap icon, KToolBar *toolBar,QPopupMenu *menu);
	~CMapToolZone();
	
	/** This method is called when the mouse is pressed */
	void mousePressEvent(QMouseEvent *e);
	/** This method is called when the mouse is released */
	void mouseReleaseEvent(QMouseEvent *e);
	/** This method is called when the mouse is moved */
	void mouseMoveEvent(QMouseEvent *e);
	/** This function called when the zone tool is selected */
	void toolSelected(void);
	/** This function is called when the zone tool is unselected */
	void toolUnselected();
	
private:
	int lastX,lastY;
	QPainter dragPainter;	
};

#endif
