/***************************************************************************
                          dlgcustomtoolbar.cpp
                      -------------------
    description          :
    begin                : Tue Nov 14 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgcustomtoolbar.h"

DlgCustomToolbar::DlgCustomToolbar(KmudDoc* document,QWidget *parent, const char *name) : QDialog(parent,name,true)
{
	setCaption(i18n("Custom Toolbar"));
	
	profile = document->getCharacterProfile(document->getCurrentCharacterID());
	profile->readToolbar();
	
	doc = document;

	initDialog();
	
  	cmdDown->setPixmap(Icon("kmud_lvldown.xpm"));
	cmdUp->setPixmap(Icon("kmud_lvlup.xpm"));
	
	toolbarListView->setAllColumnsShowFocus( true );	
	toolbarListView->setColumnWidth(0, 100);
	toolbarListView->setColumnWidth(1, 35);
	toolbarListView->setColumnWidth(2, toolbarListView->width()-100-35); // take the rest
	toolbarListView->setColumnWidthMode(0, QListView::Manual);
	toolbarListView->setColumnWidthMode(1, QListView::Manual);
	toolbarListView->setColumnWidthMode(2, QListView::Manual);
	toolbarListView->setSorting(-1,false);
	
	connect( cmdCancel, SIGNAL(clicked()), SLOT(slotCancelPressed()) );
	connect( cmdOk, SIGNAL(clicked()), SLOT(slotOKPressed()) );
	
	connect( cmdNew, SIGNAL(clicked()), SLOT(slotNewPressed()) );
	connect( cmdEdit, SIGNAL(clicked()), SLOT(slotEditPressed()) );
	connect( cmdDelete, SIGNAL(clicked()), SLOT(slotDeletePressed()) );
	
	connect( cmdUp, SIGNAL(clicked()), SLOT(slotUpPressed()) );
	connect( cmdDown, SIGNAL(clicked()), SLOT(slotDownPressed()) );	
	
	if (profile == NULL) {
		return;
	}
	updateListView("");	
}

DlgCustomToolbar::~DlgCustomToolbar()
{
}

/** Updates the List View of all the toolbar buttons */
void DlgCustomToolbar::updateListView(QString nameSelect)
{
	QListViewItem* item;
	ToolbarEntry* entry;

	toolbarListView->clear();
	entry = profile->lastToolbarEntry();

	while (entry != NULL)
	{
		item = new QListViewItem(toolbarListView, entry->name, "", entry->command);
		item->setPixmap(1,Icon("mini/" + entry->icon));
		if(entry->name == nameSelect)
			toolbarListView->setSelected(item,true);
			
		entry = profile->previousToolbarEntry();
	}

	if (nameSelect == "")
	{
		if (toolbarListView->firstChild() != NULL)
			toolbarListView->setSelected(toolbarListView->firstChild(), true);	

	}
	
}

/**                 **
 **    S L O T S    **
 **                 **/

/** When "OK" is pressed */
void DlgCustomToolbar::slotOKPressed()
{
	profile->writeToolbar();
	accept();
}

/** When "CANCEL" is pressed */
void DlgCustomToolbar::slotCancelPressed()
{
	reject();
}

/** When "NEW" is pressed */
void DlgCustomToolbar::slotNewPressed()
{
	DlgCustomToolbarInput d(this,"New Toolbar Entry");
	
	QListViewItem *item;
	ToolbarEntry * tmpEntry;
	
	if (d.exec())
	{
		if (d.getName() == "")
		{
			QMessageBox::information(this,i18n("Warning"),i18n("That button name is already in use"));
			return;
		}
		
		item = toolbarListView->firstChild();
		while (item != NULL)
		{			
			tmpEntry = profile->getToolbarEntry(QString(item->text(0)));
			if ( tmpEntry->name == d.getName() )
			{
				QMessageBox::information(this, i18n("Warning"), i18n("That name is already in use. No toolbar button added."));
				return;
			}
			
			item = item->nextSibling();
		}

		profile->insertToolbarEntry(d.getName(),d.getCommand(),d.getIcon());
		
		updateListView(d.getName());
		
	}
}

/** When "EDIT" is pressed */
void DlgCustomToolbar::slotEditPressed()
{
	ToolbarEntry *te;
	QListViewItem *item;
	QString n,c,ic;
	
	item = toolbarListView->firstChild();
	
	te = NULL;
	
	while (item != NULL)
	{
		if (toolbarListView->isSelected(item))
		{		
			te = profile->getToolbarEntry(QString(item->text(0)));
			break;
		}
		item = item->nextSibling();
	}
	
	if (te == NULL) return;
	
	DlgCustomToolbarInput d(this,"Edit toobar entry");
	
	d.setName(te->name);
	d.setCommand(te->command);
	d.setIcon(te->icon);
	if (d.exec())
	{
		te->name = d.getName();
		te->command = d.getCommand();
		te->icon = d.getIcon();	
	}
	
	updateListView(te->name);
}

/** When "DELETE" is pressed */	
void DlgCustomToolbar::slotDeletePressed()
{
	QListViewItem *item;
	
	item = toolbarListView->firstChild();
	
	while (item != NULL)
	{
		if (toolbarListView->isSelected(item))
		{
			profile->removeToolbarEntry(item->text(0));
			break;
		}
		item = item->nextSibling();
	}
	
	updateListView("");	
}

/** When "UP" is pressed */
void DlgCustomToolbar::slotUpPressed()
{
	QListViewItem *item;
	QString name = "";
	
	item = toolbarListView->firstChild();
	
	while (item != NULL)
	{
		ToolbarEntry *first = profile->firstToolbarEntry();
		if (toolbarListView->isSelected(item))
		{
			ToolbarEntry *entry1=profile->getToolbarEntry(QString(item->text(0)));
			if (entry1!=first)
			{
				ToolbarEntry *entry2=profile->previousToolbarEntry();

				QString tmpIcon,tmpName,tmpCommand;				
				tmpIcon = entry2->icon;
				tmpName = entry2->name ;
				tmpCommand = entry2->command;
				
				entry2->name = entry1->name;
				entry2->command = entry1->command;
				entry2->icon = entry1->icon;
				
				entry1->name = tmpName;
				entry1->command = tmpCommand;
				entry1->icon = tmpIcon;
				
				name = entry2->name;
			}
			else
				name = entry1->name;
						
			break;
		}
		item = item->nextSibling();
	}
	
	updateListView(name);
		
}

/** When "DOWN" is pressed */	
void DlgCustomToolbar::slotDownPressed()
{
	QListViewItem *item;
	QString name="";
	
	item = toolbarListView->firstChild();
	
	while (item != NULL)
	{
		ToolbarEntry *last = profile->lastToolbarEntry();
		if (toolbarListView->isSelected(item))
		{
			ToolbarEntry *entry1=profile->getToolbarEntry(QString(item->text(0)));
			if (entry1!=last)
			{
				ToolbarEntry *entry2=profile->nextToolbarEntry();

				QString tmpIcon,tmpName,tmpCommand;				
				tmpIcon = entry2->icon;
				tmpName = entry2->name ;
				tmpCommand = entry2->command;
				
				entry2->name = entry1->name;
				entry2->command = entry1->command;
				entry2->icon = entry1->icon;
				
				entry1->name = tmpName;
				entry1->command = tmpCommand;
				entry1->icon = tmpIcon;
				
				name = entry2->name;
			}
			else
				name = entry1->name;
						
			break;
		}
		item = item->nextSibling();
	}
	
	updateListView(name);
		


}