/***************************************************************************
                          dlgoptionsinput.cpp
                      -------------------
    description          : DialogTab for special input characters and keys
    begin                : Sun Oct 22 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgoptionsinput.h"

DlgOptionsInput::DlgOptionsInput(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();

	connect(enableSpecial_CheckBox, SIGNAL(clicked()), SLOT(slotSetEnablesDisables()));
	slotSetEnablesDisables();
}

DlgOptionsInput::~DlgOptionsInput(){
}

/** gets the separator character */
QString DlgOptionsInput::getSeparator()
{
  return separatorLineEdit->text();
}

/** sets the separator character */
void DlgOptionsInput::setSeparator(QString s)
{
  separatorLineEdit->setText(s);
}

/** gets the extern-command character */
QString DlgOptionsInput::getExternChar()
{
  return externCharLineEdit->text();
}

/** sets the extern-command character */
void DlgOptionsInput::setExternChar(QString s)
{
  externCharLineEdit->setText(s);
}

/** gets the speedwalking character */
QString DlgOptionsInput::getSpeedwalkingChar()
{
  return speedwalkingLineEdit->text();
}

/** sets the speedwalking character */
void DlgOptionsInput::setSpeedwalkingChar(QString s)
{
  speedwalkingLineEdit->setText(s);
}


bool DlgOptionsInput::getEnableSpecialChars()
{
	return enableSpecial_CheckBox->isChecked();
}

void DlgOptionsInput::setEnableSpecialChars(bool b)
{
	enableSpecial_CheckBox->setChecked(b);
	slotSetEnablesDisables();
}

void DlgOptionsInput::slotSetEnablesDisables()
{
	externCharLabel->setEnabled(enableSpecial_CheckBox->isChecked());
	externCharLineEdit->setEnabled(enableSpecial_CheckBox->isChecked());
	separatorLabel->setEnabled(enableSpecial_CheckBox->isChecked());
	separatorLineEdit->setEnabled(enableSpecial_CheckBox->isChecked());
	speedwalkingLabel->setEnabled(enableSpecial_CheckBox->isChecked());
	speedwalkingLineEdit->setEnabled(enableSpecial_CheckBox->isChecked());
}

