/***************************************************************************
                          cmaptooldel.cpp
                      -------------------
    description          :
    begin                : Thu Nov 23 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "cmaptooldel.h"

/** This method is called when the mouse is pressed */
void CMapToolDel::mousePressEvent(QMouseEvent *e)
{
	
}

/** This method is called when the mouse is released */
void CMapToolDel::mouseReleaseEvent(QMouseEvent *e)
{
	QScrollView *mapView = mapWidget->getMapView();

	if (mapWidget->getViewOverview() && mapWidget->width()>180 && mapWidget->height()>100)
	{
		int view_x,view_y;
		if (mapView->viewport()->width()>mapView->contentsWidth())
			view_x =mapView->contentsWidth();
		else
			view_x =mapView->viewport()->width();

		if (mapView->viewport()->height()>mapView->contentsHeight())
			view_y =mapView->contentsHeight();
		else
			view_y =mapView->viewport()->height();

		if (e->x()>=mapView->contentsX()+view_x-180 &&
			e->x()<=mapView->contentsX()+view_x &&
            		e->y()>=mapView->contentsY()+view_y-100 &&
	                e->y()<=mapView->contentsY()+view_y)
		{
			return;			
		}
	}
	
	for (CMapElement *element=elementList->first(); element !=0; element =elementList->next())
	{
		if (element->mouseInElement(e->x(),e->y(),mapWidget->getCurrentZone()))
		{				
			mapWidget->delElement(element);	
		}
	}
}

/** This method is called when the mouse is moved */
void CMapToolDel::mouseMoveEvent(QMouseEvent *e)
{

}

/** This function called when the delete tool is selected */
void CMapToolDel::toolSelected(void)
{
	mapWidget->setCursor(*deleteCursor);
	mapWidget->setMouseTracking(false);
	toolsToolbar->setButton(id,true);
	menu->setItemChecked(id,true);	
}

/** This function is called when the delete tool is unselected */
void CMapToolDel::toolUnselected()
{
	menu->setItemChecked(id,false);	
	toolsToolbar->setButton(id,false);
}
