/***************************************************************************
                          cmaptoolpath.cpp
                      -------------------
    description          : Path creation tool
    begin                : Thu Nov 23 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "cmaptoolpath.h"
#include "dialogs/dlgmappathproperties.h"

/** This method is called when the mouse is pressed */
void CMapToolPath::mousePressEvent(QMouseEvent *e)
{
	
}

/** This method is called when the mouse is released */
void CMapToolPath::mouseReleaseEvent(QMouseEvent *e)
{
	QScrollView *mapView = mapWidget->getMapView();

	if (mapWidget->getViewOverview() && mapWidget->width()>180 && mapWidget->height()>100)
	{
		int view_x,view_y;
		if (mapView->viewport()->width()>mapView->contentsWidth())
			view_x =mapView->contentsWidth();
		else
			view_x =mapView->viewport()->width();

		if (mapView->viewport()->height()>mapView->contentsHeight())
			view_y =mapView->contentsHeight();
		else
			view_y =mapView->viewport()->height();

		if (e->x()>=mapView->contentsX()+view_x-180 &&
			e->x()<=mapView->contentsX()+view_x &&
            		e->y()>=mapView->contentsY()+view_y-100 &&
	                e->y()<=mapView->contentsY()+view_y)
		{
			return;			
		}
	}
	
	if (pathToolMode==1)
	{
		int x = e->x();
		int y = e->y();
    	
    	CMapRoom *destRoom = NULL;

		for (CMapRoom *room=mapWidget->getCurrentMap()->first(); room!=0; room = mapWidget->getCurrentMap()->next())
		{
			if (room->mouseInElement(x,y,mapWidget->getCurrentZone()))
			{
				destRoom = room;
				break;
			}
		}
				
		if ((destRoom && pathStartRoom) && (pathStartRoom!=destRoom))
		{					
			DlgMapPathProperties d(mapWidget, "Properties");
        	
        	if (mapWidget->getDefaultPathTwoWay())
				d.setTwoWay(true);
					
			d.setNormalExit(true);
				
			if (d.exec())
			{						
				if (!d.getNormalExit() && d.getSpecialCmd().stripWhiteSpace() == "")
				{
					QMessageBox::information (mapWidget,"Kmud Mapper","The special exit command must not be empty for\n"
										     "special paths. The path has not been created.");
					return;

				}

				if (pathStartRoom->getPathDirection(d.getSrcDirection(),d.getSpecialCmd()) || destRoom->getPathDirection(d.getDestDirection(),d.getSpecialCmd()))
				{
					QMessageBox::information (mapWidget,"Kmud Mapper","There is already a path in place at the selected location.");
					return;
				}

				CMapPath *newPath = new CMapPath (d.getSrcDirection(),d.getDestDirection(),destRoom,pathStartRoom);
				newPath->setLowerColour(mapperData->lowerPathColour);
				newPath->setDefaultColour(mapperData->defaultPathColour);
				newPath->setHigherColour(mapperData->higherPathColour);
				newPath->setSelectColour(mapperData->selectedColour);
				mapWidget->setPathCords(newPath);	
					
				newPath->setSpecialCmd(d.getSpecialCmd());
				newPath->setSpecialExit(!d.getNormalExit());					
												
				pathStartRoom->addPath( newPath );
				destRoom->connectingPaths.append(newPath); 	
	                        							
   				elementList->append(newPath);																	
					
				if (d.getTwoWay())
				{			
					mapWidget->makePathTwoWay(newPath);
				}
						
				mapWidget->redraw();	
			}				
		}
			
		pathToolMode = 0;
		pathStartRoom = NULL;
		mapWidget->setCursor(*pathStartCursor);			
	}
	else
	{
		for (CMapElement *element=elementList->first(); element !=0; element =elementList->next())
		{
			if (element->mouseInElement(e->x(),e->y(),mapWidget->getCurrentZone()) && element->getElementType() == ROOM)
			{		
				pathStartRoom = (CMapRoom *)element;
				mapWidget->changeStatusBar(i18n("Selected the destination of the path"));
				pathToolMode = 1;
				mapWidget->setCursor(*pathEndCursor);
	            break;
			}			
		}		
	}							
}

/** This method is called when the mouse is moved */
void CMapToolPath::mouseMoveEvent(QMouseEvent *e)
{

}

/** This function called when the path tool is selected */
void CMapToolPath::toolSelected(void)
{
	mapWidget->setCursor(*pathStartCursor);
	mapWidget->setMouseTracking(false);
	
	pathStartRoom = NULL;
	pathToolMode = 0;
	toolsToolbar->setButton(id,true);
	menu->setItemChecked(id,true);	
	
}

/** This function is called when the path tool is unselected */
void CMapToolPath::toolUnselected()
{
	toolsToolbar->setButton(id,false);
	menu->setItemChecked(id,false);	
}

