/***************************************************************************
                          cmaptoolroom.h
                      -------------------
    description          : The room creation tool
    begin                : Thu Nov 23 2000
    copyright            : (C) 2000 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef CMAPTOOLROOM_H
#define CMAPTOOLROOM_H

#include "cmaptoolbase.h"


/** The tool is used to creater room elements on the map
  * @author John-Paul Stanford
  */
class CMapToolRoom : public CMapToolBase
{
public: 
	CMapToolRoom(CMapData *mapData,CMapWidget *map,int id, QString name,QPixmap icon, KToolBar *toolBar,QPopupMenu *menu) : CMapToolBase(mapData,map,id,name,icon,toolBar,menu) { }
	
	~CMapToolRoom() {}
	
	/** This method is called when the mouse is pressed */
	void mousePressEvent(QMouseEvent *e);
	/** This method is called when the mouse is released */
	void mouseReleaseEvent(QMouseEvent *e);
	/** This method is called when the mouse is moved */
	void mouseMoveEvent(QMouseEvent *e);
	/** This function called when the room tool is selected */
	void toolSelected(void);
	/** This function is called when the room tool is unselected */
	void toolUnselected();
	
private:
	int lastX,lastY;
	QPainter dragPainter;
	
};

#endif
