/***************************************************************************
                          cmudprofile.cpp
                        -------------------
    description          : Mud Profile Class
    begin                : Sun Oct 17 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapp.h> // for i18n
#include "cmudprofile.h"

CMudProfile::CMudProfile(){
	filename="";
	title="";
	hostname="";
	port=23;
	iType=0;
	map_directions = new directions;
	map_directions->north = i18n("n");
	map_directions->northeast = i18n("ne");
	map_directions->east = i18n("e");
	map_directions->southeast = i18n("se");
	map_directions->south = i18n("s");
	map_directions->southwest = i18n("sw");
	map_directions->west = i18n("w");
	map_directions->northwest = i18n("nw");
	map_directions->up = i18n("u");
	map_directions->down = i18n("d");

	doValidMoveChecking = false;
	failedMoveMsg1 = "";
	failedMoveMsg2 = "";
	failedMoveMsg3 = "";
}

CMudProfile::~CMudProfile(){
}


bool CMudProfile::getDoValidMoveChecking(void)
{
	return doValidMoveChecking;
}

void CMudProfile::setDoValidMoveChecking(bool b)
{
	doValidMoveChecking=b;
}

QString CMudProfile::getFailedMoveMsg1(void)
{
	return failedMoveMsg1;
}

void CMudProfile::setFailedMoveMsg1(QString s)
{
	failedMoveMsg1=s;
}

QString CMudProfile::getFailedMoveMsg2(void)
{
	return failedMoveMsg2;
}

void CMudProfile::setFailedMoveMsg2(QString s)
{
	failedMoveMsg2=s;
}

QString CMudProfile::getFailedMoveMsg3(void)
{
	return failedMoveMsg3;
}

void CMudProfile::setFailedMoveMsg3(QString s)
{
	failedMoveMsg3=s;
}



QString CMudProfile::getFileName()
{ return filename; }

void CMudProfile::setFileName(QString f)
{ filename=f; }

void CMudProfile::setFollowMode(bool follow)
{ bFollowMode = bCreateMode ? bFollowMode : follow; } // do not allow change when ist locked by create mode

bool CMudProfile::getFollowMode(void)
{ return bFollowMode || bCreateMode; } // create mode implies follow mode

void CMudProfile::setCreateMode(bool create)
{ bCreateMode = create; }

bool CMudProfile::getCreateMode(void)
{ return bCreateMode; }

QString CMudProfile::getTitle()
{ return title; }

void CMudProfile::setTitle(QString t)
{ title=t; }

QString CMudProfile::getHostName()
{ return hostname; }

void CMudProfile::setHostName(QString h)
{ hostname=h; }

unsigned int CMudProfile::getPort()
{ return port; }

void CMudProfile::setPort(unsigned int p)
{ port=p; }

QString CMudProfile::getNamePrompt()
{ return nameprompt; }

void CMudProfile::setNamePrompt(QString n)
{ nameprompt=n; }
	
QString CMudProfile::getPasswordPrompt()
{ return passwordprompt; }

void CMudProfile::setPasswordPrompt(QString p)
{ passwordprompt=p; }

/** returns the directions */
directions *CMudProfile::getDirections()
{ return map_directions; }

/** sets the directions */
void CMudProfile::setDirections(directions *d)
{ map_directions = d; }



void CMudProfile::readData()
{
	KSimpleConfig mudconf(QDir::homeDirPath()+"/.kde/share/apps/kmud/muds/"+filename);

	title=mudconf.readEntry("Title","");
	hostname=mudconf.readEntry("Hostname","");
	port=mudconf.readNumEntry("Port",23);
	nameprompt=mudconf.readEntry("NamePrompt","");
	passwordprompt=mudconf.readEntry("PasswordPrompt","");
	iType=mudconf.readNumEntry("InterpretType",0);
	
	map_directions->north = mudconf.readEntry("North",i18n("n"));
	map_directions->northeast = mudconf.readEntry("NorthEast",i18n("ne"));
	map_directions->east = mudconf.readEntry("East",i18n("e"));
	map_directions->southeast = mudconf.readEntry("SouthEast",i18n("se"));
	map_directions->south = mudconf.readEntry("South",i18n("s"));
	map_directions->southwest = mudconf.readEntry("SouthWest",i18n("sw"));
	map_directions->west = mudconf.readEntry("West",i18n("w"));
	map_directions->northwest = mudconf.readEntry("NorthWest",i18n("nw"));
	map_directions->up = mudconf.readEntry("Up",i18n("u"));
	map_directions->down = mudconf.readEntry("Down",i18n("d"));
	
	doValidMoveChecking = mudconf.readBoolEntry("DoValidMoveChecking",false);
	failedMoveMsg1 = mudconf.readEntry("FailedMoveMsg1","");
	failedMoveMsg2 = mudconf.readEntry("FailedMoveMsg2","");
	failedMoveMsg3 = mudconf.readEntry("FailedMoveMsg3","");

	bFollowMode = mudconf.readBoolEntry("FollowMode",false);
	bCreateMode = mudconf.readBoolEntry("CreateMode",false);
}

void CMudProfile::writeData()
{
	KSimpleConfig mudconf(QDir::homeDirPath()+"/.kde/share/apps/kmud/muds/"+filename);

	mudconf.writeEntry("Title",title);
	mudconf.writeEntry("Hostname",hostname);
	mudconf.writeEntry("Port",port);
	mudconf.writeEntry("NamePrompt",nameprompt);
	mudconf.writeEntry("PasswordPrompt",passwordprompt);
	mudconf.writeEntry("InterpretType",iType);
	
	mudconf.writeEntry("North",map_directions->north);
	mudconf.writeEntry("NorthEast",map_directions->northeast);
	mudconf.writeEntry("East",map_directions->east);
	mudconf.writeEntry("SouthEast",map_directions->southeast);
	mudconf.writeEntry("South",map_directions->south);
	mudconf.writeEntry("SouthWest",map_directions->southwest);
	mudconf.writeEntry("West",map_directions->west);
	mudconf.writeEntry("NorthWest",map_directions->northwest);
	mudconf.writeEntry("Up",map_directions->up);
	mudconf.writeEntry("Down",map_directions->down);
	
	mudconf.writeEntry("DoValidMoveChecking",doValidMoveChecking);
	mudconf.writeEntry("FailedMoveMsg1",failedMoveMsg1);
	mudconf.writeEntry("FailedMoveMsg2",failedMoveMsg2);
	mudconf.writeEntry("FailedMoveMsg3",failedMoveMsg3);

	mudconf.writeEntry("FollowMode",bFollowMode);
	mudconf.writeEntry("CreateMode",bCreateMode);
}

int CMudProfile::getInterpretationType()
{
	return iType;
}

void CMudProfile::setInterpretationType(int i)
{
	iType = i;
}


