/***************************************************************************
                          dlgoptiongeneral.cpp
                          -------------------
    description          : General Options Dialog Class
    begin                : Thu Oct 7 1999
    copyright            : (C) 1999 by Kmud Developer Team
    email                : kmud-devel@kmud.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "dlgoptiongeneral.h"
#include <qfileinfo.h>
#include <kfiledialog.h>


DlgOptionGeneral::DlgOptionGeneral(QWidget *parent, const char *name) : QDialog(parent,name,true){
	initDialog();
//    separator_LineEdit->setText(separator);

  connect(pingCheckBox, SIGNAL(clicked()), this, SLOT(slotPingCheckBoxClicked()));
  connect(pingChooseButton, SIGNAL(clicked()), this, SLOT(slotPingChooseButtonClicked()));
}

DlgOptionGeneral::~DlgOptionGeneral(){
}

bool DlgOptionGeneral::getKeepLastInput(){
	return keepLastInput_CheckBox->isChecked();
}

void DlgOptionGeneral::setKeepLastInput(bool b){
	return keepLastInput_CheckBox->setChecked(b);
}

bool DlgOptionGeneral::getUseBeep() {
	return useBeep_CheckBox->isChecked();
}

void DlgOptionGeneral::setUseBeep(bool u) {
	return useBeep_CheckBox->setChecked(u);
}

/** set's the intelligentHistory-Checkbox */
void DlgOptionGeneral::setIntelligentHistory(bool i)
{
	intelligentHistory_CheckBox->setChecked(i);
} // setIntelligentHistory

/** is intelligent history on or off? */
bool DlgOptionGeneral::getIntelligentHistory()
{
	return intelligentHistory_CheckBox->isChecked();
} // getIntelligentHistory

/** enables the Numpad for Macros */
void DlgOptionGeneral::setNumpadMacros(bool b)
{
	NumpadMacros_CheckBox->setChecked(b);
} // setNumpadMacros

/** returns if Numpad-Macros are enabled or disabled */
bool DlgOptionGeneral::getNumpadMacros()
{
	return NumpadMacros_CheckBox->isChecked();
} // getNumpadMacros

void DlgOptionGeneral::setSelectAllOnFocus(bool b)
{
	SelectAllOnFocus_CheckBox->setChecked(b);
}

bool DlgOptionGeneral::getSelectAllOnFocus()
{
	return SelectAllOnFocus_CheckBox->isChecked();
}

/** Sets data associated to ping configuration */
void DlgOptionGeneral::setPingData(QString path, bool enabled)
{
  pingInput->setText(path);
  pingCheckBox->setChecked(enabled);
  pingInput->setEnabled(enabled);
  pingChooseButton->setEnabled(enabled);
}

/** returns the path (including  filename) */
QString DlgOptionGeneral::getPingPath()
{
  return pingInput->text();
}

/** returns true if ping should be enabled */
bool DlgOptionGeneral::getPingEnabled()
{
  return pingCheckBox->isChecked();
}

/** slot for the clicked() signal of the '...'-Button */
void DlgOptionGeneral::slotPingChooseButtonClicked()
{
  QString newPath;
  QFileInfo oldFileInfo(pingInput->text());
  if (oldFileInfo.exists())
  {
    newPath = pingInput->text();
  }

  newPath = KFileDialog::getOpenFileName(newPath, 0, this, "get ping file");

  QFileInfo info(newPath);
  if (info.isExecutable() && info.isFile())
  {
    pingInput->setText(newPath);
  }
}

/** slot for the ping enable CheckBoxes signal clicked() */
void DlgOptionGeneral::slotPingCheckBoxClicked()
{
  bool enabled = pingCheckBox->isChecked();
  pingInput->setEnabled(enabled);
  pingChooseButton->setEnabled(enabled);
}
